/**
 * @file ap.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_mw\aifi_ap_direct_manager
 * @brief
 *
 * @{
 */

#ifndef AP_H
#define AP_H

#include <glib.h>
#include <aptasks.h>
#include <stdlib.h>

struct access_point;

int access_point_set_ssid (struct access_point *ap, char *ssidval, size_t length);
int access_point_set_hwmode (struct access_point *ap, const char *hwmode, gboolean save);
int access_point_set_passphrase (struct access_point *ap, const char *passphrase);
int access_point_set_country (struct access_point *ap, const char *country);
int access_point_set_powered (struct access_point *ap, const gboolean powered);
char* access_point_get_power_state (struct access_point *ap);
char* access_point_get_power_failure_reason (struct access_point *ap);
int access_point_set_hidden (struct access_point *ap, const gboolean hidden);
int access_point_set_operating_channel (struct access_point *ap, const unsigned int channel);
int access_point_set_channels (struct access_point *ap, unsigned int *channels, unsigned int length);
int access_point_set_beacon_int (struct access_point *ap, unsigned short int beacon_int);
int access_point_set_dtim_period (struct access_point *ap, const int dtim_period);
int access_point_set_max_num_station (struct access_point *ap, const int max_num_sta);
int access_point_set_vendor_elements (struct access_point *ap, const char *vendor_elements, const unsigned long length);
int access_point_set_tethering (struct access_point *ap, const gboolean tethering);
int access_point_set_acc_net_type (struct access_point *ap, const unsigned int acc_net_type);

int access_point_hex2bin (const char *hex, char *dest, size_t len);

char *access_point_get_address (struct access_point *ap);
char *access_point_get_interface (struct access_point *ap);
gboolean access_point_get_powered (struct access_point *ap);
gboolean access_point_get_hidden (struct access_point *ap);
const char *access_point_get_security (struct access_point *ap);
char *access_point_get_passphrase (struct access_point *ap);
unsigned int* access_point_get_supported_channels (struct access_point *ap, unsigned int *length);
unsigned int* access_point_get_supported_frequencies (struct access_point *ap, unsigned int *length);
unsigned int access_point_get_hwmodes (struct access_point *ap);
int access_point_get_maxstations (struct access_point *ap);
int access_point_get_max_allowed_stations (struct access_point *ap);
int access_point_get_ssid (struct access_point *ap, char *ssid, size_t *length);
char *access_point_get_country (struct access_point *ap);
unsigned int access_point_get_operating_channel(struct access_point *ap);
unsigned int access_point_get_accnettype(struct access_point *ap);
int access_point_get_hwmode (struct access_point *ap, char **mode);
int access_point_get_current_hwmode (struct access_point *ap, char **mode);
char *access_point_get_path (struct access_point *ap);
unsigned int access_point_get_dhcp_pools (struct access_point *ap);
int access_point_get_dhcp_data_from_index (struct access_point *ap, unsigned int index,
                                           const char* key, void **data);
gboolean access_point_get_tethering (struct access_point *ap);

int access_point_get_all (GVariant **variant);
int ap_process_request (struct access_point *ap, void *invocation, int taskid, void *data);
const char *ap_task2string (aptask task);

int is_hexa_decimal (const char *string, size_t length);
int is_station_connected (struct access_point *ap, const char *station);
int check_valid_channels (struct access_point *ap, const u_int16_t *channels, size_t length);
int channels_is_5ghz (const unsigned int *channels, unsigned int length);

int access_point_get_associatedstations (void *service, GVariantBuilder *builder);

int ap_init (char *conffiles);
int ap_deinit ();

#endif //AP_H

/** @} */
