/**
 * @file utils.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef UTILS_H
#define UTILS_H

struct timeval;

/**
 * enum filetype - different file types
 */
typedef
enum __file_type
{
    FILE_TYPE_BLK,
    FILE_TYPE_CHR,
    FILE_TYPE_DIR,
    FILE_TYPE_FIFO,
    FILE_TYPE_LNK,
    FILE_TYPE_REG,
    FILE_TYPE_SOCK,
    NUM_FILE_TYPES
} filetype;

#define VERSION                             "2.0"
#define COMPONENT_NAME                      "WiFi_AP_Direct_Manager"

#define WAPDMAN_SERVICE                     "org.bosch.wapdman"

#define SESSION_PARAMS_BEARERS              "AllowedBearers"
#define SESSION_PARAMS_CONNTYPE             "ConnectionType"
#define SESSION_CONNECTION_TYPE             "any"
#define SESSION_STATE_DISCONNECTED          "disconnected"
#define SESSION_STATE_CONNECTED             "connected"
#define SESSION_STATE_ONLINE                "online"

#define CONNMAN_BUS_NAME                    "net.connman"
#define CONNMAN_MANAGER_INTERFACE_NAME      CONNMAN_BUS_NAME".Manager"
#define CONNMAN_SESSION_INTERFACE_NAME      CONNMAN_BUS_NAME".Session"
#define CONNMAN_MANAGER_INTERFACE_PATH      "/"
#define CONNMAN_NOTIFICATION_IFACE_NAME     "net.connman.Notification"
#define DNSMASQ_BUS_NAME                    "uk.org.thekelleys.dnsmasq"
#define DNSMASQ_INTERFACE_NAME              DNSMASQ_BUS_NAME
#define DNSMASQ_OBJECT_PATH                 "/uk/org/thekelleys/dnsmasq"

#define ORG_FREEDESKTOP_DBUS_BUS_NAME       "org.freedesktop.DBus"
#define ORG_FREEDESKTOP_DBUS_IFACE_NAME     ORG_FREEDESKTOP_DBUS_BUS_NAME
#define ORG_FREEDESKTOP_DBUS_OBJ_PATH       "/org/freedesktop/DBus"

extern char* byte_to_hexstring (const char *bytestring, size_t length);
int get_real_time (struct timeval *val);
int get_monotonic_time (struct timeval *val);
int get_time_difference (struct timeval *tv1, struct timeval *tv2, struct timeval *res);
int is_hex_string (const char *str, const unsigned long length);
unsigned char calculate_netmask (const char *netmask);
int file_exists (const char *filepath, filetype type);
char *nl_addr2string (void *nla, int family);
int calculate_argc (char **argv, int *length);
int convert_strtoumax (const char *string, unsigned int *value);
int get_family_from_addr (const char *address);
int nl_add_address (void *msg, int family, int attr, const char *ipaddress);
int is_valid_regdom (const char *alpha2);
int objpath_from_addr (const char *address, char *objpath);

#endif // UTILS_H

/** @} */
