/**
 * @file errors.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef ERRORS_H
#define ERRORS_H

#include <gio/gio.h>

#define ERROR_INTERNAL_FAILURE          255

void wapdman_error_failed (GDBusMethodInvocation *invocation, int errnum);
void wapdman_error_invalid_arguments (GDBusMethodInvocation *invocation);
void wapdman_error_permission_denied (GDBusMethodInvocation *invocation);
void wapdman_error_not_unique (GDBusMethodInvocation *invocation);
void wapdman_error_not_supported (GDBusMethodInvocation *invocation);
void wapdman_error_not_implemented (GDBusMethodInvocation *invocation);
void wapdman_error_no_such_device (GDBusMethodInvocation *invocation);
void wapdman_error_no_carrier (GDBusMethodInvocation *invocation);
void wapdman_error_no_data (GDBusMethodInvocation *invocation);
void wapdman_error_in_progress(GDBusMethodInvocation *invocation);
void wapdman_error_already_exists (GDBusMethodInvocation *invocation);
void wapdman_error_already_enabled (GDBusMethodInvocation *invocation);
void wapdman_error_already_disabled (GDBusMethodInvocation *invocation);
void wapdman_error_not_connected (GDBusMethodInvocation *invocation);
void wapdman_error_operation_timeout (GDBusMethodInvocation *invocation);
void wapdman_error_invalid_property (GDBusMethodInvocation *invocation);
void wapdman_error_invalid_interface (GDBusMethodInvocation *invocation);
void wapdman_error_no_memory (GDBusMethodInvocation *invocation);
void wapdman_error_busy (GDBusMethodInvocation *invocation);
void wapdman_error_operation_cancelled (GDBusMethodInvocation *invocation);
void wapdman_error_already_same (GDBusMethodInvocation *invocation);
void wapdman_error_read_only (GDBusMethodInvocation *invocation);
void wapdman_error_internal_failure (GDBusMethodInvocation *invocation);

#endif //ERRORS_H

/** @} */
