/**
 * @file rtnl.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef RTNL_H
#define RTNL_H

#include <netlink/attr.h>

typedef
struct __rtnl_watch
{
    char *client;

    int (*newlink) (int index,
                    unsigned short type,
                    unsigned int family,
                    unsigned int flags,
                    unsigned int change,
                    struct nlattr **attr);

    int (*dellink) (int index,
                    unsigned short type,
                    unsigned int family,
                    unsigned int flags,
                    unsigned int change,
                    const char *name);

    int (*newaddr) (unsigned int index,
                    int family,
                    const char *label,
                    const char *local,
                    const char *address,
                    const char *anycast,
                    const char *multicast);

    int (*deladdr) (unsigned int index,
                    int family,
                    const char *label,
                    const char *local,
                    const char *address,
                    const char *anycast,
                    const char *multicast);

    int (*newgw) (void *nlhdr);
    int (*delgw) (void *nlhdr);

    int (*newrule) (void *nlhdr);
    int (*delrule) (void *nlhdr);
} rtnlwatch;

int rtnl_init ();
int rtnl_deinit ();
int rtnl_get_information ();
int rtnl_get_device_type (int index);
int rtnl_notifier_register (rtnlwatch *ops);
int rtnl_notifier_unregister (rtnlwatch *ops);
const char *rtnl_table2string (int table);
const char *rtnl_scope2string (int scope);

#endif //RTNL_H

/** @} */
