/**
 * @file fib.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef ROUTE_H
#define ROUTE_H

typedef struct __active_route route_t;

#define route_ref(route) route_ref_impl(route, __FILE__, __LINE__, __func__)
#define route_unref(route) route_unref_impl(route, __FILE__, __LINE__, __func__)

route_t *route_ref_impl (route_t *route, const char *file,
                         int line, const char *caller);
void route_unref_impl (route_t *route, const char *file, int line,
                       const char *caller);

int modify_ip_route (const char *route);

int route_init ();
int route_deinit ();

#endif // ROUTE_H
/** @} */
