/**
 * @file log_syslog.c
 * @author RBEI/ECO3-Murali Kakkanavar
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <libgen.h>
#include <string.h>
#include <glib.h>
#include <log.h>
#include <main.h>
#include <log_syslog.h>

static logops
syslog_utils = {
        .util_name = "SYSLOG",
        .util_open = syslog_open,
        .util_close = syslog_close,
        .util_log = syslog_log
};

static int
syslog_priority (const int prio)
{
    int prio_level;

    switch (prio) {
    default:
    case DEBUG_TRACE:
        prio_level = LOG_DEBUG;
        break;
    case DEBUG_INFO:
        prio_level = LOG_INFO;
        break;
    case DEBUG_WARNING:
        prio_level = LOG_WARNING;
        break;
    case DEBUG_ERR:
        prio_level = LOG_ERR;
        break;
    case DEBUG_CRITICAL:
        prio_level = LOG_CRIT;
        break;
    case DEBUG_ALERT:
        prio_level = LOG_ALERT;
        break;
    case DEBUG_EMERG:
        prio_level = LOG_EMERG;
        break;
    case DEBUG_NOTICE:
        prio_level = LOG_NOTICE;
        break;
    }

    return prio_level;
}

int
log_syslog_init()
{
    if(getenv ("WAPDMAN_ENABLE_SYSLOG"))
        log_util_register(&syslog_utils);

    return 0;
}

int
log_syslog_deinit()
{
    if(getenv ("WAPDMAN_ENABLE_SYSLOG"))
        log_util_unregister(&syslog_utils);

    return 0;
}

int
syslog_open()
{
    char *programname = log_get_program_name();
    int loglevel = get_log_level();

    if (loglevel < LOG_EMERG || loglevel > LOG_DEBUG)
        setlogmask (LOG_UPTO (LOG_DEBUG));
    else
        setlogmask (LOG_MASK (loglevel));

    openlog (basename (programname), LOG_CONS |
             LOG_PID | LOG_NDELAY, LOG_DAEMON);

    return 0;
}

int
syslog_close()
{
    closelog ();

    return 0;
}

int
syslog_log(int log_level, const char *str, va_list args)
{
    vsyslog (syslog_priority(log_level), str, args);

    return 0;
}

/** @} */
