/**
 * @file log_stdout.c
 * @author RBEI/ECO3-Murali Kakkanavar
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <main.h>
#include <log.h>
#include <log_stdout.h>

static logops
stdout_utils = {
        .util_name = "STDIO",
        .util_open = stdout_open,
        .util_close = stdout_close,
        .util_log = stdout_log
};

int
log_stdout_init()
{
    gboolean detach = FALSE;

    detach = get_deamon_option ();
    if (!detach && getenv ("WAPDMAN_ENABLE_STDOUT"))
        log_util_register(&stdout_utils);

    return 0;
}

int
log_stdout_deinit()
{
    gboolean detach = FALSE;

    detach = get_deamon_option ();
    if (!detach && getenv ("WAPDMAN_ENABLE_STDOUT"))
        log_util_unregister(&stdout_utils);

    return 0;
}

int
stdout_open()
{
    return 0;
}

int
stdout_close()
{
    return 0;
}

int
stdout_log(int log_level, const char *str, va_list args)
{
    struct timeval tmval;
    char tme [TIMESTAMP], buf [BUFFER];

    (void)log_level;
    memset (tme, 0, sizeof (tme));
    memset (buf, 0, sizeof (buf));

    if ( !timestamp (tme) ) {
        if ( !gettimeofday (&tmval, NULL) ) {
            snprintf(buf, BUFFER, "%s.%06lu ", tme,
                     tmval.tv_usec);
                fprintf (stdout, "%s ", buf);
        } else
                fprintf (stdout, "%s ", tme);
    }

    vfprintf (stdout, str, args);
    fprintf (stdout, "\n");

    return 0;
}
/** @} */
