/**
 * @file log_dlt.c
 * @author RBEI/ECO3-Murali Kakkanavar
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#include <main.h>
#include <log.h>
#include <log_dlt.h>
#include <dlt/dlt.h>
#include <dlfcn.h>


static logops
dlt_utils = {
        .util_name = "DLT",
        .util_open = dlt_open,
        .util_close = dlt_close,
        .util_log = dlt_debug_log
};

static void *dlhandle;

int
log_dlt_init()
{
    if (getenv ("WAPDMAN_ENABLE_DLT")) {
        dlhandle = dlopen ("libwapdmandlt_so.so", RTLD_LAZY);
        if (!dlhandle) {
            fputs (dlerror(), stderr);
            return 1;
        } else
            log_util_register(&dlt_utils);
    }

    return 0;
}

int
log_dlt_deinit()
{
    if (getenv ("WAPDMAN_ENABLE_DLT")) {
        if (dlhandle)
            dlclose(dlhandle);
        log_util_unregister(&dlt_utils);
    }

    return 0;
}

int
dlt_open()
{
    typedef void (*libdlt_open_t)();

    dlerror();

    libdlt_open_t libdlt_open = (libdlt_open_t) dlsym(dlhandle, "wapdmandlt_open");
    const char *dlsym_error = dlerror();

    if (dlsym_error) {
        fputs (dlsym_error, stderr);
        dlclose(dlhandle);
        return 1;
    }

    libdlt_open();

    return 0;
}

int
dlt_close()
{
    typedef void (*libdlt_close_t)();

    dlerror();

    libdlt_close_t libdlt_close = (libdlt_close_t) dlsym(dlhandle, "wapdmandlt_close");
    const char *dlsym_error = dlerror();

    if (dlsym_error) {
        fputs (dlsym_error, stderr);
        dlclose(dlhandle);
        return 1;
    }

    libdlt_close();

    return 0;
}

int 
dlt_debug_log(int log_level, const char *str, va_list args)
{
    typedef void (*libdlt_log_t)(int, const char*, va_list);

    dlerror();

    libdlt_log_t libdlt_log = (libdlt_log_t) dlsym(dlhandle, "wapdmandlt_log");

    const char *dlsym_error = dlerror();

    if (dlsym_error) {
        fputs (dlsym_error, stderr);
        dlclose(dlhandle);
        return 1;
    }

    libdlt_log(log_level, str, args);

    return 0;
}

/** @} */
