/**
 * @file dnsmasq-man.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef DNSMASQ_MAN_H
#define DNSMASQ_MAN_H

/**
 * enum dnsmasqevent - DHCP lease events
 */
typedef
enum __dnsmasq_events
{
    /**
     * A new DHCP lease has been added
     */
    DNSMASQ_DHCP_LEASE_ADDED,

    /**
     * An existing DHCP lease has been updated
     */
    DNSMASQ_DHCP_LEASE_UPDATED,

    /**
     * A DHCP lease has been removed form the
     * internal db (ex: a client invalidates the
     * provided DHCP lease via DHCPRELEASE)
     */
    DNSMASQ_DHCP_LEASE_DELETED,
    NUM_DNSMASQ_EVENTS
} dnsmasqevent;

/**
 * dnsmasq_init - Initialize the dnsmasq
 */
int dnsmasq_init ();

/**
 * dnsmasq_deinit - Deinitialize the dnsmasq
 */
int dnsmasq_deinit ();

#endif  //DNSMASQ_MAN_H

/** @} */
