/**
 * @file db_defines.h
 * @author RBEI/ECO32-Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_mw\aifi_ap_direct_manager
 * @brief
 *
 * @{
 */

#ifndef DB_DEFINES_H
#define DB_DEFINES_H

//TO DO: Temp path - to be moved to a common defines path
//once location of conf hostapd.conf is decided.

#define DYNAMIC_STORAGE             "/var/opt/bosch/dynamic"
#define CONNECTIVITY_DB_DIR         DYNAMIC_STORAGE"/connectivity"
#define WAPDMAN_DB_DIR              CONNECTIVITY_DB_DIR"/db"
#define DNSMASQ_DB_DIR              DYNAMIC_STORAGE"/dnsmasq"
#define DNSMASQ_DB_TEMP_DIR         WAPDMAN_TEMP_CONF_DIR

/* Introduced the static storage, because of weired behavior of dynamic partition
 * during certain scenarios SW_upate, cyclic reset and FOTA update
 * And due to RTC Bug 765995, we introduced static partition in WAPDMAN
 * This is a temporary solution, but this needs a fix later, which is identified
 * and we should remove this implementation once the real solution available
 */
#define STATIC_STORAGE              "/var/opt/bosch/static"
#define STATIC_CONNECTIVITY_DB_DIR  STATIC_STORAGE"/connectivity"
#define STATIC_DNSMASQ_DB_DIR       STATIC_STORAGE"/dnsmasq"

#define PID_FILE_DIR                "/var/run"
#define WAPDMAN_TEMP_CONF_DIR       "/tmp"

#endif //DB_DEFINES_H

/** @} */





