
#ifndef BT_IAP_PLUGIN_COMMON_H
#define BT_IAP_PLUGIN_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif

#include <adit_typedef.h>
#include <stdio.h>
#include <stdlib.h> /* needed to avoid 'implicit declaration of calloc ...' compiler warning */
#include <unistd.h> /* for pid_t */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

enum tenTrcTraceClass 
{
   TR_CLASS_IAP_PLUGIN_COMMON = 0x3B29,
   TR_CLASS_IAP_PLUGIN_IAP1   = 0x3B2A,
   TR_CLASS_IAP_PLUGIN_IAP2   = 0x3B2B
};

/* ADIT defines */

#define IPOD_DATACOM_FLAGS_RDONLY 1
#define IPOD_DATACOM_FLAGS_WRONLY 2
#define IPOD_DATACOM_FLAGS_RDWR   3

#define IPOD_DATACOM_MODE_BLOCKING      0
#define IPOD_DATACOM_MODE_NONBLOCKING   1

#define IPOD_DATACOM_SUCCESS                        0
#define IPOD_DATACOM_ERROR                          -1
#define IPOD_DATACOM_ERR_NOMEM                      -33
#define IPOD_DATACOM_ERR_ABORT                      -66
#define IPOD_DATACOM_ERR_UNSUP_DEV                  -84
#define IPOD_DATACOM_BAD_PARAMETER                  -86
#define IPOD_DATACOM_NOT_CONNECTED                  -90
#define IPOD_DATACOM_ALREADY_CONNECTED              -91

/* IAP_BT defines */
#define DEV_NAME_BUFFERSIZE                          30

#define IPOD_DATACOM_PROPERTY_MAX_SIZE               512

S32 iAPBTOpenPlugin (const U8* device_name);
S32 iAPBTClosePlugin (S32 device_fd);
S32 iAPBTDeviceIoCtl (S32 request, void* argp);
S32 iAPBTSendMessage (S32 device_fd, U32 msgLenTotal, const U8 *iPod_msg);
S32 iAPBTReceiveMessage (S32 device_fd, U32 buffer_size, U8 *msgBuffer);

#ifdef __cplusplus
}
#endif

#endif


