
#include "iap_bt_plugin_common.h"
#include "iap2_bt_plugin.h"
#include <adit_typedef.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <poll.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IAP_PLUGIN_IAP2
#include "trcGenProj/Header/iap2_bt_plugin.c.trc.h"
#endif

//Initialize the variables to default values
IPOD_IAP2_DEVICE_DETAILS ipod_iap2_device_details[MAX_DEVICE_CONNECTION_SUPPORTED] = {{0xFF, -1, {0}, {IPOD_DATACOM_SUCCESS, 0, 0}},\
                                                                                      {0xFF, -1, {0}, {IPOD_DATACOM_SUCCESS, 0, 0}},\
                                                                                      {0xFF, -1, {0}, {IPOD_DATACOM_SUCCESS, 0, 0}}};

void* iPodiAP2BTComInit (IPOD_IAP2_DATACOM_FUNC_TABLE* data_com_function)
{
   U8* retIpodHandlePtr = NULL;
   ETG_TRACE_USR3(("iPodiAP2BTComInit::entered"));

   if (data_com_function != NULL)
   {
      U8 index = 0;
      for(; (index < MAX_DEVICE_CONNECTION_SUPPORTED); index++)
      {
         //find the unused index and assign the ipod handle
         if(ipod_iap2_device_details[index].iap2_bt_ipod_handle == 0xFF)
         {
            ipod_iap2_device_details[index].iap2_bt_ipod_handle = (U8)(index+1);
            retIpodHandlePtr = &ipod_iap2_device_details[index].iap2_bt_ipod_handle;

            ETG_TRACE_USR3(("iPodiAP2BTComInit::ipod_handle assigned: %d", ipod_iap2_device_details[index].iap2_bt_ipod_handle));

            break;
         }
      }

      data_com_function->hdlevent = &iPodiAP2BTHandleEvent;
      data_com_function->getfds = &iPodiAP2BTGetFDs;
      data_com_function->open = &iPodiAP2BTOpenPlugin;
      data_com_function->close = &iPodiAP2BTClosePlugin;
      data_com_function->abort = &iPodiAP2BTCloseMsgHandling;
      data_com_function->write = &iPodiAP2BTSendMessage;
      data_com_function->read = &iPodiAP2BTReceiveMessage;
      data_com_function->ioctl = iPodiAP2BTDeviceIoCtl;
      data_com_function->property = &iPodiAP2BTGetProperty;
   }
   else
   {
      retIpodHandlePtr = NULL;
   }

   ETG_TRACE_USR3(("iPodiAP2BTComInit::leaving"));
   return retIpodHandlePtr;
}

S32 iPodiAP2BTComDeinit (IPOD_IAP2_DATACOM_FUNC_TABLE* data_com_function,
                        void* iPodHdl)
{
   ETG_TRACE_USR3(("iPodiAP2BTComDeinit::entered"));

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTComDeinit::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd = -1;
      memset(ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_name, '\0', DEV_NAME_BUFFERSIZE+1);
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_SUCCESS;
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue = 0;
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = 0;

      //handle should be set at last since this is referenced in (U8*)iPodHdl. So it will point to 0xFF after this.
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_ipod_handle = 0xFF;

      ETG_TRACE_USR3(("iPodiAP2BTComDeinit::successful"));
   }

   if (data_com_function != NULL)
   {
      data_com_function->hdlevent = NULL;
      data_com_function->getfds = NULL;
      data_com_function->open = NULL;
      data_com_function->close = NULL;
      data_com_function->abort = NULL;
      data_com_function->write = NULL;
      data_com_function->read = NULL;
      data_com_function->ioctl = NULL;
      data_com_function->property = NULL;
   }

   ETG_TRACE_USR3(("iPodiAP2BTComDeinit::leaving"));
   return IPOD_DATACOM_SUCCESS;
}

S32 iPodiAP2BTHandleEvent (void* iPodHdl, 
                           U32 buffer_size, 
                           U8 *msgBuffer, 
                           S32 pollFD)
{
   ETG_TRACE_USR3(("iPodiAP2BTHandleEvent::entered"));

   // avoid lint warnings
   // pollFD = pollFD;

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTHandleEvent::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = buffer_size;
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue = pollFD;

      if(msgBuffer != NULL)
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = iAPBTReceiveMessage(
                                                                                       ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue,
                                                                                       ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue,
                                                                                       msgBuffer);
      }
      else
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_BAD_PARAMETER;
      }

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = 0;
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue = 0;

      ETG_TRACE_USR3(("iPodiAP2BTHandleEvent::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTHandleEvent::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}


S32 iPodiAP2BTGetFDs (void* iPodHdl, IPOD_IAP2_DATACOM_FD* getFDs, S32* fd_count)
{
   ETG_TRACE_USR3(("iPodiAP2BTGetFDs::entered"));

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTGetFDs::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_ERROR;

      if (ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd >= 0)
      {
         if (getFDs != NULL)
         {
            ETG_TRACE_USR3(("iPodiAP2BTGetFDs:: getFDs != NULL"));

            getFDs->fd = ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd;
            getFDs->event = POLLIN;
         }

         if (fd_count != NULL)
         {
            ETG_TRACE_USR3(("iPodiAP2BTGetFDs:: fd_count != NULL"));
            *fd_count = 1;
            ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_SUCCESS;
         }
      }

      ETG_TRACE_USR3(("iPodiAP2BTGetFDs::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTGetFDs::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTOpenPlugin (void* iPodHdl,const U8* device_name, S32 flags, S32 mode)
{
   ETG_TRACE_USR3(("iPodiAP2BTOpenPlugin::entered"));

   // avoid lint warnings
   flags = flags;
   mode = mode;

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE) && (device_name != NULL))
   {
      ETG_TRACE_USR3(("iPodiAP2BTOpenPlugin::entered iPodHdl: %d, device_name: %s", *(U8*)iPodHdl, device_name));

      // copy device_name
      memset(ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_name, '\0', DEV_NAME_BUFFERSIZE+1);
      strncpy ((char *)ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_name, (char *)device_name, DEV_NAME_BUFFERSIZE);

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = iAPBTOpenPlugin (
                                                                                    ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_name);

      if (ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue >= 0)
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd = ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_SUCCESS;
      }
      else
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_ERROR;
      }

      ETG_TRACE_USR3(("iPodiAP2BTOpenPlugin::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTOpenPlugin::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTClosePlugin (void *iPodHdl)
{
   ETG_TRACE_USR3(("iPodiAP2BTClosePlugin::entered"));

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTClosePlugin::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = iAPBTClosePlugin (
                                                                                    ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd);

      // reset file descriptor
      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd = -1;

      ETG_TRACE_USR3(("iPodiAP2BTClosePlugin::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTClosePlugin::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTCloseMsgHandling (void *iPodHdl)
{
   ETG_TRACE_USR3(("iPodiAP2BTCloseMsgHandling::entered"));

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTCloseMsgHandling::iPodHdl: %d", *(U8*)iPodHdl));
      ETG_TRACE_USR3(("iPodiAP2BTCloseMsgHandling::leaving"));
      return IPOD_DATACOM_SUCCESS;
   }

   ETG_TRACE_USR3(("iPodiAP2BTCloseMsgHandling::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTGetProperty (void *iPodHdl, IPOD_IAP2_DATACOM_PROPERTY *property)
{
   ETG_TRACE_USR3(("iPodiAP2BTGetProperty::entered"));

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTGetProperty::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_SUCCESS;

      if(property != NULL)
      {
         property->maxSize = IPOD_DATACOM_PROPERTY_MAX_SIZE;
      }
      else
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_BAD_PARAMETER;
      }

      ETG_TRACE_USR3(("iPodiAP2BTGetProperty::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTGetProperty::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTDeviceIoCtl (void* iPodHdl, S32 request, void* argp)
{
   ETG_TRACE_USR3(("iPodiAP2BTDeviceIoCtl::entered"));

   // avoid lint warnings
   request = request;

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTDeviceIoCtl::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue = request;

      if(argp != NULL)
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = iAPBTDeviceIoCtl (
                                                                                       ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue,
                                                                                       argp);
      }
      else
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_BAD_PARAMETER;
      }

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.s32argValue = 0;

      ETG_TRACE_USR3(("iPodiAP2BTDeviceIoCtl::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTDeviceIoCtl::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTSendMessage (void *iPodHdl, U32 msgLenTotal, const U8 *iPod_msg, S32 flags)
{
   ETG_TRACE_USR3(("iPodiAP2BTSendMessage::entered"));

   // avoid lint warnings
   flags = flags;

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTSendMessage::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = msgLenTotal;

      if((iPod_msg != NULL)&&(ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue > 0))
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = iAPBTSendMessage(
                                                                                       ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd,
                                                                                       ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue,
                                                                                       iPod_msg);
      }
      else
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_BAD_PARAMETER;
      }

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = 0;

      ETG_TRACE_USR3(("iPodiAP2BTSendMessage::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTSendMessage::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}

S32 iPodiAP2BTReceiveMessage (void *iPodHdl, U32 buffer_size, U8 *msgBuffer, S32 flags)
{
   ETG_TRACE_USR3(("iPodiAP2BTReceiveMessage::entered"));

   // avoid lint warnings
   flags = flags;

   if((iPodHdl != NULL) && (*(U8*)iPodHdl >= MINIMUM_IPOD_HANDLE) && (*(U8*)iPodHdl <= MAXIMUM_IPOD_HANDLE))
   {
      ETG_TRACE_USR3(("iPodiAP2BTReceiveMessage::iPodHdl: %d", *(U8*)iPodHdl));

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = buffer_size;

      if(msgBuffer != NULL)
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = iAPBTReceiveMessage(
                                                                                 ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_device_fd,
                                                                                 ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue,
                                                                                 msgBuffer);
      }
      else
      {
         ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue = IPOD_DATACOM_BAD_PARAMETER;
      }

      ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.u32argValue = 0;

      ETG_TRACE_USR3(("iPodiAP2BTReceiveMessage::leaving"));
      return ipod_iap2_device_details[(*(U8*)iPodHdl)-1].iap2_bt_func_vars.retValue;
   }

   ETG_TRACE_USR3(("iPodiAP2BTReceiveMessage::leaving"));
   return IPOD_DATACOM_BAD_PARAMETER;
}
