/*******************************************************************************
*
* FILE:          .h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:

* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_VCARD_UTILS_
#define _FC_PHONEBOOK_VCARD_UTILS_

#include <QtCore/QtCore>


#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility

class FC_PhoneBook_VCard_Document;
class FC_PhoneBook_VCard_Property;


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class FC_PhoneBook_VCard_Utils
{
public:
  static QByteArray encode(const QByteArray& ba, QTextCodec* codec);
  static QByteArray encode(char ch, QTextCodec* codec);
  static QList<QByteArrayMatcher>* newlineList(QTextCodec* codec);
  static void changeCodec(QTextCodec* codec);
  static FC_PhoneBook_VCard_Property takeProperty(const FC_PhoneBook_VCard_Document& document,
                                                  const QString& propertyName,
                                                  QList<FC_PhoneBook_VCard_Property>* toBeRemoved);

private:
  // These are caches for performance:
  // The previous codec that encode(char, QTextCodec) was called with
  static QTextCodec* m_previousCodec;
  // The QByteArray corresponding to each char from 0-255, encoded with m_previousCodec
  static QByteArray m_encodingMap[256];
  // List of different newline delimeters, encoded with m_previousCodec
  static QList<QByteArrayMatcher>* m_newlineList;
};


#endif // _FC_PHONEBOOK_VCARD_UTILS_
