/*******************************************************************************
*
* FILE:          FC_PhoneBook_VCard_Utils.cpp
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "FC_PhoneBook_VCard_Utils.h"
#include "FC_PhoneBook_VCard_Document.h"
#include "FC_PhoneBook_VCard_Property.h"


QTextCodec* FC_PhoneBook_VCard_Utils::m_previousCodec = NULLPTR;
QList<QByteArrayMatcher>* FC_PhoneBook_VCard_Utils::m_newlineList = NULLPTR;
QByteArray FC_PhoneBook_VCard_Utils::m_encodingMap[256];


/*******************************************************************************
*
* FUNCTION: FC_PhoneBook_VCard_Utils::encode()
*
* DESCRIPTION: Encode ch with codec, without adding an byte-order mark
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QByteArray FC_PhoneBook_VCard_Utils::encode(char ch, QTextCodec* codec)
{
  if (codec != m_previousCodec)
  {
    changeCodec(codec);
  }
  return m_encodingMap[(int)ch];
}


/*******************************************************************************
*
* FUNCTION: FC_PhoneBook_VCard_Utils::encode()
*
* DESCRIPTION: Encode ba with codec, without adding an byte-order mark. ba is interpreted as ASCII
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QByteArray FC_PhoneBook_VCard_Utils::encode(const QByteArray& ba, QTextCodec* codec)
{
  QTextCodec::ConverterState state(QTextCodec::IgnoreHeader);
  return codec->fromUnicode(QString::fromLatin1(ba.data()).data(), ba.length(), &state);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Utils::newlineList()
*
* DESCRIPTION: Returns the list of DOS, UNIX and Mac newline characters for \a codec.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QList<QByteArrayMatcher>* FC_PhoneBook_VCard_Utils::newlineList(QTextCodec* codec)
{
  if ( (m_newlineList) && (codec == m_previousCodec) )
  {
    return m_newlineList;
  }
  changeCodec(codec);
  return m_newlineList;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Utils::changeCodec()
*
* DESCRIPTION:Update the cached tables of pregenerated encoded text with codec.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Utils::changeCodec(QTextCodec* codec)
{
  // Build m_encodingMap
  QChar qch;
  QTextCodec::ConverterState state(QTextCodec::IgnoreHeader);
  for (int c = 0; c < 256; c++)
  {
    qch = QLatin1Char((char)c);
    m_encodingMap[c] = codec->fromUnicode(&qch, 1, &state);
  }

  // Build m_newlineList
  if (m_newlineList)
    delete m_newlineList;
  m_newlineList = new QList<QByteArrayMatcher>;
  m_newlineList->append(QByteArrayMatcher(encode("\r", codec)));
  m_newlineList->append(QByteArrayMatcher(encode("\r\n", codec)));
  m_newlineList->append(QByteArrayMatcher(encode("\n", codec)));

  m_previousCodec = codec;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Utils::takeProperty()
*
* DESCRIPTION: Finds a property in the document
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Property FC_PhoneBook_VCard_Utils::takeProperty(const FC_PhoneBook_VCard_Document& document,
                                                                   const QString& propertyName,
                                                                   QList<FC_PhoneBook_VCard_Property>* toBeRemoved)
{
  QList<FC_PhoneBook_VCard_Property> documentProperties = document.properties();
  foreach (const FC_PhoneBook_VCard_Property& currentProperty, documentProperties)
  {
    if (currentProperty.name() == propertyName)
    {
      *toBeRemoved << currentProperty;
      return currentProperty;
    }
  }
  return FC_PhoneBook_VCard_Property();
}

