/*******************************************************************************
*
* FILE:          FC_PhoneBook_VCard_Property.cpp
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "FC_PhoneBook_VCard_Property.h"



/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::FC_PhoneBook_VCard_Property()
*
* DESCRIPTION: Constructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Property::FC_PhoneBook_VCard_Property() :  m_Type(FC_PhoneBook_VCard_Property::Plain)
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::FC_PhoneBook_VCard_Property()
*
* DESCRIPTION: Constructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Property::FC_PhoneBook_VCard_Property(const FC_PhoneBook_VCard_Property& other)
  : m_Groups(other.m_Groups),
  m_Name(other.m_Name),
  m_Parameters(other.m_Parameters),
  m_Value(other.m_Value),
  m_Type(other.m_Type)
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::~FC_PhoneBook_VCard_Property()
*
* DESCRIPTION: Destructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Property::~FC_PhoneBook_VCard_Property()
{
}


/*******************************************************************************
*
* FUNCTION:    FC_PhoneBook_VCard_Property::operator=()
*
* DESCRIPTION: Assignment operator
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Property& FC_PhoneBook_VCard_Property::operator=(const FC_PhoneBook_VCard_Property& other)
                                                                   {
  if (this != &other)
  {
    m_Groups = other.m_Groups;
    m_Name = other.m_Name;
    m_Parameters = other.m_Parameters;
    m_Type = other.m_Type;
    m_Value = other.m_Value;
  }
  return *this;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::operator==()
*
* DESCRIPTION: Equals opereator
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_Property::operator==(const FC_PhoneBook_VCard_Property& other) const
{
  bool equal = m_Groups == other.m_Groups &&
               m_Name == other.m_Name &&
               m_Parameters == other.m_Parameters &&
               m_Type == other.m_Type;
  if (!equal)
    return false;

  if (m_Value.userType() == qMetaTypeId<FC_PhoneBook_VCard_Document>())
    return  other.m_Value.userType() == qMetaTypeId<FC_PhoneBook_VCard_Document>()
    && m_Value.value<FC_PhoneBook_VCard_Document>() == other.m_Value.value<FC_PhoneBook_VCard_Document>();
  else
    return m_Value == other.m_Value;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::operator!=()
*
* DESCRIPTION: Not Equals operator.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_Property::operator!=(const FC_PhoneBook_VCard_Property& other) const
{
  return !(*this == other);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::qHash()
*
* DESCRIPTION: Create a hash key to be used by QHash
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
uint qHash(const FC_PhoneBook_VCard_Property &key)
{
  uint hash = qHash(key.name()) + qHash(key.value());

  QStringList keyGroups = key.groups();
  foreach (const QString& group, keyGroups)
  {
    hash += qHash(group);
  }

  QHash<QString,QString>::const_iterator it = key.parameters().constBegin();
  QHash<QString,QString>::const_iterator end = key.parameters().constEnd();

  while (it != end)
  {
    hash += qHash(it.key()) +qHash(it.value());
    ++it;
  }
  return hash;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::setGroups()
*
* DESCRIPTION: Add the groups to the list of groups
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::setGroups(const QStringList& str_groups)
{
  m_Groups.clear();
  foreach (const QString& group, str_groups)
  {
    m_Groups.append(group);
  }
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::groups()
*
* DESCRIPTION:  Gets the groups of the property.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QStringList FC_PhoneBook_VCard_Property::groups() const
{
  return m_Groups;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::setName()
*
* DESCRIPTION: Sets the name of the property.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::setName(const QString& str_name)
{
  m_Name = str_name.toUpper();
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::name()
*
* DESCRIPTION: Gets the name of the property in upper-case.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QString FC_PhoneBook_VCard_Property::name() const
{
  return m_Name;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::setParameters()
*
* DESCRIPTION: Replaces all the parameters with parameters.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::setParameters(const QMultiHash<QString,QString>& hash_parameters)
{
  m_Parameters.clear();

  QList<QString> keys = hash_parameters.uniqueKeys();
  for (int i=keys.count()-1; i >= 0; i--)
  {
    QString key = keys.at(i);
    QList<QString> values = hash_parameters.values(key);
    for (int j=values.count()-1; j >= 0; j--)
    {
      insertParameter(key,values.at(j));
    }
  }
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::insertParameter()
*
* DESCRIPTION: Adds a new parameter with name and value.
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::insertParameter(const QString& prop_name, const QString& prop_value)
{
  m_Parameters.insert(prop_name.toUpper(), prop_value);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::removeParameter()
*
* DESCRIPTION: Removes a parameter
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::removeParameter(const QString& prop_name, const QString& prop_value)
{
  m_Parameters.remove(prop_name.toUpper(), prop_value);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::removeParameters()
*
* DESCRIPTION: Removes all parameters with the given name
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::removeParameters(const QString& prop_name)
{
  m_Parameters.remove(prop_name.toUpper());
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::parameters()
*
* DESCRIPTION: Return a copy of the contained list of parameters.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QMultiHash<QString,QString> FC_PhoneBook_VCard_Property::parameters() const
{
  return m_Parameters;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::setValue()
*
* DESCRIPTION: Sets the property value.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::setValue(const QVariant& prop_value)
{
  m_Value = prop_value;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::variantValue()
*
* DESCRIPTION: Returns the value of the property.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QVariant FC_PhoneBook_VCard_Property::variantValue() const
{
  return m_Value;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::value()
*
* DESCRIPTION: Returns the value of the property as a string
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QString FC_PhoneBook_VCard_Property::value() const
{
  if (m_Value.type() == QVariant::ByteArray)
  {
    if (m_Parameters.contains(QLatin1String("CHARSET")))
    {
      QTextCodec* codec = QTextCodec::codecForName(
          m_Parameters.value(QLatin1String("CHARSET")).toLatin1());
      if (codec != NULL)
      {
        return codec->toUnicode(m_Value.toByteArray());
      }
    }
    return QString();
  }
  else
  {
    return m_Value.toString();
  }
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::setType()
*
* DESCRIPTION: Sets the type of value held in the property to type.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::setType(FC_PhoneBook_VCard_Property::Type type)
{
  m_Type = type;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::type()
*
* DESCRIPTION: Returns the type of value held in the property.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Property::Type FC_PhoneBook_VCard_Property::getType() const
{
  return m_Type;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::isEmpty()
*
* DESCRIPTION: Returns true if the property is empty.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_Property::isEmpty() const
{
  return m_Groups.isEmpty()
      && m_Name.isEmpty()
      && m_Parameters.isEmpty()
      && !m_Value.isValid();
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Property::clear()
*
* DESCRIPTION: Clears the contents of this property.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Property::clear()
{
  m_Groups.clear();
  m_Name.clear();
  m_Value.clear();
  m_Parameters.clear();
  m_Type = FC_PhoneBook_VCard_Property::Plain;
}


