/*******************************************************************************
*
* FILE:          .h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:

* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_VCARD_PARSER_
#define _FC_PHONEBOOK_VCARD_PARSER_

#include <QtCore/QtCore>


#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility

#include "FC_PhoneBook_VCard_Document.h"
#include "FC_PhoneBook_VCard_Property.h"


class FC_PhoneBook_VCard_LineReader;
class FC_PhoneBook_VCard_ByteArray;
class FC_PhoneBook_VCard_Parser;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class FC_PhoneBook_VCard_Parser
{
public:
  FC_PhoneBook_VCard_Parser();
  ~FC_PhoneBook_VCard_Parser();

  QList<FC_PhoneBook_VCard_Document> parseData(const QByteArray& inputData);

private:
  static QHash<QPair<FC_PhoneBook_VCard_Document::CardType,QString>,
  FC_PhoneBook_VCard_Property::Type>* valueTypeMap();

  bool parseDocument(FC_PhoneBook_VCard_LineReader* device, FC_PhoneBook_VCard_Document* document);
  bool parseDocumentBody(FC_PhoneBook_VCard_LineReader* device, FC_PhoneBook_VCard_Document* document);

  FC_PhoneBook_VCard_Property parseNextProperty(
      FC_PhoneBook_VCard_Document::CardType type,
      FC_PhoneBook_VCard_LineReader* lineReader);

  void parseVCard21Property(
      FC_PhoneBook_VCard_ByteArray* text,
      FC_PhoneBook_VCard_Property* property,
      FC_PhoneBook_VCard_LineReader* lineReader);

  void parseVCard30Property(
      FC_PhoneBook_VCard_Document::CardType type,
      FC_PhoneBook_VCard_ByteArray* text,
      FC_PhoneBook_VCard_Property* property,
      FC_PhoneBook_VCard_LineReader* lineReader);

  bool setVersionFromProperty(
      FC_PhoneBook_VCard_Document* document,
      const FC_PhoneBook_VCard_Property& property) const;

  bool unEncode(
      QByteArray* value,
      FC_PhoneBook_VCard_Property* property,
      FC_PhoneBook_VCard_LineReader* lineReader) const;

  QString decodeCharset(
      const QByteArray& value,
      FC_PhoneBook_VCard_Property* property,
      QTextCodec* defaultCodec,
      QTextCodec** codec) const;

  void decodeQuotedPrintable(QByteArray* text) const;

  QPair<QStringList,QString> extractPropertyGroupsAndName(FC_PhoneBook_VCard_ByteArray* line, QTextCodec* codec)
      const;
  QMultiHash<QString,QString> extractVCard21PropertyParams(FC_PhoneBook_VCard_ByteArray* line, QTextCodec* codec)
      const;
  QMultiHash<QString,QString> extractVCard30PropertyParams(FC_PhoneBook_VCard_ByteArray* line, QTextCodec* codec)
      const;

  QList<QByteArray> extractParams(FC_PhoneBook_VCard_ByteArray* line, QTextCodec *codec) const;
  QList<QByteArray> extractParts(const QByteArray& text, const QByteArray& separator,
                                 QTextCodec *codec) const;
  QByteArray extractPart(const QByteArray& text, int startPosition, int length=-1) const;
  QString paramName(const QByteArray& parameter, QTextCodec* codec) const;
  QString paramValue(const QByteArray& parameter, QTextCodec* codec) const;
  template <class T> static bool containsAt(const T& text, const QByteArray& match, int index)
  {
       int n = match.length();
       if (text.size() - index < n)
       return false;
       const char* textData = text.constData();
       const char* matchData = match.constData();
       return memcmp(textData+index, matchData, (size_t)n) == 0;
   }

  bool splitStructuredValue(FC_PhoneBook_VCard_Property* property,
                            bool hasEscapedBackslashes) const;
  static QStringList splitValue(const QString& string,
                                const QChar& sep,
                                QString::SplitBehavior behaviour,
                                bool hasEscapedBackslashes);
  static void removeBackSlashEscaping(QString* text);

  QPointer<QIODevice> m_IoDevice;
  QScopedPointer<QBuffer> m_InputBytes;
  QList<FC_PhoneBook_VCard_Document> m_Documents;
  int m_DocumentNestingLevel;
  QTextCodec* m_DefaultCodec;

  static QHash<QPair<FC_PhoneBook_VCard_Document::CardType,QString>, FC_PhoneBook_VCard_Property::Type>* m_ValueTypeMap;

  friend class FC_PhoneBook_VCard_LineReader;

};

#endif // _FC_PHONEBOOK_VCARD_PARSER_
