/*******************************************************************************
*
* FILE:          FC_PhoneBook_VCard_Document.cpp
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "FC_PhoneBook_VCard_Document.h"
#include "FC_PhoneBook_VCard_Property.h"


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::FC_PhoneBook_VCard_Document()
*
* DESCRIPTION:  Constructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Document::FC_PhoneBook_VCard_Document()
  : m_CardType(FC_PhoneBook_VCard_Document::Invalid)
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::FC_PhoneBook_VCard_Document()
*
* DESCRIPTION:  Constructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Document::FC_PhoneBook_VCard_Document(CardType oCardtype)
{
  m_CardType = oCardtype;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::FC_PhoneBook_VCard_Document()
*
* DESCRIPTION:  Copy Constructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Document::FC_PhoneBook_VCard_Document(const FC_PhoneBook_VCard_Document& other)
  : m_CardType(other.m_CardType),
  m_ComponentType(other.m_ComponentType),
  m_Properties(other.m_Properties),
  m_SubDocuments(other.m_SubDocuments)
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::~FC_PhoneBook_VCard_Document()
*
* DESCRIPTION:  Destructor
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Document::~FC_PhoneBook_VCard_Document()
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::operator=()
*
* DESCRIPTION:  Assignment operator
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Document& FC_PhoneBook_VCard_Document::operator=(const FC_PhoneBook_VCard_Document& other)
{
  if (this != &other)
  {
    m_CardType = other.m_CardType;
    m_Properties = other.m_Properties;
    m_SubDocuments = other.m_SubDocuments;
    m_ComponentType = other.m_ComponentType;
  }
  return *this;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::operator==()
*
* DESCRIPTION:  Equals operator
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_Document::operator==(const FC_PhoneBook_VCard_Document& other) const
{
  return m_CardType == other.m_CardType &&
      m_Properties == other.m_Properties &&
      m_SubDocuments == other.m_SubDocuments &&
      m_ComponentType == other.m_ComponentType;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::operator!=()
*
* DESCRIPTION:  Not equal operator
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_Document::operator!=(const FC_PhoneBook_VCard_Document& other) const
{
  return !(*this == other);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::qHash()
*
* DESCRIPTION: Generate a hash value used for QHash
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
uint qHash(const FC_PhoneBook_VCard_Document &key)
{
  uint hash = qHash(key.type());
  hash += qHash(key.componentType());

  QList<FC_PhoneBook_VCard_Property> keyProperty = key.properties();
  foreach (const FC_PhoneBook_VCard_Property& property, keyProperty)
  {
    hash += qHash(property);
  }

  QList<FC_PhoneBook_VCard_Document> keySubDocument = key.subDocuments();
  foreach (const FC_PhoneBook_VCard_Document& nested, keySubDocument)
  {
    hash += qHash(nested);
  }

  return hash;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::setType()
*
* DESCRIPTION: Change the CardType of the document
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::setType(CardType oCardtype)
{
  m_CardType = oCardtype;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::type()
*
* DESCRIPTION:  Gets the document CardType.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_Document::CardType FC_PhoneBook_VCard_Document::type() const
{
  return m_CardType;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::setComponentType()
*
* DESCRIPTION: Sets the type
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::setComponentType(QString str_componentType)
{
  m_ComponentType = str_componentType;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::componentType()
*
* DESCRIPTION:  Gets the type
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QString FC_PhoneBook_VCard_Document::componentType() const
{
  return m_ComponentType;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::addProperty()
*
* DESCRIPTION:  Add new property to the list
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::addProperty(const FC_PhoneBook_VCard_Property& property)
{
  m_Properties.append(property);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::removeProperty()
*
* DESCRIPTION:  Removes the property from the list
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::removeProperty(const FC_PhoneBook_VCard_Property& property)
{
  m_Properties.removeAll(property);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::removeProperties()
*
* DESCRIPTION: Removes all the properties of given name
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::removeProperties(const QString& name)
{
  for (int i=m_Properties.count()-1; i >=0; i--)
  {
    if (m_Properties[i].name() == name)
    {
      m_Properties.removeAt(i);
    }
  }
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::clear()
*
* DESCRIPTION:  Reset the document to default
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::clear()
{
  m_Properties.clear();
  m_SubDocuments.clear();
  m_CardType = FC_PhoneBook_VCard_Document::Invalid;
  m_ComponentType.clear();
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::addSubDocument()
*
* DESCRIPTION:  Adds a subdocument document. (Not required in specs)
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::addSubDocument(const FC_PhoneBook_VCard_Document& subdocument)
{
  m_SubDocuments.append(subdocument);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::setSubDocuments()
*
* DESCRIPTION:  Sets the list of subdocuments
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_Document::setSubDocuments(const QList<FC_PhoneBook_VCard_Document>& documents)
{
  m_SubDocuments = documents;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::subDocuments()
*
* DESCRIPTION:  Returns the list of subdocuments
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QList<FC_PhoneBook_VCard_Document> FC_PhoneBook_VCard_Document::subDocuments() const
{
  return m_SubDocuments;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::properties()
*
* DESCRIPTION:  Gets the list properties.
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QList<FC_PhoneBook_VCard_Property> FC_PhoneBook_VCard_Document::properties() const
{
  return m_Properties;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_Document::isEmpty()
*
* DESCRIPTION: Check if the document is empty.
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_Document::isEmpty() const
{
  return m_Properties.isEmpty()
      && m_SubDocuments.isEmpty()
      && m_CardType == FC_PhoneBook_VCard_Document::Invalid;
}


