/*******************************************************************************
*
* FILE:          FC_PhoneBook_VCard_ByteArray.cpp
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "FC_PhoneBook_VCard_ByteArray.h"


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::FC_PhoneBook_VCard_ByteArray()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_ByteArray::FC_PhoneBook_VCard_ByteArray()
  : mStart(0), mEnd(0)
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::FC_PhoneBook_VCard_ByteArray()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_ByteArray::FC_PhoneBook_VCard_ByteArray(const QByteArray& data)
  :mData(data), mStart(0), mEnd(data.size())
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::FC_PhoneBook_VCard_ByteArray()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_ByteArray::FC_PhoneBook_VCard_ByteArray(const QByteArray& data, int start, int end)
  :mData(data), mStart(start), mEnd(end)
{
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::isEmpty()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_ByteArray::isEmpty() const
{
  return mEnd <= mStart;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::at()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
char FC_PhoneBook_VCard_ByteArray::at(int i) const
{
  return mData.at(mStart + i);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::toByteArray()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QByteArray FC_PhoneBook_VCard_ByteArray::toByteArray() const
{
  return mData.mid(mStart, mEnd-mStart);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::chopLeft()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
/* Removes \a n bytes from the start of the QByteArray. */
void FC_PhoneBook_VCard_ByteArray::chopLeft(int n)
{
  Q_ASSERT(size() >= n && n >= 0);
  mStart += n;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::left()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
QByteArray FC_PhoneBook_VCard_ByteArray::left(int n)
{
  Q_ASSERT(size() >= n && n >= 0);
  return mData.mid(mStart, n);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::indexOf()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
int FC_PhoneBook_VCard_ByteArray::indexOf(const QByteArray& needle)
{
  int array_index = mData.indexOf(needle, mStart) - mStart;
  if (array_index < size())
    return array_index;
  return -1;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::size()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
int FC_PhoneBook_VCard_ByteArray::size() const
{
  return mEnd - mStart;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::constData()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
const char* FC_PhoneBook_VCard_ByteArray::constData() const
{
  return mData.constData() + mStart;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::contains()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_ByteArray::contains(const QByteArray& ba) const
{
  int array_index= mData.indexOf(ba, mStart);
  return (((array_index > 0) && (array_index <= mEnd))?true:false);
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::endsWith()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_ByteArray::endsWith(const QByteArray& ba) const
{
  // Loop backwards from ba and from mData (starting from index mEnd)
  if (ba.size() > size())
    return false;
  return memcmp(mData.constData()+mEnd-ba.size(), ba.constData(), (size_t)ba.size()) == 0;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::operator=()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
FC_PhoneBook_VCard_ByteArray& FC_PhoneBook_VCard_ByteArray::operator=(const QByteArray& ba)
{
  mData = ba;
  mStart = 0;
  mEnd = mData.size();
  return *this;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::operator==()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_ByteArray::operator==(const QByteArray& ba)
{
  return toByteArray() == ba;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::operator!=()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
bool FC_PhoneBook_VCard_ByteArray::operator!=(const QByteArray& ba)
{
  return toByteArray() != ba;
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::dropOldData()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_ByteArray::dropOldData()
{
  if (mStart > FC_PB_MAX_OLD_BYTES_TO_KEEP && mEnd >= mStart)
  {
    mData.remove(0, mStart);
    mEnd -= mStart;
    mStart = 0;
  }
}


/*******************************************************************************
*
* FUNCTION:  FC_PhoneBook_VCard_ByteArray::setBounds()
*
* DESCRIPTION:
*
*
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/
void FC_PhoneBook_VCard_ByteArray::setBounds(int start, int end)
{
  mStart = start;
  mEnd = end;
}

