/*******************************************************************************
*                                                                               
* FILE:          FC_PhoneBook_EvoDBusIfCallBacks.cpp
*                                                                               
* SW-COMPONENT:  FC_PhoneBook application
*                                                                               
* PROJECT:                                                                      
*                                                                               
* DESCRIPTION:   CCA service PhoneBook.
*                                                                               
* AUTHOR:
*                                                                               
* COPYRIGHT:
*                                                                               
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../FC_PhoneBook_Debug.h"
#include "../FC_PhoneBook_main.h"
#include "../FC_PhoneBook_service_PhoneBook.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONEBOOK_DBUS
#include "trcGenProj/Header/FC_PhoneBook_DBusIfCallbacksEvo.cpp.trc.h"
#endif

#include "FC_PhoneBook_DBusInterfaceEvo.h"

static PhBK_CCA_Dbus_If rPhBkCCA_DBusIf_Evo =
{
   EvoFcPhoneBookDbusCallback_DownloadInitiated,
   EvoFcPhoneBookDbusCallback_PostLoopback,
   EvoFcPhoneBookDbusCallback_PushLoopbackData
};

/*******************************************************************************
 * FUNCTION: pGetCCAPhoneBookDBusIf_Evo
 *
 * DESCRIPTION: Suplies CCA_DBusIf_Evo
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
PhBK_CCA_Dbus_If *pGetCCAPhoneBookDBusIf_Evo(tVoid)
{
    return(&rPhBkCCA_DBusIf_Evo);
}


/*******************************************************************************
* FUNCTION: EvoFcPhoneBookDbusCallback_DownloadInitiated
*
* DESCRIPTION: 
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid EvoFcPhoneBookDbusCallback_DownloadInitiated( FC_Device_Details* DeviceDetails )
{
   fc_phonebook_tclService_PhoneBook *poPhoneBookService = NULL;
   poPhoneBookService = fc_phonebook_tclService_PhoneBook::pGetInstance();
   if(poPhoneBookService)
   {
      poPhoneBookService->vPhoneBook_DownloadInitiated(DeviceDetails);
   }
}
/*******************************************************************************
* FUNCTION: EvoFcPhoneBookDbusCallback_PostLoopback
*
* DESCRIPTION: Posts a loop back message for the given function ID
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid EvoFcPhoneBookDbusCallback_PostLoopback(guint32 u32FuncID)
{
   fc_phonebook_tclService_PhoneBook *poPhoneBookService = NULL;
   poPhoneBookService = fc_phonebook_tclService_PhoneBook::pGetInstance();
   if(poPhoneBookService)
   {
      poPhoneBookService->vPrepareandsendLoopBackMsg(u32FuncID);
   }
}

/*******************************************************************************
* FUNCTION: EvoFcPhoneBookDbusCallback_PushLoopbackData
*
* DESCRIPTION: Pushes loopback data into the queue
*
* PARAMETER:
*
* RETURNVALUE: None.
*
********************************************************************************/
tVoid EvoFcPhoneBookDbusCallback_PushLoopbackData(PhBk_Loopback_Data* LB_Data)
{
   fc_phonebook_tclService_PhoneBook *poPhoneBookService = NULL;
   poPhoneBookService = fc_phonebook_tclService_PhoneBook::pGetInstance();
   if(poPhoneBookService)
   {
      poPhoneBookService->vPush_Back_LB_Data(*LB_Data);
   }
}
