/*******************************************************************************
*                                                                               
* FILE:          FC_PhoneBook_service_PhoneBook.h                   
*                                                                               
* SW-COMPONENT:  FC_PhoneBook application                                  
*                                                                               
* PROJECT:       Bosch                                                               
*                                                                               
* DESCRIPTION:   CCA service PhoneBook.                                     
*                                                                               
* AUTHOR:        Arun Choudhary, Omveer                                                               
*                                                                               
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim                          
*                                                                               
*******************************************************************************/

#ifndef _FC_PHONEBOOK_SERVICE_PHONEBOOK_H_
#define _FC_PHONEBOOK_SERVICE_PHONEBOOK_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

// Include Application Help Library.

#include "ahl_if.h"
#include "FC_PhoneBook_Debug.h"
#include "midw_fi_if.h"

#include "DbusClient/FC_PhoneBook_EvoDbusClient.h"//CMG3G-14314
#include "Interface/FC_PhoneBook_DBusInterface.h"
#include "Interface/FC_PhoneBook_DBusInterfaceEvo.h"
#include "FC_PhoneBook_FavoritesProvider.h"
#include "FC_PhoneBook_Dnl_Manager.h"
#include "Database/FC_PhoneBook_Usage.h"
#include "Common/FC_PhoneBook_Global.h" //c++11 compatibility

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Loop back message defines to be processed by vOnLoopbackService().

/* Definition of internal Function IDs (iFIDs) and message        */
/* content IDs (MSGID) which are not public and therefore are     */
/* not in the public FI of our service. Such internal function    */
/* and message content IDs are necessary for 'loopback' messages, */
/* i.e. messages the application sends itself. These internal     */
/* function IDs must be different to the ones from the public FI. */
/* The developer has to take care about that. To have a maximum   */
/* separation of the public and the internal FIDs we start the    */
/* definition for the internal ones nearly at the end of the      */
/* possible range and then count downwards.*/

// Include message framework interface (AMT, msgfw).
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_PHONEBOOK_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_PHONEBOOK_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_PHONEBOOK_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_PHONEBOOK_SERVICEINFO
#define PHONEBOOK_C_U32_MSGID_EXAMPLE_1 0x00000001
#define PHONEBOOK_LOOPBACK_VECTOR_INVALID_POSITION  0xFFFF

#define PHONEBOOK_C_U16_IFID_DBUS   0xFFF0
#define PHONEBOOK_C_U16_IFID_TIMER  0xFFF1

// -bn: MY15 Feature: VPB Import: Code addition: BEGIN
#define PHONEBOOK_C_U32_VEHICLE_CONTACT_IMPORT_SILENT_ADD_CONTACT  0xFA000000   // (A = 'Add vehicle contact' by import ["bulk insertion"] )
#define PHONEBOOK_C_U32_VEHICLE_CONTACT_IMPORT_COMPLETED           0xFC000000   // (C = vehicle contact import ["bulk insertion"] Completed)
// -bn: MY15 Feature: VPB Import: Code addition: END

#define DEVHANDLE 255
#define NOOFCALLINSTANCE 2

#define PARAM_ERR_POSITION_2 2
#define PARAM_ERR_POSITION_3 3
#define PARAM_ERR_POSITION_4 4
#define NIL_ERROR_INFO 0


//FIX CMG3G-8367 IS2424_DownloadOnOff behaviour@FC_Phonebook
// The user shall have possibility to switch the phonebook and call history list download On or Off individual for each paired phone device.
enum EnDownloadOnOffState
{
   PB_DL_ON, PB_DL_OFF, PB_DL_IN_TRANSITION_TO_ON, PB_DL_IN_TRANSITION_TO_OFF
};
//End of fix FIX CMG3G-8367

#define PHONEBOOK_DOWNLOAD_ARRAY_RESET_VALUE 0xFF

// CMG3G-7983 - Indicate the Phonebook Download Progress
#define PBK_DOWNLOAD_PROGRESS_UPDATE_COUNT_REACHED 100   // CMG3G-8386
#define INVALID_VALUE 0xFF //NCG3D-65982
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class FC_PhoneBook_Database;
class ahl_tclBaseOneThreadService;
class fc_phonebook_tclClientHandler_BluetoothSetings;
class FC_Device_Details;
class FC_PhoneBook_Dnl_Manager;
class FC_PhoneBook_MemoryUsage;

typedef struct fc_phonebook_incomingMessage
{
   tU16 u16SourceAppID;
   tU16 u16RegisterID;
   tU16 u16CmdCounter;
   tU16 u16FunctionID;
}IncomingMessage;
//FIX CMG3G-3262 Download State property implementation
class FC_PhoneBook_DownloadState
{
public:
   //Set methods for member variables
   tVoid vSetPBDownloadState(tU8 u8Download_State);
   tVoid vSetRecentCallListDownloadState(tU8 u8Download_State);
   tVoid vSetDeviceHandle(tU8 u8SetDeviceHandle);

   //Get methods for member variables
   tU8 u8GetPBDownloadState()
   {
      return u8PB_DownloadState;
   }
   tU8 u8GetRecentCallListDownloadState() 
   {
      return u8RecentCallList_DownloadState;
   }
   tU8 getDeviceHandle()
   {
      return  u8DeviceHandle ;
   }

   //Constructor and destructor
   FC_PhoneBook_DownloadState();
   ~FC_PhoneBook_DownloadState();
private:
   //Member variables
   tU8 u8RecentCallList_DownloadState;
   tU8 u8PB_DownloadState;
   tU8 u8DeviceHandle;
};
//End of fix

typedef enum
{
   UNKNOWN_BT_STACK = 0,
   ALPS_EVOLUTION_BT_STACK
}BtStack;

class fc_phonebook_tclService_PhoneBook FINAL: public ahl_tclBaseOneThreadService
{
public:
   BtStack m_btStack;
   FC_PhoneBook_Dnl_Manager m_oPbk_DnlManager;
   fc_phonebook_tclClientHandler_BluetoothSetings* m_poBTSettings;
   FC_PhoneBook_MemoryUsage * m_pPhoneBookMemoryUsage;

   // Application specific methods.

   tVoid vOnLoopbackService(amt_tclServiceData* poMessage);
   tVoid vProcessTimer(tU16 u16TimerId);
   // Some internal methods
   tBool bStartTimer(tU16 nTimerID,  \
      OSAL_tMSecond nTimeUntilFirstTimerTick, \
      OSAL_tMSecond nTimerTickInterval);
   tBool bStopTimer(tU16 nTimerID);

   tVoid vSetBTSettingsClientHandlerInstance(fc_phonebook_tclClientHandler_BluetoothSetings* poBTSettings);

   tVoid vSetPrivateServiceAvailableAllowed(tBool on) OVERRIDE
   {
      ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(on);
      m_bServerAvailable = on;
   }
   _CCA_dbus_interfaces_pb* m_pDBus_CCA_If_pb;
   // Attributes 
   tBool m_bServerAvailable;

   GMutex p_mutex_loopback;
   static fc_phonebook_tclService_PhoneBook* pGetInstance(fc_phonebook_tclApp* poMainAppl = NULL);
   static tVoid vDestroyPhonebookServiceInstance();

   tVoid vClearMissedCalls(tU8 u8DeviceHandle,FC_Device_Details * poDeviceObject);
   tVoid vIncomingCall(const PhBk_Loopback_Data* poLB_Data);
   tVoid vCallStatus(const PhBk_Loopback_Data* poLB_Data);

   //   Notification methods from DBus

   tVoid vPhoneBook_PBDownloadComplete(tU8 u8DeviceHandle);

   tVoid vPhoneBook_DownloadInitiated(FC_Device_Details* poDeviceDetails);

   tVoid vPhoneBook_UpdateListChange(most_phonbkfi_tclMsgListChangeStatus& oListChangeStatus);
   tVoid vPhoneBook_UpdatePreferredPhoneBookSortOrderStatus
      (most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& oPreferredPhoneBookSortOrderStatus);
   tVoid vPhoneBook_UpdatePreferredPBSortOrderStatus();
   tVoid vPhoneBook_UpdatePreferredSortOrderListStatus(); //CMG3G-14241
   tVoid vPhoneBook_UpdateMaxContactCount(unsigned int MaxContactsCount);

   tVoid vHandleGetDataError(amt_tclServiceData* poMessage, tCString poHandlerStr);
   tVoid vPhoneBook_UpdateDownloadState(); //FIX CMG3G-3262 Download State property implementation

   tVoid vDeviceDisconnected(tU8 u8ConnectionID);
   tVoid vDeviceDeleted(tU8 u8DeviceHandle);
   tVoid vHandle_PreferredPhoneBookSortOrder_Get(amt_tclServiceData* poMessage);
#ifdef BUGZID_206322 // Workaround for device disconection status
   tVoid vDeviceConnected(tU8 u8DeviceHandle, const tChar * deviceAddress);
#endif
   FC_PhoneBook_Database * poGetDatabaseInstance();
   tVoid vPrepareandsendLoopBackMsg(tU32 u32Internal_FunctionID);
   std::vector<PhBk_Loopback_Data, std::allocator<PhBk_Loopback_Data> > LB_data_queue; // 241829- Replace bpstl:: by std::
   tVoid vPush_Back_LB_Data(PhBk_Loopback_Data &LBData);
   tVoid vErase_LB_Data(tU16 u16Position);
   tU16 u16Get_Data_Position(tU16);
   tVoid vMissedCallIndicatorUpdate(tU32 cMissedCallCnt,FC_Device_Details * poDeviceObject);
   tVoid vCallHistoryUpdated(tU8 u8ConnectionID, tU8 u8CallHistoryDnlCmd);

   tVoid vOnApplicationClose();
   tVoid vClearAutocompleteListsOnOSChange();

   /*FIX CMG3GB-696 Phonebook support value is received as 1 even if user has given cancel for access to contact and call list (after call operation)
   If PbDlGetCapabilities is success, we hold the update and we shall update it in the PbDlPrepare success/failure response.
   If PbDlGetCapabilities fails, update will be sent then itself.
   Also sending updates of Phone book support during call history update.*/
   tVoid vUpdatePhoneBookFeatureSupport(FC_Device_Details * poDeviceObject, tBool bUpdateClients = TRUE);
   //End of fix

   tVoid vPhoneBook_UpdateFavoritesChanged(
      most_phonbkfi_tclMsgFavoritesChangedStatus& oFavoritesChangedStatus);
   FC_Phonebook_tclFavorite_Provider* poGetFavoritesProviderInstance();
   tVoid vPostActivateFavoriteMethodResult(tU16 u16FavoriteID,
      tU32 u32ActivationHandle);
   tVoid vPostActivateFavoriteError(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, tU16 u16FavoriteID, tU8 u8ErrorInfo=0);
   tVoid vPostStoreFavoriteError(amt_tclServiceData* poMessage, tU16 u16ErrorCode, tU8 u8ErrorInfo=0);
   tVoid vPostGetFavoriteInfoError(amt_tclServiceData* poMessage, tU16 u16ErrorCode, tU8 u8ErrorInfo=0);
   tVoid vMakeFavoriteAvaialble(quint8 u8DeviceHandle);
   tVoid vMakeFavoriteUnAvaialble(quint8 u8DeviceHandle);
   void OnLoadSettings();
   FC_PhoneBook_Database *m_pPhoneBookDB;
   //FIX CMG3G-3262 Download State property implementation
   FC_PhoneBook_DownloadState* pGetDownloadStateInstance()
   {
      return m_poDownloadState;
   }
   //End of fix

   //FIX SUZUKI-20814 - Reset observed on varying the voltage (5.7V to 14V)
   tVoid vHandleProxyDereferencing(tVoid);
   //End of fix

   // CMG3G-7983 - Indicate the Phonebook Download Progress
   // CMG3G-11074 - u8DeviceHandle has been added to support two HFP support
   tVoid vUpdatePhonebookDownloadProgress(tU8 u8DeviceHandle, tU32 u32ContactsDownloaded = 0);
   //Fix RTC 159808 -  DownloadProgress API to return percentage of contacts downloaded
   tVoid vUpdatePhonebookDownloadProgressList(tU8 u8DeviceHandle, tBool bDnlStateCompleteOrLimitReached, tU32 u32ContactsDownloaded = 0);
   // Fix CMG3G-12350 - Missed call indicator (ST 2.1)
   tVoid vUpdatePhonebookMissedCallIndicatorList(tU8 u8DeviceHandle);

   //Used by Evolution stack create session interface.
   tVoid vSetVehicleBtAddress(char* Address);
   tVoid vGetVehicleBtAddress(char* Address);

   //CMG3G-11147 - ActivePhoneDevice Property implementation
   tVoid vSetActivePhoneDeviceHandle(tU8 deviceHandle);
   tU8 u8GetActivePhoneDeviceHandle();

   tVoid vPhoneBook_UpdateClientsDownloadOnOffList();
   tVoid vPhoneBook_UpdateClientsAutomaticContactDownloadList();
   //CMG3G-12880 - Phonebook download failure pop-up
   tVoid vCheckDeviceInLockedState(tU8 u8DeviceHandle, tU8 &u8Position);
   tVoid vAddToDeviceLockedList(tU8 u8DeviceHandle);
   tVoid vRemoveFromDeviceLockedList(tU8 u8DeviceHandle);
   tVoid vUpdateProbablyLockedDeviceList();
   //End CMG3G-12880

   //NCG3D-65982
   tVoid vCheckDeviceInDownlodSuspendedState(tU8 u8DeviceHandle, tU8 &u8Position);
   tVoid vAddToSuspendedDownloadList(tU8 u8DeviceHandle);
   tVoid vRemoveFromSuspendedDownloadList(tU8 u8DeviceHandle);
   //End NCG3D-65982
   FC_PhoneBook_DownloadState* m_poDownloadState;

   BtStack getBtStack(void)
   {
      return m_btStack;
   }
   void setBtStack(BtStack btStack)
   {
      m_btStack = btStack;
   }
   //CRQ-243550-Vertical Keyboard Language Selection
   tU8   GetPhonebookLanguage();
   tVoid vSetPhonebookLanguage(tU8 f_PbkLang);
   //end of CRQ-243550-Vertical Keyboard Language Selection
protected:

   // Overriding ahl_tclBaseOneThreadService methods.

   tVoid vOnServiceAvailable() OVERRIDE;
   tVoid vOnServiceUnavailable() OVERRIDE;
   tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg) OVERRIDE;
   tBool bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error) OVERRIDE;
   tVoid vOnNewAppStateNotify(tU32 /*u32OldAppState*/, tU32 /*u32AppState*/) OVERRIDE;

   // Add your CCA message handler function prototypes here.

   // Message map definition macro

   DECLARE_MSG_MAP(fc_phonebook_tclService_PhoneBook) 
private:
   tU8  m_u8PbkLang; //CRQ-243550-Vertical Keyboard Language Selection
   // Keep the pointer to object private
   static fc_phonebook_tclService_PhoneBook* m_poPhoneBookService;

   // Make constructor, copy constructor and destructor as private
   // to make class singleton.
   fc_phonebook_tclService_PhoneBook();
   fc_phonebook_tclService_PhoneBook(fc_phonebook_tclApp* poMainAppl);
   //CMG3G-14313-Coverity Fix
   fc_phonebook_tclService_PhoneBook(const  fc_phonebook_tclService_PhoneBook &oFC_PhoneBook);//User defined Copy Constructor
   fc_phonebook_tclService_PhoneBook& operator= (const fc_phonebook_tclService_PhoneBook &oFC_PhoneBook);//User defined Assignment Operator
   //end of fix
   //(It is defined when class contains pointers or Run time memory allocation otherwise compiler generated copy constructor and assignment operator would be sufficient)

   virtual ~fc_phonebook_tclService_PhoneBook();
   
   tBool bCheckAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel::tenType e8AudioChannel);   // Fix CMG3GB-1093

   /***************************************************************************
   * Handler function declarations used by message map.
   ***************************************************************************/

   tVoid vHandleMethodError(
      most_phonbkfi_tclMsgDefaultError& defaultError,amt_tclServiceData* poMessage);
   tVoid \
      vHandle_CreatePhoneBookList_MethodStart(\
      amt_tclServiceData* poMessage);
   tVoid \
      vHandle_RequestSlicePhoneBookList_MethodStart(\
      amt_tclServiceData* poMessage);
   //FIX SUZUKI-1114 API for numeric value to indicate number of dial-able phone numbers available to a contact item in Phonebook
   tVoid vHandle_RequestPhoneBookListSliceExtended_MethodStart(amt_tclServiceData* poMessage);
   //End of fix
   tVoid \
      vHandle_ReleasePhoneBookList_MethodStart(\
      amt_tclServiceData* poMessage);
   tVoid \
      vHandle_SearchKeyboardPhoneBookList_MethodStart(\
      amt_tclServiceData* poMessage);
   tVoid vHandle_ClearMissedCallIndicator_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_AddContact_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_SearchPhoneBook_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_SearchContacts_MethodStart(amt_tclServiceData* poMessage); // CMG3G-6312

   tVoid vHandle_EditContact_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_DeleteContact_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_GetContactDetails_MethodStart(amt_tclServiceData* poMessage); // For getContact details

   //Fix CMG3G-8365 IS2421_Configurable phone number type representation@FC_Phonebook
   tVoid vHandle_AddContactExtended_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_EditContactExtended_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_GetContactDetailsExtended_MethodStart(amt_tclServiceData* poMessage); // For getContact details
   //End of Fix CMG3G-8365 IS2421_Configurable phone number type representation@FC_Phonebook
   tVoid vHandle_CreateCallHistoryList_MethodStart( amt_tclServiceData* poMessage); // For CreateCallHistoryList

   tVoid vHandle_RequestSliceCallHistoryList_MethodStart( amt_tclServiceData* poMessage); // For SlicecallhistoryList

   //FIX SUZUKI-1113 API for numeric value to indicate number of calls against a CallHistory item in Phonebook
   tVoid vHandle_RequestSliceCallHistoryListExtended_MethodStart( amt_tclServiceData* poMessage); //For SliceCallHistoryListExtended
   //End of fix
   tVoid vHandle_ReleaseCallHistoryList_MethodStart(	amt_tclServiceData* poMessage); // ReleasecallhistoryList

   // Doors ID: 20263: Manual Phonebook download
   tVoid vHandle_StartPbDownload_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_ClearPhoneBookData_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_ClearVehiclePhoneBook_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_ClearVehiclePhonebookExtended_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_SetAutomaticContactDownload_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_GetDeviceCallHistorySupport_MethodStart(amt_tclServiceData* poMessage); // For GetDeviceCallHistorySupport

   tVoid vHandle_GetContactPhotoInfo_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_GetContactPhoto_MethodStart(amt_tclServiceData* poMessage); 

   tVoid vHandle_AutoCompletePhoneNumberEntry_MethodStart(amt_tclServiceData* poMessage); // For AutoComplete Phone Entry

   tVoid vHandle_CreateContactList_MethodStart(amt_tclServiceData* poMessage);  //CMG3G-8368  IS2426_CreateContactList@FC_Phonebook

   tVoid vPhoneBook_UpdateClientsAboutMissedCallCount(tU8 u8DeviceHandle);

   //FIX CMG3G-8367 IS2424_DownloadOnOff behaviour@FC_Phonebook
   // The user shall have possibility to switch the phonebook and call history list download On or Off individual for each paired phone device.
   tVoid vHandle_SwitchDownloadOnOffState_MethodStart(amt_tclServiceData* poMessage);

   bool bOnSwitchDownloadStateOff(tU8 f_u8DeviceHandle, tU8 f_u8ConnectionID);

   bool bIsParametersValid(tU8 f_u8DeviceHandle, tU8 f_u8DownloadOnOffState);

   tVoid vDnlStopCallback(PhBk_Loopback_Data* poLB_Data);
   //End of fix FIX CMG3G-8367

   //FIX CMG3G-8372 IS2430_SetContactPhoto@FC_Phonebook
   tVoid vHandle_SetContactPhoto_MethodStart(amt_tclServiceData* poMessage);

   //FIX CMG3G-8570 IS2502_Cancel PB Download@FC_Phonebook
   tVoid vHandle_CancelPbDownload_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_SetContactPosition_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_GetPositionForContactHandle_MethodStart(amt_tclServiceData* poMessage);

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus           m_oDevicePhoneBookFeatureSupportStatus;
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus   m_oDevicePhoneBookFeatureSupportExtendedStatus;
   most_phonbkfi_tclMsgMissedCallIndicatorStatus                     m_oMisssedCallIndicatorStatus;
   most_phonbkfi_tclMsgListChangeStatus                              m_oListChangeStatus;
   most_phonbkfi_tclMsgFavoritesChangedStatus                        m_oFavoritesChangedStatus;
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus             m_oPreferredPhoneBookSortOrderStatus;
   most_phonbkfi_tclMsgDownloadOnOffListStatus                       m_oDownloadOnOffListStatus;    //FIX CMG3G-8367 IS2424_DownloadOnOff behaviour@FC_Phonebook
   most_phonbkfi_tclMsgDownloadStateStatus                           m_oDownloadState; //FIX CMG3G-3262 Download State property implementation
   most_phonbkfi_tclMsgDownloadStateExtendedStatus                   m_oDownloadStateExtended; //FIX CMG3GB-1754
   most_phonbkfi_tclMsgDownloadProgressStatus                        m_oDownloadProgress; // CMG3G-7983 - Indicate the Phonebook Download Progress
   most_phonbkfi_tclMsgDownloadProgressListStatus                    m_oDownloadProgressListStatus; // Phonebook Download Progress for all connected devices
   most_phonbkfi_tclMsgAutomaticContactDownloadListStatus            m_oAutomaticContactDownloadListStatus;
   most_phonbkfi_tclMsgProbablyLockedDevicesStatus                   m_oProbablyLockedDevices; //CMG3G-12880 - Contains probaly Locked devices
   most_phonbkfi_tclMsgMissedCallIndicatorListStatus                 m_oMissedCallIndicatorListStatus; // CMG3G-12350 - Missed call indicator for all connected devices
   most_phonbkfi_tclMsgPreferredSortOrderListStatus                  m_oPreferredSortOrderListStatus; //CMG3G-14241 - Device specific settings.
   most_phonbkfi_tclMsgPhonebookLanguageStatus                       m_oPhonebookLanguage_Status; //CRQ-243550-Vertical Keyboard Language Selection
   most_phonbkfi_tclMsgMaxContactCountStatus                         m_oMaxContactCountStatus; //CRQ-563636-Phone Book Entries Counter

   tULong m_aNoOfMissedCalls[DEVHANDLE];
   char m_sVehicleBtAddress[LENGTH_OF_DEVICE_ADDRESS];
   tU8 m_u8ActivePhoneDeviceHandle;

private:
   bool GetExistingDeviceCapability(FC_PhoneBook_FeatureSupport_Detail& fs, tU8 u8DeviceHandle);
   //***************************************************************************************
   // 	 					Interface Favorite Provider
   //***************************************************************************************
   FC_Phonebook_tclFavorite_Provider * m_poFavoriteProvider;
   tVoid vHandle_Store_Favorite_MethodStart(amt_tclServiceData* poMessage); // For StoreFavorite
   tVoid vHandle_Activate_Favorite_MethodStart(amt_tclServiceData* poMessage); // For  ActivateFavorite
   tVoid vHandle_Delete_Favorite_MethodStart(amt_tclServiceData* poMessage); // For DeleteFavorite
   tVoid vHandle_Get_FavoriteInfo_MethodStart(amt_tclServiceData* poMessage); // For GetFavoriteInfo
   tVoid vHandle_Reset_Favorites_MethodStart(amt_tclServiceData* poMessage); // For ResetFavorites

   std::map<tU16, IncomingMessage> m_oActivateFavMap; // 241829- Replace bpstl:: by std::
};

#endif // _FC_PHONEBOOK_SERVICE_PHONEBOOK_H_
