/*******************************************************************************
 *
 * FILE:          FC_PhoneBook_clienthandler_BluetoothSetings.h
 *
 * SW-COMPONENT:  FC_PhoneBook application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA client-handler for the service BluetoothSetings.
 *
 * AUTHOR:        Arun Choudhary
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_PHONEBOOK_CLIENTHANDLER_BLUETOOTHSETTINGS_H_
#define _FC_PHONEBOOK_CLIENTHANDLER_BLUETOOTHSETTINGS_H_

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

#include "conn_most_fi_if.h"
#include "FC_PhoneBook_main.h"
#include "Common/FC_PhoneBook_Global.h"

/*******************************************************************************
 *                               PROTOTYPES
 ******************************************************************************/
#define MAXIMUM_DEVICE_HANDLE			11
#define MINIMUM_DEVICE_HANDLE			0
/*******************************************************************************
 *                              START OF CODE
 ******************************************************************************/
class ahl_tclBaseOneThreadClientHandler;
class FC_Device_Details;

class fc_phonebook_tclClientHandler_BluetoothSetings : public ahl_tclBaseOneThreadClientHandler
{
   // Message map definition macro
   DECLARE_MSG_MAP( fc_phonebook_tclClientHandler_BluetoothSetings)
public:
   static std::map<tU8, std::string> ConnnectedDevicesMap; // 241829- Replace bpstl:: by std::
   std::vector< tU8 > m_u8SuspendedDeviceDownloadList; // 241829- Replace bpstl:: by std::
   tVoid vSetDeviceConnectInProgress(tU8 u8DeviceHandle);
   tU8 u8GetDeviceConnectInProgress(tVoid);

   fc_phonebook_tclClientHandler_BluetoothSetings( tVoid);
         fc_phonebook_tclClientHandler_BluetoothSetings(fc_phonebook_tclApp* poMainAppl);
   virtual ~fc_phonebook_tclClientHandler_BluetoothSetings() FINAL;

   // Assingment Operater, will not be implemented.
   // Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   // 'fc_phonebook_tclClientHandler_StreamRouter' which has no assignment operator.
   // NOTE: This is a technique to disable the assignment operator for this
   // class. So if an attempt for the assignment is made compiler complains.

   fc_phonebook_tclClientHandler_BluetoothSetings
         & operator=(const fc_phonebook_tclClientHandler_BluetoothSetings &oClientHandler);

   // Application specific methods.

   tVoid vProcessTimer(tU16 u16TimerId);

   // Overriding ahl_tclBaseOneThreadClientHandler methods.

   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;

   // Handler function declarations used by message map.


   // Add your CCA message handler function prototypes here.
   tVoid vHandle_DeviceListExtended_Status(amt_tclServiceData* poMessage);//FIX SUZUKI-22811
   tVoid vHandle_VehicleBtAddress_Status(amt_tclServiceData* poMessage);

   tVoid vTrigger_ConnectBluetoothProfile_MethodStart(tU8 u8DeviceHandle);
   tVoid
         vHandle_ConnectBluetoothProfile_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_ConnectBluetoothProfile_Error(amt_tclServiceData* poMessage);

   tVoid vTrigger_DisconnectBluetoothProfile_MethodStart(tU8 u8DeviceHandle);
   tVoid
         vHandle_DisconnectBluetoothProfile_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_DisconnectBluetoothProfile_Error(amt_tclServiceData* poMessage);

   static tBool vIsDeviceConnected(tU8);
   tVoid
         vUpdate_ClientHandler_PhoneBook(fc_phonebook_tclService_PhoneBook *& p_clientHandler_PhoneBook);
   tVoid vCheckForNewlyConnectedDevicesOrRetries(tVoid);
   tVoid vRegisterForBTProperties();


private:
   fc_phonebook_tclService_PhoneBook* m_poPhoneBookService;
   tBool m_u8DeviceConnectInProgress;

   tVoid vDeviceDisconnected(tU8 u8DeviceHandle);
   tVoid vDeviceDeleted(tU8 u8DeviceHandle);
   tBool vIsDeviceHandleValid(tU8 u8DeviceHandle);
   tVoid vPostConnectLoopback(tU8 u8DeviceHandle, const tChar *deviceAddress);
   tVoid vHandleRetryForPBAPConnect(tU8 u8DeviceHandle);
   tVoid vPostResumeSuspendedDwnldLoopback(tU8 u8DeviceHandle);
};

#endif // _FC_PHONEBOOK_CLIENTHANDLER_BLUETOOTHSETTINGS_H_
