/*******************************************************************************
*
* FILE:          FC_PhoneBook_FavoriteProvider.h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:       Bosch
*
* DESCRIPTION:   Favorite Provider PhoneBook.
*
* AUTHOR:        Abhishek Kumar Dhiman
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_FAVORITE_PROVIDER_H_
#define _FC_PHONEBOOK_FAVORITE_PROVIDER_H_

#include "Database/FC_PhoneBook_SQLite.h"
#include "Common/FC_PhoneBook_Global.h" //c++11 compatibility


/*******************************************************************************
*                           INCLUDES
*******************************************************************************/
#include "FC_PhoneBook_main.h"

class most_phonbkfi_tclMsgStoreFavoriteMethodStart;
class most_phonbkfi_tclMsgStoreFavoriteMethodResult;
class most_phonbkfi_tclMsgGetFavoriteInfoMethodStart;
class most_phonbkfi_tclMsgGetFavoriteInfoMethodResult;
class most_phonbkfi_tclMsgDeleteFavoriteMethodStart;
class most_phonbkfi_tclMsgDeleteFavoriteMethodResult;
class most_phonbkfi_tclMsgResetFavoritesMethodStart;
class most_phonbkfi_tclMsgResetFavoritesMethodResult;

class most_fi_tcl_e8_FavPrvFavoriteType;

class FC_PhoneBook_SQLite;
class fc_phonebook_tclService_PhoneBook;
class fc_phonebook_tclClientHandler_Phone;
/*******************************************************************************
*                            DEFINES
*******************************************************************************/


/*******************************************************************************
*                       ARRAYS AND CONSTANTS
*******************************************************************************/

/*******************************************************************************
*                     CLASS, ENUM AND STRUCTURES
*******************************************************************************/

class favoritidequeue
{
private:
   QMutex mutexCCAMsgService;
   QQueue<tU16> ccaMessageQBuffer;

public:
   favoritidequeue(){};
   ~favoritidequeue(){};
   tVoid enqueueCCAMessage(tU16);
   tU16 dequeueCCAMessage();
};
class FC_Phonebook_tclFavorite_Provider
{

public:
   enum favoriteTag
   {
      ContactNameTag= 0,
      FirstNameTag,
      LastNameTag,
      POINameTag,
      PrefNumTag,
      CellNum1Tag,
      CellNum2Tag,
      HomeNum1Tag,
      HomeNum2Tag,
      WorkNum1Tag,
      WorkNum2Tag,
      OtherNumTag,
      EmailAdd1Tag,
      EmailAdd2Tag,
      EmailAdd3Tag,
      HomeAddTag,
      WorkAddTag,
      OtherAddTag,
      CategoryTag,
      NotesTag
   };
   //-------------------------------------------------------------------------
   //                  Constructor and Destructor
   //-------------------------------------------------------------------------
   FC_Phonebook_tclFavorite_Provider();
   ~FC_Phonebook_tclFavorite_Provider();

   //-------------------------------------------------------------------------
   //         Suppress copy constructor and assignment operator
   //-------------------------------------------------------------------------
   FC_Phonebook_tclFavorite_Provider & operator= (const FC_Phonebook_tclFavorite_Provider &ofc_phonebook_tclFavorite_Provider);
   FC_Phonebook_tclFavorite_Provider(const FC_Phonebook_tclFavorite_Provider &ofc_phonebook_tclFavorite_Provider);

   //-------------------------------------------------------------------------
   //                           Methods
   //-------------------------------------------------------------------------
   bool Store_Favorite(const most_phonbkfi_tclMsgStoreFavoriteMethodStart* methodStart ,
      most_phonbkfi_tclMsgStoreFavoriteMethodResult *methodResult, quint16& u16ErrorCode,tU8& u8ErrorInfo);   // For  StoreFavorite
   bool GetFavoriteInfo(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart* methodStart,
      most_phonbkfi_tclMsgGetFavoriteInfoMethodResult *methodResult,tU16& u16ErrorCode,tU8& u8ErrorInfo); // For RestoreStoredFavorites

   bool Activate_Favorite(const most_phonbkfi_tclMsgActivateFavoriteMethodStart* methodStart); // For  ActivateFavorite

   bool Delete_Favorite(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart* methodStart,
      most_phonbkfi_tclMsgDeleteFavoriteMethodResult *methodResult, quint16& u16ErrorCode); 		// For DeleteFavorite

   bool Reset_Favorites(bool fResetDeviceSpecificFav = false, tU8 fU8DeviceHandle = 0xff); // For ResetFavorites

   bool Transfer_Favorites(); // For TransferFavorites

   void ResetAllFavoritesAsUnavailable();
   void MethodResultPosted(const quint16 u16FuntionID,
      const most_phonbkfi_tclMsgBaseMessage* MethodStart,
      const most_phonbkfi_tclMsgBaseMessage* MethodResult);
   void RefreshFavoritesOnDeleteContact(quint32 u32ContactHandle);
   void RefreshFavoritesOnEditContact(
      FC_PhoneBook_Contact_Detail& ContactDetail);
   static FC_Phonebook_tclFavorite_Provider* GetInstance();
   void RefreshFavoritesOnDownloadComplete(quint8 u8DeviceHandle);
   void RefreshFavoritesOnDeviceDisconnection(quint8 u8DeviceHandle);
   void RefreshFavoritesOnDeviceDeletion(quint8 u8DeviceHandle);   // ---: RB fix proposal for GMNGA-53014 and GMMY15-248
   quint32 GetTotalFavoritesCount();
   void RegisterPhoneClientHandlerInstance(
      fc_phonebook_tclClientHandler_Phone* pPhoneClientHandler);
   // Fix for GMMY16-9895 Pressing the favorite button that was used to place an outgoing call does not end the call
   void SendActivateFavoriteMError(quint16 u16ErrorCode);
   void SendActivateFavoriteMR(quint16 u16CallInstance, most_fi_tcl_e8_TelCallStatus::tenType enCallStatus);
   // End of Fix GMMY16-9895
   void CallStatusNotice(quint16 u16CallInstance,
      most_fi_tcl_e8_TelCallStatus::tenType enCallStatus);
   void UpdateFavoriteIDList();
   bool InActivateFavoriteAfterDTMF(tU16 u16FavoriteID);

   void triggerFavoritesChange(tU8 DeviceHandle);
   void triggerFavoritesChange(tU32 ContactHandle);
   void MakeFavoritesAvailable(quint8 DeviceHandle);
   void MakeFavoritesUnAvailable(quint8 DeviceHandle);
   void ChangefavoriteActiveStatus(quint8 u8Status);
   void RefreshFavoritesOnClearVehiclePhoneBook();
   bool RefreshFavoritesOnClearPhoneBook(bool fResetDeviceSpecificFav = false, tU8 fU8DeviceHandle = 0xff); //FIX GMMY16-23858
   favoritidequeue FavoriteIdqueue;
   //FIX GMNGA-56482 Favorite not highlighted when Call active
   void QueryTelephoneNumberMethodResult(QString sTelephoneNumber, quint16 u16CallInstance);

private:
   QList<quint16> m_UsedFavoriteIDList;
   FC_PhoneBook_SQLite *m_favSqlite;
   fc_phonebook_tclService_PhoneBook* m_poservice_phonebook;
   static FC_Phonebook_tclFavorite_Provider* m_self;
   fc_phonebook_tclClientHandler_Phone* m_poPhoneClientHandler;
   QList<quint16> m_ActivatedFavoriteIDList;       //This is the list of favorite ids for which the Activate_Favorite Method_Result/ Method_Error is yet to be sent
   QHash<quint16, quint16> m_CallInstanceFavIDMap; //This contains mapping from call instance to favorite id

   most_fi_tcl_e8_FavPrvFavoriteType::tenType getFavoriteType(quint8 favType);
   void fillLabelAndDescriptionText(
      const FC_PhoneBook_Fav_Detail* FavDetails, QString& LabelText,
      QString& DescriptionText);
   bool generateUniqueFavoritesID(quint16& u16FavID);
   bool fetchFavoriteDetailsFromContact(quint32 u32ObjectId,
      FC_PhoneBook_Fav_Detail& FavDetails);
   bool isFavoriteAvailable(quint32 u32ContactHandle,
      quint8& u8DeviceHandle);
   void triggerFavoritesChangeOnStore(quint16 u16FavoriteID);
   void triggerFavoritesChangeOnDelete(quint16 u16FavoriteID);
   void sendFavoritesChangedPropertyUpdate(quint32 u32FavoritesChangeType, quint32 u32ListLength,
      quint32 u32NumOfItems, QList<quint16> FavoritesIDList);
   void retreivePhoneNumberFromContact(const FC_PhoneBook_Contact_Detail& ContactDetail,
      quint8 u8TagValue, QString& PhoneNumber);

   //FIX GMMY15-6842 Favorite not highlighted when Call active
   QHash<quint16, quint8> m_CallInstanceStateMap;
};

#endif // _FC_PHONEBOOK_FAVORITE_PROVIDER_H_
