/*******************************************************************************
*
* FILE:           FC_Phonebook_Device_Details.h
*
* SW-COMPONENT:   FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:    Handles the Device Data.
*                 Every connected device will be represented by one instance this class
*
* AUTHOR:         Abhishek Kumar Dhiman
*
* COPYRIGHT:      (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_DEVICE_DETAILS_
#define _FC_PHONEBOOK_DEVICE_DETAILS_

/*******************************************************************************
*   INCLUDES
*******************************************************************************/
#include "conn_most_fi_if.h"
#include "Database/FC_PhoneBook_SQLite.h"
#include "Database/FC_PhoneBook_Usage.h"
#include "Common/FC_PhoneBook_Global.h" //CMG3G-14313- Coverity Fix
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

/*******************************************************************************
*   DEFINES
*******************************************************************************/
#define  LENGTH_OF_DEVICE_ADDRESS   25 // for dual connection
#define  NO_OF_CONNECTED_DEVICE      2  // for dual connection
#define  MAX_PBDL_TYPE_SUPPORTED     8
#define  EMPTY_STRING               ""


/*******************************************************************************
*   ARRAYS AND CONSTANTS
*******************************************************************************/
enum INDEX
{
   FIRST = 0,
   SECOND = 1,
   INVALID = 2
};

//*****************************************************************************/


class FC_Device_Details
{

public:
   tChar                       m_deviceAddress[LENGTH_OF_DEVICE_ADDRESS];
   tU8                         m_newMissedcall;
   tU8                         PBDLCommand;
   QList<quint32>              InvalidContactHandleList;
   QList<quint32>              NewContactsAdded;
   quint8                      RetryCnt;
   quint8                      u8DownloadTypeList[MAX_PBDL_TYPE_SUPPORTED];
   tBool                       m_capRequestInProcess;
   int                         m_countDownload;
   int                         downloadType;
   QList<tU8>                  m_u8PendingRecentCallCommandList;
   tBool                       m_bIsPendingRecentCallDownloading;
   tBool                       m_bMEDownloadStatus;
   tBool                       m_bSMDownloadStatus;  // -bn-PBDL.S: added

   QString                     m_sRecentMissedCallDate;
   QString                     m_sRecentMissedCallTime;

   QString                     m_sFirstMissedCallDate;
   QString                     m_sFirstMissedCallTime;

   quint32                     m_LastConnectionTimeElapsed;
   tBool                       m_bDlCompletedOnceValue;

   tBool                       m_bIsPendingManualPBDownloading;
   QList<tU8>                  m_u8PendingManualPBCommandList;

   quint32                     m_u32ContributingVCardCount;    // CMG3G-7702
   quint32                     m_u32DeviceContactsCount;       // CMG3G-8363
   quint32                     m_u32VCardsAvailableForDwnld;            // CMG3G-8688
   quint32                     m_u32PhotosUpdatedInCurrentDwnld;    // PSARCCB-8551

   QList<FC_PhoneBook_Contact_Detail> m_NewContactsToBeAddedRAMList;  // -bn: 2016.01: DL speed improvement by collecting contacts before insertion to database
   QList<FC_PhoneBook_Contact_Detail> m_PhotosToBeUpdatedRAMList;     // -bn: 2016.01: DL speed improvement by collecting contacts before photo update in database

   tU8                         m_u8FAVSPDDwnldSupport; //CMG3G-11867
   quint32                     m_u32DeviceSimContactsCount;  //RTC 159808
   quint32                     m_u32DeviceIntPbContactsCount;  //CMG3G-12876
   quint32                     m_u32DeviceFavContactsCount;  //CMG3G-12876
   quint32                     m_u32DeviceSpdContactsCount;  //CMG3G-12876
   quint32                     m_u32InidvidualTypeContactsCount;  //RTC 159808 It indicates each type (PB or SIM) count
   
   enum enDownloadStates
   {
      DOWNLOAD_ST_IDLE,
      DOWNLOAD_ST_NOT_STARTED,
      DOWNLOAD_ST_PBK_PROGRESS,
      DOWNLOAD_ST_CH_PROGRESS,
      DOWNLOAD_ST_CH_UPDATE
   };
   struct _Device_DateTime_Support
   {
      tBool DateTimesupportUpdated;
      tBool CHDateTimeSupport;
      tBool VcardsHaveDatetime;
      tBool VcardsHaveDatetimeupdated;
   }Device_DateTime_Support;

private:
   //------------------------------------------------------------------------
   //   Members
   //------------------------------------------------------------------------
   tU8                             m_connectionID;
   tU8                             m_deviceHandle;
   tU8                             m_sourceType;
   tU8                             m_deviceCapabilities;
   enDownloadStates                m_enPBKDownloadState;
   tBool                           m_sortListViewSupport;
   tBool                           m_blFirstTimeDownload;
   tU32                            m_MissedcallCount; //CMG3G-12350
   tU16                            m_downloadOnOffStatus;

   static FC_Device_Details *      arrayConnectedDevice[NO_OF_CONNECTED_DEVICE];
   static QMutex                   m_DeviceListMutex; //CLONE TICKET FIX GMMY15-1531 - Avoids parallel access to FC_Device_Details

   //FIX GMMY15-8739 Contacts are Displayed on the HMI, even though PBAP request was not accepted on the phone device.
   //HMI provided result for Create PB and CH list only if Prepare result has been received from DBus as success.
   tBool                           m_bPrepareCBStatus;
   //End of fix

   tBool                           m_bIsCancelPbDownload;//FIX CMG3G-8372

   tBool                           m_bDeviceProbablyLocked; //Fix CMG3G-12880
   tBool                           m_bSuspiciousGetSize; //Fix : CMG3G-12800

   tBool                           m_bDeviceDownloadSuspended; //Fix NCG3D-65982

public:
   //-------------------------------------------------------------------------
   //   Constructor and Destructor
   //-------------------------------------------------------------------------
   FC_Device_Details(tU8 tU8Values = 0);
   ~FC_Device_Details();

   void setCapInProgress(bool inprogress)
   {
      m_capRequestInProcess =inprogress;
   }
   bool getCapInProgress()
   {
      return m_capRequestInProcess;
   }

   //-------------------------------------------------------------------------
   //   Suppress copy constructor and assignment operator
   //-------------------------------------------------------------------------
   FC_Device_Details & operator= (const FC_Device_Details &oFC_Device_Details);
   FC_Device_Details(const FC_Device_Details &oFC_Device_Details);

   //-------------------------------------------------------------------------
   //   Methods
   //-------------------------------------------------------------------------
   // get/set function for connectionID
   tU8  getConnectionID();
   tVoid  setConnectionID(tU8 );

   // get/set function for devicehandle
   tU8  getDeviceHandle();
   tVoid  setDeviceHandle(tU8 );

   // get/set function for sourceType
   tU8  getSourceType();
   tVoid  setSourceType(tU8 );

   // get/set function for deviceCapabilities
   tU8  getDeviceCapabilities();
   tVoid  setDeviceCapabilities(tU8 );

   // get/set function for deviceAddress
   tChar *  getDeviceAddress();
   tVoid  setDeviceAddress(const tChar * );

   //FIX CMG3G-8367 IS2424_DownloadOnOff behaviour@FC_Phonebook
   // The user shall have possibility to switch the phonebook and call history list download On or Off individual for each paired phone device.   
   // get/set function for DownloadOnOffStatus
   tU16 getDownloadOnOffStatus();
   tVoid setDownloadOnOffStatus(tU16 downloadOnOffStatus);
   //End of fix FIX CMG3G-8367		   

   //FIX GMMY15-8739 Contacts are Displayed on the HMI, even though PBAP request was not accepted on the phone device.
   //HMI provided result for Create PB and CH list only if Prepare result has been received from DBus as success.
   // get/set function for Prepare CallBack Status
   tBool  getPhBkPrepareCallBackStatus();
   tVoid  setPhBkPrepareCallBackStatus(tBool setPrepCBStatus);
   //End of fix

   tVoid SetDownloadState(enDownloadStates enNewDnlState);
   enDownloadStates GetDownloadState();

   // get/set function for sort list view support
   tBool  getSortListViewSupport();
   tVoid  setSortListViewSupport(tBool );
   tBool  blIsCCHSupported();

   void   setFirstTimeDownload(tBool blValue);
   tBool  blIsItFirstTimeDownload();

   //get/set Cancel contacts download
   tBool  bIsCancelPBRequested();
   tVoid  setCancelPBDownload(tBool );

   //Fix: CMG3G-12880 Phonebook download failure popup
   tVoid  vSetDeviceProbablyLocked(tBool);
   tBool  bIsDeviceProbablyLocked();
   tVoid  vSetSuspiciousGetSize(tBool);
   tBool  bGetSuspiciousGetSize();
   tU32   GetMissedcallCount();
   tVoid  vSetMissedcallCount(tU32 missedcallCount);
   tVoid  vSwapMissedCallDetails();

   //Fix: NCG3D-65982
   tVoid  vSetDeviceDownloadSuspended(tBool);
   tBool  bIsDeviceDownloadSuspended();
   //End fix NCG3D-65982

   // -bn: 2016.01: DL speed improvement by collecting contacts before insertion to database
   bool FindExactMatchingContact_inRAMList(const FC_PhoneBook_Contact_Detail& ContactDetail,
                                           bool& bPhotoMatches, quint32& u32photoSizeOld);

   //---------------------------------------------------------------------------
   //   static methods to maintain device class data
   //---------------------------------------------------------------------------
   static FC_Device_Details * getDeviceObject(INDEX getIndex);
   static tVoid createDeviceObject(INDEX createIndex );
   static tVoid deleteDeviceObject(INDEX deleteIndex);
   static FC_Device_Details* deviceAddressToObjectInstance(const tChar *deviceAddress);
   static FC_Device_Details* deviceHandleToObjectInstance(tU8 devicehandle);
};
#endif // _FC_PHONEBOOK_DEVICE_DETAILS_
