/*******************************************************************************
 *
 * FILE:          FC_PhoneBook_EvoDbusClient.h
 *
 * SW-COMPONENT:  FC_PhoneBook application
 *
 * PROJECT:
 *
 * DESCRIPTION:  Dbus Client handler API's
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _FB_EVO_DBUS_H
#define _FB_EVO_DBUS_H
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include <unistd.h>
#include <pthread.h>
#include <fstream>

// work-around for Qt "signals" macro
#ifdef signals
# undef signals
# define __define_signals__
#endif

#include <gio/gio.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <../generated/FC_PhoneBook_DbusClient_bindings_client.h>
#include <../generated/FC_PhoneBook_DbusClient_bindings_session.h>
#include <../generated/FC_PhoneBook_DbusClient_bindings_phonebook_access.h>
#include <../generated/FC_PhoneBook_DbusClient_bindings_transfer.h>
#include <../generated/FC_PhoneBook_EvoDbusClient_bindings_device.h>
#include <../generated/FC_PhoneBook_DbusClient_bindings_freedesktop_properties.h>
#include <../generated/FC_PhoneBook_DbusClient_bindings_object_manager.h>
#include "../FC_PhoneBook_clienthandler_BluetoothSetings.h"//CMG3G-14314
#include "../Interface/FC_PhoneBook_DBusInterface.h"//CMG3G-14314
// work-around for Qt "signals" macro
#ifdef __define_signals__
# define signals protected
# undef __define_signals__
#endif


#include "../Common/FC_PhoneBook_Global.h"

//Evolution object path and Service Name
#define BASE_OBJECT_PATH_EVO  "/org/bluez/obex"
#define PHBK_DEVICE_OBJ_PATH "/org/bluez/hci1/"
#define BASE_SERVICE_NAME_EVO "org.bluez.obex"
#define PHBK_TRANSFER_INT_NAME "org.bluez.obex.Transfer"
#define PHBK_SESSION_PATH_PREFIX "/org/bluez/obex/client/session"

#define TARGET_FILE_CALL_HISTORY "/tmp/phonebook/CallHistory.vcf"
#define TARGET_FILE_PHONE_BOOK "/tmp/phonebook/PhoneBook.vcf"

//SELECT and PULLALL method specific parameters
#define VCARD_LOCATION_INT "INT"
#define VCARD_LOCATION_SIM "SIM"

#define VCARD_PHONEBOOK_PB "pb"
#define VCARD_PHONEBOOK_ICH "ich"
#define VCARD_PHONEBOOK_OCH "och"
#define VCARD_PHONEBOOK_MCH "mch"
#define VCARD_PHONEBOOK_CCH "cch"
#define VCARD_PHONEBOOK_SPD "spd"
#define VCARD_PHONEBOOK_FAV "fav"
#define VCARD_PHONEBOOK_INVALID "invalid"

#define EVO_ENABLE_V_CARD_PICTURE_ICON 1
#define EVO_DISABLE_V_CARD_PICTURE_ICON 0

//v-cards to be pulled in multiples of 100 from the connected device
#define PULL_ITERATION_CONTACTS_COUNT 100

#define NO_OF_RETRIES_EVO 5
#define LENGTH_OF_EVO_DEVICE_ADDRESS 18 //Evo stack accepts device address as aa:bb:cc:dd:ee:ff
//Dbusclient.spp MACROS- CMG3G-14314
// Genric macros
#define E_ERROR -1
#define E_SUCCESS 0
#define E_NO_MEMORY 1
#define E_FAILURE 2
#define E_INVALID_ARG 3
#define E_THREAD_CREATE 4
#define NO_OF_CH_RETRIES 1

#define DEFAULT_CONTACT_COUNT 0

#define PBDL_SUCCESS  0x00
#define PBDL_STOPPED 0x0C
#define PB_DOWNLOAD_COMPLETE_SUCCESS 0x00
#define PB_DOWNLOAD_COMPLETE_FAILED 0x01

//Fix RTC 175077 , 239517 & 240713
//Error was sent by stack, if phone sends "Operation Fail" for any operation.
//This error was retrieved from the "GError" structure and example as follows
//error sender=:1.30 -> dest=:1.29 error_name=org.bluez.obex.Error.Failed reply_serial=728
//      string "operation fail"
#define DBUS_ERROR_OBEX_OPERATION_FAILED   "GDBus.Error:org.bluez.obex.Error.Failed: operation fail"
#define DBUS_ERROR_OPERATION_FAILED "GDBus.Error:org.bluez.Error.Failed: operation fail"
#define DBUS_ERROR_SESSION_BUSY "GDBus.Error:org.bluez.Error.Failed: Session busy" //NCG3D-103980

//End fix RTC 175077 , 239517 & 240713

extern QMutex g_Phonebook_DeviceMutex;


typedef struct CCA_dbus_interface_table_pb
{
   int  (*vPhoneBook_Load_MaxContactCount)();
   int  (*PhoneBook_InitiateDownload)(FC_Device_Details *,unsigned char);
   int  (*vPhoneBook_DnlStop)(guint8);
   int  (*vPhoneBook_onDeviceConnect)(FC_Device_Details *);
   int  (*vPhoneBook_onDeviceDisconnect)(guint8);
   int  (*vPhoneBook_DnlPrepare)(guint8 );
   int  (*vPhoneBook_DnlGetCapabilities)(guint8 );
   int  (*vPhoneBook_DnlStart)(guint8, guchar,tU8);
   int  (*vPhoneBook_DnlComplete)(guint8);
   int  (*vPhoneBook_StartDlPB)(FC_Device_Details *,unsigned char);
   void (*vPhoneBook_DnlGetSize)(FC_Device_Details *); 
}_CCA_dbus_interfaces_pb;
//End of Fix CMG3G-14314

//Fix CMG3G-12876
#define PBAP_FAV_DWNLD_SUPPORTED 0x08 //CMG3G-11867
#define PBAP_SPD_DWNLD_SUPPORTED 0x04
#define PBAP_SIM_DWNLD_SUPPORTED 0x02
//End Fix CMG3G-12876

//Phone Book Proxy structure
typedef struct PhoneBookDBusProxies_Evo
{
   OrgBluezObexPhonebookAccess* m_poProxyPbAccess;
   OrgBluezObexTransfer* m_poProxyTransfer;
   OrgBluezDevice1* m_poProxyDevice;
   OrgFreedesktopDBusProperties* m_poFreeDesktopProxy;

} PhoneBookDBusProxies_Evo;

//Phone Book ObjectPath structure
typedef struct ObjectPath_Evo
{
   char* SessionPath;
   char* DevicePath;
   char* TransferPath;
   tULong u1PropertyChangedID;
   tU8 DeviceHandle;

} ObjectPath_Evo;

//Phone Book Signal handler IDs
typedef struct SignalHandlerIDs_Evo
{
   tULong ulInterfacesAddedID;
   tULong ulInterfacesRemovedID;

} SignalHandlerIDs_Evo;

//Evolution instance
_CCA_dbus_interfaces_pb * get_cca_dbus_interface_pb_Evo(void);

//Register Callback.
unsigned char register_PhBkcca_callbacks_Evo(_PhBK_CCA_Dbus_If *vCCA_callbacks);

//Methods from DCCA_dbus_interfaces_pb_Evo struct
int EvoPhoneBook_InitiateDownload(FC_Device_Details * deviceObject, unsigned char cmd);
int EvoPhoneBook_Load_MaxContactCount(void);
int EvoPhoneBook_DlStop(guint8 u8ConnectionID);
int EvoPhoneBook_onDeviceConnect(FC_Device_Details *);
int EvoPhoneBook_onDeviceDisconnect(guint8);
int EvoPhoneBook_DlPrepare(guint8 u8ConnectionID);
int EvoPhoneBook_DlGetCapabilities(guint8 u8ConnectionID);
int EvoPhoneBook_DnlStart(guint8 u8ConnectionID, guchar pbDownlaodType, tU8 f_u8DeviceHandle);
int EvoPhoneBook_DlComplete(guint8 u8ConnectionID);
int EvoPhoneBook_StartDlPB(FC_Device_Details * deviceObject, unsigned char cmd);
void EvoPhoneBook_DnlGetSize(FC_Device_Details *); 

void updateCHErrorStatusToClients();//NCG3D-103980
void updatePBErrorStatusToClients();//NCG3D-103980

//Methods to create remote proxies.
void AssignSystemBusConnection(GDBusConnection *systemBusConnection);
void AssignSessionBusConnection(GDBusConnection *sessionBusConnection);
void RemoveSystemBusConnection();
void RemoveSessionBusConnection();
int EvoPhoneBook_Create_RemoteProxy_Client(void);
int EvoPhoneBook_Create_RemoteProxy_ObjectManager(void);
int EvoPhoneBook_Create_Session(FC_Device_Details *deviceObject);
OrgBluezObexPhonebookAccess
      * EvoPhoneBook_Create_RemoteProxy_PhoneBookAccess(FC_Device_Details *deviceObject);
OrgBluezObexTransfer* EvoPhoneBook_Create_RemoteProxy_Transfer(gchar* transferPath);
OrgBluezDevice1
* EvoPhoneBook_Create_RemoteProxy_Device(FC_Device_Details *deviceObject);
void RegisterForPropertiesChanged(guint8 l_ConnID);
void
      freedesktopProxyCB(GObject *source_object, GAsyncResult *res, gpointer user_data);

//Evolution methods
int
      EvoPhoneBook_Select_PhoneBook(FC_Device_Details *deviceObject, const gchar* arg_location, const gchar* arg_phonebook);
void
      EvoPhoneBook_Pull_All(FC_Device_Details *deviceObject, const gchar* targetFile, guint offset, guint maxcount, guint8 filter);
int EvoPhoneBook_Get_Size(FC_Device_Details *deviceObject);

//Evolution callback Methods.
void
      EvoPhoneBook_Pull_All_Callback(GObject *source_object, GAsyncResult *res, gpointer user_data);

quint32
      EvoPhoneBook_Select_GetSize(FC_Device_Details *deviceObject, OrgBluezObexPhonebookAccess *l_poProxyPbAccess, const gchar* arg_location, const gchar* arg_phonebook);
//End fix CMG3G-12876

const gchar* getEvoPhonebookType(guchar pbDownlaodType);
void EvoPhonebook_Start_PullAll(FC_Device_Details* deviceObject);


void
      EvoPhoneBook_Transfer_Property_Callback(GObject *source_object, GAsyncResult *res, gpointer user_data);
void
      EvoPhoneBook_DlStop_Callback(GObject *source_object, GAsyncResult *res, gpointer user_data);

void
      propertyChangedCallback(GObject *object, const gchar *interfaceName, GVariant *changedProperties, const gchar* const *arg_invalidated_properties);

void
      interfacesAddedCallback(OrgFreedesktopDBusObjectManager *object, const gchar *arg_object, GVariant *arg_interfaces);
void
      interfacesRemovedCallback(OrgFreedesktopDBusObjectManager *object, const gchar *arg_object, const gchar * const *arg_interfaces);
void pullAllPhoneBookCallback(GObject* pGObject, GAsyncResult* pGAsyncResult, gpointer pUserData);
void EvoPhonebook_PullAll_Delay();

void
EvopostLoopBackMessage(guint32 u32FunctionID, PhBk_Loopback_Data* LoopbackData);
void vPostDataCompleteLoopBack(FC_Device_Details * deviceObject);

void vClearEvoObjectPathMapping(tU8 l_ConnID);
void vClearEvoProxyConnMapping(tU8 l_ConnID);
void vUnRegisterClientAndObjectManagerSignals(void);

//Generic methods
gboolean bCheckIfDownloadIsComplete(guint8 u8DeviceHandle);


void printErrorMessage(GError* error, const char* description );

void vSetCapabilitiesForSuspendedDownloadDevice(FC_Device_Details * deviceObject);

//Fix 280860
bool bCheckSessionPathAvailable(FC_Device_Details *pDeviceObject);

void updateCHErrorStatusToClients();
void updatePBErrorStatusToClients();

bool updateMaxContactCount(unsigned int contactCount);
int getMaxContactCount();
#endif   //_FB_EVO_DBUS_H
