/*******************************************************************************
*
* FILE:          FC_PhoneBook_CallHistory_List.h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:	Function to handle call history list
*
* AUTHOR:		Balasubramani.V
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/
#ifndef _FC_PHONEBOOK_USAGE_H_
#define _FC_PHONEBOOK_USAGE_H_

#include <QtCore>
#include <glib.h>
#include <QMap>

#include "../FC_PhoneBook_Debug.h"

class FC_PhoneBook_SQLite;


class FC_PhoneBook_MemoryUsage
{
private:
    quint32  m_u32TotallyUsedContactMemory;  // Contact (APL1) Memory used by all phones
    quint32  m_u32TotallyUsedPhotoMemory;    // Photo   (APL2) Memory used by all phones

public:
    FC_PhoneBook_MemoryUsage();
    ~FC_PhoneBook_MemoryUsage();

    bool bRemoveLeastRecentlyUsedPhonebook();

    //Phonebook Memory Usage Handling
    bool bCheckMemoryPoolForContacts( quint32 u32ContactMemoryToBeAdded); 
    void vUpdateMemoryPoolForContacts(quint32 u32ContactMemoryToBeAdded); 

    bool bCheckMemoryPoolForPhoto( quint32 u32photoSizeNew, quint32 u32photoSizeOld);
    void vUpdateMemoryPoolForPhoto(quint32 u32photoSizeNew, quint32 u32photoSizeOld);

    void CalculateMemoryUsageFromDB();

};

#endif /* _FC_PHONEBOOK_USAGE_H_ */
