/*******************************************************************************
*
* FILE:          FC_PhoneBook_Database.h
*
* SW-COMPONENT:  FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:   Handles the sqlite database using QtSql module. This class is
*                implemented using the "Private Implementation (or PIMPL)" design
*                pattern. This is done to hide all the Qt headers from rest of the
*                module because Qt headers creates problem with overloaded new/delete
*                operators of OSAL. Using this class prevents us from defining the
*                workaround macro everywhere.
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

#ifndef _FC_PHONEBOOK_DATABASE_
#define _FC_PHONEBOOK_DATABASE_

#include <glib.h>
#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility

class most_phonbkfi_tclMsgBaseMessage;

class most_phonbkfi_tclMsgCreatePhoneBookListMethodStart;
class most_phonbkfi_tclMsgCreatePhoneBookListMethodResult;

class most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart;
class most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult;

class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart;
class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult;

class most_phonbkfi_tclMsgReleasePhoneBookListMethodStart;
class most_phonbkfi_tclMsgReleasePhoneBookListMethodResult;

class most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart;
class most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult;

class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart;
class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult;

class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart;
class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult;

class most_phonbkfi_tclMsgSearchPhoneBookMethodStart;
class most_phonbkfi_tclMsgSearchPhoneBookMethodResult;

class most_phonbkfi_tclMsgSearchContactsMethodStart;
class most_phonbkfi_tclMsgSearchContactsMethodResult;

class most_phonbkfi_tclMsgAddContactMethodStart;
class most_phonbkfi_tclMsgAddContactMethodResult;

class most_phonbkfi_tclMsgEditContactMethodStart;
class most_phonbkfi_tclMsgEditContactMethodResult;

class most_phonbkfi_tclMsgDeleteContactMethodStart;
class most_phonbkfi_tclMsgDeleteContactMethodResult;

class most_phonbkfi_tclMsgGetContactDetailsMethodStart;
class most_phonbkfi_tclMsgGetContactDetailsMethodResult;

class most_phonbkfi_tclMsgListChangeStatus;

class most_phonbkfi_tclMsgCreateCallHistoryListMethodStart;
class most_phonbkfi_tclMsgCreateCallHistoryListMethodResult;

class most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart;
class most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult;

class most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart;
class most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult;

class most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart;
class most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult;

class most_phonbkfi_tclMsgGetContactPhotoMethodStart;
class most_phonbkfi_tclMsgGetContactPhotoMethodResult;

class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart;
class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult;

class most_phonbkfi_tclMsgStoreFavoriteMethodStart;
class most_phonbkfi_tclMsgStoreFavoriteMethodResult;

class most_phonbkfi_tclMsgGetFavoriteInfoMethodStart;
class most_phonbkfi_tclMsgGetFavoriteInfoMethodResult;

class most_phonbkfi_tclMsgCreateContactListMethodStart;
class most_phonbkfi_tclMsgCreateContactListMethodResult;

class most_phonbkfi_tclMsgSetContactPositionMethodStart;
class most_phonbkfi_tclMsgSetContactPositionMethodResult;

class most_phonbkfi_tclMsgAddContactExtendedMethodStart;
class most_phonbkfi_tclMsgAddContactExtendedMethodResult;

class most_phonbkfi_tclMsgEditContactExtendedMethodStart;
class most_phonbkfi_tclMsgEditContactExtendedMethodResult;

class most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart;
class most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult;

class FC_PhoneBook_List;
class FC_PhoneBook_CallHistory_List;
class FC_Phonebook_tclFavorite_Provider;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class FC_PhoneBook_Database //Singleton class
{
public:
   static FC_PhoneBook_Database* Instance();
   static void DeleteInstance();

   bool CreatePhoneBookList(
      const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart* methodStart,
      most_phonbkfi_tclMsgCreatePhoneBookListMethodResult* methodResult, 
      tU32 u32RegisterID );//FIX GMMY15-1578 RegisterID is passed to identify the requested client

   bool CreateContactList(
      const most_phonbkfi_tclMsgCreateContactListMethodStart* methodStart,
      most_phonbkfi_tclMsgCreateContactListMethodResult* methodResult,
      tU32 u32RegisterID );//FIX GMMY15-1578 RegisterID is passed to identify the requested client

   bool RequestSlicePhoneBookList(
      const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult* methodResult );
   //FIX SUZUKI-1114 API for numeric value to indicate number of dial-able phone numbers available to a contact item in Phonebook
   bool RequestSlicePhoneBookListExtended(
      const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult* methodResult );
   //End of fix

   bool ReleasePhoneBookList(
      const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart* methodStart,
      most_phonbkfi_tclMsgReleasePhoneBookListMethodResult* methodResult,
      tU32 u32RegisterID);//FIX GMMY15-1578 RegisterID is passed to identify the requested client
   bool ReleaseCallHistoryList(
      const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart* methodStart,
      most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult* methodResult,
      tU32 u32RegisterID);//FIX GMMY15-1578 RegisterID is passed to identify the requested client

   bool SearchKeyboardPhoneBookList(
      const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart* methodStart,
      most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult* methodResult );

   bool SearchPhoneBook(
      const most_phonbkfi_tclMsgSearchPhoneBookMethodStart* methodStart,
      most_phonbkfi_tclMsgSearchPhoneBookMethodResult* methodResult);

   bool SearchContacts(
      const most_phonbkfi_tclMsgSearchContactsMethodStart* methodStart,
      most_phonbkfi_tclMsgSearchContactsMethodResult* methodResult);

   bool AddContact(
      const most_phonbkfi_tclMsgAddContactMethodStart* methodStart,
      most_phonbkfi_tclMsgAddContactMethodResult* methodResult );

   bool EditContact(
      const most_phonbkfi_tclMsgEditContactMethodStart* methodStart,
      most_phonbkfi_tclMsgEditContactMethodResult* methodResult);

   bool DeleteContact(
      const most_phonbkfi_tclMsgDeleteContactMethodStart* methodStart,
      most_phonbkfi_tclMsgDeleteContactMethodResult* methodResult);

   bool ClearPhoneBookData();//FIX GMMY16-23858
   bool ClearVehiclePhoneBook();

   bool SearchPhoneNumberEntries(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart* methodStart,
      most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult* methodResult,guint8 ConnectionID);

   bool GetContactDetails(
      const most_phonbkfi_tclMsgGetContactDetailsMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactDetailsMethodResult* methodResult);

   bool CreateCallHistoryList(
      const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart* methodStart,
      most_phonbkfi_tclMsgCreateCallHistoryListMethodResult* methodResult,
      tU32 u32RegisterID);//FIX GMMY15-1578 RegisterID is passed to identify the requested client

   bool RequestSliceCallHistoryList(
      const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult* methodResult,tU32 registerID);

   //FIX SUZUKI-1113 API for numeric value to indicate number of calls against a CallHistory item in Phonebook
   bool RequestSliceCallHistoryListExtended(
      const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult* methodResult,tU32 registerID);
   //End of fix

   bool GetContactPhotoInfo(
      const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult* methodResult,
      tU16& u16ErrorCode);

   bool GetContactPhoto(
      const most_phonbkfi_tclMsgGetContactPhotoMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactPhotoMethodResult* methodResult,
      tU16& u16ErrorCode);

   void ParseVCard(
      GByteArray* data,
      unsigned char deviceHandle, unsigned char connectionid);

   void MethodResultPosted(const guint16 u16FuntionID,
      const most_phonbkfi_tclMsgBaseMessage* MethodStart,
      const most_phonbkfi_tclMsgBaseMessage* MethodResult);

   void DownloadCompleted(guint8 u8DeviceHandle);

   void CallHistoryUpdated(guint8 u8ConnectionID, guint8 u8CallHistoryDnlCmd);

   void DeviceDisconnected(FC_Device_Details* DeviceDetails);
   void PhoneBookDownloadInitiated(FC_Device_Details* DeviceDetails);

   bool DeleteCallHistoryRecordsGivenCallType(guint8 u8ConnectionID,
      guint8 u8CallType);

   FC_PhoneBook_List * getCurrentListInstance();
   void DeviceDeleted(guint8 u8DeviceHandle);

#ifdef BUGZID_206322 // Workaround for device disconection status
   void DeviceConnected(FC_Device_Details* DeviceDetails);
#endif
   void clearAutocompleteListsOnOSChange();
   FC_PhoneBook_CallHistory_List * getCallHistoryListInstance();

   bool StoreFavorite(
      const most_phonbkfi_tclMsgStoreFavoriteMethodStart* methodStart,
      most_phonbkfi_tclMsgStoreFavoriteMethodResult *methodResult,tU16& u16ErrorCode,tU8& u8ErrorInfo);

   bool GetFavoriteInfo(
      const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart* methodStart,
      most_phonbkfi_tclMsgGetFavoriteInfoMethodResult *methodResult,tU16& u16ErrorCode,tU8& u8ErrorInfo);

   void ClearFavoritesAvailableAndActiveStatus();
   void RegisterFavoritesInstance(FC_Phonebook_tclFavorite_Provider* pFavInstance);
   guint32 GetTotalFavoritesCount();
   void DeleteCallHistoryRecordsGivenConnectionID(quint8 u8ConnectionID);
   void MakeFavoritesAvailable(quint8 DeviceHandle);
   void MakeFavoritesUnAvailable(quint8 DeviceHandle);
   void ChangefavoriteActiveStatus(quint8 u8Status);

   FC_PhoneBook_List* poGetPhonebookList()
   {
      return m_list;
   }

   bool UpdateSortView(quint8 u8DeviceHandle);
   bool SearchPhoneNumberEntriesInPB(
      const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart* methodStart,
      most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult* methodResult,guint8 u8DeviceHandle);

   //Fix CMG3G-8365 IS2421_Configurable phone number type representation@FC_Phonebook
   bool AddContactExtended(
      const most_phonbkfi_tclMsgAddContactExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgAddContactExtendedMethodResult* methodResult );

   bool EditContactExtended(
      const most_phonbkfi_tclMsgEditContactExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgEditContactExtendedMethodResult* methodResult);

   bool GetContactDetailsExtended(
      const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult* methodResult);
   //End of Fix CMG3G-8365 IS2421_Configurable phone number type representation@FC_Phonebook

   bool GetPositionForContactHandle(
      const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart* methodStart,
      most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult* methodResult);

private:
   FC_PhoneBook_Database();
   ~FC_PhoneBook_Database();

   // Make copy constructor private to make it a singleton proof
   FC_PhoneBook_Database(const FC_PhoneBook_Database&);

   static FC_PhoneBook_Database* m_self;
   FC_PhoneBook_List* m_list;
   FC_PhoneBook_CallHistory_List* m_callHistory;
   FC_Phonebook_tclFavorite_Provider *m_fav;
};

#endif//_FC_PHONEBOOK_DATABASE_
