/*******************************************************************************
*
* FILE:           FC_PhoneBook_CallHistory_List.h
*
* SW-COMPONENT:   FC_PhoneBook application
*
* PROJECT:
*
* DESCRIPTION:    Function to handle call history list
*
* AUTHOR:         Balasubramani.V
*
* COPYRIGHT:      (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/
#ifndef _FC_PHONEBOOK_CALLHISTORY_LIST_H_
#define _FC_PHONEBOOK_CALLHISTORY_LIST_H_

#include <QtCore/QtCore>
#include <glib.h>

#include "FC_PhoneBook_SQLite.h"
#include "FC_PhoneBook_ListChange_Handler.h"
#include "../FC_PhoneBook_clienthandler_BluetoothSetings.h"
#include "../../Configuration/PhoneBook/Pbk_FeatureConfig.h"
#include "../Common/FC_PhoneBook_Global.h" //c++11 compatibility

class most_phonbkfi_tclMsgCreateCallHistoryListMethodStart;
class most_phonbkfi_tclMsgCreateCallHistoryListMethodResult;
class most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart;
class most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult;

class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart;
class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult;

class most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart;
class most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult;

class most_fi_tcl_e8_PhonBkCallHistorySortType;
class most_fi_tcl_e8_PhonBkCallHistoryType;
class most_fi_tcl_PhonBkCallHistoryListSliceResultItem;

class most_fi_tcl_PhonBkCallHistoryListSliceResultExtenedItem;

class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart;
class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult;

class FC_PhoneBook_List;
class FC_PhoneBook_VCard_Property;
#define FC_PHONEBOOK_VEHICLE_DEVICEHANDLE   (1)

enum FC_PhoneBook_NumberType
{
   enNumType_Unknown=0,
   enNumType_Preffered,
   enNumType_Cell,
   enNumType_Home,
   enNumType_Work,
   enNumType_Other
};

/***********************************************************************
*
*   CLASS DEFINITION
*
***********************************************************************/

class FC_PhoneBook_CallHistory_List
{
public:

   bool CreateCallHistoryList(
      const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart* methodStart,
      most_phonbkfi_tclMsgCreateCallHistoryListMethodResult* methodResult,
      tU32 registerID);//FIX GMMY15-1578 RegisterID is passed to identify the requested client

   bool RequestSliceCallHistoryList(
      const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult* methodResult ,tU32 u32RegisterID);
   //FIX SUZUKI-1113 API for numeric value to indicate number of calls against a CallHistory item in Phonebook
   bool RequestSliceCallHistoryListExtended(
      const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart* methodStart,
      most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult* methodResult, tU32 u32RegisterID);
   //End of fix

   bool ReleaseCallHistoryList(
      const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart* methodStart,
      most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult* methodResult,
      tU32 registerID);//FIX GMMY15-1578 RegisterID is passed to identify the requested client

   void AddNewVCardData( GByteArray* data, int phonebookType,
      unsigned char deviceHandle);

   //FIX GMMY15-11882 SHUTDOWN_QUEUE_FULL: CCA_C_U16_APP_UI request reset because entry queue full of CCA_C_U16_APP_PHONEBOOK, Thread AE_61 callstack found
   //Replacing multiple similar functions with single one
   void RefreshCallHistoryOnChangeInContact(FC_PhoneBook_Contact_Detail& PBook_Contact);
   //End of fix

   void RefreshCallHistoryOnDeviceDisconnect(quint8 u8ConnectionID);

   bool DeleteCallHistoryRecordsGivenCallType(quint8 u8ConnectionID,	quint8 u8CallType);

   void SearchPhoneNumberEntries(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart* methodStart,
      most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult* methodResult,guint8 ConnectionID);

   void clearAutocompleteListsOnOSChange();

   void RefreshCallHistoryOnCallHistoryUpdate(quint8 u8ConnectionID, quint8 u8CallHistoryDnlCmd);
   void ClearCallHistoryRecords();
#ifdef BUGZID_206322 // Workaround for device disconection status
   void DeviceConnected(FC_Device_Details* DeviceDetails);
#endif
   void DeleteCallHistoryRecordsGivenConnectionID(quint8 u8ConnectionID);

   bool blIgnoreCCHData[FC_PB_TOTAL_NUMBER_OF_CH];

   //FIX CMG3G-4786 CCHListSupport is shown inconsistently -- CallList loading is shown on Autoconnect
   //CCHSupport to be updated as FALSE on receiving an invalid v card amidst valid ones.
#ifdef UPDATE_CCH_SUPPORT_ON_INVALID_VCARD
   tBool bSendSCHSupport;
#endif
   //End of fix

   const QHash< quint16, FC_CallHistory_List_Data* >* poGetHashTable()   // Return type changed to const to avoid LINT Warning 1536 (CMG3G-4848)
   {
      return &m_hashCHList;
   }

   void ClearVehicleCallhistorylist();
   void ClearcallHistory();

   //CLONE TICKET FIX - GMMY15-1545 - Singleton creation for FC_PhoneBook_List and FC_PhoneBook_CallHistory_List
   static FC_PhoneBook_CallHistory_List* GetCurrentInstance();
   static tVoid vDestroyInstance();

   //FIX GMMY15-8739 Contacts are Displayed on the HMI, even though PBAP request was not accepted on the phone device.
   //FIX CMG3G-8367 IS2424_DownloadOnOff behaviour@FC_Phonebook
   // The user shall have possibility to switch the phonebook and call history list download On or Off individual for each paired phone device.
   bool bClearCHRecords(quint8 u8ConnectionID);
   //End of fix FIX CMG3G-8367

   //FIX GMMY16-782 GMMY16-1106 After contacts downloaded, recent calls list still only shows phone numbers (no names).
   //During second download check if call history contains any record whose number is available in PB. If yes update the same with PB contact's details
   tVoid SyncCallHistoryList(tU8 deviceHandle);
   //End of fix

   //FIX GMMY15-1578 Bosch Internal: Proper usage of SQLite database instead of RAM -- removing redundant objects which are created in RAM for different clients & sorted lists.
   void vClearCHListAndHashListEntriesForListHandle(tU16 u16ListHandle);
   //End of fix GMMY15-1578

   //FIX GMMY15-1578 Removing redundant objects which are created in RAM for different clients & sorted lists.
   void vUtf8Validate(QString &sCandidateToValidate);
   //End of fix GMMY15-1578

private:

   //CLONE TICKET FIX - GMMY15-1545 - Singleton creation for FC_PhoneBook_List and FC_PhoneBook_CallHistory_List
   static FC_PhoneBook_CallHistory_List* m_self;
   FC_PhoneBook_CallHistory_List();
   FC_PhoneBook_CallHistory_List(const FC_PhoneBook_CallHistory_List&);
   ~FC_PhoneBook_CallHistory_List();
   void vUpdateDateAndTimeDetails(FC_Device_Details* deviceObject,QString dateStamp, QString timeStamp,int iDownloadType,tBool isUpdateForFirst);
   //CLONE TICKET FIX-GMMY15-624 [CT]N6 37XX Phonebook || Missed Call Indicator displayed at the second missed call
   tVoid vCheckMissedCallPresence(FC_Device_Details* deviceObject, QList<FC_PhoneBook_Callhistory_Detail>&, int iDownloadType);

   //Key:List Handle, Value: Pointer to list in RAM
   QHash< quint16, FC_CallHistory_List_Data* > m_hashCHList;

   //FIX GMMY15-1578 Bosch Internal: Proper usage of SQLite database instead of RAM -- removing redundant objects which are created in RAM for different clients & sorted lists.
   //Key:List Handle, Value: Client Register ID
   QMultiHash<tU16, tU32> m_multiHashCHClientRequests;
   //End of fix GMMY15-1578
   FC_PhoneBook_SQLite* m_poSqlite;

   void Convert(const FC_PhoneBook_Callhistory_Detail* callHistorydata,
      most_fi_tcl_PhonBkCallHistoryListSliceResultItem* CallHistoryitem );
   //FIX SUZUKI-1113 API for numeric value to indicate number of calls against a CallHistory item in Phonebook
   void Convert_Extended(const FC_PhoneBook_Callhistory_Detail* callHistorydata,
      most_fi_tcl_PhonBkCallHistoryListSliceResultExtenedItem* CallHistoryitemExtended );
   //End of fix

   void AddPropertyToCallhistory(const FC_PhoneBook_VCard_Property* prop,
      FC_PhoneBook_Callhistory_Detail* contact, const int& phonebookType,
      unsigned char deviceHandle);

   bool ParseVCards(QByteArray ba, int phonebookType, unsigned char deviceHandle,
      QList<FC_PhoneBook_Callhistory_Detail> & list);

   FC_PhoneBook_SQLite::SortType getCallHistorySortType( const most_fi_tcl_e8_PhonBkCallHistorySortType* type );

   FC_PhoneBook_SQLite::FC_PhoneBook_enCallHistoryType getCallHistoryType(
      const most_fi_tcl_e8_PhonBkCallHistoryType* type);

   quint8 MapTextToNumberForCallType(QString CallType, quint8 u8DeviceHandle);

   quint8 MapTextToNumberForNumberType(QString NumberType);

   bool GetMatchingContactFromExistingCHtable(FC_PhoneBook_Callhistory_Detail& CallHistoryRecord,
      quint8 u8DeviceHandle, FC_PhoneBook_Search_Result& PhoneContact); // -SP,31.05.2019 - Call History Efficient Resolving

   bool GetMatchingContactForCallHistoryEntry(FC_PhoneBook_Callhistory_Detail& CallHistoryRecord,
      quint8 u8DeviceHandle, FC_PhoneBook_Search_Result& PhoneContact, tU8 &u8NameEdited);//FIX GMMY16-782

   //FIX CMG3GB-505 Upon disconnecting a call/call is established/entering numbers in dialpad, resets when doing handsfree operation was observed
   tU8 AutoCompletePhNoSearchIndex;
   //End of fix

   FC_PhoneBook_SQLite::FC_PhoneBook_enCallHistoryType MapCallHistoryTypeFromDnlCommand(
      FC_PhoneBookDwldCallType DnlCmd);
   void MapContactDetailTypeToCallPhonetype(quint8& u8NumberType);

   //FIX GMMY15-11882 SHUTDOWN_QUEUE_FULL: CCA_C_U16_APP_UI request reset because entry queue full of CCA_C_U16_APP_PHONEBOOK, Thread AE_61 callstack found
   //Function to check if Phone number in Call history entry is available in PB contact.
   //If found, it updates number type in call history entry
   tBool bCHPhoneNumberAvailableInGivenPBContact(FC_PhoneBook_Callhistory_Detail& CallHistoryDetail, FC_PhoneBook_Contact_Detail& PBook_Contact);//CMG3G-14313-Coverity Fix-Pass by Reference
   //End of fix

};

#endif /* _FC_PHONEBOOK_CALLHISTORY_LIST_H_ */
