/*******************************************************************************
 *
 * FILE:          FC_PhoneBook_Global.h
 *
 * SW-COMPONENT:  FC_PhoneBook application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Interface definition Helper functions.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _PHONEBOOK_GLOBAL_H
#define _PHONEBOOK_GLOBAL_H

#if __cplusplus < 201103L
#define NULLPTR NULL //C++03 or below
#else
#define NULLPTR nullptr //C++11 or above
#endif

#if __cplusplus < 201103L
#define OVERRIDE //C++03 or below
#define FINAL //C++03 or below
#else
#define OVERRIDE override //C++11 or above
#define FINAL final //C++11 or above
#endif

#define FC_PBK_DEFAULT_LANG                0   //CRQ-243550-Vertical Keyword Language Selection
#define FC_PB_USER_NAME  "aid_phbk"
#define FC_PB_GROUP_NAME "aid_phbk_share"

#include <alsa/asoundlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <linux/soundcard.h>
#include <new>
#include <limits.h>
#include <pwd.h>
#include <grp.h>

#include "conn_most_fi_if.h" // 241829 - bpstl removal task - for inclusion of tu32, ts8 etc. types

void vStringCopy(char *dest, const char* src, tU32 dest_size);
tS8 u8StringCompare(const char *str1, const char*str2);

#define NULL_CHECK(arg) if (arg == NULL) return;

#endif // _PHONEBOOK_GLOBAL_H
