/*******************************************************************************
 *
 * FILE:          FC_Phone_WaitingMode.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:       PSA
 *
 * DESCRIPTION:   Handles Waiting Mode requests during active call and incoming call
 *
 * AUTHOR:        Sandeep Arjun
 *
 * COPYRIGHT:     (c) 2015 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_PHONE_WAITINGMODE_H_
#define _FC_PHONE_WAITINGMODE_H_

#include "../FC_Phone_main.h"

/* All the events that the Waiting Mode can take */
typedef enum FC_Phone_WaitingModeEvent
{
   FC_PHONE_WAITING_MODE_EVENT_START = 0,
   FC_PHONE_WAITING_MODE_EVENT_STOP,
   FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ON,
   FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_OFF,
   FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ROUTING_FAILED,
   FC_PHONE_WAITING_MODE_EVENT_SCO_CONNECTION_STATUS,
   FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS,
   FC_PHONE_WAITING_MODE_EVENT_SLC_OFF,
   FC_PHONE_WAITING_MODE_EVENT_ACCEPTCALL_ERROR
} tenFC_Phone_WaitingModeEvent;

typedef enum FC_Phone_WaitingModeState
{
   FC_PHONE_WAITINGMODE_IDLE = 0,
   FC_PHONE_WAITINGMODE_START_IN_PROGRESS,
   FC_PHONE_WAITINGMODE_ACTIVE,
   FC_PHONE_WAITINGMODE_STOP_IN_PROGRESS
} tenFC_Phone_WaitingModeState;

typedef struct
{
   tU8 u8SCOConnectionStatus;
   tU8 u8Codec;
} trFC_Phone_SCOConnStatus;

typedef struct
{
   tU32 u32WaitingModePlayState;
} trFC_Phone_WaitingModePlayState;

class fc_phone_tclWaitingMode
{
public:

   static fc_phone_tclWaitingMode* poGetInstance();
   static tVoid vDestroyWaitingModeInstance();

   tVoid vSetFilePath(tString, tString);

   tenFC_Phone_WaitingModeState enGetWaitingModeState();
   tVoid vSetWaitingModeState(tenFC_Phone_WaitingModeState);

   tBool bProcessEvent(tenFC_Phone_WaitingModeEvent, tVoid *pvArg = NULLPTR);

private:

   fc_phone_tclWaitingMode();
   fc_phone_tclWaitingMode(fc_phone_tclWaitingMode & waitMode);
   fc_phone_tclWaitingMode& operator=(fc_phone_tclWaitingMode & waitMode);
   ~fc_phone_tclWaitingMode();

   tVoid vHandleEventInIdle(tenFC_Phone_WaitingModeEvent, tVoid* pvArg = NULLPTR);
   tVoid vHandleEventInStartInProgress(tenFC_Phone_WaitingModeEvent, tVoid* pvArg = NULLPTR);
   tVoid vHandleEventInActive(tenFC_Phone_WaitingModeEvent, tVoid* pvArg = NULLPTR);
   tVoid vHandleEventInStopInProgress(tenFC_Phone_WaitingModeEvent);

   tVoid vStartWaitingMode();
   tVoid vStopWaitingMode();

   tBool bPlayWaitingModeTone();
   tVoid vStopWaitingModeTone();
   tVoid vHandleSCOConnAndPhoneWaitSrcOn();
   tVoid vHandleSCODiscSLCOffIdleCallStatus();
   tVoid vHandleAudioPlayerErrorResponse();
   tVoid vClearFilePath();

   static fc_phone_tclWaitingMode* s_poInstance;

   GMutex m_Mutex_WaitMode;

   tenFC_Phone_WaitingModeState m_enWaitingModeState;

   tBool m_bWaitModeTonePlaying;
   tBool m_bPhoneWaitSrcAvailable;
   tBool m_bEventConsumed;

   tU8 m_u8SCOConnectionStatus;
   tU8 m_u8Codec;

   tString m_sFilePathNB;
   tString m_sFilePathWB;

};

#endif // _FC_PHONE_WAITINGMODE_H_
