/*******************************************************************************
 *
 * FILE:          FC_Phone_SMVRSession.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:        Vignesh R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_VRSESSION_H_
#define _FC_PHONE_VRSESSION_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define FC_PHONE_BT_VR_ACTIVE                1
#define FC_PHONE_BT_VR_INACTIVE              0
#define FC_PHONE_BT_DEVICE_VR_SUPPORTED      1
#define FC_PHONE_BT_DEVICE_VR_NOT_SUPPORTED  0

/* Define the states that this machine can take */
#define FC_PHONE_VR_STATE_GET_REQUEST  0
#define FC_PHONE_VR_STATE_RELEASE_REQUEST 1
#define FC_PHONE_VR_STATE_WAITFOR_STOPVR_FROMBT 2
#define FC_PHONE_VR_STATE_WAITFOR_STARTVR_FROMBT 3

#define FC_PHONE_VR_STATUS_ACTIVATE 0x01
#define FC_PHONE_VR_STATUS_DEACTIVATE 0x00

enum States
{
   STATE_IDLE,
   STATE_ACTIVE
};

typedef enum
{
   EN_VR_IDLE = 0,
   EN_VR_DEACT_OK = 1 ,
   EN_VR_SCO_REL = 2,
   EN_VR_SCO_REL_DEACT_OK = 3
}tenPassiveDevVRRelStatus;

class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMVRSession : public fc_phone_tclSM
{
public:

   /* Constructor */
   fc_phone_tclSMVRSession();

   /* Destructor */
   virtual ~fc_phone_tclSMVRSession();

   /* Process event from hmi */
   virtual tVoid vProcessEvent(tU16 u16EventId) FINAL;

   /* Process event from alps */
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);

   virtual tVoid vCancel(tVoid) FINAL;

   static  fc_phone_tclSMVRSession* poGetInstance(void);
   tU16 u16GetVRSessionState();
   tVoid vUpdateVRstatusInactive();
   tBool bIsVRSessionRunning();
   tBool bIsVRActivationRequestPendingFromBTStack();

   // CMG3G-7982- Extend VR session
   tVoid vTimerCallBack(tU16 u16TimerId) FINAL;
   tVoid vStopExtendedVRSession();

   //Fix for PSARCCB-5362
   tBool bIsExtendVRSessionTimerRunning();
   tVoid vProcessVRRequestForOtherDevice();
private:
   static fc_phone_tclSMVRSession* m_poVRInstance;
   tU16 m_u16State;
   tU16 m_u16SubState;
   tU16 m_u16AudioChannel;
   tBool bActivationFromDevice;
   tBool m_bAVinterrupt;
   tBool m_bBTVRProcessingRelease;

   // As a part of NCG3D-61283
   tU8 m_u8VRRelStatus;

   tVoid vHandleEventInIdleState(tU16 u16EventId);
   tVoid vHandleEventInActiveState(tU16 u16EventId);
   tVoid vHandleEventInGetRequest(tU16 u16EventId);
   tVoid vHandleEventInReleaseRequest(tU16 u16EventId);
   tVoid vHandleEventInWaitForStopVR(tU16 u16EventId);
   tVoid vHandleEventInWaitForStartVR(tU16 u16EventId);

   tVoid vHandleSourceActvityOn();
   tVoid vHandleSourceActvityOff();
   tVoid vHandleVoiceRecActive();
   tVoid vHandleVoiceRecInActive();
   tVoid vHandleSpeechGetRequestOk();
   tVoid vSendActivateVoiceRecognition();
   tVoid vHandleSpeechGetRequestNOk();
   tVoid vHandleSpeechReleaseRequestOk();
   tVoid vHandleSpeechReleaseRequestNOk();
   tVoid vHandleVoiceRecActivated();
   tVoid vHandleVoiceRecDeActivated();
   tVoid vHandleVoiceRecActivationInd();
   tVoid vHandleVoiceRecDeActivationInd();
   //GMMY15-62 Bluetooth Speech Recognition shown as available after walking phone out of range during BTSR session.
   //tVoid vEndVoiceSesion();
   tVoid vEndVoiceSesion(bool bDeviceDisconnected = false);

   tVoid vSendBtVRStatus();

   tVoid vHandleDbusError(tU16 u16DbusAckType,tChar Code);
   tVoid vSendErrorCode(tChar Code);
   tBool bHandleEventSLCOFF(tVoid *varg);

   //CMG3G-7982- Extend VR session
   tU16 m_u16TimerId;
   tBool m_bExtendVRSessionTimerRunning;
};

#endif // _FC_PHONE_VRSESSION_H_


