/******************************************************************************
 *
 * FILE:          FC_Phone_SMRejectCall.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "stdio.h"
#include "FC_Phone_SMIncludes.h"
#include "../FC_Phone_clienthandler_BTSettings.h"

#include "FC_Phone_SMIncludes.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMRejectCall.cpp.trc.h"
#endif

tVoid vAudioCallBackReject(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" vAudioCallBackReject"));
   //fc_phone_tclSMRejectCall::m_poInstance ->vAudioCallBack(u16AudioChannelId, u16RequestState);
   fc_phone_tclSM* pSMInstance ;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID) ;

   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16TimerId %d",u16AudioReqID));
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMRejectCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMRejectCall::fc_phone_tclSMRejectCall(fc_phone_tclCallInstance*&  rfpCallInstance):\
      fc_phone_tclSM(rfpCallInstance)

      {
   ETG_TRACE_USR4(("fc_phone_tclSMRejectCall::fc_phone_tclSMRejectCall"));
   m_bRejectMethodResultSent = FALSE;
   ETG_TRACE_USR2(("m_bRejectMethodResultSent = FALSE"));
   m_u16State = FC_PHONE_SMREJECTCALL_STATE_REJECT_CALL_STARTED;
   m_bEventConsumed = FALSE ;
   ETG_TRACE_USR2(("STATE Change: FC_PHONE_SMREJECTCALL_STATE_REJECT_CALL_STARTED"));
      }
/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMRejectCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMRejectCall::~fc_phone_tclSMRejectCall()
{
   ETG_TRACE_USR4(("fc_phone_tclSMRejectCall::~fc_phone_tclSMRejectCall"));
}
/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMRejectCall::vCancel(tVoid)
{
   ETG_TRACE_USR4(("fc_phone_tclSMRejectCall::vCancel"));
}
/*******************************************************************************
 *
 * FUNCTION: vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMRejectCall::vExecute()
{
   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vExecute "));

   /* Delegate it to Dbus */
   //This is the case when caller reject the call of the non outgoing source device
   //if(p_clientHndler_bluetooth->GetOutGoingSourceChangeStatus() && ((m_poCallInstance->OutGoingSrcChanged == TRUE)))
   m_u16State = FC_PHONE_SMREJECTALL_STATE_WAIT_FOR_CONNECT_FROM_BT; 
   ETG_TRACE_USR2(("STATE change: FC_PHONE_SMREJECTALL_STATE_WAIT_FOR_CONNECT_FROM_BT"));
   m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance); 

   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::calling DEBUS vRejectCall  "));

   if(TRUE ==  m_poCallInstance->m_bcallWaitingState)
   {
      m_poCallInstance->m_bcallWaitingState = FALSE ;
      m_pDbusIf->bRejectCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId) , FC_PHONE_DBUS_IGNORE_SECOND_WAITINGCALL);
   }
   else
   {
      m_pDbusIf->bRejectCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId) , FC_PHONE_DBUS_IGNORE_SINGLECALL);
   }

}

/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMRejectCall::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4(("fc_phone_tclSMRejectCall::bProcessEvent u16EventId %d",u16EventId));
   (tVoid)varg ;
   FcPhone_processEventArg   *ptProcessEventArg = (FcPhone_processEventArg *) varg;
   tBool bRetVal = FALSE;
   if(TRUE == ptProcessEventArg->bIsItDbusAck)
   {
      ETG_TRACE_USR4((" Status :: %d Code :: 0x%x",ptProcessEventArg->Status,ptProcessEventArg->Code));
      if(FC_PHONE_DBUS_STATUS_SUCCESS != ptProcessEventArg->Status)
      {
         ETG_TRACE_USR4((" DBUS Call is not succeed, updating error code "));
         vHandleDbusError(ptProcessEventArg->u16DbusAckType,ptProcessEventArg->Code);
      }
      else
      {
         ETG_TRACE_USR4((" DBUS Call is  succeeded "));
         bRetVal = bProcessEvent(u16EventId) ;
      }
   }
   else
   {
      bRetVal = bProcessEvent(u16EventId) ;
   }
   return bRetVal ;
}
/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMRejectCall::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMRejectCall::bProcessEvent u16EventId %d",u16EventId));
   ETG_TRACE_USR2(("m_u16State :: %d",m_u16State));
   switch (m_u16State) 
   {  
      case FC_PHONE_SMREJECTALL_STATE_WAIT_FOR_CONNECT_FROM_BT:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SMREJECTALL_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInRejectBTInCall(u16EventId);
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMRejectCall::bProcessEvent DEFAULT u16EventId %d",u16EventId));
      }
      break;
   }
   tBool bRetVal= m_bEventConsumed ;
   m_bEventConsumed = FALSE ;
   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRejectBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMRejectCall::vHandleEventInRejectBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vHandleEventInRejectBTInCall u16EventId %d",u16EventId));
   switch (u16EventId) 
   {         
      case FC_PHONE_SM_EVENT_DBUS_REJECTCALL_ACK_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_REJECTCALL_ACK_OK "));
         ETG_TRACE_USR3((" m_bRejectMethodResultSent = TRUE "));
         m_bRejectMethodResultSent = TRUE;
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_IGNORECALL,m_poCallInstance);
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vHandleEventInRejectBTInCall DEFAULT u16EventId %d",u16EventId));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMRejectCall::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vAudioCallBack u16AudioChannelId %d",u16AudioChannelId));
   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE:
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR3((" EVENT :: FC_PHONE_AUDIOCHANNEL_GRANTED "));

            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);
         }
         else
         {
            ETG_TRACE_USR3((" EVENT :: FC_PHONE_AUDIOCHANNEL_DENIED "));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK);
         }             
      }
      break;   
      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vAudioCallBack DEFAULT u16AudioChannelId %d",u16AudioChannelId));
      }
      break;
   }
}





/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMRejectCall::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vProcessOnDynamicDisconnect u16EventId %d",u16EventId));
   //release Audio channels

   switch(u16EventId)
   {

      case FC_PHONE_SM_EVENT_SLC_OFF:
      {

         if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
         {
            ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
            //if any audio channel aquired, release it
            ETG_TRACE_USR3((" Release Audio  ..."));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackReject);
            ETG_TRACE_USR3((" No audio channel is aquired, releasing instance "));
            if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
            {
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            }
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            //if any audio channel is not aquired , got to idle state and send the status to client

            m_poCallInstance->vInit();               
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            //send SLC status to client                
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
            m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMRejectCall::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vNewCallStatus "));
   (tVoid)u16_callInstance ;
   if(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
   {
      if(m_bRejectMethodResultSent == FALSE)
      {
         ETG_TRACE_USR4((" Sending  FC_PHONE_SM_EVENT_DBUS_REJECTCALL_ACK_OK"));
         bProcessEvent(FC_PHONE_SM_EVENT_DBUS_REJECTCALL_ACK_OK);
      }

      ETG_TRACE_USR4((" vNewCallStatus :PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState "));
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR4((" RELEASE AUDIO"));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackReject);
      }
      m_poCallInstance->m_bUsingVehicleAudio = FALSE;
      ETG_TRACE_USR3((" UsingVehicleAudio = FALSE"));
      m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));

      ETG_TRACE_USR4((" Sending u16IncomingCallEvent IDLE in INCOMING CALL STATUS to HMI "));
      m_poCallInstance->m_u16IncomingCallEvent = FC_PHONE_CALLINSTANCE_INCOMINGCALLEVENT_IDLE;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL, m_poCallInstance);

      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
      m_poCallInstance->vInit();
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMRejectCall::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4((" fc_phone_tclSMRejectCall::vHandleDbusError "));
   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_REJECTCALL:
      {
         ETG_TRACE_USR4((" FC_PHONE_CB_FID_REJECTCALL "));
         switch(Code)
         {
            case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
            }
            break;
            case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
            case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
            {
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
            }
            break;
            default:
            {
               ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
            }
            break;
         }
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_IGNORECALL,m_poCallInstance);

         fc_phone_tclCallInstance *pCallInstance[FC_PHONE_MAX_CALLINSTANCES];
         pCallInstance[0] = m_poCallInstance;
         pCallInstance[1] = NULLPTR;

         // Call status is set to disconnecting - Get new call status
         m_pDbusIf->bGetCallStatus(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));

         m_poSMManager->vRevertStateMachine(pCallInstance);
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" This Event ID is not supported yet"));
         break;
      }
   }
}


