/*******************************************************************************
 *
 * FILE:          FC_Phone_SMManager.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine Manager
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SMMANAGER_H_
#define _FC_PHONE_SMMANAGER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/* Different SM's possible */
#define FC_PHONE_SMMANAGER_SMID_UNKNOWN 0xFF
#define FC_PHONE_SMMANAGER_CALLINSTANCEID_UNKNOWN 0xFF

#define FC_PHONE_SMMANAGER_SMID_IDLE 0
#define FC_PHONE_SMMANAGER_SMID_ACCEPTCALL 1
#define FC_PHONE_SMMANAGER_SMID_REJECTCALL 2
#define FC_PHONE_SMMANAGER_SMID_HANGUPCALL 3
#define FC_PHONE_SMMANAGER_SMID_IGNORECALL 4
#define FC_PHONE_SMMANAGER_SMID_ACTIVECALLINHANDSET 5
#define FC_PHONE_SMMANAGER_SMID_DIAL 6
#define FC_PHONE_SMMANAGER_SMID_SPEEDDIAL 7
#define FC_PHONE_SMMANAGER_SMID_TRANSFERCALL  8
#define FC_PHONE_SMMANAGER_SMID_CONFERENCECALL 9

/* Different Status Updates Possible */

#define FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL          0
#define FC_PHONE_SMMANAGER_STATUS_CALLSTATUS            1
#define FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET   2
#define FC_PHONE_SMMANAGER_STATUS_CELLDEVICENAME        3
#define FC_PHONE_SMMANAGER_STATUS_ACCEPTCALL_ACK        4
#define FC_PHONE_SMMANAGER_STATUS_RINGTONEMUTE_ACK      5
#define FC_PHONE_SMMANAGER_STATUS_SLC                   6
#define FC_PHONE_SMMANAGER_STATUS_CELLSIGNALSTRENGTH    7
#define FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO          8
#define FC_PHONE_SMMANAGER_STATUS_AUDIOMUTE             9

#define FC_PHONE_SMMANAGER_STATUS_MICROPHONEMUTESTATE   10
#define FC_PHONE_SMMANAGER_STATUS_RINGTONEMUTE          11

//fc_phone_tclSMManager::vSendStatus will use these macros for method status
#define FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL       12
#define FC_PHONE_SMMANAGER_METHOD_STATUS_REJECTCALL       13
#define FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP           14
#define FC_PHONE_SMMANAGER_METHOD_STATUS_IGNORECALL       15
#define FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL         16
#define FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL                  17
#define FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL    18
#define FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF              19
#define FC_PHONE_SMMANAGER_METHOD_STATUS_SPEEDDIAL             20
#define FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL            21
#define FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL              22
#define FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET             23
#define FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE             24
#define FC_PHONE_SMMANAGER_METHOD_STATUS_CONFCALL              25
#define FC_PHONE_SMMANAGER_METHOD_STATUS_SPLITCALL             26

#define FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION          27
#define FC_PHONE_SMMANAGER_ERROR_BT_VOICERECOGNITION           28
#define FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED          29
#define FC_PHONE_SMMANAGER_STATUS_CALLSTATUSEXTENDED           30
#define FC_PHONE_SMMANAGER_STATUS_OUTGOING_FAILED              31
#define FC_PHONE_SMMANAGER_STATUS_INCOMING_REJECTED            32
#define FC_PHONE_SMMANAGER_STATUS_EXTERNALVR_STATUS            33
#define FC_PHONE_EVENTTYPE_BROADCAST                             0xFFFF
#define FC_PHONE_EVENTTYPE_BROADCAST_CONSUMED                    0xFFF0
#define FC_PHONE_EVENTTYPE_TARGATED                              0xFF00


typedef struct
{
   tBool bIsItDbusAck ;
   tU16  u16DbusAckType;
   tU16  u16CallInstanceID ;
   tChar Status;
   tChar Code;
   tChar State;
}FcPhone_processEventArg;
typedef struct
{
   tBool bBTDeviceVoiceRecActive;
   tBool bBTDeviceVoiceRecSupported;
   tU8   u8ErrorAck;
}FCPhone_VRData;

#define FC_PHONE_SINGLE_CALL_INSTANCE_ID                              0
#define FC_PHONE_ACTIVE_OUTGOING_CALL                                 1
#define FC_PHONE_ACTIVE_INCOMING_CALL                                 2
#define INVALID_INDEX                                                -1

#define FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED                           2
#define FC_PHONE_SMMANAGER_MAX_SM_TODELETE                           50

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMManager
{
public:

   /* Constructor */
   //fc_phone_tclSMManager(){}
   fc_phone_tclSMManager(fc_phone_tclSMObserver*& rfpSMObserver);

   /* Destructor */
   virtual ~fc_phone_tclSMManager();

   /* Pointer to statemachine observer */
   fc_phone_tclSMObserver*  m_poObserver;


   tVoid vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance*& rfpCallInstance);
   tVoid vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance*& rfpCallInstance,tVoid *varg);
   tVoid vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance *rfpCallInstance[]);
   tVoid vStartSM(tU16 u16StateMachineId, fc_phone_tclCallInstance *rfpCallInstance[],tVoid *varg);
   tVoid vRevertStateMachine(fc_phone_tclCallInstance *rfpCallInstance[]);
   tVoid vExecute(fc_phone_tclCallInstance*& rfpCallInstance,tVoid *vArg);
   tVoid vProcessEvent(tU16 u16EventId,tU16 u16EventType ,tVoid *vArg);//Correcting argument name as EventType
   tBool bProcessEvent(tU16 u16EventId,tU16 u16EventType ,tVoid *vArg);//Correcting argument name as EventType
   tVoid vProcessVREvent(tU16 u16EventId);
   tVoid vProcessExtVREvent(tU16 u16EventId);
   tVoid vProcessVREvent(tU16 u16EventId, tVoid *vArg);
   tVoid vSMFinished(tU16 u16StateMachineId);
   tVoid vSMStartIdleSM( fc_phone_tclCallInstance *rfpCallInstance);
   tVoid vSendStatus(tU16 u16StatusUpdateId, fc_phone_tclCallInstance*& rfpCallInstance);
   tVoid vSendStatus(tU16 u16StatusUpdateId,tVoid *varg);
   tVoid vSendError(tU16 u16StatusUpdateId,tVoid *varg);
   tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   tVoid vProcessAudioSignal();
   //GMMY15-7789
   tVoid vProcessOnDynamicDisconnect(tU16 u16EventId,tU8 u8BDId); //no network signal, SLC off

   static fc_phone_tclSM *m_SMTable[FC_PHONE_SMMANAGER_MAX_SM_SUPPORTED];
   static fc_phone_tclSM* GetSM_FromCallInstanceID(tU16 u16_callInstanceID);
   static fc_phone_tclSM* GetSM_FromTimerID(tU16 u16_TimerID);
   static fc_phone_tclSM* GetSM_FromAudioRequestorId(tU16 u16AudioReqID);

   static tVoid vCallTimerCallBack(tU16 u16_TimerID);
   tU16  u16GetUnmappedCallInstance(const T_CallData* const prCallData);
   tVoid vBroadCastInternalEvent(tU16 u16EventId);
   tVoid vRestoreToActiveCallInHandset(tU16 u16CallInstanceId);
   tBool bRestoreFromActiveCallInHandset(tU16 u16CallInstanceId);
   tBool bIsSMRunning(tU16 u16StateMachineId, tU16 u16_callInstanceID);
   tVoid vSetDtmfLen(tU16 u16DtmfLen, tU16 u16_callInstanceID);
   fc_phone_tclCallInstance* getCallInstancebyUniqueId(tU16 u16Id);
   tU16 u8GetCallObjectState(tU16 index);

   //2HFP
   tVoid vTransferToAcceptCallSMforPassiveDev(tU16 u16CallInstanceId);
   tBool bIsExternalVRSessionIdle();

protected:


private:
   tVoid vUpdateSMInstanceInSMTable(fc_phone_tclSM* pSMInstance);
   tVoid vCreate(tU16 u16StateMachineId,fc_phone_tclCallInstance*& rfpCallInstance,tVoid *vArg);
   tVoid vCreate(tU16 u16StateMachineId,fc_phone_tclCallInstance *rfpCallInstance[],tVoid *vArg);
   tS16 GetSMIndex_FromCallInstanceID(tU16 u16_callInstanceID);
   fc_phone_tclSM *m_apSMToBeDeleted[FC_PHONE_SMMANAGER_MAX_SM_TODELETE];
   tVoid vAddSMToDelete(fc_phone_tclSM* pSMInstance);
   tVoid vTryDeleteUnusedSM();
};

#endif // _FC_PHONE_SMMANAGER_H


