/******************************************************************************
 *
 * FILE:          FC_Phone_SMExtVRSession.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../FC_Phone_clienthandler_BTSettings.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMExtVRSession.cpp.trc.h"
//#include "HelperClasses/FC_Phone_PhoneData.h"
#endif

fc_phone_tclSMExtVRSession * fc_phone_tclSMExtVRSession::m_poExtVRInstance = NULLPTR;

tVoid vAudioCallBackExtVR(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" ENTER: vAudioCallBackExtVR %d",u16AudioReqID));

   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_SPEECH:
      {
         ETG_TRACE_USR4((" u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_SPEECH"));

         fc_phone_tclSMManager* m_poSMManagerExtVR = fc_phone_tclSM::m_poSMManager;

         if (m_poSMManagerExtVR)
         {
            if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
            {
               ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED"));
               m_poSMManagerExtVR->vProcessExtVREvent(FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK);
            }
            else
            {
               ETG_TRACE_USR4((" u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED"));
               m_poSMManagerExtVR->vProcessExtVREvent(FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK);
            }
         }
      }
      break;

      default:
         break;
   }
   ETG_TRACE_USR4((" EXIT: vAudioCallBackExtVR"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMExtVRSession
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMExtVRSession::fc_phone_tclSMExtVRSession():fc_phone_tclSM()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMExtVRSession::fc_phone_tclSMExtVRSession"));
   m_poExtVRInstance = this;
   m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   m_bIdleCallState = true;
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMExtVRSession::fc_phone_tclSMExtVRSession"));
}

/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMExtVRSession
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
/* Destructor */
fc_phone_tclSMExtVRSession::~fc_phone_tclSMExtVRSession()
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMExtVRSession::~fc_phone_tclSMExtVRSession"));
}



/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMExtVRSession::vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid fc_phone_tclSMExtVRSession::vCancel(tVoid)
{
   ETG_TRACE_USR4((" State Reset: STATE_IDLE "));
   m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   m_bIdleCallState = true;
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMExtVRSession:: poGetInstance
 *
 * DESCRIPTION: Get the current VRSession instance
 *
 * PARAMETER:None
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMExtVRSession* fc_phone_tclSMExtVRSession:: poGetInstance(void)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMExtVRSession:: poGetInstance"));
   return m_poExtVRInstance;
}

/*******************************************************************************
 *
 * FUNCTION: vProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vProcessEvent : %u", u16EventId));

   bool processEvent = true;

   switch(u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_IDLE:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_IDLE"));
         m_bIdleCallState = true;

         if (m_u16State != FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS)
         {
            processEvent = false;
         }

      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_ACTIVE:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_ACTIVE"));
         m_bIdleCallState = false;

         processEvent = false;
      }
      break;

      case FC_PHONE_SM_EVENT_SLC_OFF:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_SLC_OFF"));
         vHandleEventSLCOFF();

         processEvent = false;
      }
      break;

      default:
      {
         ETG_TRACE_USR2(("Neither a call state update nor SLC disconnection"));
      }
   }

   if (processEvent)
   {
      switch ( m_u16State )
      {
         case FC_PHONE_SMEXTVR_STATE_IDLE:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_IDLE"));
            vHandleEventInIdleState(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_ACQUISITION:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_ACQUISITION"));
            vHandleEventInWaitingForChnlAquisition(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_READY:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_READY"));
            vHandleEventInReadyState(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_START_STREAMING:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STREAMING"));
            vHandleEventInWaitingForStartStreaming(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_ACTIVE:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_ACTIVE"));
            vHandleEventInActiveState(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_STREAMING:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_STREAMING"));
            vHandleEventInWaitingForStopStreaming(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_RELEASE:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_RELEASE"));
            vHandleEventInWaitingForChannelRelease(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL"));
            vHandleEventInWaitForStopExtVRDueToIncomingCall(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS"));
            vHandleEventInWaitForIdleCS(u16EventId);
         }
         break;

         case FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL:
         {
            ETG_TRACE_USR2(("FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL"));
            vHandleWaitingForChReleaseDueToIncomingCall(u16EventId);
         }
         break;

         default:
         {
            ETG_TRACE_USR3(("IN DEFAULT "));
         }
      }
   }
   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vProcessEvent"));

}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInIdleState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInIdleState(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInIdleState : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_EXT_VR_ACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_ACTIVE"));
         vHandleExtVRChannelAllocation();
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInIdleState"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitingForChnlAquisition
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInWaitingForChnlAquisition(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForChnlAquisition : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_ON"));
         vHandleChannelAcquisition();
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK"));
         vHandleSpeechRequestNotOk();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE"));
         vReleaseSpeechChannel();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForChnlAquisition"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInReadyState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInReadyState(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInReadyState : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_ACQUISITION:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_ACQUISITION"));
         vHandleSCOChannelAcquisition();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE"));
         vReleaseSpeechChannel();
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK"));
         if(m_bIdleCallState)
         {
            m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
            ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_IDLE"));

            vSendExtVRStatus();
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_VR_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_OFF"));
         vHandleSourceActivityOff();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_EXT_VR_ACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_ACTIVE"));
         vSendExtVRStatus(EXT_VR_READY, EXT_VR_NO_ERROR);
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInReadyState"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitingForStartStreaming
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInWaitingForStartStreaming(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForStartStreaming : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_EXT_VR_ECNRSTARTAUDIO:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_ECNRSTARTAUDIO"));
         vHandleStartStreamingAudio();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE"));
         vHandleSCOChannelRelease();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE"));
         vReleaseSpeechChannel();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_VR_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_OFF"));
         vHandleSourceActivityOff();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForStartStreaming"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInActiveState
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInActiveState(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInActiveState : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE"));
         vReleaseSpeechChannel();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_RELEASE"));
         vHandleSCOChannelRelease();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_VR_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_OFF"));
         vHandleSourceActivityOff();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInActiveState"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitingForStopStreaming
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInWaitingForStopStreaming(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForStopStreaming : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_EXT_VR_ECNRSTOPAUDIO:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_ECNRSTOPAUDIO"));
         vHandleStopStreamingAudio();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE"));
         vReleaseSpeechChannel();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_ACQUISITION:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_DBUS_VOICEREC_SCO_ACQUISITION"));
         vHandleSCOChannelAcquisition();
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_VR_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_OFF"));
         vHandleSourceActivityOff();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;
      }
      break;

     default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForStopStreaming"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitingForChannelRelease
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInWaitingForChannelRelease(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForChannelRelease : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK"));
         if(m_bIdleCallState)
         {
            m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
            ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_IDLE"));

            vSendExtVRStatus();
         }
         else
         {
            m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS;
            ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS"));
         }
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK"));
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInWaitingForChannelRelease"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitForStopExtVRDueToIncomingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInWaitForStopExtVRDueToIncomingCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInWaitForStopExtVRDueToIncomingCall : %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_EXT_VR_INACTIVE"));
         vReleaseSpeechChannel();
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK"));
         m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH;
         ETG_TRACE_USR3(("m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH"));
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK"));
         m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3(("m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      }
      break;

      case FC_PHONE_SM_EVENT_CCX_VR_SA_OFF:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_CCX_VR_SA_OFF"));
         vHandleSourceActivityOff();
      }
      break;

      default:
         ETG_TRACE_USR3((" default %u", u16EventId));
         break;
   }

   ETG_TRACE_USR4((" EXIT : fc_phone_tclSMExtVRSession::vHandleEventInWaitForStopExtVRDueToIncomingCall"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInWaitForIdleCS
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventInWaitForIdleCS(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventInWaitForIdleCS: %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_IDLE:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_IDLE"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
         ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_IDLE"));

         vSendExtVRStatus();
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING:
      {
         ETG_TRACE_USR2(("FC_PHONE_SM_EVENT_DBUS_CALLSTATUS_INCOMING"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
         ETG_TRACE_USR2(("m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE"));

         // m_bIdleCallState is set to true intentionally so that GetCalls() is posted w/o
         // waiting for IDLE CS
         m_bIdleCallState = true;

         vSendExtVRStatus();
      }
      break;

      default:
      {
         ETG_TRACE_USR3(("vHandleEventInWaitForIdleCS: Default case"));
      }

   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleWaitingForChReleaseDueToIncomingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleWaitingForChReleaseDueToIncomingCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleWaitingForChReleaseDueToIncomingCall: %u", u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_OK"));
         m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3(("m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));

         m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
         ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_IDLE"));

         m_bIdleCallState = true;

         vSendExtVRStatus(EXT_VR_IDLE,EXT_VR_ERROR_PHONE_CALL_ACTIVE);
      }
      break;

      case FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("FC_PHONE_SM_EVENT_SPEECH_REQUEST_NOK"));
         m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3(("m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
      }
      break;

      default:
      {
         ETG_TRACE_USR3(("vHandleWaitingForChReleaseDueToIncomingCall: default"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleExtVRChannelAllocation
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleExtVRChannelAllocation()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleExtVRChannelAllocation"));

   if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_u16AudioChannel)
   {
      m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH;
      ETG_TRACE_USR3((" Requesting Audio ..AudioChannel = FC_PHONE_AUDIOCHANNEL_SPEECH "));
      m_poAudioManager->s32GetRequest(FC_PHONE_AUDIOCHANNEL_REQUESTOR_EXT_VOICE_REC,
            FC_PHONE_AUDIOCHANNEL_SPEECH,
            vAudioCallBackExtVR);
      m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_ACQUISITION;
      ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_ACQUISITION"));
   }
   else
   {
      //Error
      ETG_TRACE_USR4((" vHandleExtVRChannelAllocation::wrong Audio Channel Value %d",m_u16AudioChannel));
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleChannelAcquisition
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleChannelAcquisition()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleChannelAcquisition"));

   m_u16State = FC_PHONE_SMEXTVR_STATE_READY;
   ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_READY"));

   vSendExtVRStatus(EXT_VR_READY);
}

/*******************************************************************************
 *
 * FUNCTION: vHandleSourceActivityOff
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleSourceActivityOff()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleSourceActivityOff"));
   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
   ETG_TRACE_USR3(("m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));

   vSendExtVRStatus(EXT_VR_IDLE, EXT_VR_ERROR_IN_STREAMING);

   if(m_bIdleCallState)
   {
      m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
      ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_IDLE"));
   }
   else
   {
      ETG_TRACE_USR4((" Waiting for the IDLE call status update to close the External VR session"));

      m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS;
      ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS"));
   }
}
/*******************************************************************************
 *
 * FUNCTION: vHandleSCOChannelAcquisition
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleSCOChannelAcquisition()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleSCOChannelAcquisition"));
   m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_START_STREAMING;
   ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_START_STREAMING"));
}

/*******************************************************************************
 *
 * FUNCTION: vHandleStartStreamingAudio
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleStartStreamingAudio()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleStartStreamingAudio"));

   m_u16State = FC_PHONE_SMEXTVR_STATE_ACTIVE;
   ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_ACTIVE"));

   vSendExtVRStatus(EXT_VR_ACTIVE);
}

/*******************************************************************************
 *
 * FUNCTION: vHandleStopStreamingAudio
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleStopStreamingAudio()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleStopStreamingAudio"));
   m_u16State = FC_PHONE_SMEXTVR_STATE_READY;
   ETG_TRACE_USR4((" State changed :: FC_PHONE_SMEXTVR_STATE_READY"));

   vSendExtVRStatus(EXT_VR_READY);
}

/*******************************************************************************
 *
 * FUNCTION: vHandleSpeechRequestNotOk
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleSpeechRequestNotOk()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleSpeechRequestNotOk"));
   m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;

   m_bIdleCallState = true;

   vSendExtVRStatus(EXT_VR_IDLE, EXT_VR_ERROR_IN_STREAMING);

   m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
}

/*******************************************************************************
 *
 * FUNCTION: vReleaseSpeechChannel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vReleaseSpeechChannel()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vReleaseSpeechChannel"));

   if(FC_PHONE_AUDIOCHANNEL_SPEECH == m_u16AudioChannel)
   {
      ETG_TRACE_USR4(("Voice session ended - Release speech channel"));

      m_u16AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;

      ETG_TRACE_USR3((" Releasing Audio ..AudioChannel - FC_PHONE_AUDIOCHANNEL_SPEECH"));
      m_poAudioManager->s32ReleaseRequest(FC_PHONE_AUDIOCHANNEL_REQUESTOR_EXT_VOICE_REC,
            FC_PHONE_AUDIOCHANNEL_SPEECH,
            vAudioCallBackExtVR);

      if (FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_EXT_VR_INCOMING_CALL == m_u16State)
      {
         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL;
         ETG_TRACE_USR2((" State Change: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CH_REL_DUE_TO_INCOMING_CALL"));
      }
      else
      {
         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_RELEASE;
         ETG_TRACE_USR2((" State Change: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_CHANNEL_RELEASE"));
      }
   }
   else
   {
      if (m_bIdleCallState)
      {
         m_u16State = FC_PHONE_SMEXTVR_STATE_IDLE;
         vSendExtVRStatus();
      }
      else
      {
         m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS;
         ETG_TRACE_USR2((" State Change: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_IDLE_CS"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleSCOChannelRelease
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleSCOChannelRelease()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleSCOChannelRelease"));
   m_u16State = FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_STREAMING;
   ETG_TRACE_USR2((" State Change: FC_PHONE_SMEXTVR_STATE_WAITING_FOR_STOP_STREAMING"));
}
/*******************************************************************************
 *
 * FUNCTION: isExtVRSessionIdle
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMExtVRSession::isExtVRSessionIdle()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::isExtVRSessionIdle"));
   if(m_u16State == FC_PHONE_SMEXTVR_STATE_IDLE)
   {
      return true;
   }
   return false;
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventSLCOFF
 *
 * DESCRIPTION: HFP SLC is OFF . Hence clearing the channel if occupied.
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vHandleEventSLCOFF()
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vHandleEventSLCOFF"));

   if(FC_PHONE_SMEXTVR_STATE_IDLE != m_u16State)
   {
      m_bIdleCallState = true;
      vReleaseSpeechChannel();
   }
}

/*******************************************************************************
 *
 * FUNCTION: vSendExtVRStatus
 *
 * DESCRIPTION: Update the External VR state to the clients
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMExtVRSession::vSendExtVRStatus(ExtVRStates u8ExtVRState, ExtVRErrorCode u8ErrorCode)
{
   ETG_TRACE_USR4((" ENTER : fc_phone_tclSMExtVRSession::vSendIdleExtVRStatus"));

   ExtVRStateParams extVRState;
   extVRState.m_u8ExtVRState = u8ExtVRState;
   extVRState.m_u8ErrorCode = u8ErrorCode;
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_EXTERNALVR_STATUS, &extVRState);
}

