/*******************************************************************************
 *
 * FILE:          FC_Phone_SMDial.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SMDIAL_H_
#define _FC_PHONE_SMDIAL_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
/* Define the states that this machine can take */

//Dial Dbus call error macros
#define FC_PHONE_DIAL_DBUS_ERR_BUSY  0x22 
#define FC_PHONE_SMDIAL_UNKNOWN_MEMID 0xFF


//STATE MACHINE MACROS 
#define FC_PHONE_SMDIAL_STATE_DIAL_STARTED                               0
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT                   1 
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE        2
#define FC_PHONE_SMDIAL_STATE_CONNECTED_FROM_BT                          3

#define  FC_PHONE_SMDIAL_STATE_CALL_ROUTED                               4
#define  FC_PHONE_SMDIAL_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO     6
#define  FC_PHONE_SMDIAL_STATE_WAIT_FOR_DISCONNECT_FROM_BT               7

#define  FC_PHONE_SMDIAL_STATE_WAIT_FOR_MICROPHONE_MUTE                  8
#define  FC_PHONE_SMDIAL_STATE_MICROMUTED                                9
#define  FC_PHONE_SMDIAL_STATE_WAIT_FOR_MICROPHONE_UNMUTE                10
#define  FC_PHONE_SMDIAL_STATE_WAIT_FOR_HOLDCALL                         11
#define  FC_PHONE_SMDIAL_STATE_ONHOLD                                    12
#define  FC_PHONE_SMDIAL_STATE_CALL_TRANSFERTOHANDSET                    13
#define  FC_PHONE_SMDIAL_STATE_ROUTING_OUTGOINGCALL_IN_HANDSET           14

#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_SLC_OFF_RESPONSE                            15
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_NOSIGNAL_RESPONSE                           16

#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_RESUMECALL                                    17
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK_AND_CALLSTATUS                    18
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_SWAPDBUSACK                                   19
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_CALLSTATUS                                    20

#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_AND_AUDIOTRANSFER_DBUS_CALL     21
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_CONNECT_FROM_BT_FOR_TRANSFERAUDIO             22
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOACTIVATION_FOR_RESTOREDIALSM         23
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE 24
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE 25
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_HANGUP_ONSTARCALL 26
#define FC_PHONE_SMDIAL_STATE_WAIT_FOR_AUDIOTRANSFER_ONDIAL 27


class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

//DialType ::Enum for speed dial and dial
typedef enum
{
   FC_PHONE_DIALTYPE_DIAL = 1,
   FC_PHONE_DIALTYPE_SPEEDDIAL = 2,
   FC_PHONE_DIALTYPE_DIALEXTENDED = 3
}FcPhoneDialTypeEnum;


//struct is used for differenciating Dial and Speed Dial
//If dial type is only dial update the phonenumber member
//if dial type is Speed dial update the memoryId member
typedef struct
{
   tU8                  *pu8_phoneNumber ;
   tU16                  u16_memID ;
   FcPhoneDialTypeEnum   en_dialType ;

}FcPhoneDial_InputParamStruct ;



class fc_phone_tclSMDial FINAL: public fc_phone_tclSM
{
public:

   /* Constructor */
   fc_phone_tclSMDial(fc_phone_tclCallInstance*&  rfpCallInstance);
   fc_phone_tclSMDial(fc_phone_tclCallInstance*&  rfpCallInstance,tVoid *vArg);
   fc_phone_tclSMDial(fc_phone_tclSMDial & smDial);
   fc_phone_tclSMDial& operator=(fc_phone_tclSMDial & smDial);

   /* Destructor */
   virtual ~fc_phone_tclSMDial();


   virtual tVoid vCancel(tVoid) OVERRIDE;
   virtual tVoid vExecute(tVoid)OVERRIDE;
   virtual tBool bProcessEvent(tU16 u16EventId) OVERRIDE;
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg) OVERRIDE;

   virtual tVoid vTimerCallBack(tU16 u16TimerId) OVERRIDE;
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState) OVERRIDE;
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance) OVERRIDE;
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId) OVERRIDE;
   virtual tVoid vRestore(tVoid) OVERRIDE;
   virtual tVoid vProcessAudioSignal() OVERRIDE;
   virtual tVoid vSetDtmfLength(tU16 u16DtmfLength) OVERRIDE;

private:
   tU8*  m_phonenumber;
   tBool m_bTimerRunning;
   tBool m_bTerminateCallTimerRunning;
   tBool m_bCallStatusFailureTimerRunning;
   tU8 m_u8RetryCount;
   tU16  m_u16State_while_MicroPhoneMute ;
   tU8   m_u8errorCode ;
   tU16  m_u16_memID ;
   tU16 m_u16State_while_Hold ;
   tU16 m_u16State_while_TransferAudio;
   tU16 m_u16State_CurrentState;
   tBool m_bTransferCallToVehicleRequest;
   //DTMF attributes
   tU16 u16_DialoneTimeDTMFCalculation;
   tU16 m_u16DTMFCharLength ;
   tU16 m_u16SentDtmfCounter ;
   tBool m_bTerminateCallReqBeforeDial;
   tBool m_bTerminateCallRequest;
   FcPhoneDialTypeEnum m_en_dialType ;
   tBool m_bEventConsumed ;
   tBool m_bTerminateCallPosted;

   tVoid vHandleEventInDialBTInCall(tU16 u16EventId);
   tVoid vHandleEventInDialConnectedWithBT(tU16 u16EventId);
   tVoid vHandleEventInAMInActivateVoiceCall(tU16 u16EventId);
   tVoid vHandleEventInCallRouted(tU16 u16EventId);
   tVoid vHandleEventInCancelOutgoingCallAndAudio(tU16 u16EventId);
   tVoid vHandleEventInTerminateBTInCall(tU16 u16EventId);
   tVoid vHandleEventInHoldCall(tU16 u16EventId);
   tVoid vHandleEventInRoutingHandsetCall(tU16 u16EventId);
   tVoid vHandleDbusError(tU16 u16DbusAckType,tChar Code);
   tVoid vHandleEventInResumeCall(tU16 u16EventId);
   tVoid vHandleEventInSwapDbusAckOrCallStatus(tU16 u16EventId);
   tVoid vHandleEventInSwapCall(tU16 u16EventId);
   tVoid vHandleEventInReleaseAudioAndTransferAudio(tU16 u16EventId);
   tVoid vHandleEventInAudioActivationOnRestoreDialSM(tU16 u16EventId);
   tVoid vHandleEventInAudioReleaseOnTransferAudioRequest(tU16 u16EventId);
   tVoid vHandleEventInAudioAcquisitionOnTransferAudioRequest(tU16 u16EventId);
   tVoid vAssignErrorCode(tChar Code);
   tVoid vStopTimer(tVoid);
   tVoid vHandleEventInAudioTransferOnDial(tU16 u16EventId);
   tVoid vTerminateOutgoingCall();
   tVoid vCancelOutgoingCall();
   tVoid vStopTerminateRetryTimer();
   tVoid vHandleCallstatusFailure();
   tVoid vStopCallStatusFailureTimer();
   tVoid vCancelSMReleaseChannel();
   tVoid vSendOutGoingFailedStatus(tCString ErrorInfo,tU8 u8DbusAckType);

};

#endif // _FC_PHONE_SMDIAL_H_


