/*******************************************************************************
 *
 * FILE:          FC_Phone_SMConferenceCall.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a statemachine
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_CONFERENCECALL_H_
#define _FC_PHONE_CONFERENCECALL_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
/* Define the states that this machine can take */

#define FC_PHONE_CONFERENCECALL_STATE_CONFERENCE_CALL_STARTED  0
#define FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_CONNECT_FROM_BT 1 
#define FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_SPLITCALL       2
#define FC_PHONE_CONFERENCECALL_STATE_CALL_ROUTED              3
#define FC_PHONE_CONFERENCECALL_STATE_SPLIT                    4
#define FC_PHONE_CONFERENCECALL_STATE_HANGUPALL                5
#define FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_HANGUPDBUSACK             8
#define FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_HANGUPALLDBUSACK          9
#define FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE  10
#define FC_PHONE_CONFERENCECALL_STATE_HANGUPSINGLE                       11
#define FC_PHONE_CONFERENCECALL_STATE_WAIT_FOR_SLC_OFF_RESPONSE          12
#define FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE1 13
#define FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_AUDIOACTIVATION_ON_RESTORECONFERENCESM_CALLINSTANCE2 14
#define FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE1_TRANSFERAUDIOREQUEST_FROMPHONE 15
#define FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIORELEASE_CALLINSTANCE2_TRANSFERAUDIOREQUEST_FROMPHONE 16
#define FC_PHONE_CONFERENCECALL_STATE_WAITFOR_AUDIOACQUISITION_ON_TRANSFERAUDIOREQUEST_FROMPHONE 17
//FIX GMMY15-8315 [CT]Cannot place conference call on hold
//Hold request was not handled in this state machine, hence conference call was not possible to be put on hold.
//These are internal states that handles acknowledgement for Hold call and resume call.
#define FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_HOLDCALL_ACK 18
#define FC_PHONE_SMCONFERENCECALL_STATE_WAIT_FOR_RESUMECALL_ACK 19
//End of fix

typedef struct
{
   tBool                  isConfFromCallStatus;   
}FCPhoneConf_InputParamStruct;

class fc_phone_tclSMManager;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMConferenceCall : public fc_phone_tclSM 
{
public:

   /* Constructor */
   fc_phone_tclSMConferenceCall(fc_phone_tclCallInstance*  rfpCallInstance[]);
   fc_phone_tclSMConferenceCall(fc_phone_tclCallInstance*  rfpCallInstance[],tVoid *vArg);

   /* Destructor */
   virtual ~fc_phone_tclSMConferenceCall();

   virtual tVoid vCancel(tVoid) FINAL;
   virtual tVoid vExecute(tVoid);
   virtual tBool bProcessEvent(tU16 u16EventId) FINAL;
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vTimerCallBack(tU16 u16TimerId);
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   virtual tVoid vRestore(tVoid);
   virtual tVoid vProcessAudioSignal();
   virtual tVoid vSetDtmfLength(tU16 u16DtmfLength);
private:
   tVoid vHandleEventInCallRouted(tU16 u16EventId);
   tVoid vHandleEventInConferenceCall(tU16 u16EventId);
   tVoid vHandleEventInSplitCall(tU16 u16EventId);
   tVoid vHandleEventHangUpSingleCall(tU16 u16EventId);
   tVoid vHandleAudioReleaseCallInstance1(tU16 u16EventId);
   tVoid vHandleAudioReleaseCallInstance2(tU16 u16EventId);
   tVoid vHandleAudioReleaseForTransferAudioOfCallInstance1(tU16 u16EventId);
   tVoid vHandleAudioReleaseForTransferAudioOfCallInstance2(tU16 u16EventId);

   tVoid vHandleAudioAcqusitionOnTransferAudioFromPhone(tU16 u16EventId);

   tVoid vHandleAudioReleaseCallInstance(tU16 u16EventId);
   tVoid vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance1(tU16 u16EventId);
   tVoid vHandleEventInAudioAcquisitionOnRestoreConferenceSMCallInstance2(tU16 u16EventId);
   tVoid vReleaseAudioHangUp();
   tVoid vReleaseAudioSingleCall();
   tVoid vHandleDbusError(tU16  u16DbusAckType, tChar Code);
   tVoid vHandleConfCallError();
   tVoid vHandleSplitCallError();
   tVoid vHandleHangUpCallError();
   tVoid vRestoreSM();
   tVoid vStartIdleHangUpAll();
   tVoid vStartIdleHangUp();
   tVoid vStartIdleAndRestoreSM(fc_phone_tclCallInstance*& rfpCallInstance);
   tVoid vStartIdleAndSMFinished();
   tVoid vAssignErrorCode(tChar Code);
   tVoid vSetCallStatusConference();
   tVoid vHandleTransferCallToVehicle();
   tVoid vHandleTransferCallToHandset();
   tVoid vSendCallStatusSplit(fc_phone_tclCallInstance*& rfpCallInstance, const T_CallData* const prCallData);

   //FIX GMMY15-8315 [CT]Cannot place conference call on hold
   //Hold request was not handled in this state machine, hence conference call was not possible to be put on hold.
   //This is Event handler for Hold call acknowledgement
   tVoid vHandleEventInHoldCallAck(tU16 u16EventID);
   tVoid vHandleEventInResumeCallAck(tU16 u16EventId);
   //End of fix

   tBool m_bEventConsumed ;
   tBool m_bTimerRunning;
   tU16  m_splitCallInstanceID;
   tU16  m_releaseCallInstanceID;
   fc_phone_tclCallInstance *m_pReleaseCallInstance;
   tBool m_bHangUpMethodStart;
   tBool m_bHangUpAllMethodStart;
   tU16  m_u16State_while_TransferAudio;
   tBool m_isConfFromCallStatus;
   tBool m_isConfFromHmiCallInHandset;
   tU8 m_u8CallTransferDirection;
   tBool m_SlcOff;

   // DTMF attributes
   tU16 u16_oneTimeDTMFCalculation;
   tU16 m_u16DTMFCharLength;
   tU16 m_u16SentDtmfCounter;
   tBool m_bSplitMethodResultSent;
};

#endif // _FC_PHONE_CONFERENCECALL_H_


