

/*******************************************************************************
 *
 * FILE:          FC_Phone_SMActiveCallInHandset.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts a Active Call In Handset statemachine
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SMACTIVECALLINHANDSET_H_
#define _FC_PHONE_SMACTIVECALLINHANDSET_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/* Define the states that this machine can take */

#define FC_PHONE_SMACH_STATE_IDLE                               0
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_GET_ALERTTONE 1
#define FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY            2
#define FC_PHONE_SMACH_STATE_DISPLAY_ONLY_PROMPT                3
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_REL_ALERTTONE 4
#define FC_PHONE_SMACH_STATE_MAINTAINCALLSTATUS                 5
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_AND_REINIT_IDLE  6
#define FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET                  7
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE     8
#define FC_PHONE_SMACH_STATE_WAIT_FOR_CONNECT_FROM_BT                9


#define FC_PHONE_SMACH_STATE_ONCALLACCEPTED_IN_HANDSET 11
#define FC_PHONE_SMACH_STATE_WAIT_FOR_BT_CHANGEDEVICESTATE_RESPONSE_ONINCOMINGCALL 12
#define FC_PHONE_SMACH_STATE_WAITFORAUDIORELEASE_ONCALL_INHANDSET 15
#define FC_PHONE_SMACH_STATE_WAIT_FOR_TRANSFERAUDIO_ONCALL_INHANDSET 16
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIOTRANSFER_OR_AUDIOCHANNELRELEASE 17
#define FC_PHONE_SMIDLE_STATE_WAIT_FOR_SWITCHSOURCE_ONCALL_END 18
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE 19
#define FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE 20
#define FC_PHONE_SMACH_STATE_WAIT_FOR_HOLDCALL 21
#define FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PAUSE 22
#define FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO 23 //gmmy15-5984
#define FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT 24 //gmmy15-5984
#define FC_PHONE_SMACH_STATE_WAIT_FOR_HANGUP_FROM_BT 25 //gmmy15-11041- Hangup ACK when broadcasted was handled in callrouted state of both statemachines 
//in case if two activecallin handset statemachine exist.
#define FC_PHONE_SMACH_STATE_DISCONNECTED_FROM_BT 26

/* Some general defines */
#define FC_PHONE_SMACH_ALERT_TONE_INTERVAL_TIME          5000 /* 5 seconds */
#define FC_PHONE_SMACH_ALERT_TONE_COUNT                  5    /* 5 seconds */
#define FC_PHONE_AUDIOTRANSFER_REFTIMER 2000
#define FC_PHONE_AUDIOTRANSFER_TIMER_INTERVAL_INC 400
#define FC_PHONE_CALLSTATUS_INCOMING 1
#define FC_PHONE_CALLSTATUS_WALKINCALL 2
#define FC_PHONE_CALLSTATUS_DIAL 3
#define FC_PHONE_CALLSTATUS_UNKNOWN 0
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclSMACH : public fc_phone_tclSM 
{
public:

   /* Constructor */
   fc_phone_tclSMACH(fc_phone_tclCallInstance*&  rfpCallInstance);
   fc_phone_tclSMACH(fc_phone_tclCallInstance*  rfpCallInstance[]);

   /* Destructor */
   virtual ~fc_phone_tclSMACH();
   virtual tVoid vCancel(tVoid) FINAL;
   virtual tVoid vExecute(tVoid);
   virtual tBool bProcessEvent(tU16 u16EventId) FINAL;
   virtual tBool bProcessEvent(tU16 u16EventId,tVoid *varg);
   virtual tVoid vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance);
   virtual tVoid vTimerCallBack(tU16 u16TimerId);
   virtual tVoid vProcessAudioSignal() FINAL;
   virtual tVoid vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState);
   virtual tVoid vProcessOnDynamicDisconnect(tU16 u16EventId);
   virtual tVoid vRestore(tVoid);
   virtual tVoid vSetDtmfLength(tU16 u16DtmfLength);
private:
   tBool m_bTimerRunning;
   tBool m_bAlertTimerRunning ;
   tU16  m_u16AlertPromptPlayCount;
   tBool m_bEventConsumed;
   tU32  m_u32AudioTransferTimer;
   tBool m_bHangUpMethodStart;
   tBool m_bHangUpAllMethodStart;
   tBool m_bSwapCallMethodStart;
   tBool m_bResumeCallMethodStart;
   tU16 m_u16State_while_TransferAudio;
   //m_pReleaseCallInstance = NULL; //GMMY15-8821 commenting as it is not used anywhere else
   tU16  m_releaseCallInstanceID;
   tU8 m_u8CallTransferDirection;
   tU8 m_u8CallStatus;
   tVoid vInit(tVoid);
   tBool m_bAlertPlaying;
   tBool m_bAlertPlayingFromSaOn;
   tBool m_bAudioTransferTriggerWalkInCall;
   // DTMF attributes
   tU16 u16_oneTimeDTMFCalculation;
   tU16 m_u16DTMFCharLength;
   tU16 m_u16SentDtmfCounter;
   tBool m_bReleaseRingTone; //CloneTicket:GMMY15-5176:Call was lost when chages from handsfree to private mode.

   tVoid vHandleEventInIdle(tU16 u16EventId);
   tVoid vHandleEventInAMGetAlertTone(tU16 u16EventId);
   tVoid vHandleEventInAlertTonePlay(tU16 u16EventId);
   tVoid vHandleEventInAlertTonePause(tU16 u16EventId);
   tVoid vHandleEventInRelAlertTone(tU16 u16EventId);
   tVoid vHandleEventInCancelOutgoingCallAndAudio(tU16 u16EventId); //gmmy15-5984
   tVoid vHandleEventInTerminateBTInCall(tU16 u16EventId);//gmmy15-5984
   tVoid vHandleEventInRoutingCallInHandset(tU16 u16EventId);
   tVoid vHandleEventInAMInActivateVoiceCall(tU16 u16EventId);
   tVoid vHandleEventInSMachBTInCall(tU16 u16EventId);
   tVoid vHandleEventInSMachOnCallAcceptedInHandset(tU16 u16EventId);
   tVoid vHandleEventWaitForAudioTransferAudioChannelReleaseOnHandsetCall(tU16 u16EventId);
   tVoid vHandleEventInAudioAcquisitionOnTransferAudioRequest(tU16 u16EventId);
   tVoid vHandleEventInAudioReleaseOnTransferAudioRequest(tU16 u16EventId);
   tVoid vTimeOutOnAudioTransfer(tVoid);
   tVoid vHandleDbusError(tU16 u16DbusAckType,tChar Code);
   tVoid vHangUpCall();
   tVoid vHandleEventInHoldCall(tU16 u16EventId);
   tVoid vAssignErrorCode(tChar Code);
   tVoid vStopAlertTone();
   tVoid vStopAlertToneFromSaOn();
   tVoid vPlayAlertToneStatus();
   tVoid vTerminateOutgoingCall();//gmmy15-5984
   tVoid vHandleEventInCancelOutgoingCallOk();//gmmy15-5984
   tVoid vHandleErrorInTerminate(tChar Code);//gmmy15-5984
   //gmmy15-11041- Hangup ACK when broadcasted was handled in callrouted state of both statemachines
   //in case if two activecallin handset statemachine exist.
   tVoid vHandleEventInHangUpCall(tU16 u16EventId);

   /* GMMY15-9114 FC_Phone : logiscope code complexity value >= 20 */
   tVoid vProcessEventHelper(tU16 u16EventId);
};



#endif // _FC_PHONE_SMACTIVECALLINHANDSET_H_


