/******************************************************************************
 *
 * FILE:          FC_Phone_SMActiveCallInHandset.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_SMIncludes.h"
#include "../HelperClasses/FC_Phone_CallManager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_STATEMACHINE
#include "trcGenProj/Header/FC_Phone_SMActiveCallInHandset.cpp.trc.h"
#endif

// TODO: The Alert Tone related things has to be removed from this file

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBackACH
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid vAudioCallBackACH(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering vAudioCallBackACH"));
   fc_phone_tclSM* pSMInstance ;
   pSMInstance = fc_phone_tclSMManager::GetSM_FromAudioRequestorId(u16AudioReqID) ;

   if(pSMInstance)
   {
      pSMInstance->vAudioCallBack(u16AudioChannelId, u16RequestState);
   }
   else
   {
      ETG_TRACE_ERR(("ERROR:: could not get SM for u16AudioReqID %d",u16AudioReqID));
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMACH
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMACH::fc_phone_tclSMACH(fc_phone_tclCallInstance*&  rfpCallInstance):\
      fc_phone_tclSM(rfpCallInstance)

      {
   ETG_TRACE_USR4((" Entering constructor fc_phone_tclSMACH::fc_phone_tclSMACH"));
   vInit();
   m_bEventConsumed = FALSE ;
   m_u32AudioTransferTimer = FC_PHONE_AUDIOTRANSFER_REFTIMER;
   m_u16State_while_TransferAudio = 0;
   m_releaseCallInstanceID = 0;
   m_bHangUpMethodStart = FALSE;
   m_bHangUpAllMethodStart = FALSE;
   m_bSwapCallMethodStart = FALSE;
   m_bResumeCallMethodStart = FALSE;
   m_u8CallStatus = FC_PHONE_CALLSTATUS_UNKNOWN;
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_oneTimeDTMFCalculation = 0;
   m_bAudioTransferTriggerWalkInCall = FALSE;
   m_bReleaseRingTone = FALSE;
   m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN;	//Fix for CMG3GB-1664
   m_bAlertPlaying = FALSE; 
   m_bAlertPlayingFromSaOn = FALSE;
   m_bAlertTimerRunning = FALSE;
   m_u16AlertPromptPlayCount = 0;
      }

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMACH
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMACH::fc_phone_tclSMACH(fc_phone_tclCallInstance *rfpCallInstance[]) : fc_phone_tclSM(rfpCallInstance)
{
   ETG_TRACE_USR4((" ENTER: fc_phone_tclSMACH::fc_phone_tclSMACH with two call instances"));

   vInit();
   m_bEventConsumed = FALSE ;
   m_u32AudioTransferTimer = FC_PHONE_AUDIOTRANSFER_REFTIMER;
   m_bAlertPlaying = FALSE;
   m_bAlertPlayingFromSaOn = FALSE;
   m_bAudioTransferTriggerWalkInCall = FALSE;
   m_releaseCallInstanceID = 0;
   m_bHangUpMethodStart = FALSE;
   m_bHangUpAllMethodStart = FALSE;
   m_bSwapCallMethodStart = FALSE;
   m_bResumeCallMethodStart = FALSE;
   m_u8CallStatus = FC_PHONE_CALLSTATUS_UNKNOWN;
   m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN; //Fix for CMG3GB-1664
   m_u16SentDtmfCounter  = 0;
   m_u16DTMFCharLength   = 0;
   u16_oneTimeDTMFCalculation = 0;
   m_bReleaseRingTone = FALSE;
   m_bAlertTimerRunning = FALSE;
   m_u16AlertPromptPlayCount = 0;
   m_u16State_while_TransferAudio = 0;
   ETG_TRACE_USR4((" EXIT: fc_phone_tclSMACH::fc_phone_tclSMACH with two call instances"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMACH
 *
 * DESCRIPTION: Destructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
fc_phone_tclSMACH::~fc_phone_tclSMACH()
{
   ETG_TRACE_USR4((" Entering destructor fc_phone_tclSMACH::~fc_phone_tclSMACH"));
}

/*******************************************************************************
 *
 * FUNCTION: vCancel
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vCancel(tVoid)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vCancel"));

   if(TRUE == m_bTimerRunning)
   {
      ETG_TRACE_USR4((" Stoping Timer with TimerId:; %d ",m_poCallInstance->m_u16Id));
      m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
      m_bTimerRunning = FALSE;
      ETG_TRACE_USR3(("  m_bTimerRunning = FALSE"));
   }

   vStopAlertTone();
   m_bResumeCallMethodStart = FALSE;
   m_bSwapCallMethodStart = FALSE;
   m_u16State_while_TransferAudio = 0;
   m_bAudioTransferTriggerWalkInCall = FALSE;
   // If DTMF sending is not finished , send method error
   if (m_u16SentDtmfCounter != m_u16DTMFCharLength)
   {
      ETG_TRACE_USR4((" sending Methos Error to client"));
      u16_oneTimeDTMFCalculation = 0;
      m_u16SentDtmfCounter  = 0;
      m_u16DTMFCharLength   = 0;
      m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
   }
}

/*******************************************************************************
 *
 * FUNCTION: vExecute
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vExecute()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vExecute "));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   ETG_TRACE_USR4(("  fc_phone_tclSMACH::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));

   tU16 u16CallState = FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE;
   m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIOTRANSFER_OR_AUDIOCHANNELRELEASE;
   ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIOTRANSFER_OR_AUDIOCHANNELRELEASE"));
   if(FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice)
   {
      //Incoming call accepted in Handset start timer immediately
      ETG_TRACE_USR4((" fc_phone_tclSMACH::Call Accepted in Handset "));
      m_bTimerRunning = TRUE;
      ETG_TRACE_USR3(("  m_bTimerRunning = TRUE"));
      m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
      m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);

      // BugV2.0 174211- RetrieveCallStatus is no longer needed. the Call state is retrieved from CallStatusList table
      u16CallState = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->u16GetCallStateFromCallInstID(m_poCallInstance->m_u16Id);
      ETG_TRACE_USR3(("u16CallState: %u", ETG_ENUM(TR_CALLSTATUS,u16CallState)));

      m_poCallInstance->m_u16CallStatusNotice = u16CallState;

      // Fix for GMMY17-3623. The ActiveCallInHandset property is updated when the incoming call is accepted in the handset 
      // And the call is in Handset i.e. No SCO connection is being established
      if(FC_PHONE_DBUS_SCO_CONN_ESTABLISHED != u8SCOConnectionStatus )
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);

      m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
      m_u8CallStatus = FC_PHONE_CALLSTATUS_INCOMING;
   }
   else if(FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING == m_poCallInstance->m_u16CallStatusNotice)
   {
      ETG_TRACE_USR4((" fc_phone_tclSMACH::Call Dialled from  Handset "));
      m_u8CallStatus = FC_PHONE_CALLSTATUS_DIAL;
   }
   else
   {
      ETG_TRACE_USR4((" fc_phone_tclSMACH::User walk in with call"));
      //User walk in with call start timer
      if (FALSE == m_bTimerRunning)
      {
         m_bTimerRunning = TRUE;
         ETG_TRACE_USR3(("  m_bTimerRunning = TRUE"));
         m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
         m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
      }
      m_u8CallStatus = FC_PHONE_CALLSTATUS_WALKINCALL;
   }
   tU16 bInBandRingtone;
   bInBandRingtone = p_clientHndler_bluetooth->vIsInBandRingtone();
   if ((!bInBandRingtone) || p_clientHndler_bluetooth->bIsSuppressRingtoneEnabled())
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
      {
         m_bReleaseRingTone = TRUE;
         // release Alert or Ring Tone channel
         ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackACH);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      else
      {
         ETG_TRACE_USR4((" EVENT::CHANNEL Is not Used"));
         bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK);
      }
   }
   else
   {
      //For SUZUKI- 23529
      if(FALSE ==  m_poCallInstance->m_bcallWaitingState)
      {
         ETG_TRACE_USR3(("Inband ringtone send event FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
      }
      else
      {
         if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" Requesting for release alert tone"));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);
         }
      }
   }

   ETG_TRACE_USR4(("  fc_phone_tclSMACH::u8SCOConnectionStatus = %d ",u8SCOConnectionStatus));
   if(m_u8CallStatus == FC_PHONE_CALLSTATUS_WALKINCALL)
   {
      ETG_TRACE_USR4(("  fc_phone_tclSMACH::User Walk in with call"));
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
      {
         ETG_TRACE_USR4(("  fc_phone_tclSMACH::u8SCOConnectionStatus is disconnected"));
      }
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         ETG_TRACE_USR4((" fc_phone_tclSMACH::u8SCOConnectionStatus is established"));
      }
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
      {
         ETG_TRACE_USR4(("  fc_phone_tclSMACH::u8SCOConnectionStatus is established"));
      }
   }
   if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
   {
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
      {
         vProcessAudioSignal();
      }

   }
}

/*******************************************************************************
 *
 * FUNCTION: vRestore
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vRestore()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vRestore "));

   m_bTimerRunning = TRUE;
   ETG_TRACE_USR3(("  m_bTimerRunning = TRUE"));
   m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET ;
   ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
   m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);

   //send Walk-in call alert to alert manager
}


/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMACH::bProcessEvent(tU16 u16EventId,tVoid *varg)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::bProcessEvent:2param  u16EventId %d",u16EventId));
   (tVoid)varg ;
   tBool bRetVal= FALSE;
   ETG_TRACE_USR4((" fc_phone_tclSMACH::vProcessEvent With Args"));
   FcPhone_processEventArg *p_method_data = (FcPhone_processEventArg *)varg;

   if(p_method_data->bIsItDbusAck == TRUE)
   {
      if(p_method_data->u16DbusAckType == FC_PHONE_CB_FID_AUDIOTRANSFER)
      {
         /*Currently ALPS is returning 1->Success 0->Failure */
         if((p_method_data->Status == CALLTRANSFER_FAILURE) &&
               (m_u32AudioTransferTimer > FC_PHONE_AUDIOTRANSFER_TIMEOUT))

         {
            ETG_TRACE_USR4(("DBUS TransferCall  FAILS  p_method_data->Status :: %d  p_method_data->Code :: 0x%x",p_method_data->Status,p_method_data->Code));
            vHandleDbusError(p_method_data->u16DbusAckType,p_method_data->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS TransferCall fails and retrying"));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
      else
      {
         if(FC_PHONE_DBUS_STATUS_SUCCESS != p_method_data->Status)
         {
            ETG_TRACE_USR4(("DBUS Request Fails"));
            vHandleDbusError(p_method_data->u16DbusAckType,p_method_data->Code);
         }
         else
         {
            ETG_TRACE_USR4(("DBUS Request Success"));
            bRetVal = bProcessEvent(u16EventId);
         }
      }
   }
   else
   {
      ETG_TRACE_USR4((" Handling Other events of SMACH"));
      if (u16EventId == FC_PHONE_SM_EVENT_HANGUPCALL_OK)
      {
         ETG_TRACE_USR4((" u16CallInstanceID :: %d       m_releaseCallInstanceID :: %d",p_method_data->u16CallInstanceID,m_releaseCallInstanceID));
         m_releaseCallInstanceID = p_method_data->u16CallInstanceID;
      }
      bRetVal = bProcessEvent(u16EventId);
   }
   ETG_TRACE_USR4(("   bRetVal = %d  ",bRetVal));
   m_bEventConsumed = FALSE;
   return bRetVal;

}
/*******************************************************************************
 *
 * FUNCTION: bProcessEvent
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tBool fc_phone_tclSMACH::bProcessEvent(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::bProcessEvent:1param  u16EventId %d",u16EventId));
   switch (m_u16State)
   {
      case FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_GET_ALERTTONE:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_GET_ALERTTONE "));
         vHandleEventInAMGetAlertTone(u16EventId);
      }
      break;

      case FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY "));
         vHandleEventInAlertTonePlay(u16EventId);
      }
      break;

      case FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PAUSE:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PAUSE "));
         vHandleEventInAlertTonePause(u16EventId);
      }
      break;

      case FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_REL_ALERTTONE:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_REL_ALERTTONE "));
         vHandleEventInRelAlertTone(u16EventId);
      }
      break;
      case FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET :
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET "));
         vHandleEventInRoutingCallInHandset(u16EventId);

      }
      break ;

      case FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE :
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE "));
         vHandleEventInAMInActivateVoiceCall(u16EventId);

      }
      break ;
      case FC_PHONE_SMACH_STATE_WAIT_FOR_CONNECT_FROM_BT :
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInSMachBTInCall(u16EventId);

      }
      break ;
      //gmmy15-11041- Hangup ACK when broadcasted was handled in callrouted state of both statemachines
      //in case if two activecallin handset statemachine exist.
      case FC_PHONE_SMACH_STATE_WAIT_FOR_HANGUP_FROM_BT :
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_CONNECT_FROM_BT "));
         vHandleEventInHangUpCall(u16EventId);
      }
      break;

      /* GMMY15-9114 FC_Phone : logiscope code complexity value >= 20 */
      default:
      {
         vProcessEventHelper(u16EventId);
      }
   }
   tBool bRetVal= m_bEventConsumed ;
   m_bEventConsumed = FALSE ;
   return bRetVal ;
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHoldCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInHoldCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInHoldCall  u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_HOLDCALL_ACK_OK "));
         //update the status to hold
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vHandleEventInHoldCall DEFAULT "));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMACH::vHandleEventInAudioReleaseOnTransferAudioRequest
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInAudioReleaseOnTransferAudioRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInAudioReleaseOnTransferAudioRequest  u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         m_u16State_while_TransferAudio = 0;
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         m_u16State_while_TransferAudio = 0;
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMACH::vHandleEventInAudioAcquisitionOnTransferAudioRequest
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInAudioAcquisitionOnTransferAudioRequest(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInAudioAcquisitionOnTransferAudioRequest  u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET, m_poCallInstance);
         m_u16State_while_TransferAudio = 0;

      }
      break;
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         //AcquireAudioChannel and transfer audio to handsfree
         m_u16State_while_TransferAudio = FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
         ETG_TRACE_USR3((" AudioChannel =  FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_u8CallTransferDirection = FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET;
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         m_u16State_while_TransferAudio = 0;
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT : Wrong Event ID u16EventId: %d",u16EventId));
      }
      break;
   }
}

//gmmy15-5984

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCancelOutgoingCallAndAudio
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInCancelOutgoingCallAndAudio(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInCancelOutgoingCallAndAudio with EventId %d",u16EventId));

   if (m_poCallInstance)
   {
      switch (u16EventId)
      {
         case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
         {
            ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
            //Update the audio channel status
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
                  m_poCallInstance);
            vTerminateOutgoingCall();
         }
         break;

         case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
         {
            ETG_TRACE_USR2(("  EVENT :OR  FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
            /* TO DO:Transfer the call to handset */
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE "));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,
                  m_poCallInstance);

         }
         break;

         default:
         {
            ETG_TRACE_USR4(("  fc_phone_tclSMACH::vHandleEventInCancelOutgoingCallAndAudio :: Default"));
         }
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventWaitForAudioTransferAudioChannelReleaseOnHandsetCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventWaitForAudioTransferAudioChannelReleaseOnHandsetCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventWaitForAudioTransferAudioChannelReleaseOnHandsetCall  u16EventId %d",u16EventId));
   tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
   fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
   u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
   switch (u16EventId)
   {
      /*Calls kept in private mode or handsfree mode based on connected BT Device Request
       * If BT device sends HfSetUp Audio call is kept in Handsfree or else in Handset */
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK"));

         m_bReleaseRingTone = FALSE;
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         vProcessAudioSignal();
      }
      break;
      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK"));

         m_bReleaseRingTone = FALSE;
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         vProcessAudioSignal();
      }
      break;
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         m_u32AudioTransferTimer = FC_PHONE_AUDIOTRANSFER_REFTIMER;
         //call Accepted From Handset

         if(m_u8CallStatus == FC_PHONE_CALLSTATUS_INCOMING)
         {
            //When Call is accepted in Handset
            ETG_TRACE_USR4(("Case of user accepted calls in handset"));
            /*If call is already in Head Unit no need to transfer other call also to handset*/
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               m_poSMManager->vBroadCastInternalEvent(FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET);
            }
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
            m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
            ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
         }
         else if(m_u8CallStatus == FC_PHONE_CALLSTATUS_DIAL)
         {
            ETG_TRACE_USR4((" Case of user dialled from handset"));
            //For the case when call is dialled from handset
            /*If call is already in Head Unit no need to transfer other call also to handset*/
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               m_poSMManager->vBroadCastInternalEvent(FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET);
            }
            //m_u16State = FC_PHONE_SMACH_STATE_WAITFORAUDIORELEASE_ONCALL_INHANDSET;
            m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
            ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         }
         else if(m_u8CallStatus == FC_PHONE_CALLSTATUS_WALKINCALL)
         {
            ETG_TRACE_USR3((" EVENT::User Walk In With calls in handset"));
            if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
            {
               m_poSMManager->vBroadCastInternalEvent(FC_PHONE_SM_EVENT_IF_VEHICLECALL_TRANSFER_TOHANTSET);
               /*When call is accepted in Handset this function checks for Audio in Handset or handsfree.If audio
               is in  Handsfree transfer to handset (i)Audio may be transferred by using Transfercall SM (ii)
               Broadcast internal event may transfer audio (iii)In order to avoid repeated request of Audio transfer */
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
               /* Request for ALERT TONE */
               m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_GET_ALERTTONE;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_GET_ALERTTONE"));
               ETG_TRACE_USR3(("Requesting for audio ....to AVM"));
               m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE, vAudioCallBackACH);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
               ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE"));
            }
            else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
            {
               m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
            }
            else
            {
               m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
            }
         }
         else
         {
            ETG_TRACE_USR3((" EVENT::Call Status Doesnt Match"));
         }
         m_u8CallStatus = FC_PHONE_CALLSTATUS_UNKNOWN;
      }
      break;
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE;
         if (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackACH);
         }
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vHandleEventInCancelOutgoingCallOk();
         m_bEventConsumed = TRUE;
      }
      break;


      default:
      {

         ETG_TRACE_USR4((" warning : In default: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK :Error case of Audio Transfer is not handled"));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAMAlertTone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInAMGetAlertTone(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInAMGetAlertTone u16EventId %d",u16EventId));
   switch (u16EventId) 
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         /* ALERT Logical channel is obtained.
         Now Keep on playing the ALERT every  FC_PHONE_SMACH_ALERT_TONE_INTERVAL_TIME
          */

         /* Play ALERT Tone */
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY"));
         m_bAlertPlayingFromSaOn = TRUE;
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ALERTTONE;
         ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ALERTTONE"));
      }
      break;
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         m_u16State =  FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
      }
      break ;
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE;


         if (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackACH);
         }

         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         if(m_poCallInstance->m_u8AudioChannel == FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;     
      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vHandleEventInCancelOutgoingCallOk();
         m_bEventConsumed = TRUE;
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vHandleEventInAMGetAlertTone DEFAULT "));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAlertTonePlay
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInAlertTonePlay(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInAlertTonePlay u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_TIMER_EXPIRED:
      {
         ETG_TRACE_USR3((" EVENT::FC_PHONE_SM_EVENT_TIMER_EXPIRED "));

         if (m_bAlertPlayingFromSaOn)
         {
            /* Stop the alert tone playing from SA_ON */
            ETG_TRACE_USR4(("Call vStopAlertToneFromSaOn"));
            vStopAlertToneFromSaOn();
         }

         /* Stop the alert tone playing */
         vStopAlertTone();

         /* Alert file played.
               Now wait for pause duration to restart play  */

         /* Pause Alert Tone */
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PAUSE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PAUSE"));
      }
      break;

      //While Playing Alert if user request for transfer call to vehicle release alert tone and transfer call
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackACH);
         }
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vHandleEventInCancelOutgoingCallOk();
         m_bEventConsumed = TRUE;
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vHandleEventInAlertTonePlay DEFAULT "));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInAlertTonePause
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInAlertTonePause(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInAlertTonePause u16EventId %d",u16EventId));

   m_bEventConsumed = TRUE ;

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_TIMER_EXPIRED:
      {
         ETG_TRACE_USR3(("  EVENT::FC_PHONE_SM_EVENT_TIMER_EXPIRED - m_u16AlertPromptPlayCount: %d ",m_u16AlertPromptPlayCount));
         if(0x00 == m_u16AlertPromptPlayCount)
         {
            ETG_TRACE_USR4((" m_u16AlertPromptPlayCount is 0, wait for call to end or to accept from user      Calling AlertToneGstPlayer::vStop "));
            vStopAlertTone();
         }
         else
         {
            m_u16AlertPromptPlayCount--;
            ETG_TRACE_USR3((" m_u16AlertPromptPlayCount: %d ",m_u16AlertPromptPlayCount));

            if (0x00 != m_u16AlertPromptPlayCount)
            {
               m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY"));

               vPlayAlertToneStatus();

               m_bAlertPlaying = TRUE;
            }
            else
            {
               ETG_TRACE_USR3((" Alert tone played for : %d times",m_u16AlertPromptPlayCount));
               ETG_TRACE_USR4((" Calling AlertToneGstPlayer::vStop"));

               vStopAlertTone();

               //vInit();
               m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_REL_ALERTTONE;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_REL_ALERTTONE"));
               if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
               {
                  ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE, \
                        vAudioCallBackACH);
               }
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
            }
         }
      }
      break;

      //While Playing Alert if user request for transfer call to vehicle release alert tone and transfer call
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE;
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackACH);
         }
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;


      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vHandleEventInCancelOutgoingCallOk();
         m_bEventConsumed = TRUE;
      }
      break;

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vHandleEventInAlertTonePause DEFAULT "));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRelAlertTone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInRelAlertTone(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInRelAlertTone u16EventId %d",u16EventId));
   switch (u16EventId) 
   {
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
      }
      break;
      //While releasing Alert tone if user request for transfer call to vehicle release alert tone and transfer call
      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE;

         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));

         if(FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackACH);
         }

         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vHandleEventInCancelOutgoingCallOk();
         m_bEventConsumed = TRUE;
      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vHandleEventInRelAlertTone DEFAULT "));
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInRoutingCallInHandset
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInRoutingCallInHandset(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInRoutingCallInHandset u16EventId %d",u16EventId));

   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         /* Release audio channel is complete */
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
         else
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
            ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK"));
         ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_ALERT_REQUEST_OK"));
         m_bEventConsumed = TRUE ;

         // Fix for RTC ticket- Bug 267485.
         // m_u8AudioChannel to be checked for FC_PHONE_AUDIOCHANNEL_ID_UNUSED
         // and then the vehicle audio status and m_u8AudioChannel need to be updated
         // since the SM might be waiting for PHONE channel Get response in the scenarios
         // like - "End and Accept the incoming call in iPhone (RTC ticket- Bug 267485)"
         if (FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK:
      case FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK:
      {
         ETG_TRACE_USR3((" EVENT : FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK"));
         ETG_TRACE_USR3(("  EVENT :OR  FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK"));
         m_bEventConsumed = TRUE ;
         /* TO DO:Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE:
      case FC_PHONE_SM_EVENT_TRANSFERCALLVEHICLE_REQUEST_OK:
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_IF_HANDSETCALL_TRANSFER_TOVEHICLE "));
         m_bEventConsumed = TRUE ;
         //Acquire Audio
         //Transfer Audio to Vehicle
         //Start corresponding SM (Dial/Accept)
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_ACTIVATE_VOICE"));
         if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK"));
         if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioReleaseOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
         else if(m_u16State_while_TransferAudio == FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE)
         {
            vHandleEventInAudioAcquisitionOnTransferAudioRequest(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;
      case FC_PHONE_SM_EVENT_HANGUPCALLALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_HANGUPCALLALL_OK"));
         m_bEventConsumed = TRUE ;
         m_bHangUpAllMethodStart = TRUE;
            FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
            if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
            {
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_ALL;
            }
            ETG_TRACE_USR4((" enTerminateType:: %d",enTerminateType));
            m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),enTerminateType);
      }
      break;

      case FC_PHONE_SM_EVENT_HANGUPCALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_HANGUPCALL_OK"));
         vHangUpCall();
      }
      break;


      case FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK :
      {
         ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_CANCELOUTGOINGCALL_OK "));
         vHandleEventInCancelOutgoingCallOk();
         m_bEventConsumed = TRUE;
      }
      break;

      case FC_PHONE_SM_EVENT_HOLDCALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_HOLDCALL_REQUEST "));
         /* Forward Hold Request to DBus */
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_HOLDCALL;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_HOLDCALL"));
         m_pDbusIf->bHoldCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      case FC_PHONE_SM_EVENT_SWAPCALL_OK :
      {
         ETG_TRACE_USR3((" FC_PHONE_SM_EVENT_SWAPCALL_OK :; calling dbus swapcall "));
         m_bSwapCallMethodStart = TRUE;
         m_bEventConsumed = TRUE ;
         m_pDbusIf->bSwapCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break ;

      case FC_PHONE_SM_EVENT_RESUMECALL_REQUEST:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_RESUMECALL_REQUEST "));
         /* Forward Resume Request to DBus */
         m_bEventConsumed = TRUE ;
         m_bResumeCallMethodStart = TRUE;
         m_pDbusIf->bResumeCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId));
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_SWAPCALL_ACK_OK :
      {
         ETG_TRACE_USR3(("   SENDING SWAPCALL MR to client"));
         m_bSwapCallMethodStart = FALSE;
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
      }
      break ;

      case FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_RESUMECALL_ACK_OK "));
         m_bResumeCallMethodStart = FALSE;
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
      }
      break;

      case FC_PHONE_SM_EVENT_SENDDTMF:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_SENDDTMF "));

         ETG_TRACE_USR4(("u16_oneTimeDTMFCalculation:: %d ",u16_oneTimeDTMFCalculation));

         if(0 == u16_oneTimeDTMFCalculation)
         {
            u16_oneTimeDTMFCalculation = 1;
            m_u16DTMFCharLength  = static_cast<tU16>(OSAL_u32StringLength(m_poCallInstance->DTMFChar));
            m_u16SentDtmfCounter  = 0;
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(TRUE);
            ETG_TRACE_USR4(("  m_u16DTMFCharLength :: %d ",m_u16DTMFCharLength));
         }


         tU8 u8DtmfValue = (tU8)m_poCallInstance->DTMFChar[m_u16SentDtmfCounter];
         m_pDbusIf->bSendDTMF(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),u8DtmfValue);
      }
      break;

      case FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK:
      {
         ETG_TRACE_USR3(("  EVENT ::FC_PHONE_SM_EVENT_DBUS_DTMF_ACK_OK "));

         //Update Method Status
         m_u16SentDtmfCounter++;

         if(m_u16SentDtmfCounter == m_u16DTMFCharLength)
         {
            ETG_TRACE_USR4(("  SENDING DTMF SUCCESS ,sending MR to client"));
            u16_oneTimeDTMFCalculation = 0;
            m_u16SentDtmfCounter  = 0;
            m_u16DTMFCharLength   = 0;
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         }
         else
         {
            ETG_TRACE_USR4((" Previous DTMF sent, processing for next  "));
            bProcessEvent(FC_PHONE_SM_EVENT_SENDDTMF);
         }
      }
      break;

#ifdef PHONE_WAITINGMODE
      case FC_PHONE_SM_EVENT_START_WAITING_MODE:
      {
         ETG_TRACE_USR3((" EVENT:: FC_PHONE_SM_EVENT_START_WAITING_MODE "));

         m_bEventConsumed = TRUE;

         if (FALSE ==
               ((fc_phone_tclApp::m_poMainAppInstance)->m_poPhoneAudioRouting->vTriggerPhoneAudioAllocation(
                     FC_PHONE_AUDIOCHANNEL_PHONEWAIT)))
         {
            ETG_TRACE_ERR(("Audio Route request posting failed!"));

            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_PHONEWAIT_SRC_ROUTING_FAILED);
         }
      }
      break;
#endif

      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vHandleEventInRoutingCallInHandset DEFAULT "));
         m_bEventConsumed = FALSE ;
      }
      break;
   }
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMACH::vHandleEventInAMInActivateVoiceCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInAMInActivateVoiceCall(tU16 u16EventId)
{

   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInAMInActivateVoiceCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_PHONE_REQUEST_OK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_OK"));
         /* Receiving audio channel is complete */
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
         ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_PHONE"));
         m_poCallInstance->m_bUsingVehicleAudio = TRUE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);

         //Transfer Audio
         m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_CONNECT_FROM_BT ;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_CONNECT_FROM_BT"));
         m_u8CallTransferDirection =  FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE;
         tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
         fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
         u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
         if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
         {
            ETG_TRACE_USR4(("EVENT : FC_PHONE_DBUS_SCO_CONN_DISCONNECTED"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
         }
         // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
         else if (u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
         {
            ETG_TRACE_USR4(("EVENT : FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
            m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
         }
      }
      break;

      case FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK:
      {
         ETG_TRACE_USR3(("  EVENT : FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK"));
         /* TO DO:Transfer the call to handset */
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET,m_poCallInstance);
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMACH::vHandleEventInAMInActivateVoiceCall DEFAULT "));
      }

      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInSMachBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInSMachBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInSMachBTInCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK :
      {
         if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED))
         {
            ETG_TRACE_USR4((" SCO Connection Established"));
            ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK ,START corresponding (dial/Accept) SM "));
            (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID+(m_poCallInstance->m_u16Id)));
            m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
            if(!m_poSMManager->bRestoreFromActiveCallInHandset(m_poCallInstance->m_u16Id))
            {
               m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
            }
         }
         else if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED))
         {
            ETG_TRACE_USR4((" SCO  Disconnection failed "));
            ETG_TRACE_USR3((" EVENT :: FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_NOK ,Active call in Handset SM is active"));
            /*Retry Audio Transfer */
            if(m_u32AudioTransferTimer < FC_PHONE_AUDIOTRANSFER_TIMEOUT)
            {
               ETG_TRACE_USR4((" Audio Transfer Fails Start Timer"));
               m_poTimer->s32Start(static_cast<tU16>(FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID+(m_poCallInstance->m_u16Id)),m_u32AudioTransferTimer,vCallInstanceTimerCallBack);
               m_u32AudioTransferTimer = m_u32AudioTransferTimer+FC_PHONE_AUDIOTRANSFER_TIMER_INTERVAL_INC;
               return;
            }
            else
            {
               ETG_TRACE_USR4((" Audio Transfer Fails Even after many trials"));
               m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
               //On failure of Audio transfer request to vehicle Phone channel is released
               if(m_poCallInstance->m_u8AudioChannel != FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
               {
                  ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackACH);
               }
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED ;
               ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO, m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE,m_poCallInstance);
               /*Release Audio Channel and Go to Routed State of this SM*/
               m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
               ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
            }

         }
      }
      break;

      default:
      {
         ETG_TRACE_USR4((" fc_phone_tclSMACH::vHandleEventInSMachBTInCall DEFAULT "));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vNewCallStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vNewCallStatus(const T_CallData* const prCallData,tU16 u16_callInstance)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vNewCallStatus"));

   (tVoid)u16_callInstance ;
   switch (m_u16State)
   {
      case FC_PHONE_SMACH_STATE_IDLE:
      case FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_GET_ALERTTONE:
      case FC_PHONE_SMACH_STATE_WAIT_FOR_ALERTTONE_PLAY:
      case FC_PHONE_SMACH_STATE_DISPLAY_ONLY_PROMPT:
      case FC_PHONE_SMACH_STATE_WAIT_FOR_AM_RESPONSE_REL_ALERTTONE:
      case FC_PHONE_SMACH_STATE_MAINTAINCALLSTATUS:
      case FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET:
      default:
         {
            if(((FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice)
               ||(FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD == m_poCallInstance->m_u16CallStatusNotice))
               && (PHONE_CALLSTATE_IDLE != prCallData->rCallStatus.u8CallState))
            {
               ETG_TRACE_USR4(("Callstatus ACTIVE | HELD "));
               // if call status received as ACTIVE while hangup in processing,, POST Hangup MR.
               if (m_bHangUpMethodStart || m_bHangUpAllMethodStart)
               {
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
                  ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));
                  m_bHangUpMethodStart = FALSE;
                  m_bHangUpAllMethodStart = FALSE;
               }
            }

            ETG_TRACE_USR4((" Default m_poCallInstance->m_u16CallStatusNotice = %d, prCallData->rCallStatus.u8CallState = %d     ",m_poCallInstance->m_u16CallStatusNotice,prCallData->rCallStatus.u8CallState));
            if(PHONE_CALLSTATE_IDLE == prCallData->rCallStatus.u8CallState)
            {
#ifdef PHONE_WAITINGMODE
               fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
               tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

               //Both calls/single call came to an end during waiting mode
               if ((FC_PHONE_WAITINGMODE_IDLE != enWaitingModeState) && (0 == prCallData->rCallStatus.u8CallTotal))
               {
                  poWaitingMode->bProcessEvent(FC_PHONE_WAITING_MODE_EVENT_END_OF_ACTIVE_CALLS);
               }
#endif
               m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
               m_bTimerRunning = FALSE;
               ETG_TRACE_USR3(("  m_bTimerRunning = FALSE"));
            }
            /* Send call status notification and act on Call Status accordingly */
            if((FC_PHONE_CALLINSTANCE_CALLSTATUS_IDLE != \
               m_poCallInstance->m_u16CallStatusNotice)
               &&( PHONE_CALLSTATE_IDLE ==
               prCallData->rCallStatus.u8CallState)
               )
            {
               ETG_TRACE_USR4((" outgoing call in handset ended :  Release call instance..."));
               /* Call got hung up at the receiver end,so delete the call Instance */

               if (m_bHangUpMethodStart)
               {
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
                  ETG_TRACE_USR4((" Set m_bHangUpMethodStart to FALSE"));
                  m_bHangUpMethodStart = FALSE;
               }

               if (m_bHangUpAllMethodStart)
               {
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
                  ETG_TRACE_USR4((" Set m_bHangUpAllMethodStart to FALSE"));
                  m_bHangUpAllMethodStart = FALSE;
               }
               // if cancel outgoing call in process and IDLE callstatus received
               if((m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO) 
                  ||(m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT))
               {
                  ETG_TRACE_USR4(("FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO|FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
                  //post cancel outgoing call MR
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_OK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
               }

               //If two active call in handset exist and one is ended from the other side, LC_Phone channel allocated for dialing should be released.

               if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
               {
                  ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
                  m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDummy);
               }
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
               m_poCallInstance->m_bUsingVehicleAudio = FALSE;
               ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
                  m_poCallInstance);



               vCancel() ;
               m_poCallInstance->vInit();
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
                  m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);
            }
            else if((FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING == m_poCallInstance->m_u16CallStatusNotice)
               &&((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState)
               || (PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState)))
            {
               //if cancel outgoing call in process and active received post MR 
               if((m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO)
                  ||(m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT))
               {
                  ETG_TRACE_USR4(("FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO     "));
                  //post cancel outgoing call MR
                  m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
                  m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);
                  // acquire audio channel if release while processing cancel outgoing call.
                  vProcessAudioSignal();
               }



               ETG_TRACE_USR4(("Dialling from Handset is active and starting time     "));
               m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
               ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               //Timer Start for Call Dialled from HandSet
               m_bTimerRunning = TRUE;
               ETG_TRACE_USR3(("  m_bTimerRunning = TRUE"));
               m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
               m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
               /* Else just maintain Call Instance */
            }
            else if(((FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice))
               &&(PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState))
            {
               //TODO when should i hv to stop playing alert and start timer???


               ETG_TRACE_USR4(("  User Walking In with Call in Handset..."));

               /* Fix for - PSARCCB-7343 - Sometimes when the user walks in with an active call, the callSatus
                * reported from the device do not have the number reported initially, but later the callstatus
                * is updated with the number correctly. In such cases copy call data is invoked to copy the
                * number appropriately
                */
               vCopyCallData(prCallData);

               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               //Timer Start for Call Dialled from HandSet
               if (FALSE == m_bTimerRunning)
               {
                  m_bTimerRunning = TRUE;
                  ETG_TRACE_USR3(("  m_bTimerRunning = TRUE"));
                  m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
                  m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
               }
               /* Else just maintain Call Instance */
            }/*If audio channel is denied in accept or dial SM restore to active call in handset SM start timer*/
            else if(((FC_PHONE_CALLINSTANCE_CALLSTATUS_RINGTONE == m_poCallInstance->m_u16CallStatusNotice))
               &&((PHONE_CALLSTATE_ACTIVE == prCallData->rCallStatus.u8CallState) || (PHONE_CALLSTATE_HELD == prCallData->rCallStatus.u8CallState)))
            {
               //TODO when should i hv to stop playing alert and start timer???
               ETG_TRACE_USR4(("  Audio is not acquired for incoming call and hence in Active call in handset SM"));
               vCopyCallData(prCallData);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
               m_bTimerRunning = TRUE;
               ETG_TRACE_USR3(("  m_bTimerRunning = TRUE"));
               m_poCallInstance->m_u16TimerId = FC_PHONE_CALLINSTANCE_TIMER_ID;
               m_poTimer->s32Start(m_poCallInstance->m_u16TimerId,FC_PHONE_ONE_SECOND,vCallInstanceTimerCallBack);
               /* Else just maintain Call Instance */
            }
            else
            {
               ETG_TRACE_USR4((" outgoing call in handset in Progress : Maintain call instance..."));
               /* Else just maintain Call Instance */
               vCopyCallData(prCallData);
               //update the client
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
                  m_poCallInstance);
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
            }
         }
         break;
}
}

/*******************************************************************************
 *
 * FUNCTION: vTimerCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vTimerCallBack(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("  fc_phone_tclSMACH::vTimerCallBack u16TimerId = %d",u16TimerId));
   if((FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID +(m_poCallInstance->m_u16Id)) == u16TimerId)
   {
      vTimeOutOnAudioTransfer();
   }
   else
   {
      if(u16TimerId == FC_PHONE_CALLINSTANCE_TIMER_ID)
      {
         vIncrementTimer(m_poCallInstance);
         ETG_TRACE_USR4(("fc_phone_tclSMACH: calling vSendStatus"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
      }
      else
      {
         ETG_TRACE_USR4(("Invalid timerID(Not CallInstance)"));    	
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAudioCallBack
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vAudioCallBack(tU16 u16AudioChannelId, tU16 u16RequestState)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vAudioCallBack "));
   switch (u16AudioChannelId)
   {
      case FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE:
      {
         ETG_TRACE_USR4(("  u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE "));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_INCOMING RING TONE_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_INCOMING RING TONE_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            bProcessEvent(FC_PHONE_SM_EVENT_INCOMINGCALL_REQUEST_NOK);
         }
      }
      break;
      case FC_PHONE_AUDIOCHANNEL_ALERTTONE:
      {
         ETG_TRACE_USR4(("  u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_ALERTTONE "));
         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            bProcessEvent(FC_PHONE_SM_EVENT_ALERT_REQUEST_NOK);
         }
      }
      break;

      case FC_PHONE_AUDIOCHANNEL_PHONE :
      {
         ETG_TRACE_USR4(("  u16AudioChannelId::FC_PHONE_AUDIOCHANNEL_PHONE "));

         if (FC_PHONE_AUDIOCHANNEL_GRANTED == u16RequestState)
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_GRANTED "));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);

         }
         else
         {
            ETG_TRACE_USR4(("  u16RequestState::FC_PHONE_AUDIOCHANNEL_DENIED_SUSPENDED "));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_NOK);
         }

      }
      break;
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vAudioCallBack DEFAULT "));
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vInit(tVoid)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vInit"));
   m_u16State = FC_PHONE_SMACH_STATE_IDLE;
   ETG_TRACE_USR2(("State Change INIT :FC_PHONE_SMACH_STATE_IDLE"));
   m_bTimerRunning = FALSE;
   ETG_TRACE_USR3(("  INIT: m_bTimerRunning = FALSE"));
}
/*******************************************************************************
 *
 * FUNCTION: vProcessOnDynamicDisconnect
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vProcessOnDynamicDisconnect(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vProcessOnDynamicDisconnect "));
   //release Audio channels

   switch(u16EventId)
   {

      case FC_PHONE_SM_EVENT_SLC_OFF:
      {
         //m_bUsingVehicleAudio false , and stop timer if running
         if(TRUE == m_bTimerRunning)
         {
            m_poTimer->s32Stop(m_poCallInstance->m_u16TimerId); // Bugfix for GMMY16-17241
            m_bTimerRunning = FALSE;
            ETG_TRACE_USR3(("  m_bTimerRunning = FALSE"));
         }
         if( FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel )
         {
            ETG_TRACE_USR3((" EVENT :: RELEASING Audio Channel "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackACH);
         }
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
         m_poCallInstance->m_bUsingVehicleAudio = FALSE;
         ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,\
               m_poCallInstance);
         vCancel();
         m_poCallInstance->vInit();
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,\
               m_poCallInstance);

         //send SLC status to client
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_SLC,m_poCallInstance);
         m_poSMManager->vSMFinished(m_poCallInstance->m_u16Id);


      }
      break;

      default:
      {
         ETG_TRACE_USR4(("IN DEFAULT : vProcessOnDynamicDisconnect: wrong u16EventId= %d ",u16EventId));
      }
      break;
   }
}
/*******************************************************************************
 *
 * FUNCTION: vTimeOutOnAudioTransfer
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vTimeOutOnAudioTransfer(tVoid)
{
   /*Retry Audio Transfer till it return success*/
   ETG_TRACE_USR4((" Entering Handle vTimeOutOnAudioTransfer"));
   (fc_phone_tclApp::m_poMainAppInstance)->m_poTimer->s32Stop(static_cast<tU16>(FC_PHONE_SMACH_AUDIOTRANSFER_TIMER_ID+(m_poCallInstance->m_u16Id)));
   if(m_u8CallTransferDirection ==  FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET)
   {
      ETG_TRACE_USR4(("Handle Call Transfer form Handsfree to handset"));
      if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_ESTABLISHED"));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
      else if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET);
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
      }
   }
   else if(m_u8CallTransferDirection == FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE)
   {
      ETG_TRACE_USR4(("Handle Call Transfer form Handset to handsdfree"));
      if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_DISCONNECTED"));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
      }
      // GMMY15-813 Cannot switch call to handsfree from radio if incoming call answered from Bluetooth phone
      else if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vGetAudioTransferStatus() == FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN)
      {
         ETG_TRACE_USR4(("FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN"));
         m_pDbusIf->bAudioTransfer(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE);
      }
      else
      {
         bProcessEvent(FC_PHONE_SM_EVENT_DBUS_TRANSFERCALL_ACK_OK);
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vProcessAudioSignal
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vProcessAudioSignal()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vProcessAudioSignal "));
   if (FALSE == m_bReleaseRingTone)
   {
      tU8 u8SCOConnectionStatus = FC_PHONE_DBUS_SCO_CONN_FAILED;
      fc_phone_tclClientHandler_BTSettings *p_clientHndler_bluetooth = (fc_phone_tclApp::m_poMainAppInstance)->m_poClientHandlerBTSettings;
      u8SCOConnectionStatus = p_clientHndler_bluetooth->vGetSCOConnectionStatus(const_cast<tChar *> (fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId))); //CMG3G-4847 - To solve Lint
      ETG_TRACE_USR4(("  fc_phone_tclSMACH::u8SCOConnectionStatus:Fixes for ANDRIOD Phone = %d ",u8SCOConnectionStatus));
      /* HfSetUpAudio Signal is triggered when call becomes alerting for Nexus */
      if (FC_PHONE_AUDIOCHANNEL_ALERTTONE == m_poCallInstance->m_u8AudioChannel)
      {
         ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
         m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_ALERTTONE,vAudioCallBackACH);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
         ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
      }
      if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_ESTABLISHED)
      {
         m_u16State_while_TransferAudio = FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_ACQUISITION_ON_TRANSFERCALLREQ_FROM_PHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED == m_poCallInstance->m_u8AudioChannel)
         {
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE;
            ETG_TRACE_USR3(("Requesting for audio ....to AVM ::AudioChannel = FC_PHONE_AUDIOCHANNEL_PHONE "));
            m_poAudioManager->s32GetRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
         }
         else if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
         {
            if(m_poAudioManager->bIsPhoneOrRingtoneChannelAcquistionIdle())
            {
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
      else if(u8SCOConnectionStatus == FC_PHONE_DBUS_SCO_CONN_DISCONNECTED)
      {
         m_u16State_while_TransferAudio = FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIO_RELEASE_ON_TRANSFERCALLREQ_FROM_PHONE;
         if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED != m_poCallInstance->m_u8AudioChannel)
         {
#ifdef PHONE_WAITINGMODE
            fc_phone_tclWaitingMode* poWaitingMode = fc_phone_tclWaitingMode::poGetInstance();
            tenFC_Phone_WaitingModeState enWaitingModeState = poWaitingMode->enGetWaitingModeState();

            //During waiting mode, phone audio source will not be in use (audio channel attributes has to be updated)
            if ((FC_PHONE_WAITINGMODE_ACTIVE == enWaitingModeState) && (FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel))
            {
               m_poAudioManager->vUpdateChannelAttributes(m_poCallInstance->m_u8AudioChannel, FC_PHONE_REQUESTTYPE_RELEASE);
               m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
               bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
            }
            else
            {
#endif
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackACH);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
#ifdef PHONE_WAITINGMODE
            }
#endif
         }
         else
         {
            bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
         }
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHangUpCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHangUpCall()
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMHangUpCall::vHangUpCall"));
   if (m_poCallInstance)
   {
      if (m_releaseCallInstanceID == m_poCallInstance->m_u16Id)
      {
         //gmmy15-11041- Hangup ACK when broadcasted was handled in callrouted state of both statemachines
         //in case if two activecallin handset statemachine exist.
         FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
         if ((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
         {
            ETG_TRACE_USR4(("Three way call supoorted in phone device!!!"));
            ETG_TRACE_USR4(("m_poCallInstance->m_u16CallStatusNotice is %d", m_poCallInstance->m_u16CallStatusNotice));
            ETG_TRACE_USR4(("The value of m_u16Count is %d", fc_phone_tclCallManager::m_u16Count));
            if (fc_phone_tclCallManager::m_u16Count > 1)
            {
               //GMMY15-7209-7198
               m_bEventConsumed = TRUE;
               m_bHangUpMethodStart = TRUE;
               m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_HANGUP_FROM_BT;
               ETG_TRACE_USR4(("State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_HANGUP_FROM_BT"));

#ifndef BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL // Disabled enhanced call control in BT_Stack
               // Use HfReleaseSpecCall when ENDTARGETCALL is supported by the device
               if (((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->getAgThreeWayCallSuppFeatures()) & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
               {
                  //GMMY16-25794 - donot use release active call here as if both calls are active, it would end both calls
                  fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager;
                  if (p_callManagerInstance)
                  {
                     //GMMY16-2960 - to find corresponding instance to be sent to DBus
                     tU16 u16DbusCallInstance = p_callManagerInstance->u16GetDbusCallInstanceFromCM(m_poCallInstance->m_u16Id);
                     ETG_TRACE_USR2(("u16DbusCallInstance %d", u16DbusCallInstance));
                     enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC;
                     ETG_TRACE_USR4((" enTerminateType :: %d", enTerminateType));
                     m_pDbusIf->bReleaseSpecCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId),
                           enTerminateType, (const unsigned char) u16DbusCallInstance);
                     //GMMY15-8821 Send the Status update only after the hangupcall is posted to the dbus
                     ETG_TRACE_USR4((" Sending call status as disconnecting "));
                     m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING;
                     m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
                     return;
                  }
                  else
                  {
                     ETG_TRACE_ERR(("The p_callManagerInstance is NULL."));
                  }
               }
#endif // Disabled enhanced call control in BT_Stack
               if ((FC_PHONE_CALLINSTANCE_CALLSTATUS_ACTIVE == m_poCallInstance->m_u16CallStatusNotice) \
                     || (FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING == m_poCallInstance->m_u16CallStatusNotice))
               {
                  ETG_TRACE_USR4(("Terminate active call"));
                  enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE;
               }
               else if (FC_PHONE_CALLINSTANCE_CALLSTATUS_ONHOLD == m_poCallInstance->m_u16CallStatusNotice)
               {
                  ETG_TRACE_USR4(("Terminate held call"));
                  enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_INACTIVE;
               }
               ETG_TRACE_USR4((" enTerminateType:: %d", enTerminateType));
               m_pDbusIf->bHangUpCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
               //GMMY15-8821 Send the Status update only after the hangupcall is posted to the dbus
               ETG_TRACE_USR4((" Sending call status as disconnecting "));
               m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DISCONNECTING;
               m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS, m_poCallInstance);
            }
         }
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleDbusError
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleDbusError(tU16 u16DbusAckType,tChar Code)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMACH::vHandleDbusError "));

   switch(u16DbusAckType)
   {
      case FC_PHONE_CB_FID_HOLDCALL:
      {
         if(m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_HOLDCALL)
         {
            ETG_TRACE_USR3((" FC_PHONE_CB_FID_HOLDCALL "));
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL,m_poCallInstance);
            m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
            ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         }
         else
         {
            ETG_TRACE_ERR((" Dial error is not serviced"));
         }
      }
      break;

      case FC_PHONE_CB_FID_RESUMECALL:
      {
         if(m_bResumeCallMethodStart == TRUE)
         {
            ETG_TRACE_USR3((" FC_PHONE_CB_FID_RESUMECALL "));
            m_bResumeCallMethodStart = FALSE;
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL,m_poCallInstance);
            m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
            ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         }
         else
         {
            ETG_TRACE_USR4((" Resume Call error is not serviced"));
         }
      }
      break;

      case FC_PHONE_CB_FID_SWAPCALL:
      {
         if(m_bSwapCallMethodStart == TRUE)
         {
            ETG_TRACE_USR3((" FC_PHONE_CB_FID_SWAPCALL "));
            m_bSwapCallMethodStart = FALSE;
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL,m_poCallInstance);
            m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
            ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         }
         else
         {
            ETG_TRACE_ERR((" Swap Call error is not serviced"));
         }
      }
      break;

      case FC_PHONE_CB_FID_HANGUPCALL:
      {
         if((m_bHangUpAllMethodStart == TRUE) || (m_bHangUpMethodStart == TRUE))
         {
            ETG_TRACE_USR3((" FC_PHONE_CB_FID_HANGUPCALL "));
            vAssignErrorCode(Code);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP,m_poCallInstance);
            m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
            ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
         }
         else
         {
            ETG_TRACE_USR4((" Hangup CALL Error is not serviced in this state"));
         }
      }
      break;

      //It comes here if and only if Audio transfer fails after some retry
      case FC_PHONE_CB_FID_AUDIOTRANSFER:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_AUDIOTRANSFER "));
         vAssignErrorCode(Code);
         if(FC_PHONE_AUDIOCHANNEL_PHONE == m_poCallInstance->m_u8AudioChannel)
         {
            ETG_TRACE_USR3(("Requesting for releasing ....to AVM "));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,FC_PHONE_AUDIOCHANNEL_PHONE,vAudioCallBackACH);
            m_poCallInstance->m_bUsingVehicleAudio = TRUE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = TRUE"));
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3((" AudioChannel =FC_PHONE_AUDIOCHANNEL_ID_UNUSED"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         }
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
      }
      break;

      case FC_PHONE_CB_FID_SENDDTMF:
      {
         //Targeted to SM hence dont care of States
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_SENDDTMF "));
         vAssignErrorCode(Code);
         (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->vSetDtmfStatus(FALSE);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF,m_poCallInstance);
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));
      }
      break;

      case FC_PHONE_CB_FID_TERMINATE:
      {
         ETG_TRACE_USR3((" FC_PHONE_CB_FID_TERMINATE "));
         vHandleErrorInTerminate(Code);
      }

      break;

      default:
      {
         ETG_TRACE_USR4((" This Event ID is not supported yet"));
         break;
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vAssignErrorCode
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vAssignErrorCode(tChar Code)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMACH::vAssignErrorCode "));
   switch(Code)
   {
      case FC_PHONE_DBUS_ERRORCODE_STATE_ERROR:
      {
         ETG_TRACE_USR3(("  FC_PHONE_DBUS_ERRORCODE_STATE_ERROR"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACK_STATE_ERROR;
      }
      break;
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED:
      case FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:
      {
         ETG_TRACE_USR3((" FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_ALLOWED: FC_PHONE_DBUS_ERRORCODE_OPERATION_NOT_SUPPORTED:"));
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOTAVAILABLE;
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" IN DEFAULT This Error Code [0x%x] is not supported yet",Code) );
         m_poCallInstance->m_AckError = FC_PHONE_CALLINSTANCE_ACKERROR_NOK;
      }
      break;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vStopAlertTone
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vStopAlertTone()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMACH::vStopAlertTone "));
   if(m_bAlertPlaying == TRUE)
   {
      ETG_TRACE_USR4((" Stoping Alert Tone Play"));

      // TODO: The StopAlertTone interface to be called
      //FC_Phone_PlayerEngine *m_AlertTonePlayer = (fc_phone_tclApp::m_poMainAppInstance)->m_poAlertTonePlayer;
      //m_AlertTonePlayer->StopAlertTone();

      m_bAlertPlaying = FALSE;
   }
}

/*******************************************************************************
 *
 * FUNCTION: vStopAlertToneFromSaOn
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vStopAlertToneFromSaOn()
{
   ETG_TRACE_USR4((" fc_phone_tclSMACH::vStopAlertToneFromSaOn"));

   // TODO: The StopAlertTone interface to be called
   //FC_Phone_PlayerEngine *m_AlertTonePlayer = (fc_phone_tclApp::m_poMainAppInstance)->m_poAlertTonePlayer;
   //m_AlertTonePlayer->StopAlertTone();

   m_bAlertPlayingFromSaOn = FALSE;
}

/*******************************************************************************
 *
 * FUNCTION: vPlayAlertToneStatus()
 *
 * DESCRIPTION: Repeat alert tone
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vPlayAlertToneStatus()
{
   ETG_TRACE_USR4((" fc_phone_tclSMACH::vPlayAlertToneStatus: FINISHEDSTATE - repeat alerttone"));

   // TODO: The PlayAlertTone interface to be called.
   //FC_Phone_PlayerEngine *m_AlertTonePlayer = (fc_phone_tclApp::m_poMainAppInstance)->m_poAlertTonePlayer;
   //m_AlertTonePlayer->PlayAlertTone(ALERTTONE_FILE_PATH);
}

/*******************************************************************************
 *
 * FUNCTION: vSetDtmfLength
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vSetDtmfLength(tU16 u16DtmfLength)
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMACH::vSetDtmfLength "));
   m_u16DTMFCharLength = u16DtmfLength;
}


/*******************************************************************************
 *
 * FUNCTION: vTerminateOutgoingCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vTerminateOutgoingCall()
{
   ETG_TRACE_USR4(("Entering fc_phone_tclSMACH::vTerminateOutgoingCall "));

   FCPhoneDbusClient_TerminateType_t enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_SINGLECALL;
   if(m_poCallInstance)
   {
      if (fc_phone_tclCallManager::m_u16Count > 1)
      {
         ETG_TRACE_USR4(("Terminating ACTIVE Call"));
         //send property status to client
         m_poCallInstance->m_u16CallStatusNotice = FC_PHONE_CALLINSTANCE_CALLSTATUS_DIALING;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_u16State =   FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT ;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
#ifndef BLUETOOTH_DISABLE_ENHANCED_CALL_CTRL
         //GMMY15-9890 To cancel the second outgoing call using HfReleaseSpecCall instead of HfReleaseActiveCall when a call has been already established
         if(((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->getAgThreeWayCallSuppFeatures()) & FC_PHONE_ENHANCECALLCTRL_ENDTARGETCALL_MASK)
         {
            fc_phone_tclCallManager *p_callManagerInstance = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->m_poCallManager;
            if(p_callManagerInstance)
            {
               tU16 u16DbusCallInstance ;
               u16DbusCallInstance = p_callManagerInstance->u16GetDbusCallInstanceFromCM(m_poCallInstance->m_u16Id);
               enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_THREEWAYCALL_SPECIFIC_CANCEL_OUTGOING;
               ETG_TRACE_USR4((" enTerminateType :; %d",enTerminateType));
               m_pDbusIf->bReleaseSpecCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType, (const unsigned char)u16DbusCallInstance);
            }
            else
            {
               ETG_TRACE_ERR(("The p_callManagerInstance is NULL. Hence not terminating the call."));
            }
         }
         else
#endif
         {
            if((fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->bIsAgThreeWayCallSupported())
            {
            enTerminateType = FC_PHONE_DBUS_TERMINATETYPE_MULTIPLECALL_ACTIVE ;
               ETG_TRACE_USR4((" enTerminateType :; %d",enTerminateType));
            }
            m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
         }
      }
      /*Ending a single call*/
      else if (fc_phone_tclCallManager::m_u16Count == 1)
      {
         //send property status to client
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);
         m_u16State =   FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT ;
         ETG_TRACE_USR2(("State Change:FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT"));
         ETG_TRACE_USR4(("Terminating Single Call"));
         m_pDbusIf->bTerminateCall(fc_phone_tclDeviceList::getInstance()->u8GetBDAddressFromDeviceList(m_poCallInstance->m_u8BDAddressId), enTerminateType);
      }
      else
      {
         ETG_TRACE_ERR(("Call Count doesn't Match"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCancelOutgoingBTInCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInTerminateBTInCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMDial::vHandleEventInTerminateBTInCall %d",u16EventId));


   switch (u16EventId)
   {

      case FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK:
      {

         ETG_TRACE_USR3(("  EVENT : OR FC_PHONE_SM_EVENT_DBUS_TERMINATE_ACK_OK"));
         //to stop timer if active
         //send method result
         m_u16State = FC_PHONE_SMACH_STATE_DISCONNECTED_FROM_BT;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,\
               m_poCallInstance);
      }
      break;

      default:
      {
         ETG_TRACE_ERR(("  ERROR : fc_phone_tclSMDial::vHandleEventInTerminateBTInCall:: DEFAULT  u16EventId %d",u16EventId));
      }
      break;
   }




}



/*******************************************************************************
 *
 * FUNCTION: vHandleEventInCancelOutgoingCallOk
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInCancelOutgoingCallOk()
{
   ETG_TRACE_USR3((" EVENT :: vHandleEventInCancelOutgoingCallOk "));

   //update the state
   m_u16State = FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO ;
   ETG_TRACE_USR2((" State Change: FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO "));

   if( (m_poCallInstance)&& (m_poAudioManager))
   {
      //release ringtone/Alert audio channel, if in use
      if(FC_PHONE_AUDIOCHANNEL_ID_UNUSED !=  m_poCallInstance->m_u8AudioChannel )
      {
         ETG_TRACE_USR3((" Releasing  Audio m_poCallInstance "));
         m_poAudioManager->s32ReleaseRequest( m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackACH);
         m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
      }
      else
      {
         //No audio channel engaged, so going to next step by faking FC_PHONE_SM_EVENT_PHONE_REQUEST_OK
         bProcessEvent(FC_PHONE_SM_EVENT_PHONE_REQUEST_OK);
      }
   }

   //do thing for cancel outgoing call
}


/*******************************************************************************
 *
 * FUNCTION: vHandleErrorInTerminate
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleErrorInTerminate(tChar Code)
{
   ETG_TRACE_USR2((" fc_phone_tclSMACH::vHandleErrorInTerminate Entered m_u16State = %d ",m_u16State));
   //Send Cancel outgoing call Method result eventhough receiving error for
   //terminate request from Phone device(Example: Blackberry) GMMY15-6691
   if(m_poCallInstance)
   {
      if((m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT) || (m_u16State == FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO))
      {
         ETG_TRACE_USR2((" FC_PHONE_CB_FID_TERMINATE "));

         vAssignErrorCode(Code);
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL,m_poCallInstance);

         tU16 u16CallState = (fc_phone_tclApp::m_poMainAppInstance)->m_poTelephone->u16GetCallStateFromCallInstID(m_poCallInstance->m_u16Id);
         ETG_TRACE_USR3(("u16CallState: %u", ETG_ENUM(TR_CALLSTATUS,u16CallState)));
         ETG_TRACE_USR3(("m_poCallInstance->m_u16CallStatusNotice: %u", ETG_ENUM(TR_CALLSTATUS, m_poCallInstance->m_u16CallStatusNotice)));
         m_poCallInstance->m_u16CallStatusNotice = u16CallState;
         m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_CALLSTATUS,m_poCallInstance);

         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         ETG_TRACE_USR2(("State Change: FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET"));

      }
      else
      {
         ETG_TRACE_USR4((" Terminate Call is not serviced in Other States"));
      }
   }
}

/* GMMY15-9114 FC_Phone : logiscope code complexity value >= 20 */
tVoid fc_phone_tclSMACH::vProcessEventHelper(tU16 u16EventId)
{
   ETG_TRACE_USR4(("fc_phone_tclSMACH::vProcessEventHelper called"));

   switch (m_u16State)
   {

      case FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIOTRANSFER_OR_AUDIOCHANNELRELEASE:
      {
         ETG_TRACE_USR2((" STATE :FC_PHONE_SMACH_STATE_WAIT_FOR_AUDIOTRANSFER_OR_AUDIOCHANNELRELEASE "));
         vHandleEventWaitForAudioTransferAudioChannelReleaseOnHandsetCall(u16EventId);
      }
      break;

      case FC_PHONE_SMACH_STATE_WAIT_FOR_HOLDCALL:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL :: "
               "FC_PHONE_SMTRANSFERCALL_STATE_WAIT_FOR_HOLDCALL "));
         vHandleEventInHoldCall(u16EventId);
      }
      break;

      //gmmy15-5984{
      case FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACH_STATE_WAIT_FOR_CANCELOUTGOINGCALL_AND_AUDIO "));
         vHandleEventInCancelOutgoingCallAndAudio(u16EventId);
      }
      break;

      case FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT:
      {
         ETG_TRACE_USR2((" STATE :: FC_PHONE_SMACH_STATE_WAIT_FOR_DISCONNECT_FROM_BT "));
         vHandleEventInTerminateBTInCall(u16EventId);
      }
      break;

      //gmmy15-5984}
      default:
      {
         ETG_TRACE_USR4(("fc_phone_tclSMACH::vProcessEventHelper DEFAULT "));
      }
   }
}


/*******************************************************************************
 *
 * FUNCTION: vHandleEventInHangUpCall
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid fc_phone_tclSMACH::vHandleEventInHangUpCall(tU16 u16EventId)
{
   ETG_TRACE_USR4((" Entering fc_phone_tclSMACH::vHandleEventInHangUpCall u16EventId %d",u16EventId));
   switch (u16EventId)
   {
      case FC_PHONE_SM_EVENT_DBUS_HANGUPCALL_ACK_OK:
      {
         ETG_TRACE_USR4((" FC_PHONE_SM_EVENT_DBUS_HANGUPCALL_ACK_OK"));
         m_u16State = FC_PHONE_SMACH_STATE_ROUTING_CALL_INHANDSET;
         if(m_poCallInstance->m_u8AudioChannel != FC_PHONE_AUDIOCHANNEL_ID_UNUSED)
         {
            ETG_TRACE_USR3(("   Release request to AVManager ..."));
            m_poAudioManager->s32ReleaseRequest(m_poCallInstance->m_u16Id,m_poCallInstance->m_u8AudioChannel,vAudioCallBackDummy);
            m_poCallInstance->m_u8AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED;
            ETG_TRACE_USR3(("  AudioChannel = FC_PHONE_AUDIOCHANNEL_ID_UNUSED "));
            m_poCallInstance->m_bUsingVehicleAudio = FALSE;
            ETG_TRACE_USR3(("  UsingVehicleAudio = FALSE"));
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO,m_poCallInstance);
            m_poSMManager->vSendStatus(FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET,m_poCallInstance);
         }
      }
      break;
      default:
      {
         ETG_TRACE_USR4((" vHandleEventInHangUpCall: In Default"));
      }
      break;
   }
}
