/*******************************************************************************
 *
 * FILE:          FC_Phone_EcnrIfCallbacks.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../../Configuration/Phone/Phone_FeatureConfig.h"

#include "../FC_Phone_service_Telephone.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_SERVICE_TELEPHONE
#include "trcGenProj/Header/FC_Phone_EcnrIfCallbacks.cpp.trc.h"
#endif

#define FC_PHONE_S_IMPORT_INTERFACE_MSG
#include "FC_Phone_if.h"

#include "FC_Phone_EcnrInterface.h"

/* Declare all the functions interface here*/

//tVoid ecnrSetWidebandCB(tBool bCallBackStatus);
tVoid ecnrStartAudioCB(tBool bCallBackStatus);
tVoid ecnrStopAudioCB(tBool bCallBackStatus);


static T_CCA_ECNR_If rCCA_EcnrIf =
{
      //     ecnrSetWidebandCB,
      ecnrStartAudioCB,
      ecnrStopAudioCB

};


/*******************************************************************************
 *
 * FUNCTION: tVoid ecnrStartAudioCB
 *
 * DESCRIPTION: This callback is called to notify ecnr start audio
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid ecnrStartAudioCB(tBool bCallBackStatus)
{
   ETG_TRACE_USR4((" ***** In ecnrStartAudioCB *****      "));
   vSendLoopBackMessage(bCallBackStatus,FC_PHONE_CB_FID_ECNR_STARTAUDIO);
}

/*******************************************************************************
 *
 * FUNCTION: tVoid ecnrStopAudioCB
 *
 * DESCRIPTION: This callback is called to notify ecnr stop audio
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid ecnrStopAudioCB(tBool bCallBackStatus)
{
   ETG_TRACE_USR4((" ***** In ecnrStopAudioCB *****      "));
   vSendLoopBackMessage(bCallBackStatus,FC_PHONE_CB_FID_ECNR_STOPAUDIO);
}

/*******************************************************************************
 *
 * FUNCTION: tVoid pGetCCAEcnrIf
 *
 * DESCRIPTION: Exposes ecnr interfaces
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
T_CCA_ECNR_If *pGetCCAEcnrIf(tVoid)
{
   ETG_TRACE_USR4((" pGetCCAEcnrIf "));
   return(&rCCA_EcnrIf);
}

/*******************************************************************************
 *
 * FUNCTION: tVoid vSendLoopBackMessage
 *
 * DESCRIPTION: Send loopback message.
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid vSendLoopBackMessage(tBool bCallBackStatus, tU32 u16FunctionID)
{

   ETG_TRACE_USR4((" vSendLoopBackMessage "));

   fc_phone_tclService_Telephone* poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if(poTelService)
   {
      if (TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         LB_data.ecnrCallBackStatus.bCallBackStatus = bCallBackStatus ;
         LB_data.u16FunctionID = u16FunctionID;
         poTelService->push_back_LB_data(LB_data);

         poTelService->vPrepareLoopBackMsg(u16FunctionID);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: Loopback message sending failed "));
      }
   }
}
