/*******************************************************************************
 *
 * FILE:          FC_Phone_DBusInterface.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Interface definition for DBusClient_CallBack.
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/
#ifndef _FC_PHONE_DBUSINTERFACE_H_
#define _FC_PHONE_DBUSINTERFACE_H_

#include "../FC_Phone_main.h"
#include "../WorkQueue/FC_Phone_WorkQueue.h"

/***************************************************
General Defines 
 ***************************************************/
#define PHONE_CELLDEVICENAME_LENGTH 255
#define PHONE_BDADRESS_LENGTH       255
#define PHONE_CALLNUMBER_LENGTH     255
#define PHONE_CALLNAME_LENGTH     255
#define PHONE_VOICEMAILNUMBER_LENGTH 255
#define PHONE_TELEPHONENUMBER_LENGTH 255
#define PHONE_NWOPERATORNAME_LENGTH  255

#define PHONE_DIALING_PHONE_NUMBER   26
#define PHONE_DIALING_PHONE_NUMBER_EVO   81
#define PHONE_DEV_ADDRESS            100
#define PHONE_TEMP_DEV_ADDRESS       25
#define PHONE_CONNMAP_DEV_ADDRESS   25
#define PHONE_OBJECT_PATH            100
#define PHONE_SLCOFF_BDADDRESS       25
#define PHONE_SM_BDADDRESS           25
#define PHONE_FORMAT_BDADDRESS       12

/* The values taken by u8CallHandle in T_CallStatus */
#define PHONE_CALLSTATUS_CALLHANDLE_1 0
#define PHONE_CALLSTATUS_CALLHANDLE_2 1

/* The values taken by u8CallDirection in T_CallStatus */
#define PHONE_CALLDIRECTION_UNKNOWN   0
#define PHONE_CALLDIRECTION_INCOMING  2
#define PHONE_CALLDIRECTION_OUTGOING 1

/* The values taken by u8CallState in T_CallStatus */
#define PHONE_CALLSTATE_IDLE                0
#define PHONE_CALLSTATE_ACTIVE              1
#define PHONE_CALLSTATE_HELD                2
#define PHONE_CALLSTATE_DIALING             3
#define PHONE_CALLSTATE_ALERTING            4
#define PHONE_CALLSTATE_INCOMING            5
#define PHONE_CALLSTATE_WAITING             6
#define PHONE_CALLSTATE_RESPONSE_AND_HOLD   7
#define PHONE_CALLSTATE_UNKNOWN             8

/* The values taken by u8CallMode in T_CallStatus */
#define PHONE_CALLMODE_UNKNOWN              0
#define PHONE_CALLSTATE_VOICE               1 
#define PHONE_CALLSTATE_DATA                2
#define PHONE_CALLSTATE_FAX                 3

/* The values taken by u8CallType in T_CallStatus */
#define PHONE_CALLMODE_UNKNOWN              0
#define PHONE_CALLMODE_INTERNATIONAL        1
#define PHONE_CALLMODE_NATIONAL             2
#define PHONE_CALLMODE_NETWORK              3
#define PHONE_CALLMODE_DEDICATED            4 

#define FC_PHONE_DBUS_STATUS_SUCCESS    0

#define FC_PHONE_DBUS_SCO_CONN_STATUS_UNKNOWN 0xFF
#define FC_PHONE_DBUS_SCO_CONN_ESTABLISHED 0
#define FC_PHONE_DBUS_SCO_CONN_DISCONNECTED 1
#define FC_PHONE_DBUS_SCO_CONN_FAILED 2
#define FC_PHONE_PROCESS_AUDIOSIGNAL_TIMEOUT 0
#define FC_PHONE_DBUS_SCO_CONN_CODE 0xFF

//Added four Function ID in this enum #ifdef PHONE_SIRI
enum FCPhone_FunctionID
{
   FC_PHONE_CB_FID_BASE = 100,
   FC_PHONE_CB_FID_INCOMINGCALL,
   FC_PHONE_CB_FID_REJECTCALL,
   FC_PHONE_CB_FID_ACCEPTCALL,
   FC_PHONE_CB_FID_CALLSTATUS,
   FC_PHONE_CB_FID_CALLSTATUS_CONSOLIDATED,
   FC_PHONE_CB_FID_PHONESTATUS,
   FC_PHONE_CB_FID_HANGUPCALL,
   FC_PHONE_CB_FID_HOLDCALL,
   FC_PHONE_CB_FID_DIAL,
   FC_PHONE_CB_FID_TERMINATE,
   FC_PHONE_CB_FID_SLCSTATUS,
   FC_PHONE_CB_FID_DEVICENAME,
   FC_PHONE_CB_FID_AUDIOTRANSFER,
   FC_PHONE_CB_FID_QUERYTELEPHONENUMBER,
   FC_PHONE_CB_FID_SENDDTMF,
   FC_PHONE_CB_FID_RESUMECALL,
   FC_PHONE_CB_FID_HOLDINCOMINGCALL,
   FC_PHONE_CB_FID_SWAPCALL,
   FC_PHONE_CB_FID_CONFCALL,
   FC_PHONE_CB_FID_SPLITCALL,
   FC_PHONE_CB_FID_SCOCONNECTIONSTATUS,
   FC_PHONE_CB_FID_PHONE_DEVICE_CALL_STATUS,
   FC_PHONE_CB_FID_DELAYED_PROCESS_AUDIOSIGNAL,
   FC_PHONE_CB_FID_HANGUP_ONSTARCALL,
   FC_PHONE_CB_FID_AUDIOMANAGER,
   FC_PHONE_CB_FID_VOICERECOGNITION_CFM,
   FC_PHONE_CB_FID_VOICERECOGNITION_IND,
   FC_PHONE_CB_FID_VOICERECOGNITION_ONSTAR,
   FC_PHONE_CB_FID_ACQUIRETELEPHONENUMBER,
   FC_PHONE_CB_FID_VOICERECOGNITION_STATUS,
   FC_PHONE_CB_FID_SIRI_NR_IND,
   FC_PHONE_CB_FID_SIRISTATUS_IND,
   //Bugfix for GMMY16-12538: [CT]Inconsistencies with Siri
#ifdef PHONE_SIRI
   FC_PHONE_CB_FID_SIRISTATUSREQ_RETRY,
   FC_PHONE_CB_FID_SIRINRSTATUSREQ_RETRY,
#endif //PHONE_SIRI
   FC_PHONE_CB_FID_NRSTATUS,
   FC_PHONE_CB_FID_PNPINFO_IND,
   FC_PHONE_CB_FID_WIDEBANDSPEECHSETUP,
   FC_PHONE_CB_FID_ECNR_STARTAUDIO,
   FC_PHONE_CB_FID_ECNR_STOPAUDIO,
   FC_PHONE_CB_FID_ECNR_MUTESWITCH,
   FC_PHONE_LB_FROM_WQ_FOR_QUEUED_METHODS,
   FC_PHONE_LB_FROM_WQ_FOR_FAILED_METHODS,
   FC_PHONE_LB_FROM_ARL_FOR_SA_ON,
   FC_PHONE_LB_FID_AUDIOTRANSFER_TO_HS,
   FC_PHONE_LB_FID_AUDIOTRANSFER_TO_HF,
   FC_PHONE_LB_FROM_ARL_FOR_SA_PAUSE,
   FC_PHONE_CB_FID_TIMER,
   FC_PHONE_CB_FID_NAME_APPEARED,
#ifdef PHONE_WAITINGMODE
   FC_PHONE_CB_FID_PHONEWAIT_SRC_ON,
   FC_PHONE_CB_FID_PHONEWAIT_SRC_OFF,
#endif
   FC_PHONE_LB_FID_SCO_CONNECT_REQUEST,
   FC_PHONE_CB_FID_END
};

typedef struct _T_CallbackStatus{
   tBool bCallBackStatus;
}T_CallbackStatus;

typedef struct _T_CallStatus
{
   tU8 u8CallHandle;
   tU8 u8CallTotal;
   tU8 u8CallDirection;
   tU8 u8CallState;
   tU8 u8CallMode;
   tChar achCallNumber[PHONE_CALLNUMBER_LENGTH];
   tU8 u8CallType;
}T_CallStatus;


typedef struct _T_PhoneStatus
{
   tU8 u8PhoneService;
   tU8 u8PhoneSignal;
   tU8 u8PhoneRoaming;
   tU8 u8PhoneBattery;
   tU8 u8PhoneAudiopath;
   tChar achPhoneOperatorName[PHONE_CALLNUMBER_LENGTH];
   tU32 u32PhoneSuppFeature;
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
   tU8 u8AgThreeWayCallSuppFeatures;
}T_PhoneStatus;

#ifdef PHONE_SIRI
typedef struct _T_SiriStatus
{
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
   tU8 m_u8SiriStatus;// Can be  0 (or) 1 (or) 2
}T_SiriStatus; 

typedef struct _T_NrStatus
{
   tU8 Activation;
}T_NrStatus;

typedef struct _T_EfmStatus
{
   tU8 Activation;
}T_EfmStatus;

#endif

typedef struct _T_SCOConnectionStatus
{
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
   tU8 SCOConnectionStatus;
   tU8 Codec;
}T_SCOConnectionStatus;

typedef struct _T_VoiceRecIND
{
   tU8 Activation;
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
}T_VoiceRecInd;

//Dip
typedef struct _T_PnpInfoIND
{
   tU16 m_usSpecificationID;
   tU16 m_usVendorID;
   tU16 m_usProductID;
   tU16 m_usVersion;
   tU8 m_ucPrimaryRecord;
   tU16 m_usVendorIDSource;
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
}T_PnpInfoInd;

#ifdef PHONE_SIRI
typedef struct _T_SiriNRStatusInd
{
   tU8 m_u8SiriNrStatus;
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
}T_SiriNRStatusInd;
#endif //SIRI_FEATURE_ENABLE

typedef struct Async_method_data
{
   tChar Status;
   tChar Code;
   tChar State;
   tChar device_name[PHONE_CELLDEVICENAME_LENGTH];
   tChar voiceMailNumber[PHONE_VOICEMAILNUMBER_LENGTH];
   tChar TelephoneNumber[PHONE_TELEPHONENUMBER_LENGTH];
   tChar SubcriberNumber[PHONE_TELEPHONENUMBER_LENGTH];
   tU8 Service;

}Async_method_data_t;

typedef struct _T_CallData
{
   tChar achCellDeviceName[PHONE_CELLDEVICENAME_LENGTH];
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
   T_CallStatus rCallStatus;
   Async_method_data_t MR_Data;
   tChar Service;
   tBool Status_ConnComp;
   tChar ConnLosstype;
   tU8 u8RingTone; /*palani: for incomingcallevent*/
   tBool b_SLC_status ;
}T_CallData;

typedef struct 
{
   tU16 u16AudioReqID;  //LB data from Audio Mgr
   tU16 u16AudioChannelId; //LB data from Audio Mgr
   tU16 u16RequestState; //LB data from Audio Mgr
   tVoid (*AudioCallBack)(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState);
}T_AudioMgrInfo;
typedef struct 
{
   tU16 u16TimerId; // LB data from OSAL Timer
}T_TimerInfo;
typedef struct
{
   T_CallData    Call_data;
   T_CallData    Call_data_Consolidated[FC_PHONE_MAX_CALLINSTANCES];
   T_PhoneStatus phone_status;
   T_SCOConnectionStatus SCOConnectionStatus;
   T_VoiceRecInd VoiceRecInd;
   T_PnpInfoInd PnpInfoInd; //Dip

#ifdef PHONE_SIRI
   T_SiriNRStatusInd NRStatusInd;
#endif //SIRI_FEATURE_ENABLE

   //tBool         bSLCStatus ;
   T_AudioMgrInfo AudioMgr_Data;
   tU32 u16FunctionID;
#ifdef PHONE_SIRI
   T_SiriStatus siri_status;
   tU16 u16VehicleMovementState;
#endif
   T_CallbackStatus ecnrCallBackStatus;
   T_TimerInfo Timer_CB;
   Job job;
}LoopBackData ;
// Last four function pointer added in theis structure for Siri #if PHONE_SIRI
typedef struct _T_CCA_Dbus_If
{
   tVoid (*vIncomingCall)(const T_CallData* const prCallData);
   tVoid (*vCallStatus)(const T_CallData* const prCallData);
   tVoid (*vCallStatusConsolidated)(const T_CallData* prCallData);
   tVoid (*vPhoneStatus)(const T_PhoneStatus* const prPhoneData);
   tVoid (*vSLCStatus)(const T_CallData* const prCallData);
   tVoid (*vAcceptCB)(const T_CallData* const prCallData);
   tVoid (*vHoldCB)(const T_CallData* const prCallData);
   tVoid (*vRejectCB)(const T_CallData* const prCallData);
   tVoid (*vHangupCB)(const T_CallData* const prCallData);
   tVoid (*vGetDeviceNameCB)(const T_CallData* const prCallData);
   tVoid (*vDialCB)(const T_CallData* const prCallData);
   tVoid (*vTerminateCB)(const T_CallData* const prCallData);
   tVoid (*vAudioTransferCB)(const T_CallData* const prCallData);
   tVoid (*vQueryTelephoneNumber)(const T_CallData* const prCallData);
   tVoid (*vSendDTMFCB)(const T_CallData* const prCallData);
   tVoid (*vResumeCallCB)(const T_CallData* const prCallData);
   tVoid (*vHoldIncomingCB)(const T_CallData* const prCallData);
   tVoid (*vSwapCallCB)(const T_CallData* const prCallData);
   tVoid (*vConfCallCB)(const T_CallData* const prCallData);
   tVoid (*vSplitCallCB)(const T_CallData* const prCallData);
   tVoid (*vSCOConnectionStatus)(const T_SCOConnectionStatus* const prCallData);

   tVoid (*vVoiceRecognitionCB)(const T_CallData* const prCallData);
   tVoid (*vVoiceRecognitionInd)(const T_VoiceRecInd* const prCallData);
   tVoid (*vAcquireTelephoneNumberCB)(const T_CallData* const prCallData);
   tVoid (*vPnpInfoInd)(const T_PnpInfoInd* const prCallData); //Dip
#ifdef PHONE_SIRI
   tVoid (*vSiriNRStatusInd)(const T_SiriNRStatusInd* const prCallData);
   tVoid (*vSiriStatusInd)(const T_SiriStatus * const prCallData);
   tVoid (*vSiriNrStatus)(const T_SiriNRStatusInd* const prCallData);
   tVoid (*vSiriStatusReqRetry)(const T_SiriStatus* const prCallData); //Bugfix for GMMY16-12538
   tVoid (*vSiriNrStatusReqRetry)(const T_SiriNRStatusInd* const prCallData); //Bugfix for GMMY16-12538
#endif
   tVoid (*vWideBandAudioSetup)(const T_SCOConnectionStatus* const prCallData);
   tVoid (*vNameAppearedCB)(const T_CallData* const prCallData);
   tVoid (*vSCOConnectRequest)(const T_CallData* const prCallData);
}T_CCA_Dbus_If;

T_CCA_Dbus_If *pGetCCAPhoneDBusIf(tVoid);
tVoid vNotify_Status(const T_CallData* const prCallData,tU32 u16FuncId);
tVoid vNotify_Status_Consolidated(const T_CallData* prCallData,tU32 u16FuncId);

#endif
