/*******************************************************************************
 *
 * FILE:          FC_Phone_DBusIfCallbacks.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../FC_Phone_main.h"
#include "../FC_Phone_service_Telephone.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_SERVICE_TELEPHONE
#include "trcGenProj/Header/FC_Phone_DBusIfCallbacks.cpp.trc.h"
#endif

#define FC_PHONE_S_IMPORT_INTERFACE_MSG
#include "FC_Phone_if.h"

#include "FC_Phone_DBusInterface.h"

/* Declare all the functions interface here*/
static tVoid FcPhoneDbusCallback_vIncomingCall(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vCallStatus(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vCallStatusConsolidated(const T_CallData* prCallData);
static tVoid FcPhoneDbusCallback_vPhoneStatus(const T_PhoneStatus* const prCallData);
static tVoid FcPhoneDbusCallback_vSLCStatus(const T_CallData* const prCallData);
//tVoid FcPhoneDbusCallback_vDisconnection(const T_CallData* const prCallData);
//tVoid FcPhoneDbusCallback_vConnectionComplete(const T_CallData* const prCallData);

static tVoid FcPhoneDbusCallback_vAcceptCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vRejectCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vHangupCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vHoldCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vDialCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vGetDeviceNameCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vTerminateCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vAudioTransferCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vQueryTelephoneNumberCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vSendDTMFCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vResumeCallCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vHoldIncomingCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vSwapCallCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vConfCallCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vSplitCallCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vSCOConnectionStatus(const T_SCOConnectionStatus* const prCallData);
static tVoid FcPhoneDbusCallback_vVoiceRecognitionCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vVoiceRecognitionInd(const T_VoiceRecInd* const prCallData);
static tVoid FcPhoneDbusCallback_vAcquireTelephoneNumberCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vPnpInfoInd(const T_PnpInfoInd* const prCallData); //Dip
#ifdef PHONE_SIRI
static tVoid FcPhoneDbusCallback_vSiriNRStatusInd(const T_SiriNRStatusInd* const prCallData);
static tVoid FcPhoneDbusCallback_vSiriStatusInd(const T_SiriStatus* const prCallData);
static tVoid FcPhoneDbusCallback_vNrStatusCB(const T_SiriNRStatusInd* const prCallData);
static tVoid FcPhoneDbusCallback_vSiriStatusReqRetry(const T_SiriStatus* const prCallData); //Bugfix for GMMY16-12538
static tVoid FcPhoneDbusCallback_vSiriNrStatusReqRetry(const T_SiriNRStatusInd* const prCallData); //Bugfix for GMMY16-12538
#endif
static tVoid FcPhoneDbusCallback_vWideBandAudioSetup(const T_SCOConnectionStatus* const prCallData);
static tVoid FcPhoneDbusCallback_vNameAppearedCB(const T_CallData* const prCallData);
static tVoid FcPhoneDbusCallback_vSCOConnectRequest(const T_CallData* const prCallData);
// FOUR FUNCTIONS ADDED FOR SIRI
//static const T_CCA_Dbus_If rCCA_DBusIf = 
static T_CCA_Dbus_If rCCA_DBusIf = 
{
      FcPhoneDbusCallback_vIncomingCall,
      FcPhoneDbusCallback_vCallStatus,
      FcPhoneDbusCallback_vCallStatusConsolidated,
      FcPhoneDbusCallback_vPhoneStatus,
      FcPhoneDbusCallback_vSLCStatus,
      FcPhoneDbusCallback_vAcceptCB,
      FcPhoneDbusCallback_vHoldCB,
      FcPhoneDbusCallback_vRejectCB,
      FcPhoneDbusCallback_vHangupCB,
      FcPhoneDbusCallback_vGetDeviceNameCB,
      FcPhoneDbusCallback_vDialCB,
      FcPhoneDbusCallback_vTerminateCB,
      FcPhoneDbusCallback_vAudioTransferCB,
      FcPhoneDbusCallback_vQueryTelephoneNumberCB,
      FcPhoneDbusCallback_vSendDTMFCB,
      FcPhoneDbusCallback_vResumeCallCB,
      FcPhoneDbusCallback_vHoldIncomingCB,
      FcPhoneDbusCallback_vSwapCallCB,
      FcPhoneDbusCallback_vConfCallCB,
      FcPhoneDbusCallback_vSplitCallCB,
      FcPhoneDbusCallback_vSCOConnectionStatus,
      FcPhoneDbusCallback_vVoiceRecognitionCB,
      FcPhoneDbusCallback_vVoiceRecognitionInd,
      FcPhoneDbusCallback_vAcquireTelephoneNumberCB,
      FcPhoneDbusCallback_vPnpInfoInd,
#ifdef PHONE_SIRI
      FcPhoneDbusCallback_vSiriNRStatusInd,
      FcPhoneDbusCallback_vSiriStatusInd,
      FcPhoneDbusCallback_vNrStatusCB,
      FcPhoneDbusCallback_vSiriStatusReqRetry,
      FcPhoneDbusCallback_vSiriNrStatusReqRetry,
#endif

      FcPhoneDbusCallback_vWideBandAudioSetup,
      FcPhoneDbusCallback_vNameAppearedCB,
      FcPhoneDbusCallback_vSCOConnectRequest
};
/*******************************************************************************
 *
 * FUNCTION: copy_LB_data
 *
 * DESCRIPTION: copy data
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data(LoopBackData *p_LB_data,const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("copy_LB_data "));
   vStringCopy(p_LB_data->Call_data.achCellDeviceName , prCallData->achCellDeviceName, PHONE_CELLDEVICENAME_LENGTH);
   vStringCopy(p_LB_data->Call_data.BD_Address , prCallData->BD_Address, PHONE_BDADRESS_LENGTH);
   //rCallStatus
   p_LB_data->Call_data.rCallStatus.u8CallHandle = prCallData->rCallStatus.u8CallHandle ;
   p_LB_data->Call_data.rCallStatus.u8CallTotal = prCallData->rCallStatus.u8CallTotal ;
   p_LB_data->Call_data.rCallStatus.u8CallDirection = prCallData->rCallStatus.u8CallDirection ;
   p_LB_data->Call_data.rCallStatus.u8CallState = prCallData->rCallStatus.u8CallState ;
   p_LB_data->Call_data.rCallStatus.u8CallMode = prCallData->rCallStatus.u8CallMode ;
   vStringCopy(p_LB_data->Call_data.rCallStatus.achCallNumber , prCallData->rCallStatus.achCallNumber, PHONE_CALLNUMBER_LENGTH);
   p_LB_data->Call_data.rCallStatus.u8CallType = prCallData->rCallStatus.u8CallType ;

   //MR_Data
   p_LB_data->Call_data.MR_Data.Status = prCallData->MR_Data.Status ;
   p_LB_data->Call_data.MR_Data.Code = prCallData->MR_Data.Code ;
   p_LB_data->Call_data.MR_Data.State = prCallData->MR_Data.State ;
   vStringCopy(p_LB_data->Call_data.MR_Data.device_name , prCallData->MR_Data.device_name, PHONE_CELLDEVICENAME_LENGTH);
   vStringCopy(p_LB_data->Call_data.MR_Data.voiceMailNumber , prCallData->MR_Data.voiceMailNumber, PHONE_VOICEMAILNUMBER_LENGTH);
   vStringCopy(p_LB_data->Call_data.MR_Data.TelephoneNumber , prCallData->MR_Data.TelephoneNumber, PHONE_TELEPHONENUMBER_LENGTH);
   vStringCopy(p_LB_data->Call_data.MR_Data.SubcriberNumber , prCallData->MR_Data.SubcriberNumber, PHONE_TELEPHONENUMBER_LENGTH);

   p_LB_data->Call_data.Service = prCallData->Service ;
   p_LB_data->Call_data.Status_ConnComp = prCallData->Status_ConnComp ;
   p_LB_data->Call_data.ConnLosstype = prCallData->ConnLosstype ;
   p_LB_data->Call_data.u8RingTone = prCallData->u8RingTone ;
   p_LB_data->Call_data.b_SLC_status = prCallData->b_SLC_status ;
}

/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_Consolidated
 *
 * DESCRIPTION: copy data
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_Consolidated(LoopBackData *p_LB_data,const T_CallData* prCallData)
{
   ETG_TRACE_USR4(("copy_LB_data_Consolidated "));

   for(tU8 index = 0 ; index < FC_PHONE_MAX_CALLINSTANCES; ++index, ++prCallData)
   {
      vStringCopy(p_LB_data->Call_data_Consolidated[index].achCellDeviceName , prCallData->achCellDeviceName, PHONE_CELLDEVICENAME_LENGTH);
      vStringCopy(p_LB_data->Call_data_Consolidated[index].BD_Address , prCallData->BD_Address, PHONE_BDADRESS_LENGTH);

      //rCallStatus
      p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallHandle = prCallData->rCallStatus.u8CallHandle;
      p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallTotal = prCallData->rCallStatus.u8CallTotal;
      p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallDirection = prCallData->rCallStatus.u8CallDirection;
      p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallState = prCallData->rCallStatus.u8CallState;
      p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallMode = prCallData->rCallStatus.u8CallMode;
      vStringCopy(p_LB_data->Call_data_Consolidated[index].rCallStatus.achCallNumber , prCallData->rCallStatus.achCallNumber, PHONE_CALLNUMBER_LENGTH);
      p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallType = prCallData->rCallStatus.u8CallType;

      ETG_TRACE_USR4(("Call_data_Consolidated[index].rCallStatus.u8CallHandle :%d",p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallHandle));
      ETG_TRACE_USR4(("Call_data_Consolidated[index].rCallStatus.u8CallTotal  :%d",p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallTotal));
      //ETG_TRACE_USR4(("Call_data_Consolidated[index].rCallStatus.u8CallDirection :%u",ETG_ENUM(TR_CALLDIRECTION,p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallDirection)));
      ETG_TRACE_USR4(("Call_data_Consolidated[index].rCallStatus.u8CallState :%u",ETG_ENUM(TR_CALLSTATE,p_LB_data->Call_data_Consolidated[index].rCallStatus.u8CallState)));
      ETG_TRACE_USR4(("Call_data_Consolidated[index].rCallStatus.achCallNumber :%s",p_LB_data->Call_data_Consolidated[index].rCallStatus.achCallNumber));
      ETG_TRACE_USR4(("p_LB_data->Call_data_Consolidated[index].BD_Address :%s",p_LB_data->Call_data_Consolidated[index].BD_Address));

   }
}

/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_phoneStatus
 *
 * DESCRIPTION: copy phoneStatus data
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_phoneStatus(LoopBackData *p_LB_data,const T_PhoneStatus* const pPhoneStatus)
{
   ETG_TRACE_USR4(("copy_LB_data_phoneStatus "));
   p_LB_data->phone_status.u8PhoneService = pPhoneStatus->u8PhoneService ;
   p_LB_data->phone_status.u8PhoneSignal = pPhoneStatus->u8PhoneSignal ;
   p_LB_data->phone_status.u8PhoneRoaming = pPhoneStatus->u8PhoneRoaming ;
   p_LB_data->phone_status.u8PhoneBattery = pPhoneStatus->u8PhoneBattery ;
   p_LB_data->phone_status.u8PhoneAudiopath = pPhoneStatus->u8PhoneAudiopath ;
   p_LB_data->phone_status.u8AgThreeWayCallSuppFeatures = pPhoneStatus->u8AgThreeWayCallSuppFeatures ;
   p_LB_data->phone_status.u32PhoneSuppFeature = pPhoneStatus->u32PhoneSuppFeature ;

   memset(p_LB_data->phone_status.BD_Address, '\0', PHONE_CONNMAP_DEV_ADDRESS);
   memset(p_LB_data->phone_status.achPhoneOperatorName, '\0', PHONE_NWOPERATORNAME_LENGTH);

   vStringCopy((char *)p_LB_data->phone_status.achPhoneOperatorName , (const char*)pPhoneStatus->achPhoneOperatorName, PHONE_NWOPERATORNAME_LENGTH) ;
   vStringCopy((char *)p_LB_data->phone_status.BD_Address , (const char*)pPhoneStatus->BD_Address, PHONE_BDADRESS_LENGTH) ;
}

/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_SCOConnectionStatus
 *
 * DESCRIPTION: copy SCOConnection Status Info
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_SCOConnectionStatus(LoopBackData *p_LB_data,const T_SCOConnectionStatus* const pSCOConnectionStatus)
{
   ETG_TRACE_USR4(("copy_LB_data_SCOConnectionStatus "));
   p_LB_data->SCOConnectionStatus.SCOConnectionStatus = pSCOConnectionStatus->SCOConnectionStatus ;
   p_LB_data->SCOConnectionStatus.Codec = pSCOConnectionStatus->Codec ;
   vStringCopy((char *)p_LB_data->SCOConnectionStatus.BD_Address , (const char*)pSCOConnectionStatus->BD_Address,
         PHONE_BDADRESS_LENGTH) ;
}
/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_VoiceRecInd
 *
 * DESCRIPTION: copy Voice recognition indication
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_VoiceRecInd(LoopBackData *p_LB_data,const T_VoiceRecInd* const pVoiceRecInd)
{
   ETG_TRACE_USR4(("copy_LB_data_VoiceRecInd "));
   p_LB_data->VoiceRecInd.Activation = pVoiceRecInd->Activation;
   vStringCopy((char *)p_LB_data->VoiceRecInd.BD_Address , (const char*)pVoiceRecInd->BD_Address,
         PHONE_BDADRESS_LENGTH) ;
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vIncomingCallEvent
 *
 * DESCRIPTION: This function is called by the DBus client whenever there is
 *              incoming call notification to be passed on.
 *
 * PARAMETER:  T_CallData* - Pointer to call data structure
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vIncomingCall(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vIncomingCall"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_INCOMINGCALL);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vCallStatusConsolidated
 *
 * DESCRIPTION: This callback is called to notify the current call status of the
 *              connected phone
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vCallStatusConsolidated(const T_CallData* prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vCallStatusConsolidated"));
   vNotify_Status_Consolidated(prCallData,FC_PHONE_CB_FID_CALLSTATUS_CONSOLIDATED);

}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vCallStatus
 *
 * DESCRIPTION: This callback is called to notify the current call status of the
 *              connected phone
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vCallStatus(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vCallStatus"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_CALLSTATUS);

}


/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vPhoneStatus
 *
 * DESCRIPTION: This callback is called to notify the current phone status of the
 *              connected phone
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vPhoneStatus(const T_PhoneStatus* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vPhoneStatus"));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {

         LoopBackData LB_data;
         copy_LB_data_phoneStatus(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_PHONESTATUS ;
         poTelService->push_back_LB_data(LB_data);

         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_PHONESTATUS);

      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" FcPhoneDbusCallback_vPhoneStatus"));
      }
   }
}



/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSLCStatus
 *
 * DESCRIPTION: This callback is called to notify the connection status from bluetooth service level
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSLCStatus(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vSLCStatus"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_SLCSTATUS);
}
/*******************************************************************************
 *
 * FUNCTION: vMethodCB
 *
 * DESCRIPTION: This callback is called to call the corresponding MethodResult of FC_Phone Methods
 *       viz.. vAcceptCall,vRejectCall,vHanguCall etc.
 *
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vAcceptCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vAcceptCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_ACCEPTCALL);
}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vRejectCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vRejectCB(const T_CallData* const prCallData)
{   
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vRejectCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_REJECTCALL);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vHangupCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid FcPhoneDbusCallback_vHangupCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vHangupCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_HANGUPCALL);
}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vHoldCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vHoldCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vHoldCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_HOLDCALL);
}


/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vResumeCallCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vResumeCallCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vResumeCallCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_RESUMECALL);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vHoldIncomingCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vHoldIncomingCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vHoldIncomingCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_HOLDINCOMINGCALL);
}


/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSwapCallCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSwapCallCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vSwapCallCB"));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_SWAPCALL);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vConfCallCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vConfCallCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vConfCallCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_CONFCALL);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSplitCallCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSplitCallCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vSplitCallCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_SPLITCALL);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vVoiceRecognitionCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vVoiceRecognitionCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vVoiceRecognitionCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_VOICERECOGNITION_CFM );
}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vNewDeviceNameCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vGetDeviceNameCB(const T_CallData* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vGetDeviceNameCB "));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         vStringCopy(LB_data.Call_data.MR_Data.device_name, prCallData->achCellDeviceName,
               PHONE_CELLDEVICENAME_LENGTH);
         vStringCopy(LB_data.Call_data.BD_Address, prCallData->BD_Address,PHONE_BDADRESS_LENGTH);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_DEVICENAME ;
         poTelService->push_back_LB_data(LB_data);

         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_DEVICENAME);


      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vGetDeviceNameCB "));
      }
   }

}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vDialCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vDialCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vDialCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_DIAL );
}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vAudioTransferCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vAudioTransferCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vAudioTransferCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_AUDIOTRANSFER );
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vTerminateCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vTerminateCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vTerminateCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_TERMINATE );
}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vNameAppearedCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vNameAppearedCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vNameAppearedCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_NAME_APPEARED );
}


/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vQueryTelephoneNumberCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vQueryTelephoneNumberCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vQueryTelephoneNumberCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_QUERYTELEPHONENUMBER );
}




/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSendDTMFCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSendDTMFCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vSendDTMFCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_SENDDTMF );
}
/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSCOConnectionStatus
 *
 * DESCRIPTION: This callback is called to notify the current phone status of the
 *              connected phone
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSCOConnectionStatus(const T_SCOConnectionStatus* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vSCOConnectionStatus"));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         ETG_TRACE_USR3((" Sending SCO Connection Status"));
         LoopBackData LB_data;
         copy_LB_data_SCOConnectionStatus(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_SCOCONNECTIONSTATUS;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_SCOCONNECTIONSTATUS);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vSendDTMFCB "));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vVoiceRecognitionInd
 *
 * DESCRIPTION: This callback is called to notify the whether BT Voice recogniton
has started or not.
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vVoiceRecognitionInd(const T_VoiceRecInd* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vVoiceRecognitionInd "));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if (TRUE == poTelService->m_bServerAvailable)
      {
         ETG_TRACE_USR3((" Sending Voice Rec activation ind"));
         LoopBackData LB_data;
         copy_LB_data_VoiceRecInd(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_VOICERECOGNITION_IND;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_VOICERECOGNITION_IND);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vVoiceRecognitionInd "));
      }
   }
}

/*******************************************************************************
 * FUNCTION: FcPhoneDbusCallback_vAcquireTelephoneNumberCB
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vAcquireTelephoneNumberCB(const T_CallData* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vAcquireTelephoneNumberCB "));
   vNotify_Status(prCallData,FC_PHONE_CB_FID_ACQUIRETELEPHONENUMBER );
}

/*******************************************************************************
 * FUNCTION: vNotify_Status
 *
 * DESCRIPTION:send notification
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid vNotify_Status(const T_CallData* const prCallData,tU32 u16FuncId)
{
   ETG_TRACE_USR4(("Notify_Status entered "));
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         copy_LB_data(&LB_data,prCallData);
         LB_data.u16FunctionID = u16FuncId ;
         poTelService->push_back_LB_data(LB_data);

         poTelService->vPrepareLoopBackMsg(u16FuncId);

      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: vNotify_Status "));
      }
   }
}


/*******************************************************************************
 * FUNCTION: vNotify_Status_Consolidated
 *
 * DESCRIPTION:send notification
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid vNotify_Status_Consolidated(const T_CallData* prCallData,tU32 u16FuncId)
{
   ETG_TRACE_USR4(("vNotify_Status_Consolidated entered "));
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         copy_LB_data_Consolidated(&LB_data,prCallData);
         LB_data.u16FunctionID = u16FuncId ;
         poTelService->push_back_LB_data(LB_data);

         poTelService->vPrepareLoopBackMsg(u16FuncId);

      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: vNotify_Status "));
      }
   }
}

/*******************************************************************************
 * FUNCTION: pGetCCAPhoneDBusIf
 *
 * DESCRIPTION: Suplies CCA_DBusInterface
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
T_CCA_Dbus_If *pGetCCAPhoneDBusIf(tVoid)
{
   ETG_TRACE_USR4(("pGetCCAPhoneDBusIf"));
   return(&rCCA_DBusIf);
}



/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_PnpInfoInd
 *
 * DESCRIPTION: copy PnpInfo indication
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_PnpInfoInd(LoopBackData *p_LB_data,const T_PnpInfoInd* const pPnpInfoInd)
{
   ETG_TRACE_USR4(("copy_LB_data_PnpInfoInd "));
   p_LB_data->PnpInfoInd.m_usSpecificationID = pPnpInfoInd->m_usSpecificationID;
   p_LB_data->PnpInfoInd.m_usProductID = pPnpInfoInd->m_usProductID;
   p_LB_data->PnpInfoInd.m_usVendorID  = pPnpInfoInd->m_usVendorID;
   p_LB_data->PnpInfoInd.m_ucPrimaryRecord = pPnpInfoInd->m_ucPrimaryRecord;
   p_LB_data->PnpInfoInd.m_usVendorIDSource = pPnpInfoInd->m_usVendorIDSource;
   p_LB_data->PnpInfoInd.m_usVersion = pPnpInfoInd->m_usVersion;
   vStringCopy(p_LB_data->PnpInfoInd.BD_Address,pPnpInfoInd->BD_Address,PHONE_BDADRESS_LENGTH);
   /* vStringCopy(p_LB_data->PnpInfoInd.m_aucClientExecutableURL,pPnpInfoInd->m_aucClientExecutableURL,strlen(pPnpInfoInd->m_aucClientExecutableURL));
   vStringCopy(p_LB_data->PnpInfoInd.m_aucDocumentationURL,pPnpInfoInd->m_aucDocumentationURL,strlen(pPnpInfoInd->m_aucDocumentationURL));
   vStringCopy(p_LB_data->PnpInfoInd.m_aucServiceDescription,pPnpInfoInd->m_aucServiceDescription,strlen(pPnpInfoInd->m_aucServiceDescription));
    */
}

/*******************************************************************************
 * FUNCTION: FcPhoneDbusCallback_vPnpInfoInd
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vPnpInfoInd(const T_PnpInfoInd* const prCallData)
{

   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vPnpInfoInd "));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();
   if (poTelService)
   {
      if (TRUE == poTelService->m_bServerAvailable)
      {
         ETG_TRACE_USR3((" Sending PnpInfo Ind"));
         LoopBackData LB_data;
         copy_LB_data_PnpInfoInd(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_PNPINFO_IND;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_PNPINFO_IND);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vPnpInfoInd "));
      }
   }

}

#ifdef PHONE_SIRI
/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_SiriStatus
 *
 * DESCRIPTION: copy siriStatus data
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_siriStatus(LoopBackData *p_LB_data,const T_SiriStatus* const pSiriStatus)
{
   ETG_TRACE_USR4(("copy_LB_data_SiriStatus "));
   p_LB_data->siri_status.m_u8SiriStatus = pSiriStatus->m_u8SiriStatus;
   vStringCopy(p_LB_data->siri_status.BD_Address,pSiriStatus->BD_Address,PHONE_BDADRESS_LENGTH);
}

/*******************************************************************************
 *
 * FUNCTION: copy_LB_data_SiriNrStatusInd
 *
 * DESCRIPTION: copy SiriNrStatus data
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid copy_LB_data_SiriNrStatusInd(LoopBackData *p_LB_data,const T_SiriNRStatusInd* const pNrStatInd)
{
   ETG_TRACE_USR4(("copy_LB_data_SiriNrStatusInd "));
   p_LB_data->NRStatusInd.m_u8SiriNrStatus= pNrStatInd->m_u8SiriNrStatus;
   vStringCopy(p_LB_data->NRStatusInd.BD_Address,pNrStatInd->BD_Address,PHONE_BDADRESS_LENGTH);
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSiriNRStatusInd
 *
 * DESCRIPTION: This callback is called to notify  whether Noise Reduction status is enabled or disabled.
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSiriNRStatusInd(const T_SiriNRStatusInd* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vSiriNRStatusInd entered "));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if (TRUE == poTelService->m_bServerAvailable)
      {
         ETG_TRACE_USR3((" Sending NRStatusInd "));
         LoopBackData LB_data;
         copy_LB_data_SiriNrStatusInd(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_SIRI_NR_IND;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_SIRI_NR_IND);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vSiriNRStatusInd "));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSiriStatusInd
 *
 * DESCRIPTION: Kasi
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid FcPhoneDbusCallback_vSiriStatusInd(const T_SiriStatus* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vSiriStatusInd"));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {

         LoopBackData LB_data;
         copy_LB_data_siriStatus(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_SIRISTATUS_IND ;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_SIRISTATUS_IND);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" FcPhoneDbusCallback_vSiriStatusInd Error"));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vNrStatusCB
 *
 * DESCRIPTION: Kasi
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

tVoid FcPhoneDbusCallback_vNrStatusCB(const T_SiriNRStatusInd* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vNrStatusCB"));

   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();
   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         LB_data.u16FunctionID = FC_PHONE_CB_FID_NRSTATUS;
         copy_LB_data_SiriNrStatusInd(&LB_data, prCallData);
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_NRSTATUS);
      }
      else
      {
         ETG_TRACE_ERR((" FcPhoneDbusCallback_vNrStatusCB Error"));
      }
   }
}

tVoid FcPhoneDbusCallback_vSiriStatusReqRetry(const T_SiriStatus* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vSiriStatusReqRetry"));
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();
   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         LB_data.u16FunctionID = FC_PHONE_CB_FID_SIRISTATUSREQ_RETRY;
         copy_LB_data_siriStatus(&LB_data,prCallData);
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_SIRISTATUSREQ_RETRY);
      }
      else
      {
         ETG_TRACE_ERR((" FcPhoneDbusCallback_vSiriStatusReqRetry Error"));
      }
   }
}

tVoid FcPhoneDbusCallback_vSiriNrStatusReqRetry(const T_SiriNRStatusInd* const prCallData)
{
   ETG_TRACE_USR4(("FcPhoneDbusCallback_vSiriNrStatusReqRetry"));
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   poTelService = fc_phone_tclService_Telephone::pGetInstance();
   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         LB_data.u16FunctionID = FC_PHONE_CB_FID_SIRINRSTATUSREQ_RETRY;
         copy_LB_data_SiriNrStatusInd(&LB_data,prCallData);
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_SIRINRSTATUSREQ_RETRY);
      }
      else
      {
         ETG_TRACE_ERR((" FcPhoneDbusCallback_vSiriNrStatusReqRetry Error"));
      }
   }
}
#endif //PHONE_SIRI

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vWideBandAudioSetup
 *
 * DESCRIPTION: This call back is called to notify for wide band speech setup
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vWideBandAudioSetup(const T_SCOConnectionStatus* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vWideBandAudioSetup"));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         ETG_TRACE_USR3((" Sending eSCO Connection Status"));
         LoopBackData LB_data;
         copy_LB_data_SCOConnectionStatus(&LB_data,prCallData);
         LB_data.u16FunctionID = FC_PHONE_CB_FID_WIDEBANDSPEECHSETUP;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_CB_FID_WIDEBANDSPEECHSETUP);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vWideBandAudioSetup "));
      }
   }
}

/*******************************************************************************
 *
 * FUNCTION: FcPhoneDbusCallback_vSCOConnectRequest
 *
 * DESCRIPTION: This call back is called to notify for SCO Connect request from Phone device
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/
tVoid FcPhoneDbusCallback_vSCOConnectRequest(const T_CallData* const prCallData)
{
   fc_phone_tclService_Telephone *poTelService = NULLPTR;
   ETG_TRACE_USR4((" FcPhoneDbusCallback_vSCOConnectRequest"));
   poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if (poTelService)
   {
      if(TRUE == poTelService->m_bServerAvailable)
      {
         ETG_TRACE_USR3((" Sending SCO Connection Request"));
         LoopBackData LB_data;

         //BD_Address is enough for processing SCO Connect Request in the service side
         vStringCopy(LB_data.Call_data.BD_Address , prCallData->BD_Address, PHONE_BDADRESS_LENGTH);
         LB_data.u16FunctionID = FC_PHONE_LB_FID_SCO_CONNECT_REQUEST;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(FC_PHONE_LB_FID_SCO_CONNECT_REQUEST);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: FcPhoneDbusCallback_vSCOConnectRequest "));
      }
   }
}
