/*******************************************************************************
 *
 * FILE:          FC_Phone_AudioManager.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Abstracts Audio channel rights management provided by PhoneService class
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c)Celestial Systems, Bangalore, India
 *
 *******************************************************************************/

#ifndef _FC_PHONE_AUDIOMANAGER_H_
#define _FC_PHONE_AUDIOMANAGER_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "../FC_Phone_service_Telephone.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
typedef tVoid (*AudioCallBack)(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16RequestState);

typedef struct _AudioChannelIdCallBackMap
{
   tU16 u16AudioReqID ;
   tU16 u16AudioChannelId;
   AudioCallBack FpCallBack;
}AudioChannelIdCallBackMap;

#define FC_PHONE_CHANNELAQUISITION_STATE_IDLE                 0
#define FC_PHONE_CHANNELAQUISITION_STATE_PROCESSING_GET       1
#define FC_PHONE_CHANNELAQUISITION_STATE_PROCESSING_RELEASE   2
#define FC_PHONE_CHANNELCOUNTER_DEFAULT                 0
typedef struct
{
   tU16  u16ChannelAquCounter ;
   tU16  u16ChannelAquState;
   tBool bPendingReleaseRequest ;
   tBool bPendingGetRequest ;
}FcPhoneChannelAquAttr_t;

#define FC_PHONE_AUDIOCHANNEL_INCOMINGRINGTONE 0x00
#define FC_PHONE_AUDIOCHANNEL_PHONE            0x01
#define FC_PHONE_AUDIOCHANNEL_ALERTTONE        0x02  
#define FC_PHONE_AUDIOCHANNEL_SPEECH           0x03
#ifdef PHONE_WAITINGMODE
#define FC_PHONE_AUDIOCHANNEL_PHONEWAIT         0x04
#endif
#define FC_PHONE_AUDIOCHANNEL_ID_UNUSED        0xFF

#define FC_PHONE_AUDIOCHANNEL_REQUESTOR_ID_UNKNOWN        0xFF
#define FC_PHONE_AUDIOCHANNEL_REQUESTOR_VOICE_REC         0x03
#define FC_PHONE_AUDIOCHANNEL_REQUESTOR_EXT_VOICE_REC         0x04


/* At present we need only 4 audio channels and  for every channel
    there can be maximum 2 requestors */
#define FC_PHONE_AUDIOCHANNEL_LIMIT   8


/* Error codes for Audio Channel */
#define FC_PHONE_AUDIOCHANNEL_OK             0x00
#define FC_PHONE_AUDIOCHANNEL_INVALID        0x01
#define FC_PHONE_AUDIOCHANNEL_LIMIT_EXCEEDED 0x02

/* Values taken by request state parameter */
#define FC_PHONE_AUDIOCHANNEL_DENIED         0x00
#define FC_PHONE_AUDIOCHANNEL_GRANTED        0x01
#define FC_PHONE_AUDIOCHANNEL_SUSPENDED      0x02

#define FC_PHONE_NUM_OFCHANNELS                4

#define FC_PHONE_REQUESTTYPE_GET               1
#define FC_PHONE_REQUESTTYPE_RELEASE           2


#define FC_PHONE_AUDIOMANAGER_FIRST_GETREQUEST     1
#define FC_PHONE_AUDIOMANAGER_LAST_RELEASEREQUEST  1

void vAudioCallBackDummy(tU16 u16AudioReqID,tU16 u16AudioChannelId, tU16 u16Status);



/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_phone_tclAudioManager FINAL
{
public:

   /* Constructor */
   fc_phone_tclAudioManager();

   /* Destructor */
   virtual ~fc_phone_tclAudioManager();

   tS32 s32GetRequest(tU16 u16AudioReqID,tU16 u16AudioChannelId,AudioCallBack fpCallBack);

   tS32 s32ReleaseRequest(tU16 u16AudioReqID,tU16 u16AudioChannelId,AudioCallBack fpCallBack);

   tS32 s32GetRequestAck(tU16 u16AudioChannelId, tU16 u16RequestState);
   tS32 s32ReleaseRequestAck(tU16 u16AudioChannelId);
   tVoid vHandleError(tVoid); /* Temporary , no method error structure from Bosch */
   tVoid vReleaseUsedAudioChannels(tVoid);

   //GMMY17-11914
   tVoid vReleasePhoneChannel(tVoid);

   tVoid vSetPriorityChannel     (tBool b_flag_EmerOrAdvisor);
   tBool bGetPriorityChannel     ();
   static fc_phone_tclAudioManager* pGetInstance(tVoid);
   tS32 s32SyncAudioMangerOnChannelRelease(tU16 u16AudioReqID,tU16 u16AudioChannelId);
   tS32 s32SyncAudioMangerOnChannelGranted(tU16 u16AudioReqID,tU16 u16AudioChannelId);
   tBool bIsPhoneChannelRelease();
   tBool bIsPhoneChannelGet();
   tBool bIsPhoneOrRingtoneChannelAcquistionIdle();
   tBool bIsPhoneOrRingtoneChannelAcquistionInRelease();
   tU8 u8SpeechChannelStatus();

   //Fix for GMMY17-11124
   tU8 m_u8GetRequestCounter;

   //NCG3D-5406. RESET all channel attributes on SLC_ON
   tVoid vResetAllChannelAttributes();

   tVoid vResetChannelAttributes(tU16);
   tVoid vSetChannelAttributesForGetRequest(tU16);
   tVoid vUpdateChannelAttributes(tU16 u16AudioChannelId ,tU16 u16RequestType);
   tVoid vUpdateAcquisitionCounter();

   tVoid vGetChannelStatus(const tU16 u16AudioChannelId ,tU8& u8ChannelStatus);
protected:
private:
   AudioChannelIdCallBackMap   m_rAudioCallBackMap[FC_PHONE_AUDIOCHANNEL_LIMIT];
   static fc_phone_tclAudioManager* m_poInstance;


   tS32 s32GetNextSlot(tU16& rfSlotId);
   tS32 s32GetSlotIdFromAudioChannelId(tU16 u16AudioChannelId,tU16& rfSlotId);
   tS32 s32RemoveGetRequest(tU16 u16AudioReqID,tU16 u16AudioChannelId);
   tVoid vPrintChannelAttributes();

   FcPhoneChannelAquAttr_t tChannelAquAttr[FC_PHONE_NUM_OFCHANNELS] ;
   tBool m_bPriorityChannelFlag ;
};
#endif // _FC_PHONE_AUDIOMANAGER_H_


