/*******************************************************************************
 *
 * FILE:          FC_Phone_service_Telephone.h
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * DESCRIPTION:   CCA service Telephone.
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_PHONE_SERVICE_TELEPHONE_H_
#define _FC_PHONE_SERVICE_TELEPHONE_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include public FI interface of this service.
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TELEPHONE_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TELEPHONE_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TELEPHONE_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TELEPHONE_SERVICEINFO
#define WAITINGMODE_TONE_PATH "/var/opt/bosch/static/connectivity/tones/waitingmodetones/"
#include "midw_fi_if.h"

#include "HelperClasses/FC_Phone_CallInstance.h"

#define FC_PHONE_S_IMPORT_INTERFACE_MSG
#include "FC_Phone_if.h"

#include "Interface/FC_Phone_DBusInterface.h"
#include "DBusClient/FC_Phone_DBusClientEvo.h"
#include "HelperClasses/FC_Phone_PhoneData.h"

#ifdef PHONE_WAITINGMODE
#include "WaitingMode/FC_Phone_WaitingMode.h"
#endif

#include <QtCore/QtCore>
#include "Defines/TelephoneService_Defines.h"


/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class ahl_tclBaseOneThreadService;
class fc_phone_tclSMManager;
class fc_phone_tclSMObserver;
class fc_phone_tclClientHandler_BTSettings;
class fc_phone_tclCallManager ;
class fc_phone_tclSMVRSession;
class fc_phone_tclSMExtVRSession;
class fc_phone_tclAudioChannelWatchdog;

#define EN_SPEECH_CHNL_NOTACTIVE 0
#define EN_SPEECH_CHNL_GET_PROGRESS  1
#define EN_SPEECH_CHNL_ACTIVE  3
#define EN_SPEECH_CHNL_RELEASE_PROGRESS  2
#define FC_PHONE_COMMANDCOUNTERID_UNKNOWN 0xFF
#define FC_PHONE_TERMINATEALERT_CMDCNTRID_OUTBOUND 50
#define FC_PHONE_TERMINATEALERT_CMDCNTRID_INBOUND 1
#define FC_PHONE_EXTERNAL_VR_STATE_IDLE 0

class fc_phone_tclService_Telephone FINAL: public ahl_tclBaseOneThreadService
{
private:
   tInt InputDevStatus;
   tInt OutputDevStatus;
   tU16 u16ConferenceCall1;
   tU16 u16ConferenceCall2;
   tBool isConfSMExecutedFromHmi;
   tBool isConfSMExecutedFromCallStatus;
   tU8 m_u8BandSelection;
   tBool m_bStartAudioStatus;

   tU16 m_u16PnpInfoVendorID[FC_PHONE_MAX_CONNECTED_DEVICE];
   tU16 m_u16PnpInfoVendorSource[FC_PHONE_MAX_CONNECTED_DEVICE];
   tBool m_bIsPnpRxd;
   tBool m_bIsConnectionCompRxd;
   tBool m_bDtmfProcessing;
   tU8 m_u8AcquireTelephoneNumberRetryCnt;
   tU8 m_u8CurrentCallIndex;// To get the current CallInstance.
   tU8 m_u8CurrentIncomingCallIndex;// To get the current incoming CallInstance

   tU8 m_u8CurrentBDAddressIDforUpdate;
   tU8 m_u8BDAddressIDforAcquiringTelNo;

   tU8 m_u8ConsolidatedCSCountprocessed;

   tU8 m_u8DeviceHandletoSetActiveToStartVR;

#ifdef PHONE_SIRI
   tU8 m_u8SiriReqRetryCount[FC_PHONE_MAX_CONNECTED_DEVICE];
   tBool m_bSiriRetryTimerRunning[FC_PHONE_MAX_CONNECTED_DEVICE];
   tBool m_bSiriNrRetryTimerRunning[FC_PHONE_MAX_CONNECTED_DEVICE];
#endif //PHONE_SIRI

   //When Hold/Resume call method start is received in FC_Phone with call instance value as FF, then the conference call should be put on hold/ resumed.
   tBool m_bHoldOrResumeAllFlag;
   //End of fix

   //Work queue implementation -> eliminate duplicate requests
   //If same request comes again to FC_Phone we dont push them to queue. Corresponding request returns giving error.
   //Stored values for Accept Methodstart
   int m_u16StoredCallInstanceForAccept;

   //Stored values for Hangup Methodstart
   int m_u16StoredCallInstanceForHangUp;

   //Stored values for Cancel Outgoing call Methodstart
   int m_u16StoredCallInstanceForCancel;

   //Stored values for Ignore Methodstart
   int m_u16StoredCallInstanceForIgnore;

   int m_u16StoredCallInstanceForReject;

   //Storing phone number as member to access it while taken from queue
   tChar m_sValidPhoneNumber[FC_PHONE_DIAL_NUMBER_MAX_LEN_IN_CHARS +1];
   //End of fix

   // Boolean indicate the SPM sub state( 0-> NOT PHONE 1-> PHONE)
   tBool m_bSpmSubState;

   // Data set used to store the current configuration.
   // Will be updated from Indication of SetupAudioWbs
   tU8 m_u8EcnrConfigurationDataset;

 // NCG3D-3221- Hold for handset-handsfree mode
   tU16 m_u16SCOChannelReleaseTimerId;
   tBool m_bScoChannelReleaseTimerRunning;
   T_SCOConnectionStatus m_SCOChannelConnectionStatus;

   tBool m_bHeldtoActiveSwapTimerRunning;

   tBool m_bExternalTriggerStatusforPhoneChannel;
 // CMG3G-8798- Outgoing call and number to name resolution
   struct DialInfo{
       tString m_sDialName;
       tString m_sDialNumber;
    };
	
   DialInfo m_sDialInfo[FC_PHONE_MAX_CALLINSTANCES];

   struct IncomingCallEvent{
       tBool  bIsRinging;
       tU8 CallInstance;
       tChar  TelephoneNumber[PHONE_CALLNUMBER_LENGTH];
       tString FirstName;
       tString LastName;
       tBool  CallWait;
       tU8  DeviceHandle;
    };

   IncomingCallEvent m_sIncomingEventInfo;

   //2HFP
   tU8 m_u8ActiveDeviceHandle;
   tU8 m_u8ActiveDeviceHandletobeRetained;

   tU8 m_u8StoredDeviceHandletoSetActive;
   std::vector<T_CallStatusList> CallStatusList;
   tBool m_bEndCallforPassiveDev;
   tU8 m_u8HFProfDevHandle;

   /* Properties */
   most_telfi_tclMsgSLCStatusStatus           m_oSLCStatusStatus;
   most_telfi_tclMsgSourceAvailableStatus     m_oSourceAvailableStatus;
   most_telfi_tclMsgBTDeviceVoiceRecognitionStatus m_oBTDeviceVoiceRecStatus;
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus m_oBTDeviceVoiceRecExtendedStatus;
   most_telfi_tclMsgWaitingModeFilePathStatus m_oWaitingModeFilePathStatus;
   most_telfi_tclMsgWaitingModeStateStatus m_oWaitingModeStateStatus;
   most_telfi_tclMsgExternalVRStateStatus m_oExternalVRStateStatus;


   IncomingMessage m_oAcceptCallMessage;
   IncomingMessage m_oRejectCallMessage;
   IncomingMessage m_oHangUpCallMessage;    
   IncomingMessage m_oResumeCallMessage;
   IncomingMessage m_oHoldCallMessage;
   IncomingMessage m_oIgnoreCallMessage;
   IncomingMessage m_oDialMessage;
   IncomingMessage m_oSpeedDialMessage;
   IncomingMessage m_oCancelOutgoingCallMessage;
   IncomingMessage m_oVoiceMailMessage;
   IncomingMessage m_oQueryTelephoneNumberMessage;
   IncomingMessage m_oSendCellDeviceName;
   IncomingMessage m_oSendDTMFMessage;
   IncomingMessage m_oAllocateMessage[ISOURCE_NUMBER_OF_SRCNUMBER_SUPPORTED];
   IncomingMessage m_oDeAllocateMessage[ISOURCE_NUMBER_OF_SRCNUMBER_SUPPORTED];
   IncomingMessage m_oSourceActivityMessage[ISOURCE_NUMBER_OF_SRCNUMBER_SUPPORTED];
   IncomingMessage m_oSwapCallMessage;
   IncomingMessage m_oConferenceCallMessage;
   IncomingMessage m_oSplitCallMessage;
   IncomingMessage m_oTransferCallToVehicle;
   IncomingMessage m_oBTDeviceVoiceRecMessage;
   IncomingMessage m_oBTDeviceVoiceRecExtendedMessage;
   IncomingMessage m_oStartStopWaitingMode;
   IncomingMessage m_oSetActivePhone;

   std::vector<IncomingMessage, std::allocator<IncomingMessage> > m_oAcquireTelephoneNumberMessage;
   std::vector<IncomingMessage, std::allocator<IncomingMessage> > m_oTransferCallIncomingMsgQueue;


   fc_phone_tclCallInstance m_oCallInstances[FC_PHONE_MAX_CALLINSTANCES];
   fc_phone_tclPhoneData    m_oPhoneData[FC_PHONE_MAX_CONNECTED_DEVICE];
   fc_phone_tclSMObserver* m_poSMObserver;
   fc_phone_tclSMManager*  m_poSMManager;
   fc_phone_tclSMVRSession*  m_poSMVRSession;
   fc_phone_tclSMExtVRSession*  m_poSMExtVRSession;
   fc_phone_tclClientHandler_BTSettings *m_pobtTelClient ;

   /***************************************************************************
    * Audio-channel watchdog
    ***************************************************************************/

   fc_phone_tclAudioChannelWatchdog*  m_oAudioWatchdog;

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

   // Add your CCA message handler function prototypes here.
   tVoid vHandle_AcceptCall_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_AcceptCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_AcceptCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);

   tVoid vHandle_RejectCall_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_RejectCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_RejectCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_HangUpCall_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_HangUpCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_HangUpCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);

   //Fix for task CMG3G-5839
   tVoid vHandle_IgnoreCall_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_IgnoreCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_IgnoreCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);

   tVoid vHandle_HoldCall_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_HoldCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_HoldCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_ResumeCall_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_ResumeCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_ResumeCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_Dial_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_Dial_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_Dial_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);
   
   tVoid vHandle_DialExtended_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_DialExtended_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_DialExtended_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);

   tVoid vHandle_SpeedDial_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_SpeedDial_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_SpeedDial_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);

   tVoid vHandle_CancelOutgoingCall_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_CancelOutgoingCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_CancelOutgoingCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage, struct Job* poJob = NULLPTR, tBool bIsPhoneMutexLockAcquired = FALSE);

   tVoid vHandle_SendDTMF_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_SendDTMF_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_SendDTMF_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_SwapCall_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_SwapCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_SwapCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_ConferenceCall_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_ConferenceCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_ConferenceCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_SplitCall_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_SplitCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_SplitCall_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_TransferCallToVehicle_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_TransferCallToVehicle_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_TransferCallToVehicle_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_TransferCallToHandSet_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_TransferCallToHandSet_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_TransferCallToHandSet_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_AcquireTelephoneNumber_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_AcquireTelephoneNumber_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_AcquireTelephoneNumber_MethodResult(tVoid);

   tVoid vHandle_QueryTelephoneNumber_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_QueryTelephoneNumber_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_VoiceMail_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_VoiceMail_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage);

   tVoid vHandle_BtDeviceVoiceRecognition_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);
   tVoid vHandle_BtDeviceVoiceRecognitionExtended_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode);

   tVoid vHandle_StartStopWaitingMode_MethodStart(amt_tclServiceData* poMessage);

   tVoid vHandle_SetActivePhone_MethodStart(amt_tclServiceData* poMessage, struct Job* poMethodStart = NULLPTR);
   tVoid vHandle_SetActivePhone_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage = NULLPTR, tBool bResetStoredDeviceHandletoSetActive = true);

   tVoid vHandle_ActivateExternalVR_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_ActivateExternalVR_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode,amt_tclServiceData* poMessage);

   tVoid vHandle_DeActivateExternalVR_MethodStart(amt_tclServiceData* poMessage);
   tVoid vHandle_DeActivateExternalVR_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode,amt_tclServiceData* poMessage);
   tVoid vSend_ActivateExternalVR_MethodResult(amt_tclServiceData* poMessage);
   tVoid vSend_DeActivateExternalVR_MethodResult(amt_tclServiceData* poMessage);

   most_fi_tcl_e8_ErrorCode::tenType vGetMostErrorCode(fc_phone_tclCallInstance*& rfpCallInstance);

   // Other internal methods
   tS32 s32GetCallInstanceIndexFromFiCallInstance(tU16 u16FICallInstance, tU16& rfIndex);
   tS32 s32GetIdleCallInstanceIndex(tU16& rfIndex);
   tS32 s32GetActiveCallInstanceIndex(tU16& rfIndex);
   void DiagnosticModeConfig(tS32 eComponent);
   tVoid copy_from_loopback_queue(T_CallData*  prCallData,LoopBackData *p_LB_data);
   tVoid copy_Consolidated_CallData_from_loopback_queue(T_CallData  prCallData[],LoopBackData *p_LB_data);
   tVoid copy_PhoneStatus_from_loopback_queue( T_PhoneStatus*  pPhoneStatus,LoopBackData *p_LB_data);
   tVoid copy_SCOConnectionStatus_from_loopback_queue( T_SCOConnectionStatus*  pSCOConnectionStatus,LoopBackData *p_LB_data);
   tVoid copy_method_data_from_loopback_queue(Async_method_data_t *p_MR_Data,LoopBackData *p_LB_data);
   tVoid copy_VoiceRecInd_from_loopback_queue( T_VoiceRecInd*  pVoiceRecInd,LoopBackData *p_LB_data);
   tVoid copy_PnpInfoInd_from_loopback_queue( T_PnpInfoInd*  pPnpInfoInd,LoopBackData *p_LB_data);
   //FIX GMMY16-7888   [CT][MY16 D1BL Telephone] HMI reset observed when calls were swapped and then end call selected immediately.
   tVoid copy_WQJob_from_loopback_queue( Job* job, LoopBackData *p_LB_data);
   //End of fix

#ifdef PHONE_SIRI
   tVoid copy_SiriNrInd_from_loopback_queue( T_SiriNRStatusInd*  pNoiseReducInd,LoopBackData *p_LB_data);
   tVoid copy_SiriStatus_from_loopback_queue( T_SiriStatus*  pSiriStatus,LoopBackData *p_LB_data);
#endif //#if PHONE_SIRI

   // Status Messages
   tBool bStatusMessageIncomingCallEvent(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageCallStatusNotice(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageCallStatusNoticeExtended(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);   
   tBool bStatusMessageActiveCallInHandset(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageCellDeviceName(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageCellNetworkStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageCellStateOfChargeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageCellSignalStrength(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageSLCStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageSourceAvailable(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageNetworkOperator(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageVehicleAudio(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageMicrophoneMuteState(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageHFService(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageBTVoiceRecognition(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageBTVoiceRecognitionExtended(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageRingtoneMuteState(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageHFEnhancedControl(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageWaitingModeFilePath(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageActivePhoneDevice(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   tBool bStatusMessageOutgoingCallFailedEvent(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */);
   tBool bStatusMessageIncomingCallRejectEvent(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */);
   tBool bStatusMessageWaitingModeStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */);
   tBool bStatusMessageExternalVRStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* /* poInMsg */);



   // Send property Updates
   tVoid vSendSLCStatus(T_CallData* const prCallData);
   tVoid vSendCellDeviceName(tU8 u8BDAddressID);
   tVoid vSendBtVRStatus(tBool bIsPhoneStatusInd = false, tU8 u8inBDId = INVALID_BDADDRESS_ID);
   tBool vGetConfSMStatus();
   tVoid vHandleOffState(T_SCOConnectionStatus* SCOConexnStatus);
   tVoid vAppendDtmfString(fc_phone_tclCallInstance*& rfpCallInstance, tChar* pu8DTMFChar, tU16 u16CallInstanceID);
   tVoid vAcquireTelephoneNumberStatusCheck(const Async_method_data_t* const vAsync_method_data);   
   tVoid vUpdatePhoneStatusSLCoff(tU8 u8BDId);
   tVoid vPostMethodError(tU16);

protected:
   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg) OVERRIDE;
   virtual tBool bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error) OVERRIDE;

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_phone_tclService_Telephone)

public:
   fc_phone_tclCallManager* m_poCallManager;
   tBool m_bServerAvailable;
   tBool m_bDiagnosticModeFlag;
   tBool m_bDialMethodStartFlag;
   tBool m_bAcceptMethodStartFlag;

   static fc_phone_tclService_Telephone* m_poTelService;
   _CCA_dbus_interfaces* m_pDBus_CCA_If;

   tU16 u16Counter;

#ifdef PHONE_SIRI
   fc_phone_tclSiriData    m_oSiriData[FC_PHONE_MAX_CONNECTED_DEVICE];
#endif

   std::vector<LoopBackData, std::allocator<LoopBackData> > LB_data_queue;
   GMutex p_mutex_loopback;
   tU8 m_u8TransferCallCause;

   fc_phone_tclService_Telephone();
   fc_phone_tclService_Telephone(fc_phone_tclApp* poMainAppl);
   fc_phone_tclService_Telephone(fc_phone_tclService_Telephone & serivce);
   fc_phone_tclService_Telephone& operator=(fc_phone_tclService_Telephone & serivce);
   virtual ~fc_phone_tclService_Telephone();

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   tVoid vOnLoopbackService(amt_tclServiceData* poMessage);
   tVoid vSendPropertyUpdate(tU16 u16PropertyId, tVoid *varg);
   tVoid vSendPropertyError(tU16 u16PropertyId, tVoid *varg);
   tVoid vSendMethodAck(tU16 u16MethodId, fc_phone_tclCallInstance*& rfpCallInstance);
   static fc_phone_tclService_Telephone* pGetInstance();

   /***************************************************************************
    * Notification methods from DBus
    ***************************************************************************/
   tVoid vPhoneStatus(const T_PhoneStatus* const prPhoneData, tU8 BDAddressID);
   tVoid vQueryTelephoneNumberCB( const Async_method_data_t* const vAsync_method_data);
   tVoid vSetBtClient(fc_phone_tclClientHandler_BTSettings*& rfpbtTelClient);
   tVoid vPrepareLoopBackMsg(tU32 internal_functionID);
   tVoid push_back_LB_data(LoopBackData &LBData);
   tVoid erase_LB_data(tU16 position);

   tU16 get_data_position(tU32);
   tBool b_get_ActiveDevice_AddressId_FromBT(tU8 *pu8_deviceAddressID);
   tBool b_get_ConnectedDevice_AddressId_FromBT(tU8 *pu8_deviceAddressID, const tChar *pDeviceAddress);

   tVoid vUpdateSearchPhoneBookMR_ResponseToSMs();
   tVoid vUpdateRingingIncomingCallEvent(tU8 DevHandle);

   const tChar* sGetDeviceNameFromPhoneData();

   tVoid vInitPhoneData(tU8 BDAddressID);
   tBool sGetCallStatus();
   tVoid ChangeDeviceStateResponse();
   tVoid vTransferCallToHandset(tU8 u8ExtTrigger = FC_PHONE_TRANSFERCALL_EXT_TRIGGER);

   tVoid vTransferCallToHandsfree();

   tU8 vGetAudioTransferStatus();
   tVoid vResetStateMachines();
   tVoid vResetAudioTranferStatusOnEndCall();

   tBool vMuteMicroPhone(tBool,tBool bSendtoEcnr = TRUE );

   tVoid vSetConfSMStatus(tBool blValue);
   tVoid vCheckConference(tU8 u8CallsActive);
   fc_phone_tclCallInstance* vGetCallInstanceOfOtherSM(fc_phone_tclCallInstance*& rfpCallInstance);
   tBool vGetVehicleAudioStatus();
   tVoid vCheckCallStatus();
   tVoid vStartConference();
   tVoid vOnSaveSettings();
   tVoid vOnLoadSettings();
   tVoid vResetSMManager(tBool isDeviceDisconnected = FALSE);
   tVoid vSetDtmfStatus(tBool blValue);
   tVoid vResetAudioChannel();
   tVoid vSwapHoldCallStatus();
   tVoid vResetStoredCallInstance(tU16 u16FunId);
   tBool bIsAppleDevice(tU8 u8BDAddressID);
#ifdef PHONE_SIRI
   tVoid vTimerCallBack(tU16 u16TimerId);
#endif //PHONE_SIRI

   tU8 u8getDeviceHandle(tU8 BDAddrID);

   tU8 getAgThreeWayCallSuppFeatures()const;
   tBool bIsAgThreeWayCallSupported() const;

   most_telfi_tclMsgSLCStatusStatus oGetSLCStatus();
   const fc_phone_tclCallInstance* oGetCallInstances(); //CMG3G-4847 - To solve Lint

   tVoid vUpdateSpmSubState();
   tBool bGetSpmSubState();

   /*GMMY16-7759 Not Possible to Switch to second call, if first ongoing call is ended from Handset
   When any call is ended, waiting state of the other call instance should be set to FALSE as it is not waiting any more.*/
   tVoid vCheckAndUpdateCallWaitingState();

   tBool bCheckIdleCallStatus();
   tVoid vSendBtVRExtendedStatus(tU8 u8BDID_in = INVALID_BDADDRESS_ID);
   // CMG3G-7982- Extend VR session
   tVoid vStopExtendedVRSession();
   // NCG3D-3221- Hold for handset-handsfree mode
   tVoid vStopTimerAndProcessSCODisconnection(tU16 m_u16SCOChannelReleaseTimerId);
   tVoid vProcessSCODisconnection();
   tVoid vUpdateSCOChannelConnectionStatus(T_SCOConnectionStatus &SCOConnexnStatus);
   tVoid vProcessChannelAndUpdateSCOConnectionstatus();
#ifdef PHONE_WAITINGMODE

   tVoid vSendStartStopWaitingModeMethodResult(most_fi_tcl_e8_TelWaitingModeStatus::tenType);
   tVoid vSendWaitingModeState(most_fi_tcl_e8_WaitingModeState::tenType enWaitingModeState);
   tBool bGetCallInstanceIdForWaitingCall(tU16*);
#endif

   tVoid vHandle_StartStopWaitingMode_Error(most_fi_tcl_e8_ErrorCode::tenType e8ErrorCode, amt_tclServiceData* poMessage = NULLPTR);

   tVoid vSetVehicleBtAddress(char* Address);
   tVoid vGetVehicleBtAddress(char* Address);
   // CMG3G-8798- Outgoing call and number to name resolution
   tVoid validateTelephoneNumber(tString phoneNumber,tBool &isTelNumberEmpty);
   tVoid ecnrServerVoiceMode(tU8 ecnrType);
   tVoid vResetDiallerInfoForCallInstance(tU8 callInstance);
   //JAC2-5552. Setting the Phone channel to the call instance Ringing before requesting for LC_Phone channel
   //from ClientHandler_BTSettings in case of In-Band Ringtone.
   tVoid vSetPhoneChannelforRingingCallInstance();

   tVoid vSwitchActivePassive(tU8 ActDeviceHandle, tBool bResetActiveDeviceHandletobeRetained = TRUE);
   tVoid vSwitchActivePassiveFromVR();
   tVoid vSend_SetActivePhone_MethodResult();

   tString checkFileNameAndConcatFilePath(tString sFilePath);
   tVoid vSetasActiveDevice(tU8 DeviceHandle);
   tU8 u8GetActiveDeviceHandle();

   tVoid vInsertCallStatusinCSList(tU8 u8BDId);
   tVoid vDeleteCSfromCallStatusList(const tChar *pDeviceAddress);
   tVoid vUpdateCSinCallStatusList(const tChar *pDeviceAddress, T_CallStatus &rCallStatus);
   tVoid vCopyCallStatustoCSList(T_CallStatus &CallStatus, tU8 ind);

   tVoid vResetCallStatusinCallStatusList(tU8 iterator);
   tVoid vPrintCallStatusListVector();

   tU8 u8GetDeviceHandlefromDevAddrinCSList(const tChar *pDeviceAddress);
   const tChar* sGetDeviceAddressfromCSList(tU8 DeviceHandle);
   tVoid vSetCallStatefromDBUSCS(tU8 u8DBUSCallState, tU8 index);
   tVoid vSetCallStatebasedonDBusCS(tU8 u8MostFICallState, tU8 &u8DBUSCallState);

   tVoid vSetSLCStatus(tBool SLCStatus);
   tVoid vHandleWaitingMethodsOnDisconnection(const tChar *pDeviceAddress);

   tVoid vCreateCallDatafromCSListIndex(T_CallData* prCallData, int index);
   tVoid vSwitchtoActive(tU16 &u16ID);

   tU8 u8GetBDAddressIDforStatusUpdate();
   tVoid vSendSLCOFF(tU8 u8BDId, tU8 u8DeviceHandle);
   tVoid vRequestEndCallBasedOnCallInstance(tU16 CallInstanceID);
   tVoid vResetIncomingEventInfoVariable();
   tVoid vSendIncomingCallEvent(tU8 CallInstance, tBool bIsRinging);
   tVoid vOnHeldtoActiveSwapTimerExpired(tU16 u16TimerId);
   tVoid vUpdateCallStatus();
   tVoid vUpdateCurrentCallIndexAndProperty(tU16 u16PropertyId, tVoid* varg);
   tVoid vHandleCallStatusofPassiveDevice(T_CallData* prCallData, tU8 devicehandle);
   tVoid vAcknowledgeMethodStartForCallInstance(tVoid *varg);
   tVoid vRequestPhoneStatus(const tChar *pDeviceAddress);
   tBool bIsExternalTriggerReceivedForPhoneChannel();
   tU16 u16GetCallStateFromCallInstID(tU16 u16CallInstID);
   tVoid vCheckAndUpdateHFProfileUsage();
   tBool bIsFirstIncomingCallPresent();
   tBool bIsActiveDeviceIdle();
   tBool bIsTimerDurationExtendedForWaitingMode();
};

#endif // _FC_PHONE_SERVICE_TELEPHONE_H_


