/*******************************************************************************
 *
 * FILE:          FC_Phone_main.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "FC_Phone_main.h"

#include "HelperClasses/FC_Phone_Timer.h"
#include "HelperClasses/FC_Phone_AudioManager.h"
#include "FC_Phone_clienthandler_BTSettings.h"
#include "FC_Phone_service_Telephone.h"
#include "FC_Phone_clienthandler_PhoneBook.h"
#include "FC_Phone_clienthandler_SystemState.h"
#include "FC_Phone_clienthandler_DefSetHandler.h"
#include "FC_Phone_clienthandler_MediaPlayer.h"

#include "DBusClient/FC_Phone_DBusClientEvo.h"


#ifdef signals
# undef signals
# define __define_signals__
#endif

#include <gio/gio.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "Audio/FC_Phone_Audio.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_main.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
fc_phone_tclApp* fc_phone_tclApp::m_poMainAppInstance = NULLPTR;
// Main event loop
static GMainLoop* mainloop = NULLPTR;

//FIXME: not used
/*
// System bus
static GMainContext* context = NULL;
*/

/***********************************************************************/
/*
 * GDBUS declarations
 */
/***********************************************************************/

//gdbus system bus connection
static GDBusConnection *gdbusSystemBusConnection = NULLPTR;

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclApp* fc_phone_tclApp::theServer()
 *
 * DESCRIPTION: The Static function returns the Object of this class.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: fc_phone_tclApp*
 *
 ********************************************************************************/
fc_phone_tclApp* fc_phone_tclApp::theServer()
{
   if(!m_poMainAppInstance)
   {
      m_poMainAppInstance = OSAL_NEW fc_phone_tclApp();
   }
   return m_poMainAppInstance;
}

/*******************************************************************************
 *
 * FUNCTION: ahl_fc_phone_tclApp::ahl_fc_phone_tclApp()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initialize static self reference to be used in function
 *              callbacks.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_phone_tclApp::fc_phone_tclApp():ahl_tclBaseOneThreadApp()
{
   ETG_TRACE_USR4(("fc_phone_tclApp entered."));

   fc_phone_tclApp::m_poMainAppInstance = this;
   m_u8FBlockState = FC_PHONE_STATE_UNKNOWN;
   m_poTelephone = NULLPTR ;
   m_poClientHandlerBTSettings = NULLPTR ;
   m_poAudioManager = NULLPTR ;
   m_poTimer = NULLPTR ;
   m_poClientHandlerPhoneBook    = NULLPTR ;
   m_poClientHandlerSystemState = NULLPTR ;
   m_poClientHandlerMediaPlayer = NULLPTR;
   m_u8FBlockState = FC_PHONE_STATE_UNKNOWN;
   m_poPhoneAudioRouting = NULLPTR ;
   m_poPhoneAudioUtility = NULLPTR;
   m_hRxThreadId = OSAL_ERROR;

#ifdef CONNECTIVITY_DIAGNOSIS_GM
   /* Due to non availability of diagnosis
		library, this section will be compiled out for JAC  */
   m_poDefSet       = NULLPTR ;
#endif /*  CONNECTIVITY_DIAGNOSIS_GM  */

#ifdef TELEPHONE_DIAG_ENABLE
   m_poDiaglibService = NULLPTR;
#endif
}

/*******************************************************************************
 * FUNCTION: tVoid fc_phone_tclApp::vInitializeThread()
 *
 * DESCRIPTION: Initializing a Separate  thread.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *******************************************************************************/
tVoid fc_phone_tclApp::vInitializeThread()
{
   tU32 u32ThreadPrio = 0;
   tU32 u32StackSize  = 0;

   OSAL_trThreadAttribute	rAttr;
   tChar szThreadName[OSAL_C_U32_MAX_NAMELENGTH] = "\0";

   // Note:Maximum size of thread name limited to 8
   tString tStrTemp = OSAL_szStringCopy( szThreadName, "PHONE");
   tString tStrDummy = tStrTemp;//Added to remove lint warning.
   tStrTemp = tStrDummy;

   u32ThreadPrio = FC_PHONE_DEFAULT_PRIORITY ;
   u32StackSize  = FC_PHONE_DEFAULT_STACK_SIZE;



   // Initialize thread parameters
   rAttr.szName	   = szThreadName;
   rAttr.s32StackSize = (tS32)u32StackSize;
   rAttr.u32Priority  = u32ThreadPrio;
   rAttr.pfEntry	   = (OSAL_tpfThreadEntry)fc_phone_tclApp::vStartMainLoop;
   rAttr.pvArg 	   = (tPVoid)this;

   /* Create thread using pthread or OSAL thread creation process*/

   m_hRxThreadId = OSAL_ThreadSpawn(&rAttr);

   //tS32 ThreadActive = /*0;*/OSAL_s32ThreadActivate(m_hRxThreadId);

   if ( m_hRxThreadId == OSAL_ERROR )
   {
      // tS32 s32OsalError = (tS32)OSAL_u32ErrorCode(  );
      ETG_TRACE_USR4(("fc_phone_tclApp::vInitializeThread() -> the thread NOT create \n "));
   }
   else
   {
      ETG_TRACE_USR4(("fc_phone_tclApp::vInitializeThread() -> Thread creation successful \n"));
      /*Map call back function as vStartMainLoop*/
   }
}

/*******************************************************************************
 * FUNCTION    : name_appeared
 *
 * DESCRIPTION : Gets called when Evolution stack bus name appeared
 *
 * PARAMETER   : connection - GDBUS connection
 *               name - Name of the bus
 *               name_owner - Owner of the bus
 *               userdata - User data if any
 *
 * RETURNVALUE : None.
 *******************************************************************************/
static void name_appeared(GDBusConnection *connection, const gchar *name, const gchar *name_owner, gpointer userdata)
{
   ETG_TRACE_USR1(("name_appeared entered"));
   (tVoid) name;
   (tVoid) name_owner;
   (tVoid) userdata;

   if (connection)
   {
      ETG_TRACE_USR4(("GDBusConnection is NOT NULL"));
      gdbusSystemBusConnection = connection;
   }
   else
   {
      ETG_TRACE_FATAL(("FATAL_ERROR ::GDBusConnection is null"));
      return;
   }

   AssignBusConnection();

}

/*******************************************************************************
 * FUNCTION    : name_vanished
 *
 * DESCRIPTION : Gets called when Evolution stack bus name vanished
 *
 * PARAMETER   : connection - GDBUS connection
 *               name - Name of the bus
 *               user_data - User data if any
 *
 * RETURNVALUE : None.
 *******************************************************************************/
static void name_vanished(GDBusConnection *connection, const gchar *name, gpointer user_data)
{

   ETG_TRACE_USR1(("name_vanished entered"));
   (tVoid) connection;
   (tVoid) name;
   (tVoid) user_data;

}

/*******************************************************************************
 *
 * This method is called to create the ecnr proxy, based on the stack update wto to the watch element.
 *
 * @param data
 *   connection, name, name_owner, userdata.
 * @return
 *   void.
 *
 *******************************************************************************/
static void name_appeared_ecnr(GDBusConnection *connection, const gchar *name, const gchar *name_owner, gpointer userdata)
{
   ETG_TRACE_USR1(("name_appeared_ecnr entered"));
   (tVoid) name;
   (tVoid) name_owner;
   (tVoid) userdata;
   if(connection)
   {
      FB_ecnr_init(connection);
   }
}
/*******************************************************************************
 *
 * This method is called to when there is a stop in stack update for the given watch element.
 *
 * @param data
 *   connection, name, name_owner, userdata.
 * @return
 *   void.
 *
 *******************************************************************************/
static void name_vanished_ecnr(GDBusConnection *connection, const gchar *name, gpointer user_data)
{

   ETG_TRACE_USR1(("name_vanished_ecnr entered"));
   (tVoid) connection;
   (tVoid) name;
   (tVoid) user_data;
   if(connection)
   {
      FB_ecnr_deinit(connection);
   }
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclApp::vStartMainLoop()
 *
 * DESCRIPTION: Running the main loop in thread
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None

 *******************************************************************************/
tVoid fc_phone_tclApp::vStartMainLoop(tVoid * /* *pvArg*/) 
{
   ETG_TRACE_USR4(("vStartMainLoop"));
   // Create the main loop instance, uses default context
   mainloop = g_main_loop_new(NULLPTR, FALSE);
   if (!mainloop)
   {
      ETG_TRACE_ERR(("g_main_loop_new fails"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   //FIXME: not used
   /*context = g_main_loop_get_context(mainloop);
   ETG_TRACE_USR4(("\n running main loop of fc_phone_tclApp"));
*/
   ETG_TRACE_USR4(("Watching BT stack bus connection"));
   guint ownId;
   ownId = g_bus_watch_name(G_BUS_TYPE_SYSTEM,
         "org.ofono",
         G_BUS_NAME_WATCHER_FLAGS_AUTO_START,
         name_appeared,
         name_vanished,
         NULLPTR,
         NULLPTR);
   ETG_TRACE_USR4(("ownId = %d",ownId));

   ETG_TRACE_USR4(("Watching ECNR bus connection"));
   guint ownId_ecnr;
   ownId_ecnr = g_bus_watch_name(G_BUS_TYPE_SYSTEM,
         ECNR_SERVICE_NAME,
         G_BUS_NAME_WATCHER_FLAGS_AUTO_START,
         name_appeared_ecnr,
         name_vanished_ecnr,
         NULLPTR,
         NULLPTR);
   ETG_TRACE_USR4(("ownId_ecnr = %d",ownId_ecnr));

   // Main loop
   g_main_loop_run(mainloop);
}

/*******************************************************************************
 *
 * FUNCTION: ahl_fc_phone_tclApp::~ahl_fc_phone_tclApp()
 *
 * DESCRIPTION: Destructor.
 *
 *              Invalidate static self reference.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_phone_tclApp::~fc_phone_tclApp()
{
   ETG_TRACE_USR4(("~fc_phone_tclApp entered."));

   fc_phone_tclApp::m_poMainAppInstance = NULLPTR;
   m_poTelephone = NULLPTR ;
   m_poClientHandlerBTSettings = NULLPTR ;
   m_poAudioManager = NULLPTR ;
   m_poTimer = NULLPTR ;
   m_poClientHandlerPhoneBook    = NULLPTR ;
   m_poClientHandlerSystemState = NULLPTR ;
   m_poClientHandlerMediaPlayer = NULLPTR;
   m_poPhoneAudioRouting = NULLPTR;
   m_poPhoneAudioUtility = NULLPTR;
   m_u8FBlockState = FC_PHONE_STATE_UNKNOWN;
   OSAL_s32ThreadDelete(m_hRxThreadId);
   m_hRxThreadId = OSAL_ERROR;
#ifdef CONNECTIVITY_DIAGNOSIS_GM
   /* Due to non availability of diagnosis
		library, this section will be compiled out for JAC  */
   m_poDefSet       = NULLPTR ;
#endif /*  CONNECTIVITY_DIAGNOSIS_GM  */

#ifdef TELEPHONE_DIAG_ENABLE
   m_poDiaglibService = NULLPTR;
#endif  
}

/*******************************************************************************
 *
 * FUNCTION: tBool fc_phone_tclApp::bOnInit()
 *
 * DESCRIPTION: This function is called by the CCA framework before starting any
 *              CCA message related communication action. As default this
 *              function always returns TRUE. The user has to implement all his
 *              local application initialization (create client and service
 *              handler, create worker threads, allocate application memory,...).
 *              If returns TRUE, initialization could be successfully performed
 *              and framework will register application, else, a reset of the
 *              system is forced immediately.
 *
 *              This function is the counterpart of vOnApplicationClose().
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: TRUE  = Application successfully initialized.
 *              FALSE = Application NOT successfully initialized.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::bOnInit().
 *******************************************************************************/
tBool fc_phone_tclApp::bOnInit()
{
   ETG_TRACE_USR4(("bOnInit entered."));
   vInitializeThread();

   tBool bSuccess = TRUE;

   m_poTimer = OSAL_NEW fc_phone_tclTimer(m_poMainAppInstance);

   if (!m_poTimer)
   {
      bSuccess = FALSE;

      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation fc_phone_tclTimer failed"));
   }

   m_poAudioManager = OSAL_NEW fc_phone_tclAudioManager();

   if (!m_poAudioManager)
   {
      bSuccess = FALSE;

      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation fc_phone_tclAudioManager failed"));
   }


   m_poClientHandlerBTSettings = OSAL_NEW fc_phone_tclClientHandler_BTSettings(this);
   if(!m_poClientHandlerBTSettings)
   {
      bSuccess = FALSE;
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation fc_phone_tclClientHandler_BTSettings failed"));
   }


   /* Service to be initilalised at last , as it needs initialised timer and audiomanager*/
   m_poTelephone = OSAL_NEW fc_phone_tclService_Telephone(this);

   if (!m_poTelephone)
   {
      bSuccess = FALSE;

      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation fc_phone_tclService_Telephone failed"));
   }
   else
   {
      m_poTelephone->vSetBtClient(m_poClientHandlerBTSettings);
      m_poClientHandlerBTSettings->vSetTelServiceInstance(m_poTelephone);
   }

   /* GMMY15-9114 FC_Phone : logiscope code complexity value >= 20 */
   bSuccess = bInitializeClientHandlersAndServices(bSuccess);

   return bSuccess;
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclApp::vOnApplicationClose()
 *
 * DESCRIPTION: This function is called by the CCA framework to indicate the
 *              imminent shutdown of the application. The user has to implement
 *              the de-initialization of all his local application data (destroy
 *              client and service handler, destroy worker threads, free
 *              application memory, ... ). After this function call the
 *              destructor of this application will be called.
 *
 *              This function is the counterpart of bOnInit().
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
 *******************************************************************************/
tVoid fc_phone_tclApp::vOnApplicationClose()
{
   ETG_TRACE_USR4((" vOnApplicationClose entered."));

   if(m_poTimer)
   {
      m_poTimer->vStopAll();
   }

   _BP_TRY_BEGIN
   {
      if (m_poTelephone)
      {
         OSAL_DELETE m_poTelephone;
         m_poTelephone = NULLPTR;
      }

      if (m_poClientHandlerPhoneBook)
      {
         OSAL_DELETE m_poClientHandlerPhoneBook;
         m_poClientHandlerPhoneBook = NULLPTR;
      }

      if (m_poClientHandlerBTSettings)
      {
         OSAL_DELETE m_poClientHandlerBTSettings;
         m_poClientHandlerBTSettings = NULLPTR;
      }

      if (m_poAudioManager)
      {
         OSAL_DELETE m_poAudioManager;
         m_poAudioManager = NULLPTR;
      }

      if (m_poClientHandlerSystemState)
      {
         OSAL_DELETE m_poClientHandlerSystemState;
         m_poClientHandlerSystemState = NULLPTR;
      }
      if (m_poPhoneAudioRouting)
      {
         OSAL_DELETE m_poPhoneAudioRouting;
         m_poPhoneAudioRouting = NULLPTR;
      }

      if (m_poPhoneAudioUtility)
      {
         OSAL_DELETE m_poPhoneAudioUtility;
         m_poPhoneAudioUtility = NULLPTR;
      }

      if (m_poClientHandlerMediaPlayer)
      {
         OSAL_DELETE m_poClientHandlerMediaPlayer;
         m_poClientHandlerMediaPlayer = NULLPTR;
      }

      if (m_poTimer)
      {
         OSAL_DELETE m_poTimer;
         m_poTimer = NULLPTR;
      }

#ifdef CONNECTIVITY_DIAGNOSIS_GM
      /* Due to non availability of diagnosis
		library, this section will be compiled out for JAC  */
      if (m_poDefSet)
      {
         OSAL_DELETE m_poDefSet;
         m_poDefSet = NULLPTR;
      }
#endif /* CONNECTIVITY_DIAGNOSIS_GM  */

#ifdef TELEPHONE_DIAG_ENABLE
      if (m_poDiaglibService)
      {
         OSAL_DELETE m_poDiaglibService;
         m_poDiaglibService = NULLPTR;
      }
#endif
   }
   _BP_CATCH_ALL
   { }
   _BP_CATCH_END

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclApp::vOnLoadSettings()
 *
 * DESCRIPTION: This function is called by the CCA framework to trigger the
 *              loading of last mode settings. The user has to load the
 *              previously stored last mode settings from persistent memory.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnLoadSettings().
 *******************************************************************************/
tVoid fc_phone_tclApp::vOnLoadSettings()
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclApp::vOnLoadSettings"));
   NULL_CHECK(m_poTelephone)
   m_u8FBlockState = FC_PHONE_STATE_ON;

   m_poTelephone->vOnLoadSettings();

   ETG_TRACE_USR4(("EXIT: fc_phone_tclApp::vOnLoadSettings"));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclApp::vOnSaveSettings()
 *
 * DESCRIPTION: This function is called by the CCA framework to trigger the
 *              storage of last mode settings. The user has to store the last
 *              mode settings to persistent memory.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnSaveSettings().
 *******************************************************************************/
tVoid fc_phone_tclApp::vOnSaveSettings()
{
   ETG_TRACE_USR4(("ENTER: fc_phone_tclApp::vOnSaveSettings"));
   NULL_CHECK(m_poTelephone)
   m_u8FBlockState = FC_PHONE_STATE_OFF;

   m_poTelephone->vOnSaveSettings();
   ETG_TRACE_USR4(("EXIT: fc_phone_tclApp::vOnSaveSettings"));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclApp::vOnTimer(tU16 u16TimerId)
 *
 * DESCRIPTION: This function is called by the CCA framework on the expiration
 *              of a previously via function bStartTimer() started timer. The
 *              expired timer is forwarded to the respective service or
 *              client-handler via a call of vProcessTimer().
 *
 *              The function is called from this applications context and
 *              therefore no interthread programming rules must be considered
 *              and the application methods and/or member variables can be
 *              accessed without using the static self reference
 *              'm_poMainAppInstance'.
 *
 * PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
 *******************************************************************************/
tVoid fc_phone_tclApp::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer entered."));

   (tVoid) u16TimerId;
   //ahl timers are not used instead Osal timer .
   /*
   if (NULL != m_poTimer)
   {
  
     // m_poTimer->vTimerExpired(u16TimerId);
   }
   else
   {
      ETG_TRACE_USR4(( "m_poTimer is NULL"));
   }*/
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_phone_tclApp::vOnLoopback
 *                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called by the CCA framework if a message from
 *              one if this applications services is received (so called self
 *              or loopback messages). The message is forwarded to the respective
 *              service via a call of vOnLoopbackService().
 *
 * PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
 *                                message was sent.
 *
 *            [IN] poMessage = Message object.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
 *******************************************************************************/
tVoid fc_phone_tclApp::vOnLoopback
(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback entered."));

   switch(u16ServiceID)
   {
      case CCA_C_U16_SRV_FB_TELEPHONE:
      {
         if(m_poTelephone)
         {
            m_poTelephone->vOnLoopbackService(poMessage);
         }
         else
         {
            //NORMAL_M_ASSERT_ALWAYS();
            ETG_TRACE_ERR(( "Invalid ServiceId in Loopback"));
         }
      }
      break;

      default:
      {
         ETG_TRACE_ERR(("vOnLoopback. Unknown ServiceID %u.", u16ServiceID));
      }
   }
}


/******************************************************************
Function Name: getEvoBusConnection

Description: Returns DBusGConnection

Arguments: None

Return Value: GDBusConnection *gdbusSystemBusConnection

 *******************************************************************/
GDBusConnection* getEvoBusConnection()
      {
   ETG_TRACE_USR4(("ENTER : getEvoBusConnection"));
   return gdbusSystemBusConnection;
      }


//FIXME: not used
/******************************************************************
Function Name: getContext

Description: Returns GMainContext 

Arguments: None

Return Value: GMainContext *context

 ******************************************************************
GMainContext* getContext()
      {
   ETG_TRACE_USR4(("ENTER : getContext"));
   return context;
      }*/
	  
/******************************************************************
Function Name: getBt_mainLoop

Description: Returns GMainLoop

Arguments: None

Return Value: GMainLoop *mainloop

 *******************************************************************/
GMainLoop* getMainLoop()
      {
   ETG_TRACE_USR4(("ENTER : getMainLoop"));
   return mainloop;
      }

/* GMMY15-9114 FC_Phone : logiscope code complexity value >= 20 */
tBool fc_phone_tclApp::bInitializeClientHandlersAndServices(tBool bSuccess)
{
   ETG_TRACE_USR4(("fc_phone_tclApp::bInitializeClientHandlersAndServices entered."));

   m_poClientHandlerSystemState = OSAL_NEW fc_phone_tclClientHandler_SystemState(this);
   if(m_poClientHandlerSystemState)
   {
      bSuccess = TRUE;
      m_poClientHandlerSystemState->vSetTelServiceInstance(m_poTelephone) ;
   }
   else
   {
      bSuccess = FALSE;
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation fc_phone_tclClientHandler_SystemState failed"));
   }

   m_poClientHandlerPhoneBook = OSAL_NEW fc_phone_tclClientHandler_PhoneBook(this);
   if(m_poClientHandlerPhoneBook)
   {
      bSuccess = TRUE;
      m_poClientHandlerPhoneBook->vSetTelServiceInstance(m_poTelephone) ;
   }
   else
   {
      bSuccess = FALSE;
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation fc_phone_tclClientHandler_PhoneBook failed"));
   }

   m_poClientHandlerMediaPlayer = OSAL_NEW fc_phone_tclClientHandler_MediaPlayer(this);
   if(m_poClientHandlerMediaPlayer)
   {
      bSuccess = TRUE;
      m_poClientHandlerMediaPlayer->vSetTelServiceInstance(m_poTelephone) ;
   }
   else
   {
      bSuccess = FALSE;
      ETG_TRACE_FATAL(( "Creation fc_phone_tclClientHandler_MediaPlayer failed"));
   }

#ifdef TELEPHONE_DIAG_ENABLE
   m_poDiaglibService = OSAL_NEW diaglib::tclServiceDiaglib(this, 1);
   if (!m_poDiaglibService)
   {
      ETG_TRACE_ERR(( "Creation Of fc_phone_Dialog Lib service  failed "));
   }
#endif

#ifdef CONNECTIVITY_DIAGNOSIS_GM
   /* Due to non availability of diagnosis
    * library, this section will be compiled out for JAC  */
   m_poDefSet  = OSAL_NEW Phone_DefSetHandler(m_poDiaglibService);
   if (!m_poDefSet)
   {
      bSuccess = FALSE;
      ETG_TRACE_FATAL(( "Creation fc_phone_DefSet HAndler failed"));
   }
#endif /* CONNECTIVITY_DIAGNOSIS_GM */

   m_poPhoneAudioRouting = OSAL_NEW fc_phoneaudio_tclAudioRoutingfi(this);
   if(m_poPhoneAudioRouting)
   {
      bSuccess = TRUE;
      m_poPhoneAudioRouting->vSetTelServiceInstance(m_poTelephone) ;
      ETG_TRACE_USR4(( "m_poPhoneAudioRouting Creation is SUCCESS "));
   }
   else
   {
      bSuccess = FALSE;
      //FATAL_M_ASSERT_ALWAYS();
      ETG_TRACE_FATAL(( "Creation m_poPhoneAudioRouting failed"));
   }

   m_poPhoneAudioUtility = OSAL_NEW fc_phoneaudio_utility();
   if(m_poPhoneAudioUtility)
   {
      bSuccess = TRUE;
      ETG_TRACE_USR4(( "m_poPhoneAudioUtility Creation is SUCCESS "));
   }
   else
   {
      bSuccess = FALSE;
      ETG_TRACE_FATAL(( "Creation m_poPhoneAudioUtility failed"));
   }

   return bSuccess;
}
