/*******************************************************************************
 *
 * FILE:          FC_Phone_clienthandler_SystemState.h
 *
 * SW-COMPONENT:  FC_Phone Client Handler for SystemState
 *
 * PROJECT:
 *
 * DESCRIPTION:   Client-handler for SystemState FBlock.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _FC_PHONE_CLIENTHANDLER_SYSTEMSTATE_H_
#define _FC_PHONE_CLIENTHANDLER_SYSTEMSTATE_H_
#include "HelperClasses/FC_Phone_CallInstance.h"
#include "FC_Phone_main.h"

//Local defines
#define SLEEP_FAULT_TIMEOUT    600000
#define BT_RAP_EXPIRY_TIMEOUT  30000
#define DEFAULT_SYSTEM_STATE 0xFF



/******************************************************************************/
/* CLASS DEFINITION                                                           */
/******************************************************************************/
class ahl_tclBaseOneThreadClientHandler;
class fc_phone_tclService_Telephone;
class fc_phone_tclClientHandler_SystemState FINAL: public ahl_tclBaseOneThreadClientHandler
{
public:
   fc_phone_tclClientHandler_SystemState(tVoid);
   fc_phone_tclClientHandler_SystemState(fc_phone_tclApp* poMainAppl);
   virtual ~fc_phone_tclClientHandler_SystemState();
   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;
   tVoid vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance);
   tVoid vHandleSystemStateOnTransferCall();
   tVoid vTimerCallback(tU16 TimerId);
   tVoid vSendSpmSubState(tBool);
   tBool SystemStateAlertOnLocalPhone;

   //PSARCC30-1590
   tBool bIsSysteminStandByState();

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
   // Add your CCA message handler function prototypes here.
   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
   DECLARE_MSG_MAP(fc_phone_tclClientHandler_SystemState)
private:
   /****************************************************************************
                  Member variables for ClientHandler_SystemState
    ****************************************************************************/
   tVoid  vHandle_SystemState_Status(amt_tclServiceData* poMessage);
   tVoid  vHandle_OnOffTrigger_MethodResult(amt_tclServiceData* poMessage);
   tVoid  vHandle_OnOffTrigger_MethodError(amt_tclServiceData* poMessage);
   fc_phone_tclService_Telephone* m_TelService_instance;
   tU16    u16TimerID;
   tBool SleepFaultTimeout;
   tU16    m_u16SystemState;
};

#endif //_FC_PHONE_CLIENTHANDLER_SYSTEMSTATE_H_

