/************************************************************************
 * FILE:         Phone_DefSetHandler.h
 * PROJECT:
 * SW-COMPONENT:
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: Example implementation of a system set listener.
 * This handler sets the demodata value used for IncreaseDecrease demo
 * back to default on a DefSet request.
 * Take this class as a template for your own listener classes and
 * adjust the parts marked with
 * // +++ comment +++
 *
 * - ccademo_diaghandler.x              => // +++ Comment +++
 * - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
 * - Phone_DefSetHandler.x            => // +++ Comment +++
 * - ccademo_main.x                     => // +++diaglib+++ comment
 * - ccademo_msgtypes.h                 => // +++diaglib+++ comment
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author                 | Modification
 * 02.10.08  | CM-AI/PJ-FO45 Evers    | Inital version
 *
 *************************************************************************/
// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef PHONE_DEFSET_HANDLER_H
#define PHONE_DEFSET_HANDLER_H

#ifdef CONNECTIVITY_DIAGNOSIS_GM
/* Due to non availability of diagnosis
		library, this section will be compiled out for JAC  */
/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix +++
class Phone_DefSetHandler FINAL: public diaglib::tclSystemSetListenerIF
{
public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   Phone_DefSetHandler(diaglib::tclServiceDiaglib* pDiaglibService);
   virtual ~Phone_DefSetHandler();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * SystemSetListener methods
    ***************************************************************************/
   virtual tU32 vOnSystemSet ( 
         tU32 u32SystemSetID,
         diaglib::tenSystemSetType u32SystemSetType,
         diaglib::tContext MsgContext
   ) OVERRIDE;

   virtual tU32 vOnSystemSetFinished (
         tU32 u32SystemSetID,
         diaglib::tenSystemSetType u32SystemSetType,
         diaglib::tContext MsgContext
   ) OVERRIDE;

   virtual tU32 vOnSystemSetPrepare (
         tU32 u32SystemSetID,
         diaglib::tenSystemSetType u32SystemSetType,
         diaglib::tContext MsgContext
   ) OVERRIDE;

   virtual tU32 vOnSystemSetCheck (
         tU32 u32SystemSetID,
         diaglib::tenSystemSetType u32SystemSetType,
         diaglib::tContext MsgContext
   ) OVERRIDE;
private:
   diaglib::tclServiceDiaglib* mpDiaglibService;

   Phone_DefSetHandler();//lint !e1704 Info 1704 , eliminating lint warnings 

};
#endif /* CONNECTIVITY_DIAGNOSIS_GM */
#endif // CCADEMO_DEFSET_HANDLER_H
