/*******************************************************************************
 *
 * FILE:          FC_Phone_clienthandler_BtSettings.h
 *
 * SW-COMPONENT:  FC_Phone Blue Tooth Client
 *
 * PROJECT:
 *
 * DESCRIPTION:   FC_Phone client-handler for the Blue tooth Settings.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
#ifndef _FC_PHONE_CLIENTHANDLER_BTSETTINGS_H_
#define _FC_PHONE_CLIENTHANDLER_BTSETTINGS_H_
#include "FC_Phone_main.h"
#include "HelperClasses/FC_Phone_PhoneData.h"
/******************************************************************************/
/* CLASS DEFINITION                                                           */
/******************************************************************************/
#define FC_PHONE_MAXDEVICENAME_LENGTH 255
#define FC_PHONE_NONOUTGOING_SRC_DEVICEHANDLE_NOTFOUND  0x00
#define FC_PHONE_SCOCONNEXNSTATUS_UNKNOWN 0xFF
#define LC_INCOMING_RING_TONE_CHANNEL_ID 0x04
// Fix for NCG3D-103060
typedef enum
{
   DISCONNECTION_IDLE = 0,
   DISCONNECTION_STARTED = 1,
   DISCONNECTION_INCOMPLETE = 2
}tEnDisconnectionStatus;
typedef struct
{

   tU8     u8BDAddressId;
   tChar   DeviceName[FC_PHONE_MAXDEVICENAME_LENGTH];
   tChar   sVoiceMailNumber[FC_PHONE_MAXDEVICENAME_LENGTH];
   tU8     u8DeviceHandle ;
   tBool   bOutgoingSourceStatus ;
   tBool   bSlotFree ;
   tU8   u8SCOConnectionStatus;
   tU8 u8Codec;
   tBool   bIsAppleDevice ;
   tEnDisconnectionStatus enDisconnectionStatus;
}FcphoneConnectedDeviceList ;

class ahl_tclBaseOneThreadClientHandler;
class fc_phone_tclService_Telephone;
class fc_phone_tclClientHandler_BTSettings FINAL: public ahl_tclBaseOneThreadClientHandler
{
public:
   fc_phone_tclClientHandler_BTSettings(tVoid);
   fc_phone_tclClientHandler_BTSettings(fc_phone_tclApp* poMainAppl);
   virtual ~fc_phone_tclClientHandler_BTSettings();
   fc_phone_tclClientHandler_BTSettings& operator=
         (const fc_phone_tclClientHandler_BTSettings &oClientHandler);


   tU8 pGet_ActiveDevice_BDAddressId();
   tBool bIsOutGoingDevicePresent();

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable() OVERRIDE;
   virtual tVoid vOnServiceUnavailable() OVERRIDE;
   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
   // Add your CCA message handler function prototypes here.
   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
   tVoid vSetTelServiceInstance(fc_phone_tclService_Telephone*& rfpTelServiceInstance);
   tU8 u8GetOutgoingSourceDeviceHandle();
   const tChar* sGetDeviceNameFromBtAddressId(tU8 deviceAddressId);
   tU8 u8GetBTAddressIdFromDeviceHandle(tU8 DeviceHandle);
   tU8 u8GetDeviceHandleFromBtAddressId(tU8 deviceAddressId);
   tVoid vUpdateRingToneDeviceAddrId(tU8 u8BDAddrId);
   tU8 vGetRingToneDeviceAddrId();
   tVoid SwitchOutgoingSource();
   tBool GetOutGoingSourceChangeStatus();
   tVoid SetOutGoingSourceChangeStatus(tBool SourceSwitchingStatus);
   tVoid RequestAvailableRingtonesList(tU8 u8DeviceHandle);

   tU16 vIsInBandRingtone();
   tVoid vUpdateInBandRingTone(tU16 isInBandRingtone);
   const tChar* pu8GetVoiceMailNumberFromDeviceName(tChar* pu8DeviceName);
   tVoid vUpdateSCOConnectionStatus(T_SCOConnectionStatus* SCOConexnStatus);
   tU8 vGetSCOConnectionStatus(tString deviceAddress);
   tVoid vStopRingtone();
   tBool m_bCallSwitchStatusOnIncoming;
   VehicleInformation m_DeviceInformation;

   //GMMY16-12538: SIRI Inconsistencies
#ifdef PHONE_SIRI
   tBool bGetAppleDeviceStatusfromBDAddressID(tU8 u8BDAddressID);
#endif //PHONE_SIRI

   tVoid vGetVRDataSet(tU8& u8DataSet, tU8 u8Codec = 0); //Task CMG3G-7981
   //Task CMG3G-9536
   tBool bIsSuppressRingtoneEnabled();

   tVoid vSetPrimaryDevice(tU8 u8DeviceHandle);
   tVoid vSetBTProfilesUsage(tU8 u8DeviceHandle, tBool bProfileUsageInfo);
   tVoid vGetDeviceInformation(VehicleInformation  &devInfo);

   DECLARE_MSG_MAP(fc_phone_tclClientHandler_BTSettings)
private:
   /****************************************************************************
	                  Member variables for BTSettings
    ****************************************************************************/


   FcphoneConnectedDeviceList* tGetDevicelistInstanceFromDeviceHandle(tU8 u8DeviceHandle);
   FcphoneConnectedDeviceList* tGetFreeDevicelistInstanceFromDeviceListTable();
   tVoid vPrintDeviceList();
   tVoid  vHandle_ChangeDeviceState_MethodResult(amt_tclServiceData* poMessage) ;
   tVoid  vHandle_RequestStopRingtone_MethodResult(amt_tclServiceData* poMessage) ;
   tVoid  vHandle_RequestStopRingtone_MethodError(amt_tclServiceData* poMessage) ;
   tVoid  vHandle_ChangeDeviceState_MethodError(amt_tclServiceData* poMessage);
   tU8   u8GetDeviceHandleOfNonOutGoingSrcDevice();
   tVoid vHandle_RequestAvailableRingtonesList_MethodResult (amt_tclServiceData* poMessage);
   tVoid vHandle_RequestAvailableRingtonesList_MethodError (amt_tclServiceData* poMessage);
   tVoid vGetRingtoneRequest(tBool bInBandRingtone );
   //tChar   m_ActiveDeviceBD_Address[FC_PHONE_MAXDEVICENAME_LENGTH];
   //tChar   m_DeviceName[FC_PHONE_MAXDEVICENAME_LENGTH];
   //tU8  m_u8DeviceHandle ;
   tBool m_bOutGoingSourceChange; // This one is used to detect temporary outgoing source change
   fc_phone_tclService_Telephone* m_TelService_instance;
   FcphoneConnectedDeviceList tConnectedDeviceList[FC_PHONE_MAX_DEVICECONNECTION] ;
   tU8 m_u8RingToneDeviceAddrId ;
   tBool m_bInBandRingtone;

   tBool m_bSuppressRingtone;

   fc_phone_tclAudioManager* m_poAudioManager;
   tVoid vPlayRingtone(tU16 u16RingtoneId, tU8 u8LogicalAvChannel);
   tVoid vHandle_PlayRingtone_MethodResult (amt_tclServiceData* poMessage);
   tVoid vHandle_PlayRingtone_MethodError (amt_tclServiceData* poMessage);

   tVoid vHandle_DeviceListExtended_Status(amt_tclServiceData* poMessage);
   tVoid vHandle_VehicleBtAddress_Status(amt_tclServiceData* poMessage);
   tVoid vHandle_VehicleConfiguration_Status(amt_tclServiceData* poMessage);

   tVoid vHandle_SetPrimary_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_SetPrimary_MethodError(amt_tclServiceData* poMessage);

   tVoid vHandle_SetBTProfileUsage_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandle_SetBTProfileUsage_MethodError(amt_tclServiceData* poMessage);
};

#endif

