/******************************************************************************
 *
 * FILE:          FC_Phone_SMObserver.cpp
 *
 * SW-COMPONENT:  FC_Phone application
 *
 * PROJECT:
 *
 * DESCRIPTION:   Statemachine observer.
 *
 * AUTHOR:        Guruprasad G R
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#include "FC_Phone_service_Telephone.h"
#include "StateMachines/FC_Phone_SMIncludes.h"
#include "stdio.h"
#include "StateMachines/FC_Phone_SMManager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_SMObserver.cpp.trc.h"
#endif

/* Local defines, define here */
/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver
 *
 * DESCRIPTION:Constructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
fc_phone_tclSMObserver::fc_phone_tclSMObserver(fc_phone_tclService_Telephone*& rfpTelService)
{
   ETG_TRACE_USR4((" ENTER fc_phone_tclSMObserver::fc_phone_tclSMObserver"));
   m_poTelService = rfpTelService;
}

/*******************************************************************************
 *
 * FUNCTION: ~fc_phone_tclSMObserver
 *
 * DESCRIPTION:destructor
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
fc_phone_tclSMObserver::~fc_phone_tclSMObserver()
{
   ETG_TRACE_USR4((" ENTER fc_phone_tclSMObserver::~fc_phone_tclSMObserver"));
   m_poTelService = NULLPTR ;
}


/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::vSendStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
tVoid fc_phone_tclSMObserver::vSendStatus(tU16 u16StatusUpdateId,fc_phone_tclCallInstance*& rfpCallInstance)
{
   ETG_TRACE_USR4((" ENTER fc_phone_tclSMObserver::vSendStatus "));
   tU16 u16PropertyId = u16GetPropertyId(u16StatusUpdateId);

   if(MOST_TELFI_C_U16_INVALID_FUNCTIONID == u16PropertyId )
   {
      tU16 u16MethodId = u16GetMethodId(u16StatusUpdateId);
      m_poTelService->vSendMethodAck(u16MethodId, rfpCallInstance);
   }
   else
   {
      m_poTelService->vSendPropertyUpdate(u16PropertyId, (tVoid*)rfpCallInstance);
   }
   ETG_TRACE_USR4((" EXITING fc_phone_tclSMObserver::vSendStatus"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::vSendStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
tVoid fc_phone_tclSMObserver::vSendStatus(tU16 u16StatusUpdateId,tVoid *varg)
{
   ETG_TRACE_USR4((" fc_phone_tclSMObserver::vSendStatus "));
   tU16 u16PropertyId = u16GetPropertyId(u16StatusUpdateId);

   m_poTelService->vSendPropertyUpdate(u16PropertyId, varg);

   ETG_TRACE_USR4((" EXITING fc_phone_tclSMObserver::vSendStatus"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::vSendStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE: None.
 *
 ***************************************************************************/
tVoid fc_phone_tclSMObserver::vSendPropertyError(tU16 u16StatusUpdateId,tVoid *varg)
{
   ETG_TRACE_USR4(("ENTER  fc_phone_tclSMObserver::vSendStatus "));
   tU16 u16PropertyId = u16GetPropertyId(u16StatusUpdateId);

   m_poTelService->vSendPropertyError(u16PropertyId, varg);

   ETG_TRACE_USR4((" EXITING fc_phone_tclSMObserver::vSendStatus"));
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::GetMethodId
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/
tU16 fc_phone_tclSMObserver::u16GetMethodId(tU16 u16StatusUpdateId)
{
   ETG_TRACE_USR4(("ENTER  fc_phone_tclSMObserver::u16GetMethodId "));
   tU16 u16MethodId = MOST_TELFI_C_U16_INVALID_FUNCTIONID;

   switch(u16StatusUpdateId)
   {
      case FC_PHONE_SMMANAGER_METHOD_STATUS_ACCEPTCALL:
      {
         u16MethodId = MOST_TELFI_C_U16_ACCEPTCALL;
      }
      break;

      case FC_PHONE_SMMANAGER_METHOD_STATUS_REJECTCALL:
      {
         u16MethodId = MOST_TELFI_C_U16_REJECTCALL;
      }
      break;
      case FC_PHONE_SMMANAGER_METHOD_STATUS_HANGUP:
      {
         u16MethodId = MOST_TELFI_C_U16_HANGUPCALL;
      }
      break;
      case FC_PHONE_SMMANAGER_METHOD_STATUS_IGNORECALL:
      {
         u16MethodId = MOST_TELFI_C_U16_IGNORECALL;
      }
      break;
      case FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSET:
      {
         u16MethodId = MOST_TELFI_C_U16_TRANSFERCALLTOHANDSET;
      }
      break;
      case FC_PHONE_SMMANAGER_METHOD_STATUS_TRANSFERCALLTOHANDSFREE:
      {
         u16MethodId = MOST_TELFI_C_U16_TRANSFERCALLTOVEHICLE;
      }
      break;
      case FC_PHONE_SMMANAGER_METHOD_STATUS_HOLDCALL:
      {
         u16MethodId = MOST_TELFI_C_U16_HOLDCALL;
      }
      break;
      case FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL:
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_DIAL "));
         u16MethodId = MOST_TELFI_C_U16_DIAL;
      }
      break;

      case FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED:
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_DIALEXTENDED "));
         u16MethodId = MOST_TELFI_C_U16_DIALEXTENDED;
      }
      break;
	  
      case FC_PHONE_SMMANAGER_METHOD_STATUS_SPEEDDIAL:
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_SPEEDDIAL "));
         u16MethodId = MOST_TELFI_C_U16_SPEEDDIAL;
      }
      break;

      case  FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL :
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_CANCELOUTGOINGCALL "));
         u16MethodId = MOST_TELFI_C_U16_CANCELOUTGOINGCALL ;
      }
      break;

      case  FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF :
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_PLAYDTMF "));
         u16MethodId = MOST_TELFI_C_U16_SENDDTMF ;
      }
      break;

      case  FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL :
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_RESUMECALL "));
         u16MethodId = MOST_TELFI_C_U16_RESUMECALL ;
      }
      break;

      case  FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL :
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_SWAPCALL "));
         u16MethodId = MOST_TELFI_C_U16_SWAPCALL ;
      }
      break;

      case  FC_PHONE_SMMANAGER_METHOD_STATUS_CONFCALL :
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_CONFCALL "));
         u16MethodId = MOST_TELFI_C_U16_CONFERENCEIN ;
      }
      break;

      case  FC_PHONE_SMMANAGER_METHOD_STATUS_SPLITCALL :
      {
         ETG_TRACE_USR4((" CASE :FC_PHONE_SMMANAGER_METHOD_STATUS_SPLITCALL "));
         u16MethodId = MOST_TELFI_C_U16_SPLITCALL ;
      }
      break;

      default:
      {
         u16MethodId = MOST_TELFI_C_U16_INVALID_FUNCTIONID;
      }
   }
   return(u16MethodId);
}

/*******************************************************************************
 *
 * FUNCTION: fc_phone_tclSMObserver::GetPropertyId
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 ***************************************************************************/

tU16 fc_phone_tclSMObserver::u16GetPropertyId(tU16 u16StatusUpdateId)
{
   ETG_TRACE_USR4(("ENTER  fc_phone_tclSMObserver::u16GetPropertyId "));

   tU16 u16PropertyId = MOST_TELFI_C_U16_INVALID_FUNCTIONID;

   switch(u16StatusUpdateId)
   {
      case FC_PHONE_SMMANAGER_STATUS_INCOMINGCALL:
      {
         u16PropertyId = MOST_TELFI_C_U16_INCOMINGCALLEVENT;
      }
      break;

      case FC_PHONE_SMMANAGER_STATUS_CALLSTATUS:
      {
         u16PropertyId = MOST_TELFI_C_U16_CALLSTATUSNOTICE;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_CALLSTATUSEXTENDED:
      {
         u16PropertyId = MOST_TELFI_C_U16_CALLSTATUSNOTICEEXTENDED;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_ACTIVECALLINHANDSET:
      {
         u16PropertyId = MOST_TELFI_C_U16_ACTIVECALLINHANDSET;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_CELLDEVICENAME:
      {
         u16PropertyId = MOST_TELFI_C_U16_CELLDEVICENAME;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_SLC:
      {
         u16PropertyId = MOST_TELFI_C_U16_SLCSTATUS;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_CELLSIGNALSTRENGTH:
      {
         u16PropertyId = MOST_TELFI_C_U16_CELLSIGNALSTRENGTH;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_VEHICLEAUDIO:
      {
         u16PropertyId = MOST_TELFI_C_U16_VEHICLEAUDIO;
      }
      break;

      case FC_PHONE_SMMANAGER_STATUS_MICROPHONEMUTESTATE :
      {
         u16PropertyId = MOST_TELFI_C_U16_MICROPHONEMUTESTATE ;
      }
      break;

      case FC_PHONE_SMMANAGER_STATUS_RINGTONEMUTE:
      {
         u16PropertyId = MOST_TELFI_C_U16_RINGTONEMUTESTATE;
      }
      break;

      case FC_PHONE_SMMANAGER_STATUS_BT_VOICERECOGNITION:
      {
         u16PropertyId = MOST_TELFI_C_U16_BTDEVICEVOICERECOGNITION;
      }
      break;

      case FC_PHONE_SMMANAGER_ERROR_BT_VOICERECOGNITION:
      {
         u16PropertyId = MOST_TELFI_C_U16_BTDEVICEVOICERECOGNITION;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_OUTGOING_FAILED:
      {
         u16PropertyId = MOST_TELFI_C_U16_OUTGOINGCALLFAILEDEVENT;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_INCOMING_REJECTED:
      {
         u16PropertyId = MOST_TELFI_C_U16_INCOMINGCALLREJECTEDEVENT;
      }
      break;
      case FC_PHONE_SMMANAGER_STATUS_EXTERNALVR_STATUS:
      {
         u16PropertyId = MOST_TELFI_C_U16_EXTERNALVRSTATE;
      }
      break;

      default:
      {
         u16PropertyId = MOST_TELFI_C_U16_INVALID_FUNCTIONID;
      }
   }
   return(u16PropertyId);
}

