#ifndef __TELEPHONESERVICE_DEFINES_H__
#define __TELEPHONESERVICE_DEFINES_H__

#include "FC_Phone_DbusClient_bindings_evolution_modem.h"

#define VEHICLE_C_DBUS_SERVER_NAME "com.bosch.sln.vehicle_service"
#define VEHICLE_C_DBUS_SERVER_PATH "/com/bosch/sln/vehicle_service"
#define TELEPHONE_C_U16_IFID_EXAMPLE_1 0xFFF0
#define TELEPHONE_C_U32_MSGID_EXAMPLE_1 0x00000001

#define FC_PHONE_LOOPBACK_VECTOR_INVALID_POSITION  0xFFFF
#define FC_PHONE_NOCALLWAITING     0
#define FC_PHONE_CALLWAITING     1
#define FC_PHONE_MAX_CONNECTED_DEVICE 2
#define FC_PHONE_HANGUP_ALL        0xFF
#define CALLSTATUS_ACTIVE   TRUE
#define CALLSTATUS_INACTIVE FALSE

#define AUDIO_ACQUIRED_NONE      0
#define AUDIO_ACQUIRED_ONE_CALL  1
#define AUDIO_ACQUIRED_TWO_CALLS 2
#define TWO_CALLS_ACTIVE   2
#define REQ_SUCCESS 1
#define REQ_FAILURE 0
#define ISOURCE_MESSAGE_INVALID_INDEX 0xFFFF
#define ISOURCE_NUMBER_OF_SRCNUMBER_SUPPORTED 3
#define FC_PHONE_CALL_TOTAL 2
#define FC_PHONE_SECOND_CALL 2

#define FC_PHONE_TRANSFERCALL_EXT_TRIGGER 0x01
#define FC_PHONE_TRANSFERCALL_HMI_TRIGGER 0x02
#define FC_PHONE_TRANSFERCALL_EXT_TRIGGER_RELEASE_CHANNEL 0x03
#define FC_PHONE_TRANSFERCALL_EXT_TRIGGER_DNT_RELEASE_CHANNEL 0x04
#define FC_PHONE_RETRY_CNT_ACQUIRETELEPHONENUMBER 8

#define FC_PHONE_DEVICEYNAME_MAX_LEN_CHAR_COUNT 25   // Max length in charactes according to FCat for 'IBluetoothSettings.DeviceList.DeviceFriendlyName'
#define FC_PHONE_DEVICENAME_MAX_LEN_BYTE  (FC_PHONE_DEVICEYNAME_MAX_LEN_CHAR_COUNT *3 +1)  // = 76 UTF-8 bytes inclusive terminating \0
#define FC_PHONE_DIAL_NUMBER_MAX_LEN_IN_CHARS 85    //Length changed from 30 to 85 to support Evolution stack

#define FC_PHONE_CALLTRANSFER_FROMHANSFREE_TOHANDSET 0
#define FC_PHONE_CALLTRANSFER_FROMHANDSET_TOHANSFREE 1
#define FC_PHONE_CALLTRANSFER_DIRECTION_UNKNOWN 0xFF

#define FC_PHONE_DBUS_PROXY_INTERFACE_COUNT_EVO 12 //Number of Proxies need to created in Connection complete

//When Hold call method start is received in FC_Phone with call instance value as FF, then the conference call should be put on hold.
#define FC_PHONE_HOLD_ALL        0xFF
#define FC_PHONE_RESUME_ALL      0xFF
#define FC_PHONE_INVALID_DEVICE_HANDLE     0x00

//Work queue implementation -> eliminate duplicate requests
//If same request comes again to FC_Phone we dont push them to queue. Corresponding request returns giving error.
//Default value for stored parameters
#define FC_PHONE_DEFAULT_STORED_PARAM -1

//Increased timer value for Dial and speed dial as response of them from DBus is taking longer time (~ 8 seconds).
//Due to which timer is expired in FC_Phone and it unlocks next job.
//Hence next request is sent to DBus and the same results in error as per API restriction as Dial is still under process.
#define FC_PHONE_WORK_QUEUE_TIMER_VALUE_FOR_DIAL 10

#define FC_PHONE_APPLE_USB_IMPLEMENTER_VENDOR_ID (0x05AC)
#define FC_PHONE_USB_IMPLEMENTER_FORUM_ID_SOURCE (0x0002)

#define FC_PHONE_APPLE_BLUETOOTH_SIG_VENDOR_ID 0x004C
#define FC_PHONE_BLUETOOTH_SIG_ID_SOURCE 0x0001

// For features supported, to show SIRI and NR suppoerted, Bit 3 and Bit 4 should be set.
#define SUPPORTED_FEATURES 0x18

typedef enum 
{
   ISOURCE_METHODTYPE_ALLOCATE = 1,
   ISOURCE_METHODTYPE_DEALLOCATE = 2,
   ISOURCE_METHODTYPE_SRC_ACTIVITY = 3
}tEnISourceMethodType;

typedef enum
{
   FC_PHONE_EVO_DBUS_IDLE = 0,                //Idle
   FC_PHONE_EVO_DBUS_ACTIVE,                 //Active
   FC_PHONE_EVO_DBUS_HOLD,                   //Response and hold
   FC_PHONE_EVO_DBUS_DIALING,                //outgoing calls only
   FC_PHONE_EVO_DBUS_ALERTING,               //outgoing calls only
   FC_PHONE_EVO_DBUS_INCOMING,               //incoming calls only
   FC_PHONE_EVO_DBUS_HELD_HF,                //Only one call and hold by HF
   FC_PHONE_EVO_DBUS_HELD_NETWORK,           //One call hold by network
   FC_PHONE_EVO_DBUS_CALLX_DIALING,          //One of the calls is dialing
   FC_PHONE_EVO_DBUS_CALLX_ALERTING,         //One of the calls is alerting
   FC_PHONE_EVO_DBUS_CALLX_INCOMING,         //One of the calls is incoming
   FC_PHONE_EVO_DBUS_CALL_SWAPPABLE,         //At least one call is active and one call is held
   FC_PHONE_EVO_DBUS_CONF_CALL,              //All calls are active
   FC_PHONE_EVO_DBUS_CALL_BY_RING,           //active call disconnected, held call rings
   FC_PHONE_EVO_DBUS_CONF_CALL_HELD,         //Held call by conference
   FC_PHONE_EVO_DBUS_UNKNOWN                 //Unknown

}FCPhoneEvoDbusClientAllCallStatus;

typedef enum
{
   FC_PHONE_EVO_DBUS_AUDIO_PATH_IDLE = 0,                       //Idle
   FC_PHONE_EVO_DBUS_AUDIO_PATH_CALL,                          //SCO ,ECNR on
   FC_PHONE_EVO_DBUS_AUIOD_PATH_INBAND_RINGING,
   FC_PHONE_EVO_DBUS_AUIOD_PATH_MODULE_INT_RINGING,            //SCO,ECNR off
   FC_PHONE_EVO_DBUS_AUDIO_PATH_VOICE_REC,
   FC_PHONE_EVO_DBUS_AUDIO_PATH_PENDING_FOR_INBAND_RINGTONE,
   FC_PHONE_EVO_DBUS_AUDIO_PATH_UNKNOWN                        //Unknown

}FCPhoneEvoDbusClientAudiopath;

typedef enum
{
   FC_PHONE_EVO_DBUS_NOT_CONNECTED = 0,
   FC_PHONE_EVO_DBUS_NBS_S1_TO_S3,
   FC_PHONE_EVO_DBUS_WBS,
   FC_PHONE_EVO_DBUS_NBS_AND_S4

}FCPhoneEvoDbusClientSCOType;

typedef enum
{
   FC_PHONE_EVO_DBUS_SCO_REQ_NBS = 0,
   FC_PHONE_EVO_DBUS_SCO_REQ_WBS

}SCOConnectRequestType;

typedef enum
{
   CALL_STATE_IDLE      = 0x00,
   CALL_STATE_ACTIVE    = 0x01,
   CALL_STATE_HELD      = 0x02,
   CALL_STATE_DIALING   = 0x03,
   CALL_STATE_ALERTING  = 0x04,
   CALL_STATE_INCOMING  = 0x05,
   CALL_STATE_WAITING   = 0x06

}CallStateEnum;

typedef enum
{
   CALL_DIR_UNKNOWN     = 0x00,
   CALL_DIR_OUTGOING    = 0x01,
   CALL_DIR_INCOMING    = 0x02

}CallDirectionEnum;

typedef enum
{
   CALL_MODE_UNKNOWN    = 0x00,
   CALL_MODE_VOICE      = 0x01,
   CALL_MODE_DATA       = 0x02,
   CALL_MODE_FAX        = 0x03

}CallModeEnum;

typedef enum
{
   CALL_TYPE_UNKNOWN        = 0x00,
   CALL_TYPE_INTERNATIONAL  = 0x01,
   CALL_TYPE_NATIONAL       = 0x02,
   CALL_TYPE_NETWORK        = 0x03,
   CALL_TYPE_DEDICATED      = 0x04

}CallTypeEnum;

typedef enum
{
   FC_PHONE_EVO_SERVICE_DISABLED  = 0x00,
   FC_PHONE_EVO_SERVICE_ENABLED   = 0x01

}ServiceEnum;

typedef enum
{
   FC_PHONE_DBUS_PROXY_EVO_HANSFREE_INTERFACE = 0,
   FC_PHONE_DBUS_PROXY_EVO_ADAPTER_INTERFACE = 1,
   FC_PHONE_DBUS_PROXY_EVO_DEVICE_INTERFACE = 2,
   FC_PHONE_DBUS_PROXY_EVO_MANAGER_INTERFACE = 3,
   FC_PHONE_DBUS_PROXY_EVO_MODEM_INTERFACE = 4,
   FC_PHONE_DBUS_PROXY_EVO_SIRI_INTERFACE = 5,
   FC_PHONE_DBUS_PROXY_EVO_NETWORK_REGISTRATION_INTERFACE = 6,
   FC_PHONE_DBUS_PROXY_EVO_NETWORK_OPERATOR_INTERFACE = 7,
   FC_PHONE_DBUS_PROXY_EVO_CALL_VOLUME_INTERFACE = 8,
   FC_PHONE_DBUS_PROXY_EVO_VOICECALL_MANAGER_INTERFACE = 9,
   FC_PHONE_DBUS_PROXY_EVO_FREEDESKTOP_INTERFACE = 10,
   FC_PHONE_DBUS_PROXY_EVO_UNKNOWN = 11

}FC_PHONE_DBUS_ProxyIdEnum_evo;

typedef enum
{

   FC_PHONE_VOICECALL_INDEX_ONE = 1,
   FC_PHONE_VOICECALL_INDEX_TWO = 2

}VoiceCallIndexEnum;

typedef enum
{
   FC_PHONE_CALL_TOTAL_ZERO = 0,
   FC_PHONE_CALL_TOTAL_ONE = 1,
   FC_PHONE_CALL_TOTAL_TWO = 2

}CallTotalEnum;

//enum for Status of SLOT (connected or not connected)
typedef enum
{
   FC_PHONE_DEVICE_NOT_CONNECTED              = 0,
   FC_PHONE_DEVICE_CONNECTION_IN_PROGRESS     = 1,
   FC_PHONE_DEVICE_CONNECTED                  = 2
}conn_status_enum;

typedef struct {
   snd_pcm_t *sound_handle;
} DRV_AudioObj;


typedef struct{
   tChar  BD_Address[FC_PHONE_MAX_CONNECTED_DEVICE][FC_PHONE_STRING_LENGTH_MAX];
}Fc_PhoneSLCDeviceList;


/******************************************************************
 NOTE :On every call-added signal,Get all calls,create multiparty,private chat method calls, CallMapTableSTruct needs to visited
 At any point of time Total call will based on isCallPresent element in all instance.
 *******************************************************************/
typedef struct
{
   int callIndex;                                //Index got from the callPath given by stack.
   bool isCallPresent;                           //TRUE when Call-added,  FALSE when Call-removed or Disconnected
   bool isPropertyChanged;                       //TRUE when incoming property is different from old property
   GObject* voiceCallProxy;                      //Proxy for corresponding voice call
   tChar achCallPath[FC_PHONE_CALL_PATH_LENGTH]; //Voice call object path
   T_CallStatus callstatus;                      //Call status for corresponding voice call

} CallMapTableSTruct;


/******************************************************************
 Description   :Connected Device Table
*******************************************************************/
typedef struct
{
   GObject*          proxy_common[FC_PHONE_DBUS_PROXY_INTERFACE_COUNT_EVO];    //Created Proxy for the connected device
   char              DevAddr[PHONE_CONNMAP_DEV_ADDRESS];                       //Device address
   conn_status_enum  en_conn_status;                                           //Device connected status
   tU8 gcallTotal;                                                             // Total call available for the connected device
   CallMapTableSTruct CallMapTable[FC_PHONE_NUMBER_OF_CALLS_SUPPORT];          //Call handling table
   T_PhoneStatus PhoneStatus_data;
   gboolean isGetcallsInProgress;                                              //TRUE when getcalls called. FALSE when callback is received
   tU8 AllCallStatus;                                                          //AllcallStatus for corresponding device.

   gboolean bAudioTfer_direction;
   guchar u8VRAction;
} ConnMapTableSTruct;


typedef struct
{
   Modem *modemProxy;   //Modem proxy for paired devices
   tString sDevAddr;    //Device address
}ModemProxyTableSTruct;

typedef struct _T_CallStatusList
{
   T_CallStatus CallStatus;
   tU8 DeviceHandle;
   tChar BD_Address[PHONE_BDADRESS_LENGTH];
}T_CallStatusList;

typedef struct fc_phone_IncomingMessage
{
   tU16 u16SourceAppID;
   tU16 u16RegisterID;
   tU16 u16CmdCounter;
   tU16 u16FunctionID;
   tU16 u16InstanceID ;
   fc_phone_IncomingMessage()
   {
      u16SourceAppID = 0;
      u16RegisterID = 0;
      u16CmdCounter = 0;
      u16FunctionID = 0;
      u16InstanceID = 0;
   }
}IncomingMessage;

#endif /* __TELEPHONESERVICE_DEFINES_H__ */
