/*******************************************************************************
 * FILE:           FC_Phone_AudioHelper.h
 * PROJECT:        G3G
 * SW-COMPONENT:   FC_PHONE
 *-------------------------------------------------------------------------------
 *
 * DESCRIPTION:    Header file for audio routing interface.
 *
 *-------------------------------------------------------------------------------
 * COPYRIGHT:      (c) 2012 RBEI
 * HISTORY:
 * Date      | Author              | Modification
 *
 *******************************************************************************/

#ifndef _FC_BTAUDIO_AUDIOUTIL_H_
#define _FC_BTAUDIO_AUDIOUTIL_H_

/*******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| class forward declarations
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| class definition
|-----------------------------------------------------------------------------*/

#define EN_ECNR_START_AUDIO 15
#define EN_ECNR_INITIALIZE 3

typedef enum
{
   EN_IDLE = 0,
   EN_ECNR_INIT = 1 ,
   EN_SCO_EST = 2,
   EN_SA_ON = 4,
   EN_ECNR_CONFIGURATION = 8,
   EN_ECNR_STARTAUDIO = 16,
   EN_SA_PAUSE = 32
}tenEcnrSaSco;

class fc_phoneaudio_utility
{
private:

   tU8 m_u8EcnrSaScoStatus;
   tU8 m_u8EcnrConfigurationDataset;
   tU8 m_u8EcnrInitDestroyStatus;

public:

   fc_phoneaudio_utility(); // Constructor
   tVoid vRxdSAOnAndSCOEst();
   tVoid vSetSaScoEcnrInit(tenEcnrSaSco enStatus);
   tVoid vResetSaScoEcnrInit(tenEcnrSaSco enStatus);
   tVoid vSetDataSet(tU8 u8Dataset);
   tU8 vGetEcnrSaScoStatus();
   tVoid vSendLoopBackMessage(tU32 u16FunctionID);
};

#endif //_FC_BTAUDIO_AUDIOUTIL_H_
