/*******************************************************************************
 * FILE:           fc_phoneaudio_tclAudioRoutingfi
 * PROJECT:        G3G
 * SW-COMPONENT:   FC_PHONE
 *-------------------------------------------------------------------------------
 *
 * DESCRIPTION:    Implementation of audio routing interface.
 *
 *-------------------------------------------------------------------------------
 * COPYRIGHT:      (c) 2012 RBEI
 * HISTORY:
 * Date      | Author              | Modification
 *
 *******************************************************************************/

/*******************************************************************************
| includes:
| 1) system- and project-includes
| 2) needed interfaces from external components
| 3) internal and external interfaces from this component
|-----------------------------------------------------------------------------*/
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif
// own header file
#include "FC_Phone_AudioHelper.h"
#include "FC_Phone_ECNR.h"
#include "../FC_Phone_main.h"
#include "../HelperClasses/FC_Phone_AudioManager.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_PHONE_APPLICATION
#include "trcGenProj/Header/FC_Phone_AudioHelper.cpp.trc.h"
#endif


/*******************************************************************************
| defines and macros
| (scope: modul-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation
| (scope: global)
|-----------------------------------------------------------------------------*/
/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_utility::fc_phoneaudio_utility
 *
 * DESCRIPTION: constructor, creates object fc_phoneaudio_utility
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *

 *
 *******************************************************************************/

fc_phoneaudio_utility::fc_phoneaudio_utility()
{

   ETG_TRACE_USR1(("fc_phoneaudio_utility() entered."));

   m_u8EcnrSaScoStatus = EN_IDLE;
   m_u8EcnrConfigurationDataset = PHONE_DATASET_1;
   m_u8EcnrInitDestroyStatus = EN_IDLE;
}
/*******************************************************************************
 *
 * FUNCTION:    fc_phoneaudio_utility::SetSaScoEcnrInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE: TRUE
 *
 *
 *******************************************************************************/
tVoid fc_phoneaudio_utility::vSetSaScoEcnrInit(tenEcnrSaSco enStatus)

{
   ETG_TRACE_USR4((" SetSaScoEcnrInit Called.%d enStatus..",enStatus));
   switch(enStatus)
   {
      case EN_ECNR_INIT:
      {
         m_u8EcnrSaScoStatus |= EN_ECNR_INIT;
         vRxdSAOnAndSCOEst();
      }
      break;
      case EN_SCO_EST:
      {
         m_u8EcnrSaScoStatus |= EN_SCO_EST;
         vRxdSAOnAndSCOEst();
      }
      break;
      case EN_ECNR_CONFIGURATION:
      {
         m_u8EcnrSaScoStatus |= EN_ECNR_CONFIGURATION;
         vRxdSAOnAndSCOEst();
      }
      break;
      case EN_SA_ON:
      {
         m_u8EcnrSaScoStatus |= EN_SA_ON;
         vRxdSAOnAndSCOEst();
      }
      break;
      case EN_SA_PAUSE:
      {
         m_u8EcnrSaScoStatus |= EN_SA_PAUSE;
      }
      break;
      case EN_ECNR_STARTAUDIO:
      {
         m_u8EcnrSaScoStatus |= EN_ECNR_STARTAUDIO;
      }
      break;

      default:
         break;
   }
   ETG_TRACE_USR4(("m_u8EcnrSaScoStatus %d", m_u8EcnrSaScoStatus ));
}

/*******************************************************************************
 *
 * FUNCTION:    vRxdSAOnAndSCOEst
 *
 * DESCRIPTION: Result for own mute / demute request.
 *
 * PARAMETER:   enEcnrSA:               (I)   To determine whether Ecnr/SA status
 *              enStatus:        (I)   Status of ECNR/SA
 *
 * RETURNVALUE: void
 *

 *
 *******************************************************************************/
tVoid fc_phoneaudio_utility::vRxdSAOnAndSCOEst()
{
   ETG_TRACE_USR4(("vRxdSAOnAndSCOEst Entered"));
   ETG_TRACE_USR4(("m_u8EcnrSaScoStatus %d", m_u8EcnrSaScoStatus ));
   if( EN_ECNR_START_AUDIO == ( EN_ECNR_START_AUDIO & m_u8EcnrSaScoStatus ))
   {
      if ( EN_ECNR_STARTAUDIO !=  ( EN_ECNR_STARTAUDIO & m_u8EcnrSaScoStatus ))
      {
         ecnrStartAudio();
      }
      else
      {
         // RTC-387538: There is an ecnrStartAudio is already in process. In the meantime, a new request to start ecnr is received.
         // When the above condition is satisfied, which implies that all bits are set i.e.,  m_u8EcnrSaScoStatus == 31.
         // Hence clearing the event buffer, in case if ecnrStopAudio() or ecnrDestroy() are residing in the queue of event buffer.
         clearEventBuffer();
      }
   }
   else if( ( EN_ECNR_INITIALIZE == ( EN_ECNR_INITIALIZE & m_u8EcnrSaScoStatus) )
         &&  ( EN_ECNR_CONFIGURATION != ( EN_ECNR_CONFIGURATION & m_u8EcnrSaScoStatus)))
   {

         // ECNR configuration send  when data set is for Wideband/ narrowband.
         ecnrconfiguration(m_u8EcnrConfigurationDataset);

   }
   else
   {
      ETG_TRACE_USR4(("SA_ON / SCO / ecnr init EST not received "));
   }
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phone_tclService_Telephone::ResetSaScoEcnrInit
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/
tVoid fc_phoneaudio_utility::vResetSaScoEcnrInit(tenEcnrSaSco enStatus)
{
   ETG_TRACE_USR4((" vResetSaScoEcnrInit Called..."));

   switch(enStatus)
   {
      case EN_ECNR_INIT:
      {
         ETG_TRACE_USR4(("EN_ECNR_INIT..."));
         m_u8EcnrSaScoStatus = static_cast<tU8>(m_u8EcnrSaScoStatus & ~EN_ECNR_INIT);
      }
      break;
      case EN_SCO_EST:
      {
         ETG_TRACE_USR4((" EN_SCO_EST..."));
         m_u8EcnrSaScoStatus = static_cast<tU8>(m_u8EcnrSaScoStatus & ~EN_SCO_EST);
      }
      break;
      case EN_SA_ON:
      {
         ETG_TRACE_USR4((" EN_SA_ON..."));
         m_u8EcnrSaScoStatus = static_cast<tU8>(m_u8EcnrSaScoStatus & ~EN_SA_ON);
      }
      break;
      case EN_ECNR_CONFIGURATION:
      {
         ETG_TRACE_USR4((" EN_SA_CONFIGURATION..."));
         m_u8EcnrSaScoStatus = static_cast<tU8>(m_u8EcnrSaScoStatus & ~EN_ECNR_CONFIGURATION);
      }
      break;
      case EN_ECNR_STARTAUDIO:
      {
         ETG_TRACE_USR4((" EN_ECNR_STARTAUDIO..."));
         m_u8EcnrSaScoStatus = static_cast<tU8>(m_u8EcnrSaScoStatus & ~EN_ECNR_STARTAUDIO);
      }
      break;
      case EN_SA_PAUSE:
      {
         ETG_TRACE_USR4((" EN_SA_PAUSE..."));
         m_u8EcnrSaScoStatus = static_cast<tU8>(m_u8EcnrSaScoStatus & ~EN_SA_PAUSE);
      }
      break;
      default:   ETG_TRACE_USR4((" SetSaScoEcnrInit In default..."));
   }
   ETG_TRACE_USR4(("m_u8EcnrSaScoStatus %d", m_u8EcnrSaScoStatus ));
}

// vSetDataSet() func is called when SCOCONNECTION status received from device.
tVoid fc_phoneaudio_utility::vSetDataSet(tU8 u8Dataset)
{
   ETG_TRACE_USR4(("fc_phoneaudio_utility::vSetDataSet DataSet: %u", u8Dataset));

   m_u8EcnrConfigurationDataset = u8Dataset;

   if ((m_u8EcnrConfigurationDataset == PHONE_DATASET_1 )
         || (m_u8EcnrConfigurationDataset == PHONE_DATASET_3 )
#ifdef PHONE_SEPARATE_ECNR_SET_SIRI //Task CMG3G-7981
         || (m_u8EcnrConfigurationDataset == SSE_CONFIG_PHONE_SIRI_NB_FROM_FILE)
#endif
         )
   {
      vSetSaScoEcnrInit(EN_ECNR_CONFIGURATION);
   }

   vSetSaScoEcnrInit(EN_SCO_EST);
}

/*******************************************************************************
 *
 * FUNCTION:    fc_phone_tclService_Telephone::vGetEcnrSaScoStatus
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 *
 *
 * RETURNVALUE: TRUE
 *

 *
 *******************************************************************************/
tU8 fc_phoneaudio_utility::vGetEcnrSaScoStatus()
{
   ETG_TRACE_USR4(("m_u8EcnrSaScoStatus %d", m_u8EcnrSaScoStatus ));
   return m_u8EcnrSaScoStatus;
}

/*******************************************************************************
 *
 * FUNCTION: tVoid vSendLoopBackMessage
 *
 * DESCRIPTION: Send loopback message.
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid fc_phoneaudio_utility::vSendLoopBackMessage(tU32 u16FunctionID)
{

   ETG_TRACE_USR4((" vSendLoopBackMessage "));

   fc_phone_tclService_Telephone* poTelService = fc_phone_tclService_Telephone::pGetInstance();

   if(poTelService)
   {
      if (TRUE == poTelService->m_bServerAvailable)
      {
         LoopBackData LB_data;
         LB_data.u16FunctionID = u16FunctionID;
         poTelService->push_back_LB_data(LB_data);
         poTelService->vPrepareLoopBackMsg(u16FunctionID);
      }
      else
      {
         /* Throw up an error */
         ETG_TRACE_ERR((" Error: Loopback message sending failed "));
      }
   }
}


